% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rBeta}
\alias{rBeta}
\title{Random generator from the beta distribution}
\usage{
rBeta(n, mu, phi, q0 = NULL, q1 = NULL)
}
\arguments{
\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a real positive value.}

\item{q0}{the probability of augmentation in zero. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{q1}{the probability of augmentation in one. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}
}
\value{
A vector of length \code{n}.
}
\description{
The function  generates random values from the beta distribution with a mean-precision parameterization, or from the augmented beta distribution.
}
\examples{
rBeta(n = 100, mu = .5, phi = 30)
rBeta(n = 100, mu = .5, phi = 30, q0 = .2, q1 = .1)

}
\references{
{
Ferrari, S.L.P.,  Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
