% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restr.R
\name{restr}
\alias{restr}
\title{Restriction of control variability}
\usage{
restr(TEST, REP, Xi, scenario = NULL, zstat = NULL, verbose = FALSE)
}
\arguments{
\item{TEST}{The column with the name of the witness}

\item{REP}{The column with the replications}

\item{Xi}{The column with the observed value for a given genotype.}

\item{scenario}{Scenario to be used for the calculation. Use 'original' to
do not restrict the witnesses by the mean plus or minus the standard deviations,
or 'restr' to apply the restriction.}

\item{zstat}{Logical argument. Applies Z-notation normalization if 'TRUE'.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Describes controls that were removed from the dataset to restrict
variability.
}
\description{
Method for restricting the variability of control proposed by Carvalho et al.
(2023). It uses the restriction of the mean plus or minus one standard deviation.
standard deviation, which restricts variation by removing asymmetric values.
}
\examples{
library(EstimateBreed)

TEST <- rep(paste("T", 1:5, sep=""), each=3)
REP <- rep(1:3, times=5)
Xi <- rnorm(15, mean=10, sd=2)

data <- data.frame(TEST,REP,Xi)

#Apply the control variability constraint
Control <- with(data, restr(TEST,REP,Xi,scenario = "restr",zstat = FALSE))

#Apply control variability restriction with normalization (Z statistic)
Control <- with(data, restr(TEST,REP,Xi,scenario = "restr",zstat = TRUE))
}
\references{
Carvalho, I. R., Silva, J. A. G. da, Moura, N. B., Ferreira, L. L.,
Lautenchleger, F., & Souza, V. Q. de. (2023). Methods for estimation of
genetic parameters in soybeans: An alternative to adjust residual variability.
Acta Scientiarum. Agronomy, 45, e56156.
\doi{10.4025/actasciagron.v45i1.56156}
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
