% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requireIsFirstDrugEntry}
\alias{requireIsFirstDrugEntry}
\title{Restrict cohort to only the first cohort record per subject}
\usage{
requireIsFirstDrugEntry(
  cohort,
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}
}
\value{
The cohort table having applied the first entry requirement.
}
\description{
Filter the cohort table keeping only the first cohort record per subject.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requireIsFirstDrugEntry()

attrition(cdm$cohort1) |>
  glimpse()
}

}
