% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.ProbAverageWeightedVoting.R
\name{ProbAverageWeightedVoting}
\alias{ProbAverageWeightedVoting}
\title{Implementation of Probabilistic Average Weighted voting.}
\description{
Computes the final prediction by performing the weighted mean of
the probability achieved by each cluster prediction. By default, weight
values are consistent with the performance value achieved by the best M.L.
model on each cluster.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{ClassMajorityVoting}},
\code{\link{ClassWeightedVoting}}, \code{\link{ProbAverageVoting}},
\code{\link{ProbAverageWeightedVoting}}, \code{\link{ProbBasedMethodology}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Super class}{
\code{\link[D2MCS:SimpleVoting]{D2MCS::SimpleVoting}} -> \code{ProbAverageWeightedVoting}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProbAverageWeightedVoting-new}{\code{ProbAverageWeightedVoting$new()}}
\item \href{#method-ProbAverageWeightedVoting-getClassTie}{\code{ProbAverageWeightedVoting$getClassTie()}}
\item \href{#method-ProbAverageWeightedVoting-getWeights}{\code{ProbAverageWeightedVoting$getWeights()}}
\item \href{#method-ProbAverageWeightedVoting-setWeights}{\code{ProbAverageWeightedVoting$setWeights()}}
\item \href{#method-ProbAverageWeightedVoting-execute}{\code{ProbAverageWeightedVoting$execute()}}
\item \href{#method-ProbAverageWeightedVoting-clone}{\code{ProbAverageWeightedVoting$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="SimpleVoting" data-id="getCutoff"><a href='../../D2MCS/html/SimpleVoting.html#method-SimpleVoting-getCutoff'><code>D2MCS::SimpleVoting$getCutoff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="SimpleVoting" data-id="getFinalPred"><a href='../../D2MCS/html/SimpleVoting.html#method-SimpleVoting-getFinalPred'><code>D2MCS::SimpleVoting$getFinalPred()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-new"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$new(cutoff = 0.5, class.tie = NULL, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{A \link{character} vector defining the minimum probability
used to perform a positive classification. If is not defined, 0.5 will be
used as default value.}

\item{\code{class.tie}}{A \link{character} used to define the target class value
used when a tie is found. If \link{NULL} positive class value will be
assigned.}

\item{\code{weights}}{A \link{numeric} vector with the weights of each cluster.
If \link{NULL} performance achieved during training will be used as
default.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-getClassTie"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-getClassTie}{}}}
\subsection{Method \code{getClassTie()}}{
The function gets the class value assigned to solve ties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$getClassTie()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-getWeights"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-getWeights}{}}}
\subsection{Method \code{getWeights()}}{
The function returns the value of the majority class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$getWeights()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of length 1 with the name of the
majority class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-setWeights"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-setWeights}{}}}
\subsection{Method \code{setWeights()}}{
The function allows changing the value of the weights.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$setWeights(weights)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weights}}{A \link{numeric} vector containing the new weights.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-execute"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-execute}{}}}
\subsection{Method \code{execute()}}{
The function implements the cluster-weighted probabilistic
voting procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$execute(predictions, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
all the predictions achieved for each cluster.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProbAverageWeightedVoting-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProbAverageWeightedVoting-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbAverageWeightedVoting$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
