% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.DatasetLoader.R
\name{DatasetLoader}
\alias{DatasetLoader}
\title{Dataset creation.}
\description{
Wrapper class able to automatically create a
\code{\link{Dataset}}, \code{\link{HDDataset}} according to the input data.
}
\examples{
\dontrun{
# Create Dataset Handler object.
  loader <- DatasetLoader$new()

  # Load input file.
  data <- loader$load(filepath = system.file(file.path("examples",
                                                       "hcc-data-complete-balanced.csv"),
                                             package = "D2MCS"),
                      header = T, normalize.names = T)
}


}
\seealso{
\code{\link{Dataset}}, \code{\link{HDDataset}}
}
\keyword{attribute}
\keyword{connection}
\keyword{datagen}
\keyword{datasets}
\keyword{file}
\keyword{manip}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DatasetLoader-new}{\code{DatasetLoader$new()}}
\item \href{#method-DatasetLoader-load}{\code{DatasetLoader$load()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatasetLoader-new"></a>}}
\if{latex}{\out{\hypertarget{method-DatasetLoader-new}{}}}
\subsection{Method \code{new()}}{
Empty function used to initialize the object arguments in
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetLoader$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatasetLoader-load"></a>}}
\if{latex}{\out{\hypertarget{method-DatasetLoader-load}{}}}
\subsection{Method \code{load()}}{
Stores the input source into a \code{\link{Dataset}} or
\code{\link{HDDataset}} type object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetLoader$load(
  filepath,
  header = TRUE,
  sep = ",",
  skip.lines = 0,
  normalize.names = FALSE,
  string.as.factor = FALSE,
  ignore.columns = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filepath}}{The name of the file which the data are to be read from.
Each row of the table appears as one line of the file. If it does not
contain an _absolute_ path, the file name is _relative_ to the current
working directory, '\code{getwd()}'.}

\item{\code{header}}{A \link{logical} value indicating whether the file contains
the names of the variables as its first line. If missing, the value is
determined from the file format: '\code{header}' is set to '\link{TRUE}'
if and only if the first row contains one fewer field than the number of
columns.}

\item{\code{sep}}{The field separator character. Values on each line of the file
are separated by this character.}

\item{\code{skip.lines}}{Defines the number of header lines should be skipped.}

\item{\code{normalize.names}}{A \link{logical} value indicating whether the
columns names should be automatically renamed to ensure R compatibility.}

\item{\code{string.as.factor}}{A \link{logical} value indicating if character
columns should be converted to factors (default = FALSE).}

\item{\code{ignore.columns}}{Specify the columns from the input file that should
be ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Dataset}} or \code{\link{HDDataset}} object.
}
}
}
