% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubsetRecipeFunctions.R
\name{addIndicationSubsetDefinition}
\alias{addIndicationSubsetDefinition}
\title{Add Indication Subset Definition}
\usage{
addIndicationSubsetDefinition(
  cohortDefinitionSet,
  targetCohortIds,
  indicationCohortIds,
  subsetDefinitionId,
  subsetDefinitionName,
  subsetCohortNameTemplate = "@baseCohortName - @subsetDefinitionName",
  cohortCombinationOperator = "any",
  lookbackWindowStart = -99999,
  lookbackWindowEnd = 0,
  lookForwardWindowStart = 0,
  lookForwardWindowEnd = 99999,
  genderConceptIds = NULL,
  ageMin = NULL,
  ageMax = NULL,
  studyStartDate = NULL,
  studyEndDate = NULL,
  requiredPriorObservationTime = 365,
  requiredFollowUpTime = 1
)
}
\arguments{
\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{targetCohortIds}{Set of integer cohort IDs. Must be within the cohort definition set.}

\item{indicationCohortIds}{Set of integer cohort IDs. Must be within the cohort definition set.}

\item{subsetDefinitionId}{Unique integer Id of the subset definition}

\item{subsetDefinitionName}{name of the subset definition (used in resulting cohort definitions)}

\item{subsetCohortNameTemplate}{template string format for naming resulting cohorts}

\item{cohortCombinationOperator}{Logic for multiple indication cohort IDs: any (default) or all.}

\item{lookbackWindowStart}{Start of lookback period.}

\item{lookbackWindowEnd}{End of lookback period.}

\item{lookForwardWindowStart}{When the indication can end relative to index; default is 0.}

\item{lookForwardWindowEnd}{When the indication can end relative to index; default is 9999.}

\item{genderConceptIds}{Gender concepts to require}

\item{ageMin}{Minimum age at target index.}

\item{ageMax}{Maximum age at target index.}

\item{studyStartDate}{Exclude patients with index prior to this date (format "\%Y\%m\%d").}

\item{studyEndDate}{Exclude patients with index after this date (format "\%Y\%m\%d").}

\item{requiredPriorObservationTime}{Observation time prior to index; default 365.}

\item{requiredFollowUpTime}{Observation time after index; default 1.}
}
\description{
Utility pattern for creating an indication subset from a set of target cohorts.
The approach applies this subset definition to an exposure (target cohort) or
set of exposures (multiple target cohorts), requiring the individual to have
a history of the indication cohort overlapping the start of the first exposure.
The first exposure must have the `requiredPriorObservationTime` and
`requiredFollowUpTime`. If specified, the first exposure must also fall
within the `studyStartDate` and `studyEndDate` and also meet the age and
gender criteria.

Additionally, the R attribute of "indicationSubsetDefinitions" is attached to
the cohort definition set. This can be obtained by calling
`getIndicationSubsetDefinitionIds`, which should return the set of subset
definition ids that are associated with indications.
}
\examples{
\dontrun{
library(CohortGenerator)

initialSet <- getCohortDefinitionSet(
  settingsFileName = "testdata/name/Cohorts.csv",
  jsonFolder = "testdata/name/cohorts",
  sqlFolder = "testdata/name/sql/sql_server",
  cohortFileNameFormat = "\%s",
  cohortFileNameValue = c("cohortName"),
  packageName = "CohortGenerator",
  verbose = FALSE
)

print(initialSet[, c("cohortId", "cohortName")])

# Subset cohorts 1 & 2 by an "indication" cohort 3:
res <- addIndicationSubsetDefinition(
  cohortDefinitionSet = initialSet,
  targetCohortIds = c(1, 2),
  indicationCohortIds = c(3),
  subsetDefinitionId = 10
)

print(res[, c("cohortId", "cohortName", "subsetParent", "subsetDefinitionId", "isSubset")])

# Get all subset definitions that were created using the addIndicationSubsetDefinition:
subsetDefinitionId <- getIndicationSubsetDefinitionIds(res)

# Filter the cohortDefinitionSet to those cohorts defined using an indication subset definition:
newCohorts <- res |>
  dplyr::filter(subsetDefinitionId == subsetDefinitionId) |>
  dplyr::select(cohortId, cohortName, subsetParent, isSubset)
print(newCohorts)
}

}
