% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographicsCohort.R
\name{demographicsCohort}
\alias{demographicsCohort}
\title{Create cohorts based on patient demographics}
\usage{
demographicsCohort(
  cdm,
  name,
  ageRange = NULL,
  sex = NULL,
  minPriorObservation = NULL,
  .softValidation = TRUE
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{ageRange}{A list of vectors specifying minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female".}

\item{minPriorObservation}{A minimum number of continuous prior observation
days in the database.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A cohort table
}
\description{
\code{demographicsCohort()} creates a cohort table based on patient
characteristics. If and when an individual satisfies all the criteria they
enter the cohort. When they stop satisfying any of the criteria their
cohort entry ends.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor()

cohort <-  cdm |>
    demographicsCohort(name = "cohort3", ageRange = c(18,40), sex = "Male")

attrition(cohort)

# Can also create multiple demographic cohorts, and add minimum prior history requirements.

cohort <- cdm |>
    demographicsCohort(name = "cohort4",
    ageRange = list(c(0, 19),c(20, 64),c(65, 150)),
    sex = c("Male", "Female", "Both"),
    minPriorObservation = 365)

attrition(cohort)
}
}
