% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_metamodel.R
\name{run_metamodel}
\alias{run_metamodel}
\title{Fit the NLME metamodel}
\usage{
run_metamodel(mmdlfile, directoryToRun, nlme_hostPath, host)
}
\arguments{
\item{mmdlfile}{The metamodel file path; relative paths are acceptable.}

\item{directoryToRun}{The directory where the final results should be stored
If \code{missing}, the mmdlfile base directory is used.}

\item{nlme_hostPath}{json file with host definition for model execution.
Generated by Pirana application. Consider using \code{host} argument
when running from R.}

\item{host}{\code{\link[=NlmeParallelHost]{NlmeParallelHost()}} class instance.}
}
\value{
the results of \code{\link[=fitmodel]{fitmodel()}} run are returned if singular ESTARGS block is
provided; otherwise a list of \code{\link[=fitmodel]{fitmodel()}} and \code{\link[=simmodel]{simmodel()}} results
are returned.
}
\description{
Use for simple model execution given information contained in mmdl file.
}
\details{
See
\href{https://certara.github.io/R-RsNLME/articles/metamodels_overview.html#metamodel-overview}{Metamodel
documentation}.

If both \code{nlme_hostPath} and \code{host} specified, the former is used.
If \code{nlme_hostPath} is \code{missing}, \code{host} is used instead.
If both are \code{missing}, MPI local host with 4 threads is used for simple estimation
mode, multicore host is used for the others.

Multiple ESTARGS/SIMARGS are supported, they are applied for the model sequentially,
the results of previous estimation are applied to the model before the next one.
ESTARGS queue is executed first, SIMARGS queue is executed the second.
}
\examples{
\donttest{
mmdlfile <- system.file("extdata/mmdlNoTime/test.mmdl",
                       package = "Certara.RsNLME",
                       mustWork = TRUE)
directoryToRun <- file.path(tempdir(TRUE), "MmdlNoTimeTest")
# using default host
mmdlResults <- run_metamodel(mmdlfile = mmdlfile,
                             directoryToRun = directoryToRun)
}

}
\seealso{
NlmeParallelHost, fitmodel
}
\keyword{internal}
