% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_NLMELicense.R
\name{remove_NLMELicense}
\alias{remove_NLMELicense}
\title{Remove NLME License}
\usage{
remove_NLMELicense(InstallDir = Sys.getenv("INSTALLDIR"))
}
\arguments{
\item{InstallDir}{A character string specifying the directory
where the NLME Engine is installed e.g., \code{INSTALLDIR} environment
variable. The \code{cadlicensingtool} executable is expected to be located
within this directory, or within a subdirectory specified by the
\code{PML_BIN_DIR} environment variable.}
}
\value{
A logical value indicating whether the license information was
  successfully removed.
}
\description{
This function attempts to remove an NLME license using the specified
installation directory and licensing tool.
}
\details{
The function checks for the presence of the necessary
`appsettings.json` file in the specified directory or the CAD config file
specified by the `CAD_CONFIG_FILE` environment variable, runs the licensing
tool to log out the user, and attempts to remove the NLME license.
}
\examples{
\donttest{
INSTALLDIR <- Sys.getenv("INSTALLDIR")
if (INSTALLDIR == "") INSTALLDIR <- "C:/Program Files/Certara/NLME_Engine"
if (FALSE) { # to prevent unintended logout
  result <- remove_NLMELicense(INSTALLDIR)
}
}
}
