% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pyDarwin.R
\name{run_pyDarwin}
\alias{run_pyDarwin}
\title{Run pyDarwin Model Search}
\usage{
run_pyDarwin(
  InterpreterPath,
  Flags = c("-u", "-m"),
  DirectoryPath = ".",
  TemplatePath = "template.txt",
  TokensPath = "tokens.json",
  OptionsPath = "options.json",
  Wait = TRUE
)
}
\arguments{
\item{InterpreterPath}{Path to the Python interpreter executable.}

\item{Flags}{Flags to pass to the Python interpreter. Refer to Python
documentation for details. Note that \code{-m} is essential (runs library module
as a script and terminates option list).}

\item{DirectoryPath}{Optional path to the directory containing template file,
tokens file and options file. If that argument is given, it overrides the
paths of \code{TemplatePath}, \code{TokensPath}, \code{OptionsPath} with warning.
Default is current working directory.}

\item{TemplatePath}{Path to the template file.}

\item{TokensPath}{Path to the tokens JSON file.}

\item{OptionsPath}{Path to the options JSON file.}

\item{Wait}{Logical. If \code{TRUE}, the function waits for the search process to
complete and returns the results. If \code{FALSE}, the process is launched
and exits immediately.}
}
\value{
If \code{Wait} is \code{TRUE}, a list containing the results of the search,
including a data frame for all models executed, a final model and
properties of the final model generated by pyDarwin when available. If
nothing is available, \code{messages.txt} file text is given. If \code{Wait} is
\code{FALSE}, \code{messages.txt} file location is returned where raw output of
pyDarwin run is stored.
}
\description{
This function runs a pyDarwin model search using the specified parameters. It
launches the search process and monitors its progress.
}
\examples{
\dontrun{
result <- run_pyDarwin(
  InterpreterPath = "~/darwin/venv/bin/python",
  DirectoryPath = "~/project_folder",
  TemplatePath = "template.txt",
  TokensPath = "tokens.json",
  OptionsPath = "options.json"
)
}

}
