% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_StParmCustom.R
\name{modify_StParmCustom}
\alias{modify_StParmCustom}
\title{Modify custom structural parameter in PML spaces}
\usage{
modify_StParmCustom(
  PMLParametersSets,
  StParmName,
  Type,
  State,
  ThetaStParm,
  OmegaStParm,
  Covariates,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{StParmName}{Character specifying the name of the structural parameter
to be added.}

\item{Type}{Character specifying the type of the structural parameter. Options are
\itemize{
\item \code{LogNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV * wt^dVdwt * exp(nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{LogNormal1} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = (tvV + wt*dVdwt) * exp(nV + nVx0*( Occasion==0) + nVx1*( Occasion==1)))}
\itemize{
\item \code{LogNormal2} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = exp(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occason==1)))}
\itemize{
\item \code{LogitNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = ilogit(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{Normal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1))}}

\item{State}{character string that indicates the presence of the structural
parameter. Options are:
\itemize{
\item \code{None} The structural parameter does not exist in the specified \code{PMLStructures}.
\item \code{Present} The structural parameter exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the structural parameter  is searched.
}}

\item{ThetaStParm}{A Theta class instance inside the structural parameter. If
not given, the associated Theta will be automatically created with its name
set to "tv" + \code{StParmName}.}

\item{OmegaStParm}{An Omega class instance inside the structural parameter.
If not given, the associated Omega will be automatically created with its
name set to "n" + \code{StParmName}}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the structural parameter statement.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures to whichthe structural parameter will be added. For the naming
convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Modify custom structural parameter in PML spaces
}
\details{
This function can  be applied to the custom models.
It allows modification of custom structural parameters defined in the PML code
of these spaces.

When modifying a custom structural parameter, the corresponding \code{stparm}
statement is removed from the PML code, and the updated parameter is added
back as a \code{StParm} class using the provided arguments. Similarly, associated
\code{fixef} and \code{ranef} statements related to the custom structural parameter are
removed.

Please note that this function is specifically designed for modifying custom
structural parameters. For non-custom parameters, use \code{modify_StParm()}.
}
\examples{

# Modify the custom structural parameter 'Cl':
OneCpt_CustomCode <-
  paste0(
    "\nderiv(A1 = - Cl * C)",
    "\ndosepoint(A1)",
    "\ndosepoint2(A1, tlag = 12)",
    "\nC = A1 / V",
    "\nerror(CEps = 0.01)",
    "\nobserve(CObs = C + CEps * sqrt(1 + C^2 * (CMultStdev/sigma())^2), bql = 0.01)",
    "\nstparm(V = tvV * exp(nV))",
    "\nstparm(Cl = tvCl * exp(nCl))",
    "\nstparm(CMultStdev = tvCMultStdev)",
    "\nfixef(tvV = c(, 5, ))",
    "\nfixef(tvCl = c(, 1, ))",
    "\nfixef(tvCMultStdev = c(, 0.1, ))",
    "\nranef(diag(nV) = c(1))",
    "\nranef(diag(nCl) = c(1))\n"
  )

OneCpt_CustomCode <-
 modify_StParmCustom(
   create_CustomSpace(OneCpt_CustomCode),
                      StParmName = "Cl",
                      Type = "Normal")

}
\seealso{
\code{\link[=Dosepoint]{Dosepoint()}} \code{\link[=list_StParms]{list_StParms()}} \code{\link[=modify_StParm]{modify_StParm()}}

Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{add_StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParm}()},
\code{\link{remove_StParm}()}
}
\concept{StParms}
