% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{depth_distance}
\alias{depth_distance}
\title{Depth Distance}
\usage{
depth_distance(x, y = NULL, rfObject)
}
\arguments{
\item{x}{A data.frame with the same columns as in the training data of the RandomForest model}

\item{y}{A data.frame with the same columns as in the training data of the RandomForest model}

\item{rfObject}{\code{ranger} object}
}
\description{
This function returns for each observation the pairwise sum of edges  
between the corresponding terminal nodes over each tree in the random forest.
}
\examples{
\donttest{
require(ranger)
rf <- ranger(Species ~ ., data = iris, num.trees = 5, write.forest = TRUE)
depth_distance(x=iris[, -5], rfObject=rf)
}

}
