% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross2_var_vectors.R
\name{cross2_var_vectors}
\alias{cross2_var_vectors}
\title{Cross two vectors of variable names from a dataframe}
\usage{
cross2_var_vectors(data, x, y, verbose = FALSE)
}
\arguments{
\item{data}{the dataframe or tibble the variables are contained in.}

\item{x, y}{These are either character or integer vectors containing
the names, e.g. "am" or the column numbers e.g. 9}

\item{verbose}{the default is FALSE, setting to TRUE will cat additional
output to the screen}
}
\value{
a list with two sublists `lista` and `listb`. Very handy for
  feeding the lists to `purrr` for further processing.
}
\description{
Cross two vectors of variable names from a dataframe
}
\examples{
cross2_var_vectors(mtcars, 9, c(2, 10:11))
cross2_var_vectors(mtcars, "am", c("cyl", "gear", "carb"))
x2 <- c("am", "carb")
y2 <- c("vs", "cyl", "gear")
cross2_var_vectors(mtcars, x2, y2, verbose = TRUE)

\dontrun{
variables_list <- cross2_var_vectors(mtcars, x2, y2)
mytitles <- stringr::str_c(
  stringr::str_to_title(variables_list$listb),
  " by ",
  stringr::str_to_title(variables_list$lista),
  " in mtcars data"
  )
purrr::pmap(
.l = list(
   x = variables_list[[1]], # variables_list$lista
   y = variables_list[[2]], # variables_list$listb
   title = mytitles
),
.f = CGPfunctions::PlotXTabs2,
data = mtcars,
ylab = NULL,
perc.k = 1,
palette = "Set2"
)

}

}
\author{
Chuck Powell
}
