% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolateTrajectory.R
\name{interpolateTrajectory}
\alias{interpolateTrajectory}
\title{Interpolates a trajectory}
\usage{
interpolateTrajectory(data, n = 4)
}
\arguments{
\item{data}{A data frame with at least two columns: `x` and `y`, representing
the coordinates of the points.}

\item{n}{An integer indicating the number of intermediate points to generate
between each pair of points. Default is 4.}
}
\value{
A data frame containing the `x` and `y` coordinates, which includes
both the original points and the interpolated points.
}
\description{
Given a dataset of points, it interpolates to generate
intermediate points between them.
}
\examples{
# Create an example data frame
data <- data.frame(x = c(1, 2, 3), y = c(1, 4, 9))
# Interpolate the trajectory
interpolated <- interpolateTrajectory(data, n = 4)
print(interpolated)
}
