# Whole workflow works consistently

    Code
      set.seed(42)
      getLinearRegressions(getAlphaMetrics(resampling(gridding(meta, btf), measure = "ABUNDANCE",
      resamps = 1L), measure = "ABUNDANCE"), divType = "alpha")
    Message
      OK: all SL studies have 1 grid cell
    Output
           assemblageID     metric         slope       pvalue significance
      1       10_359170          S -1.071429e-01 5.456289e-01            0
      2       10_359170          N -9.094643e+01 2.713185e-01            0
      3       10_359170       maxN -4.566071e+01 3.600373e-01            0
      4       10_359170    Shannon  2.876712e-04 9.115369e-01            0
      5       10_359170 expShannon  1.535312e-03 9.111816e-01            0
      6       10_359170    Simpson  6.874126e-05 9.809871e-01            0
      7       10_359170 invSimpson  1.080483e-03 9.732770e-01            0
      8       10_359170        PIE  7.769795e-05 9.785639e-01            0
      9       10_359170      DomMc  3.730028e-04 5.829388e-02            0
      10      18_335699          S  6.636194e-02 3.593922e-01            0
      11      18_335699          N  7.985858e+00 5.519224e-02            0
      12      18_335699       maxN  1.286679e+00 3.175131e-01            0
      13      18_335699    Shannon  1.221322e-03 7.471293e-01            0
      14      18_335699 expShannon  1.408762e-02 7.215063e-01            0
      15      18_335699    Simpson  9.327292e-04 3.238158e-01            0
      16      18_335699 invSimpson  3.721588e-02 2.742686e-01            0
      17      18_335699        PIE  9.077169e-04 3.363446e-01            0
      18      18_335699      DomMc -1.361926e-03 3.690006e-01            0
      19      41_453357          S -2.563657e-01 1.379129e-01            0
      20      41_453357          N -1.936343e+00 5.137263e-02            0
      21      41_453357       maxN  4.328704e-01 1.559284e-02            1
      22      41_453357    Shannon -1.468300e-02 6.603122e-03            1
      23      41_453357 expShannon -4.490074e-01 5.283188e-03            1
      24      41_453357    Simpson -1.257937e-03 1.818562e-03            1
      25      41_453357 invSimpson -6.612574e-01 4.743937e-04            1
      26      41_453357        PIE -1.139895e-03 3.169750e-03            1
      27      41_453357      DomMc  7.400296e-03 1.927566e-04            1
      28      53_394335          S -4.224059e-02 6.302075e-01            0
      29      53_394335          N -6.050735e-01 1.326488e-01            0
      30      53_394335       maxN -3.575987e-01 2.948843e-01            0
      31      53_394335    Shannon  4.247240e-03 8.821820e-01            0
      32      53_394335 expShannon  2.999347e-02 6.880607e-01            0
      33      53_394335    Simpson  2.379700e-04 9.876894e-01            0
      34      53_394335 invSimpson  3.524614e-02 6.222640e-01            0
      35      53_394335        PIE  1.165605e-02 5.448768e-01            0
      36      53_394335      DomMc -6.298767e-03 5.061098e-01            0
      37      59_470660          S -3.247863e-02 7.118995e-01            0
      38      59_470660          N  1.567521e+00 1.702835e-01            0
      39      59_470660       maxN  1.247521e+00 5.361505e-02            0
      40      59_470660    Shannon -1.069113e-02 2.360752e-01            0
      41      59_470660 expShannon -4.081747e-02 2.142391e-01            0
      42      59_470660    Simpson -4.257660e-03 2.520287e-01            0
      43      59_470660 invSimpson -2.116523e-02 2.914275e-01            0
      44      59_470660        PIE -4.369669e-03 2.421277e-01            0
      45      59_470660      DomMc  4.197549e-04 8.633088e-01            0
      46     211_529239          S -2.000000e+00 6.779108e-02            0
      47     211_529239          N  1.779412e+01 5.191606e-01            0
      48     211_529239       maxN  6.500000e+00 3.679406e-01            0
      49     211_529239    Shannon -1.002270e-01 7.977556e-02            0
      50     211_529239 expShannon -8.459762e-01 7.451887e-02            0
      51     211_529239    Simpson -1.505174e-02 3.344109e-01            0
      52     211_529239 invSimpson -3.151640e-01 1.993800e-01            0
      53     211_529239        PIE -1.517073e-02 3.226634e-01            0
      54     211_529239      DomMc  2.365735e-02 1.453273e-01            0
      55     211_525598          S -3.623188e-01 3.779940e-01            0
      56     211_525598          N -3.752536e+01 4.342904e-02            1
      57     211_525598       maxN -1.469203e+01 2.497392e-02            1
      58     211_525598    Shannon -4.460284e-02 3.787878e-01            0
      59     211_525598 expShannon -1.927740e-01 4.676547e-01            0
      60     211_525598    Simpson -1.576438e-02 2.509026e-01            0
      61     211_525598 invSimpson -1.642639e-01 4.181959e-01            0
      62     211_525598        PIE -1.453543e-02 2.809429e-01            0
      63     211_525598      DomMc  1.850415e-02 4.332288e-01            0
      64     211_521960          S  1.746575e-01 6.852301e-01            0
      65     211_521960          N  1.171233e+01 6.813402e-01            0
      66     211_521960       maxN  3.777397e+00 7.131569e-01            0
      67     211_521960    Shannon  3.456011e-02 5.526129e-01            0
      68     211_521960 expShannon  3.549650e-01 4.621877e-01            0
      69     211_521960    Simpson  8.600778e-03 5.283409e-01            0
      70     211_521960 invSimpson  4.037533e-01 3.502875e-01            0
      71     211_521960        PIE  8.421801e-03 5.393394e-01            0
      72     211_521960      DomMc -2.339180e-02 4.186493e-01            0
      73     211_523410          S  1.428571e-01 8.594978e-01            0
      74     211_523410          N  8.964286e+00 6.140061e-01            0
      75     211_523410       maxN  8.928571e-01 8.843618e-01            0
      76     211_523410    Shannon  1.493335e-02 8.301901e-01            0
      77     211_523410 expShannon  7.392983e-02 8.194530e-01            0
      78     211_523410    Simpson  6.903318e-03 7.517301e-01            0
      79     211_523410 invSimpson  1.207049e-01 6.435506e-01            0
      80     211_523410        PIE  7.423904e-03 7.267778e-01            0
      81     211_523410      DomMc -1.668080e-02 5.468744e-01            0
      82     211_517585          S -6.000000e-01 6.837722e-01            0
      83     211_517585          N  1.090000e+01 7.417431e-01            0
      84     211_517585       maxN -3.000000e+00 7.920874e-01            0
      85     211_517585    Shannon  8.761593e-02 6.537749e-01            0
      86     211_517585 expShannon  3.210120e-01 6.242238e-01            0
      87     211_517585    Simpson  6.785295e-02 3.957919e-01            0
      88     211_517585 invSimpson  5.143976e-01 2.680090e-01            0
      89     211_517585        PIE  6.774439e-02 3.876822e-01            0
      90     211_517585      DomMc -2.481488e-02 6.675265e-01            0
      91     211_516855          S  2.100000e+00 1.242395e-01            0
      92     211_516855          N  7.960000e+01 4.680931e-01            0
      93     211_516855       maxN  5.030000e+01 4.668974e-01            0
      94     211_516855    Shannon  4.943140e-02 7.998877e-01            0
      95     211_516855 expShannon  9.562426e-02 8.883719e-01            0
      96     211_516855    Simpson  5.050678e-03 9.383583e-01            0
      97     211_516855 invSimpson -3.580542e-02 9.345056e-01            0
      98     211_516855        PIE  2.246040e-03 9.741201e-01            0
      99     211_516855      DomMc -1.122612e-02 8.668521e-01            0
      100    333_426984          S -8.226601e-02 6.092686e-01            0
      101    333_426984          N  3.705419e+00 1.821670e-01            0
      102    333_426984       maxN  9.970443e-01 1.122980e-01            0
      103    333_426984    Shannon -7.945457e-03 2.035531e-01            0
      104    333_426984 expShannon -1.623572e-01 2.032274e-01            0
      105    333_426984    Simpson -7.316497e-04 2.418345e-01            0
      106    333_426984 invSimpson -1.942904e-01 8.780413e-02            0
      107    333_426984        PIE -7.512372e-04 2.267935e-01            0
      108    333_426984      DomMc  3.907651e-03 4.216107e-02            1
      109   372_2374518          S -2.000000e-01 9.496051e-01            0
      110   372_2374518          N -1.360000e+01 7.764125e-01            0
      111   372_2374518       maxN -7.400000e+00 3.733638e-01            0
      112   372_2374518    Shannon  7.418447e-02 6.184746e-01            0
      113   372_2374518 expShannon  8.954943e-01 6.577420e-01            0
      114   372_2374518    Simpson  1.149445e-02 5.346507e-01            0
      115   372_2374518 invSimpson  9.598789e-01 5.277098e-01            0
      116   372_2374518        PIE  1.157046e-02 5.266354e-01            0
      117   372_2374518      DomMc -3.036808e-02 4.449502e-01            0
      118   372_2378881          S -1.700000e+00 4.555643e-01            0
      119   372_2378881          N  3.060000e+01 4.770262e-01            0
      120   372_2378881       maxN  1.930000e+01 6.189482e-01            0
      121   372_2378881    Shannon -1.013326e-01 4.722237e-01            0
      122   372_2378881 expShannon -1.123141e+00 4.334689e-01            0
      123   372_2378881    Simpson -1.890460e-02 6.917431e-01            0
      124   372_2378881 invSimpson -7.134108e-01 6.359300e-01            0
      125   372_2378881        PIE -1.944701e-02 6.870436e-01            0
      126   372_2378881      DomMc  1.297921e-02 8.375983e-01            0
      127   372_2426320          S -1.100000e+00 3.955090e-01            0
      128   372_2426320          N  9.300000e+00 7.047824e-01            0
      129   372_2426320       maxN  1.100000e+00 1.627331e-01            0
      130   372_2426320    Shannon -4.696182e-02 5.637843e-01            0
      131   372_2426320 expShannon -7.133819e-01 5.210816e-01            0
      132   372_2426320    Simpson -4.551556e-03 7.218677e-01            0
      133   372_2426320 invSimpson -2.738438e-01 7.750701e-01            0
      134   372_2426320        PIE -4.603360e-03 7.124017e-01            0
      135   372_2426320      DomMc -6.151076e-04 9.832597e-01            0
      136   372_2427777          S -3.700000e+00 1.012956e-01            0
      137   372_2427777          N -2.076000e+02 1.115052e-01            0
      138   372_2427777       maxN -3.100000e+00 8.561713e-01            0
      139   372_2427777    Shannon -9.952712e-02 2.812470e-01            0
      140   372_2427777 expShannon -1.300159e+00 2.908775e-01            0
      141   372_2427777    Simpson -1.517441e-02 3.607944e-01            0
      142   372_2427777 invSimpson -9.585050e-01 3.673093e-01            0
      143   372_2427777        PIE -1.507149e-02 3.629815e-01            0
      144   372_2427777      DomMc  2.596497e-02 5.624824e-01            0
      145   372_2428506          S -8.000000e-01 7.362478e-01            0
      146   372_2428506          N -1.260000e+01 7.826488e-01            0
      147   372_2428506       maxN  2.860000e+01 6.146236e-02            0
      148   372_2428506    Shannon -1.085104e-01 1.575378e-01            0
      149   372_2428506 expShannon -1.719022e+00 1.487248e-01            0
      150   372_2428506    Simpson -1.436609e-02 1.484243e-01            0
      151   372_2428506 invSimpson -1.663703e+00 1.237718e-01            0
      152   372_2428506        PIE -1.436575e-02 1.472182e-01            0
      153   372_2428506      DomMc  3.611379e-02 1.277579e-01            0
      154   372_2426316          S -1.000000e-01 7.763932e-01            0
      155   372_2426316          N -5.300000e+00 6.398805e-01            0
      156   372_2426316       maxN -8.800000e+00 7.071917e-02            0
      157   372_2426316    Shannon  4.115313e-02 2.632271e-02            1
      158   372_2426316 expShannon  4.398538e-01 2.393175e-02            1
      159   372_2426316    Simpson  1.154369e-02 1.684896e-01            0
      160   372_2426316 invSimpson  5.867791e-01 1.403523e-01            0
      161   372_2426316        PIE  1.165746e-02 1.636667e-01            0
      162   372_2426316      DomMc -2.208455e-02 2.227907e-01            0
      163   372_2408087          S -2.800000e+00 6.837722e-01            0
      164   372_2408087          N -1.200000e+01 6.768303e-01            0
      165   372_2408087       maxN -1.100000e+00 7.524807e-01            0
      166   372_2408087    Shannon -2.471932e-01 4.927307e-01            0
      167   372_2408087 expShannon -2.121452e+00 6.038410e-01            0
      168   372_2408087    Simpson -3.814539e-02 3.291424e-01            0
      169   372_2408087 invSimpson -1.719022e+00 5.352039e-01            0
      170   372_2408087        PIE -2.614672e-02 3.236527e-01            0
      171   372_2408087      DomMc  8.464926e-02 2.996006e-01            0
      172   372_2399318          S -3.000000e+00 3.325088e-01            0
      173   372_2399318          N -7.700000e+01 5.687002e-01            0
      174   372_2399318       maxN  1.500000e+00 9.471828e-01            0
      175   372_2399318    Shannon -1.346250e-01 3.362480e-02            1
      176   372_2399318 expShannon -2.403752e+00 2.061131e-02            1
      177   372_2399318    Simpson -1.386888e-02 1.086724e-03            1
      178   372_2399318 invSimpson -1.836801e+00 7.245082e-03            1
      179   372_2399318        PIE -1.371071e-02 2.457306e-03            1
      180   372_2399318      DomMc  3.024042e-02 6.342033e-02            0
      181   372_2347502          S -1.500000e+00 6.067581e-01            0
      182   372_2347502          N -8.370000e+01 7.289242e-03            1
      183   372_2347502       maxN -2.470000e+01 4.185084e-02            1
      184   372_2347502    Shannon  3.851606e-02 6.757902e-01            0
      185   372_2347502 expShannon  3.724158e-01 7.258322e-01            0
      186   372_2347502    Simpson  1.098729e-02 3.175540e-01            0
      187   372_2347502 invSimpson  7.405210e-01 3.550164e-01            0
      188   372_2347502        PIE  1.415423e-02 2.047288e-01            0
      189   372_2347502      DomMc -3.911859e-02 2.134181e-01            0
      190   372_2430698          S  1.300000e+00 5.036898e-01            0
      191   372_2430698          N -4.720000e+01 3.521803e-01            0
      192   372_2430698       maxN -9.000000e-01 8.585088e-01            0
      193   372_2430698    Shannon -7.246438e-03 8.524064e-01            0
      194   372_2430698 expShannon -1.831654e-01 8.260688e-01            0
      195   372_2430698    Simpson -1.546325e-03 5.681111e-01            0
      196   372_2430698 invSimpson -4.358781e-01 5.596699e-01            0
      197   372_2430698        PIE -1.385863e-03 5.866588e-01            0
      198   372_2430698      DomMc  7.109451e-03 5.792857e-01            0
      199   372_2428503          S -9.000000e-01 5.054364e-01            0
      200   372_2428503          N  1.800000e+00 8.344147e-01            0
      201   372_2428503       maxN  3.400000e+00 5.957651e-02            0
      202   372_2428503    Shannon -6.091616e-02 4.177806e-01            0
      203   372_2428503 expShannon -1.010040e+00 3.596490e-01            0
      204   372_2428503    Simpson -7.460551e-03 2.745110e-01            0
      205   372_2428503 invSimpson -9.888900e-01 2.230725e-01            0
      206   372_2428503        PIE -7.590716e-03 2.499460e-01            0
      207   372_2428503      DomMc  2.293953e-02 2.106918e-01            0
      208   372_2408078          S -2.200000e+00 8.590691e-02            0
      209   372_2408078          N -1.660000e+01 6.614465e-02            0
      210   372_2408078       maxN -3.700000e+00 1.919831e-01            0
      211   372_2408078    Shannon -6.672808e-02 3.166667e-01            0
      212   372_2408078 expShannon -7.154431e-01 3.452445e-01            0
      213   372_2408078    Simpson -3.947669e-03 6.606083e-01            0
      214   372_2408078 invSimpson -2.975294e-01 6.170128e-01            0
      215   372_2408078        PIE -2.377639e-03 7.834752e-01            0
      216   372_2408078      DomMc  2.601394e-03 9.189502e-01            0
      217   372_2397858          S  1.300000e+00 3.877140e-01            0
      218   372_2397858          N -9.500000e+01 1.570466e-01            0
      219   372_2397858       maxN -2.540000e+01 1.927333e-01            0
      220   372_2397858    Shannon  3.950907e-02 4.279570e-01            0
      221   372_2397858 expShannon  4.804654e-01 4.453895e-01            0
      222   372_2397858    Simpson  1.848342e-03 8.661751e-01            0
      223   372_2397858 invSimpson  2.652017e-01 7.630013e-01            0
      224   372_2397858        PIE  2.111556e-03 8.480091e-01            0
      225   372_2397858      DomMc -1.018531e-02 7.418239e-01            0
      226   372_2400785          S  9.428571e-01 4.089206e-01            0
      227   372_2400785          N  6.771429e+01 8.797802e-02            0
      228   372_2400785       maxN  1.505714e+01 2.199356e-01            0
      229   372_2400785    Shannon -2.343753e-02 6.334171e-01            0
      230   372_2400785 expShannon -3.213092e-01 6.838855e-01            0
      231   372_2400785    Simpson -4.586024e-03 5.308091e-01            0
      232   372_2400785 invSimpson -3.275967e-01 6.662400e-01            0
      233   372_2400785        PIE -5.879821e-03 4.423896e-01            0
      234   372_2400785      DomMc  8.328339e-03 7.314672e-01            0
      235   372_2437271          S  7.000000e-01 6.563835e-01            0
      236   372_2437271          N  1.210000e+01 5.460709e-01            0
      237   372_2437271       maxN -1.900000e+00 8.632173e-01            0
      238   372_2437271    Shannon  4.646403e-02 6.223275e-01            0
      239   372_2437271 expShannon  7.532291e-01 5.651600e-01            0
      240   372_2437271    Simpson  3.860858e-03 7.782008e-01            0
      241   372_2437271 invSimpson  5.175244e-01 6.338013e-01            0
      242   372_2437271        PIE  3.763390e-03 7.826470e-01            0
      243   372_2437271      DomMc  2.151003e-04 9.960122e-01            0
      244   372_2424858          S  1.100000e+00 5.412683e-01            0
      245   372_2424858          N -4.000000e+00 8.854897e-01            0
      246   372_2424858       maxN -2.900000e+00 6.823527e-01            0
      247   372_2424858    Shannon  1.068070e-01 3.054602e-01            0
      248   372_2424858 expShannon  9.305235e-01 2.868274e-01            0
      249   372_2424858    Simpson  1.824415e-02 2.343564e-01            0
      250   372_2424858 invSimpson  6.134087e-01 2.314088e-01            0
      251   372_2424858        PIE  1.880955e-02 1.683563e-01            0
      252   372_2424858      DomMc -4.190073e-02 2.168230e-01            0
      253   372_2410991          S -4.000000e-01 5.890318e-01            0
      254   372_2410991          N -2.200000e+00 7.839606e-01            0
      255   372_2410991       maxN  2.300000e+00 2.785582e-01            0
      256   372_2410991    Shannon -8.787678e-02 1.685027e-01            0
      257   372_2410991 expShannon -6.894954e-01 1.691970e-01            0
      258   372_2410991    Simpson -2.264548e-02 8.599894e-02            0
      259   372_2410991 invSimpson -8.305163e-01 5.729821e-02            0
      260   372_2410991        PIE -2.297251e-02 8.749159e-02            0
      261   372_2410991      DomMc  4.011307e-02 7.380499e-02            0
      262   372_2375241          S -2.400000e+00 4.037152e-01            0
      263   372_2375241          N -1.950000e+01 1.141396e-01            0
      264   372_2375241       maxN -1.300000e+00 4.379610e-01            0
      265   372_2375241    Shannon -2.535451e-02 7.576586e-01            0
      266   372_2375241 expShannon -4.387009e-01 8.093397e-01            0
      267   372_2375241    Simpson -5.081903e-04 8.970454e-01            0
      268   372_2375241 invSimpson -5.086697e-02 9.683298e-01            0
      269   372_2375241        PIE -1.462488e-04 9.702781e-01            0
      270   372_2375241      DomMc -3.867428e-03 7.026840e-01            0
      271   372_2406610          S  5.000000e-01 7.924043e-01            0
      272   372_2406610          N  1.690000e+01 5.892043e-01            0
      273   372_2406610       maxN  8.000000e-01 9.423976e-01            0
      274   372_2406610    Shannon -9.827945e-03 9.355223e-01            0
      275   372_2406610 expShannon -2.500644e-01 8.389547e-01            0
      276   372_2406610    Simpson  5.292233e-03 8.339108e-01            0
      277   372_2406610 invSimpson -1.344054e-01 8.717930e-01            0
      278   372_2406610        PIE  5.168786e-03 8.379158e-01            0
      279   372_2406610      DomMc  1.228539e-02 7.545438e-01            0
      280   372_2459963          S  3.400000e+00 3.446488e-02            1
      281   372_2459963          N  1.560000e+01 1.284780e-01            0
      282   372_2459963       maxN  3.200000e+00 2.192799e-01            0
      283   372_2459963    Shannon  1.933220e-01 3.624219e-02            1
      284   372_2459963 expShannon  1.542891e+00 1.869975e-02            1
      285   372_2459963    Simpson  2.934036e-02 8.284854e-02            0
      286   372_2459963 invSimpson  7.912680e-01 5.740554e-02            0
      287   372_2459963        PIE  2.837731e-02 9.008978e-02            0
      288   372_2459963      DomMc -5.757719e-02 1.532647e-01            0
      289   372_2442444          S -1.000000e+01 2.754587e-01            0
      290   372_2442444          N -6.750000e+01 1.367121e-01            0
      291   372_2442444       maxN -1.450000e+01 1.847464e-01            0
      292   372_2442444    Shannon -9.652094e-01 3.317561e-01            0
      293   372_2442444 expShannon -5.567966e+00 3.297755e-01            0
      294   372_2442444    Simpson -2.222222e-01 3.325251e-01            0
      295   372_2442444 invSimpson -3.600000e+00 3.293042e-01            0
      296   372_2442444        PIE -1.143552e-01 3.386364e-01            0
      297   372_2442444      DomMc  3.079710e-01 3.321158e-01            0
      298   372_2434415          S -1.000000e+00 4.023857e-01            0
      299   372_2434415          N  3.090000e+01 1.278804e-01            0
      300   372_2434415       maxN  3.500000e+00 6.843515e-01            0
      301   372_2434415    Shannon -7.272751e-02 4.946140e-01            0
      302   372_2434415 expShannon -1.364419e+00 4.636109e-01            0
      303   372_2434415    Simpson -3.221808e-03 7.790573e-01            0
      304   372_2434415 invSimpson -3.326579e-01 7.934841e-01            0
      305   372_2434415        PIE -3.849979e-03 7.437591e-01            0
      306   372_2434415      DomMc -1.324955e-04 9.970468e-01            0
      307   372_2367201          S -8.214286e-01 4.465380e-01            0
      308   372_2367201          N  9.285714e-01 9.236552e-01            0
      309   372_2367201       maxN -7.142857e-02 9.676329e-01            0
      310   372_2367201    Shannon -4.792520e-02 2.517006e-01            0
      311   372_2367201 expShannon -5.817428e-01 3.056349e-01            0
      312   372_2367201    Simpson -4.269680e-03 2.646172e-01            0
      313   372_2367201 invSimpson -3.692779e-01 3.699633e-01            0
      314   372_2367201        PIE -5.317711e-03 1.414594e-01            0
      315   372_2367201      DomMc  6.377724e-03 4.386399e-01            0
      316   372_2440940          S -2.600000e+00 6.581800e-02            0
      317   372_2440940          N -1.420000e+01 2.116079e-01            0
      318   372_2440940       maxN -2.700000e+00 3.087531e-01            0
      319   372_2440940    Shannon -1.912458e-01 4.085171e-02            1
      320   372_2440940 expShannon -1.723950e+00 4.221260e-02            1
      321   372_2440940    Simpson -2.539153e-02 2.642736e-02            1
      322   372_2440940 invSimpson -1.130342e+00 2.138279e-02            1
      323   372_2440940        PIE -2.190903e-02 2.170992e-02            1
      324   372_2440940      DomMc  5.391118e-02 1.783429e-02            1
      325   372_2443127          S -6.857143e-01 6.022039e-01            0
      326   372_2443127          N  2.242857e+01 7.094637e-01            0
      327   372_2443127       maxN  2.408571e+01 4.005221e-01            0
      328   372_2443127    Shannon -6.215917e-02 6.995095e-01            0
      329   372_2443127 expShannon -7.466643e-01 7.026036e-01            0
      330   372_2443127    Simpson -1.915490e-02 4.844242e-01            0
      331   372_2443127 invSimpson -8.228755e-01 6.043288e-01            0
      332   372_2443127        PIE -1.930709e-02 4.940486e-01            0
      333   372_2443127      DomMc  1.594682e-02 7.743292e-01            0
      334   372_2432888          S -2.200000e+00 1.684782e-01            0
      335   372_2432888          N -1.600000e+01 5.912458e-01            0
      336   372_2432888       maxN -4.500000e+00 6.149061e-01            0
      337   372_2432888    Shannon -8.913804e-02 3.539478e-01            0
      338   372_2432888 expShannon -1.163283e+00 3.901512e-01            0
      339   372_2432888    Simpson -4.796144e-03 7.512403e-01            0
      340   372_2432888 invSimpson -4.666183e-01 7.480734e-01            0
      341   372_2432888        PIE -4.106473e-03 7.845071e-01            0
      342   372_2432888      DomMc  6.933231e-03 8.968050e-01            0
      343   372_2428509          S  7.000000e-01 7.418011e-01            0
      344   372_2428509          N  5.140000e+01 2.016554e-01            0
      345   372_2428509       maxN  1.620000e+01 1.148994e-01            0
      346   372_2428509    Shannon -1.013873e-01 4.018842e-01            0
      347   372_2428509 expShannon -1.047380e+00 3.681606e-01            0
      348   372_2428509    Simpson -1.776985e-02 2.401802e-01            0
      349   372_2428509 invSimpson -9.108568e-01 2.307946e-01            0
      350   372_2428509        PIE -1.851755e-02 2.170973e-01            0
      351   372_2428509      DomMc  4.310071e-02 1.443948e-01            0
      352   372_2421957          S -2.500000e+00 5.122457e-01            0
      353   372_2421957          N -3.300000e+01 4.381112e-01            0
      354   372_2421957       maxN -7.500000e+00 2.549703e-01            0
      355   372_2421957    Shannon -1.336275e-02 9.009306e-01            0
      356   372_2421957 expShannon -1.457115e-01 8.936420e-01            0
      357   372_2421957    Simpson  1.750539e-03 9.487872e-01            0
      358   372_2421957 invSimpson  1.089820e-01 9.337309e-01            0
      359   372_2421957        PIE  7.202859e-03 7.098566e-01            0
      360   372_2421957      DomMc  1.096491e-02 8.187294e-01            0
      361   372_2406614          S  2.700000e+00 4.720073e-01            0
      362   372_2406614          N  4.000000e+00 9.686330e-01            0
      363   372_2406614       maxN -9.600000e+00 8.847299e-01            0
      364   372_2406614    Shannon  6.535365e-02 5.445477e-01            0
      365   372_2406614 expShannon  1.154029e+00 5.243667e-01            0
      366   372_2406614    Simpson  7.600482e-03 7.580472e-01            0
      367   372_2406614 invSimpson  6.410583e-01 7.768022e-01            0
      368   372_2406614        PIE  7.599112e-03 7.593088e-01            0
      369   372_2406614      DomMc -9.567463e-03 8.734033e-01            0
      370   372_2402963          S -2.600000e+00 4.647985e-01            0
      371   372_2402963          N -8.600000e+01 1.825893e-01            0
      372   372_2402963       maxN -2.380000e+01 3.137533e-01            0
      373   372_2402963    Shannon -5.012079e-02 6.302994e-01            0
      374   372_2402963 expShannon -9.035389e-01 6.587914e-01            0
      375   372_2402963    Simpson -3.073494e-03 7.357583e-01            0
      376   372_2402963 invSimpson -4.367655e-01 7.898394e-01            0
      377   372_2402963        PIE -2.992155e-03 7.426159e-01            0
      378   372_2402963      DomMc  4.212512e-03 8.692000e-01            0
      379   372_2426315          S -1.500000e+00 5.934803e-01            0
      380   372_2426315          N -1.140000e+02 8.651537e-02            0
      381   372_2426315       maxN -4.050000e+01 3.726639e-01            0
      382   372_2426315    Shannon  9.626862e-02 1.938753e-01            0
      383   372_2426315 expShannon  1.584400e+00 1.822900e-01            0
      384   372_2426315    Simpson  7.540625e-03 5.793284e-01            0
      385   372_2426315 invSimpson  6.441583e-01 6.206500e-01            0
      386   372_2426315        PIE  7.740637e-03 5.719333e-01            0
      387   372_2426315      DomMc  8.356152e-03 7.860817e-01            0
      388   372_2427046          S  2.000000e-01 9.274524e-01            0
      389   372_2427046          N  4.240000e+01 5.749146e-01            0
      390   372_2427046       maxN  1.880000e+01 2.706382e-01            0
      391   372_2427046    Shannon -4.967786e-02 6.989253e-01            0
      392   372_2427046 expShannon -6.144735e-01 7.784173e-01            0
      393   372_2427046    Simpson -6.822159e-03 6.260019e-01            0
      394   372_2427046 invSimpson -4.501582e-01 8.118685e-01            0
      395   372_2427046        PIE -6.923033e-03 6.186425e-01            0
      396   372_2427046      DomMc  7.889305e-03 8.098788e-01            0
      397   372_2403683          S -4.000000e-01 8.651600e-01            0
      398   372_2403683          N  3.000000e+00 9.059834e-01            0
      399   372_2403683       maxN  4.400000e+00 3.764978e-01            0
      400   372_2403683    Shannon -1.403716e-01 4.492006e-01            0
      401   372_2403683 expShannon -9.080259e-01 5.311974e-01            0
      402   372_2403683    Simpson -3.925610e-02 4.037716e-01            0
      403   372_2403683 invSimpson -7.520841e-01 5.714314e-01            0
      404   372_2403683        PIE -3.963556e-02 3.939779e-01            0
      405   372_2403683      DomMc  6.604047e-02 4.491896e-01            0
      406   372_2369392          S -2.500000e+00 2.112930e-01            0
      407   372_2369392          N -4.200000e+01 9.920320e-02            0
      408   372_2369392       maxN -2.460000e+01 7.191568e-02            0
      409   372_2369392    Shannon  6.037223e-02 7.408482e-01            0
      410   372_2369392 expShannon  7.818519e-02 9.473500e-01            0
      411   372_2369392    Simpson  5.083812e-02 4.478799e-01            0
      412   372_2369392 invSimpson  3.176433e-01 7.193804e-01            0
      413   372_2369392        PIE  5.511800e-02 4.169750e-01            0
      414   372_2369392      DomMc -4.014411e-02 4.669883e-01            0
      415   372_2400047          S  6.309524e-01 3.866478e-01            0
      416   372_2400047          N -3.035714e+00 8.143969e-01            0
      417   372_2400047       maxN -1.880952e+00 4.786668e-01            0
      418   372_2400047    Shannon  4.635253e-02 2.418376e-01            0
      419   372_2400047 expShannon  4.674246e-01 3.230650e-01            0
      420   372_2400047    Simpson  5.666853e-03 2.160511e-01            0
      421   372_2400047 invSimpson  3.011254e-01 3.489289e-01            0
      422   372_2400047        PIE  5.752282e-03 2.103928e-01            0
      423   372_2400047      DomMc -7.182582e-03 4.399553e-01            0
      424   372_2431454          S  6.000000e-01 7.075908e-01            0
      425   372_2431454          N -1.534286e+01 6.593296e-01            0
      426   372_2431454       maxN -4.800000e+00 6.051287e-01            0
      427   372_2431454    Shannon  9.031873e-02 1.064476e-01            0
      428   372_2431454 expShannon  1.000112e+00 1.410896e-01            0
      429   372_2431454    Simpson  1.252704e-02 1.068329e-01            0
      430   372_2431454 invSimpson  8.784015e-01 1.469071e-01            0
      431   372_2431454        PIE  1.355790e-02 1.033139e-01            0
      432   372_2431454      DomMc -2.393425e-02 2.540475e-01            0
      433   372_2443903          S -4.571429e+00 1.797676e-02            1
      434   372_2443903          N -2.411429e+01 2.669542e-02            1
      435   372_2443903       maxN -8.857143e-01 7.534394e-01            0
      436   372_2443903    Shannon -2.224203e-01 3.525995e-02            1
      437   372_2443903 expShannon -2.898539e+00 3.208306e-02            1
      438   372_2443903    Simpson -2.473823e-02 8.026931e-02            0
      439   372_2443903 invSimpson -2.049811e+00 7.608351e-02            0
      440   372_2443903        PIE -2.291565e-02 1.052458e-01            0
      441   372_2443903      DomMc  5.138582e-02 1.109088e-01            0
      442   372_2394207          S -1.142857e+00 2.721794e-01            0
      443   372_2394207          N -7.062857e+01 4.236546e-01            0
      444   372_2394207       maxN -3.714286e+00 8.689619e-01            0
      445   372_2394207    Shannon -4.856393e-02 1.050853e-01            0
      446   372_2394207 expShannon -5.500382e-01 1.119531e-01            0
      447   372_2394207    Simpson -7.169954e-03 1.410787e-01            0
      448   372_2394207 invSimpson -4.549371e-01 1.484012e-01            0
      449   372_2394207        PIE -7.012072e-03 1.573666e-01            0
      450   372_2394207      DomMc  2.035116e-02 1.512018e-01            0
      451   372_2362812          S  2.269231e+00 4.266836e-01            0
      452   372_2362812          N  4.092308e+01 1.367268e-01            0
      453   372_2362812       maxN  2.580769e+01 5.577950e-01            0
      454   372_2362812    Shannon  1.612788e-02 9.428289e-01            0
      455   372_2362812 expShannon  3.692289e-01 9.090041e-01            0
      456   372_2362812    Simpson -1.303561e-02 7.532924e-01            0
      457   372_2362812 invSimpson -1.719662e-01 9.563644e-01            0
      458   372_2362812        PIE -1.332536e-02 7.490471e-01            0
      459   372_2362812      DomMc  2.185256e-02 7.781898e-01            0
      460   372_2410264          S  1.000000e-01 8.459763e-01            0
      461   372_2410264          N -1.420000e+01 9.039008e-02            0
      462   372_2410264       maxN -2.300000e+00 3.319695e-01            0
      463   372_2410264    Shannon -3.001963e-03 9.177237e-01            0
      464   372_2410264 expShannon -3.286985e-02 9.303870e-01            0
      465   372_2410264    Simpson -2.724498e-04 9.560261e-01            0
      466   372_2410264 invSimpson -2.283226e-02 9.591021e-01            0
      467   372_2410264        PIE  3.984683e-04 9.353295e-01            0
      468   372_2410264      DomMc  4.509281e-04 9.775188e-01            0
      469   372_2452656          S  6.000000e-01 7.008801e-01            0
      470   372_2452656          N  5.830000e+01 2.463098e-01            0
      471   372_2452656       maxN  5.300000e+00 3.095237e-01            0
      472   372_2452656    Shannon  2.726891e-02 3.392498e-01            0
      473   372_2452656 expShannon  6.345033e-01 3.477325e-01            0
      474   372_2452656    Simpson  2.933557e-03 2.435780e-01            0
      475   372_2452656 invSimpson  7.642046e-01 2.643379e-01            0
      476   372_2452656        PIE  2.801679e-03 2.719650e-01            0
      477   372_2452656      DomMc -9.010343e-05 9.920168e-01            0
      478   372_2379617          S -3.300000e+00 5.327074e-02            0
      479   372_2379617          N -4.500000e+00 9.731803e-01            0
      480   372_2379617       maxN  3.900000e+00 8.870277e-01            0
      481   372_2379617    Shannon -4.690899e-02 2.849196e-01            0
      482   372_2379617 expShannon -6.584693e-01 2.809116e-01            0
      483   372_2379617    Simpson -2.879745e-03 3.041530e-01            0
      484   372_2379617 invSimpson -2.087765e-01 2.973421e-01            0
      485   372_2379617        PIE -2.867560e-03 3.126714e-01            0
      486   372_2379617      DomMc -3.768246e-03 7.168539e-01            0
      487   372_2441713          S  1.100000e+00 6.547293e-01            0
      488   372_2441713          N  7.310000e+01 1.041122e-01            0
      489   372_2441713       maxN -1.500000e+00 8.012329e-01            0
      490   372_2441713    Shannon  6.790312e-02 4.455487e-01            0
      491   372_2441713 expShannon  1.274921e+00 4.738833e-01            0
      492   372_2441713    Simpson  7.742421e-03 3.064683e-01            0
      493   372_2441713 invSimpson  1.326874e+00 3.525111e-01            0
      494   372_2441713        PIE  7.558839e-03 3.132083e-01            0
      495   372_2441713      DomMc -2.720082e-02 3.269747e-01            0
      496   372_2442439          S -1.800000e+00 4.522774e-01            0
      497   372_2442439          N  4.270000e+01 8.090172e-01            0
      498   372_2442439       maxN  4.570000e+01 7.451487e-01            0
      499   372_2442439    Shannon -1.771635e-01 5.757382e-01            0
      500   372_2442439 expShannon -2.534783e+00 4.887366e-01            0
      501   372_2442439    Simpson -3.178416e-02 7.080048e-01            0
      502   372_2442439 invSimpson -1.829906e+00 5.811790e-01            0
      503   372_2442439        PIE -3.190125e-02 7.095278e-01            0
      504   372_2442439      DomMc  5.142171e-02 6.865999e-01            0
      505   372_2440221          S  1.400000e+00 3.276522e-01            0
      506   372_2440221          N -4.000000e-01 9.506104e-01            0
      507   372_2440221       maxN -1.400000e+00 4.281540e-01            0
      508   372_2440221    Shannon  5.180648e-02 4.436424e-01            0
      509   372_2440221 expShannon  6.358328e-01 4.006687e-01            0
      510   372_2440221    Simpson  4.819623e-03 5.516892e-01            0
      511   372_2440221 invSimpson  4.391024e-01 5.441512e-01            0
      512   372_2440221        PIE  4.851422e-03 5.467579e-01            0
      513   372_2440221      DomMc -1.504890e-02 5.021246e-01            0
      514   372_2438027          S -9.000000e-01 6.370850e-01            0
      515   372_2438027          N  1.440000e+01 4.369154e-01            0
      516   372_2438027       maxN  5.700000e+00 2.861043e-01            0
      517   372_2438027    Shannon -4.681443e-02 5.760849e-01            0
      518   372_2438027 expShannon -8.209820e-01 5.444582e-01            0
      519   372_2438027    Simpson -4.660733e-03 5.818656e-01            0
      520   372_2438027 invSimpson -7.648796e-01 4.950330e-01            0
      521   372_2438027        PIE -5.225097e-03 5.405412e-01            0
      522   372_2438027      DomMc  1.906716e-02 4.655564e-01            0
      523   372_2434379          S -7.000000e+00 1.544210e-01            0
      524   372_2434379          N -1.020000e+02 5.392253e-02            0
      525   372_2434379       maxN -1.250000e+01 4.145679e-01            0
      526   372_2434379    Shannon -2.995711e-01 1.829268e-01            0
      527   372_2434379 expShannon -3.676084e+00 2.175944e-01            0
      528   372_2434379    Simpson -3.635856e-02 2.237979e-01            0
      529   372_2434379 invSimpson -2.410336e+00 2.689790e-01            0
      530   372_2434379        PIE -3.248340e-02 2.738893e-01            0
      531   372_2434379      DomMc  6.944123e-02 4.225727e-01            0
      532   372_2435823          S -8.000000e-01 4.037152e-01            0
      533   372_2435823          N -7.090000e+01 2.801251e-01            0
      534   372_2435823       maxN  1.570000e+01 5.252766e-01            0
      535   372_2435823    Shannon -8.128725e-02 4.038192e-01            0
      536   372_2435823 expShannon -1.289597e+00 4.406448e-01            0
      537   372_2435823    Simpson -1.369356e-02 2.709298e-01            0
      538   372_2435823 invSimpson -1.464710e+00 3.043182e-01            0
      539   372_2435823        PIE -1.361339e-02 2.753707e-01            0
      540   372_2435823      DomMc  5.103194e-02 2.309211e-01            0
      541   372_2425589          S -1.200000e+00 4.598306e-01            0
      542   372_2425589          N -2.200000e+01 8.236033e-02            0
      543   372_2425589       maxN -1.800000e+00 3.201087e-01            0
      544   372_2425589    Shannon -4.569401e-02 2.134305e-01            0
      545   372_2425589 expShannon -7.030751e-01 2.063587e-01            0
      546   372_2425589    Simpson -4.914970e-03 8.011158e-02            0
      547   372_2425589 invSimpson -6.537781e-01 6.898617e-02            0
      548   372_2425589        PIE -3.788261e-03 1.481193e-01            0
      549   372_2425589      DomMc  1.409782e-02 8.363258e-02            0
      550   372_2427047          S -9.000000e-01 2.254033e-01            0
      551   372_2427047          N -3.181000e+02 3.840827e-01            0
      552   372_2427047       maxN -1.663000e+02 4.439320e-01            0
      553   372_2427047    Shannon  1.328793e-01 2.116373e-01            0
      554   372_2427047 expShannon  1.392213e+00 2.098848e-01            0
      555   372_2427047    Simpson  2.146140e-02 3.282759e-01            0
      556   372_2427047 invSimpson  1.033092e+00 2.833218e-01            0
      557   372_2427047        PIE  2.151184e-02 3.281528e-01            0
      558   372_2427047      DomMc -4.995919e-02 3.636385e-01            0
      559   372_2427776          S  2.500000e+00 5.169595e-02            0
      560   372_2427776          N  1.100000e+02 3.453106e-03            1
      561   372_2427776       maxN  8.000000e+00 9.301482e-02            0
      562   372_2427776    Shannon  5.701977e-02 2.959977e-02            1
      563   372_2427776 expShannon  7.337850e-01 2.572033e-02            1
      564   372_2427776    Simpson  9.052183e-03 4.504357e-03            1
      565   372_2427776 invSimpson  6.862274e-01 3.198987e-03            1
      566   372_2427776        PIE  8.799992e-03 4.381277e-03            1
      567   372_2427776      DomMc -2.326626e-02 9.192456e-02            0
      568   372_2429234          S -1.500000e+00 9.393996e-02            0
      569   372_2429234          N -1.180000e+01 2.979144e-01            0
      570   372_2429234       maxN -3.800000e+00 1.419350e-01            0
      571   372_2429234    Shannon -2.908429e-02 6.188572e-01            0
      572   372_2429234 expShannon -2.956400e-01 6.625722e-01            0
      573   372_2429234    Simpson -1.260582e-03 8.248806e-01            0
      574   372_2429234 invSimpson -4.509633e-02 9.181936e-01            0
      575   372_2429234        PIE -1.087940e-03 8.503433e-01            0
      576   372_2429234      DomMc -6.951196e-03 3.405092e-01            0
      577   372_2429233          S  4.000000e-01 8.000000e-01            0
      578   372_2429233          N  1.510000e+01 6.717508e-01            0
      579   372_2429233       maxN  4.000000e+00 4.919995e-01            0
      580   372_2429233    Shannon -2.221047e-03 9.743292e-01            0
      581   372_2429233 expShannon  1.588499e-03 9.984713e-01            0
      582   372_2429233    Simpson -8.243093e-04 8.707970e-01            0
      583   372_2429233 invSimpson -5.922383e-02 8.919508e-01            0
      584   372_2429233        PIE -1.075497e-03 8.255953e-01            0
      585   372_2429233      DomMc -1.785819e-03 8.137091e-01            0
      586   372_2425610          S -1.000000e-01 9.373776e-01            0
      587   372_2425610          N -5.630000e+01 4.136355e-01            0
      588   372_2425610       maxN -1.210000e+01 7.704175e-01            0
      589   372_2425610    Shannon -6.050802e-02 5.367103e-01            0
      590   372_2425610 expShannon -5.720798e-01 5.369781e-01            0
      591   372_2425610    Simpson -1.014509e-02 7.043307e-01            0
      592   372_2425610 invSimpson -6.638677e-01 5.531088e-01            0
      593   372_2425610        PIE -9.648248e-03 7.225305e-01            0
      594   372_2425610      DomMc  3.063448e-02 5.284094e-01            0
      595   372_2423417          S  6.000000e+00 1.789124e-01            0
      596   372_2423417          N -2.035000e+02 3.945449e-01            0
      597   372_2423417       maxN -2.350000e+02 3.403267e-01            0
      598   372_2423417    Shannon  1.012615e+00 3.001500e-01            0
      599   372_2423417 expShannon  6.711603e+00 2.578699e-01            0
      600   372_2423417    Simpson  3.053637e-01 3.193848e-01            0
      601   372_2423417 invSimpson  4.496933e+00 2.390353e-01            0
      602   372_2423417        PIE  3.072396e-01 3.205086e-01            0
      603   372_2423417      DomMc -2.882599e-01 2.803290e-01            0
      604   372_2404439          S  7.117912e-13 1.000000e+00            0
      605   372_2404439          N  8.700000e+01 2.906079e-01            0
      606   372_2404439       maxN  5.150000e+01 1.070441e-02            1
      607   372_2404439    Shannon -1.951284e-01 4.959271e-02            1
      608   372_2404439 expShannon -2.931464e+00 8.398956e-02            0
      609   372_2404439    Simpson -3.410440e-02 1.226388e-01            0
      610   372_2404439 invSimpson -3.220818e+00 9.562821e-03            1
      611   372_2404439        PIE -3.468847e-02 1.161050e-01            0
      612   372_2404439      DomMc  7.615711e-02 1.285312e-01            0
      613   372_2412474          S -1.000000e+00 8.642628e-01            0
      614   372_2412474          N -7.500000e+01 5.735265e-01            0
      615   372_2412474       maxN -1.700000e+01 6.611809e-01            0
      616   372_2412474    Shannon  7.555916e-02 4.903156e-01            0
      617   372_2412474 expShannon  1.184100e+00 5.036417e-01            0
      618   372_2412474    Simpson  1.108642e-02 1.173316e-01            0
      619   372_2412474 invSimpson  1.588636e+00 1.569665e-01            0
      620   372_2412474        PIE  1.252362e-02 1.621882e-01            0
      621   372_2412474      DomMc -3.000739e-02 5.596535e-01            0
      622   372_2419754          S -2.100000e+00 2.980474e-01            0
      623   372_2419754          N  2.800000e+00 8.889204e-01            0
      624   372_2419754       maxN  7.400000e+00 5.306669e-01            0
      625   372_2419754    Shannon -1.070354e-01 2.342139e-01            0
      626   372_2419754 expShannon -1.320556e+00 2.676574e-01            0
      627   372_2419754    Simpson -1.754866e-02 3.841499e-01            0
      628   372_2419754 invSimpson -1.214213e+00 3.980049e-01            0
      629   372_2419754        PIE -1.776303e-02 3.819907e-01            0
      630   372_2419754      DomMc  4.021162e-02 3.172558e-01            0
      631   372_2419028          S  8.000000e-01 6.240652e-01            0
      632   372_2419028          N -2.000000e-01 9.892726e-01            0
      633   372_2419028       maxN -6.800000e+00 4.415278e-01            0
      634   372_2419028    Shannon  9.208719e-02 5.126102e-01            0
      635   372_2419028 expShannon  6.508272e-01 6.522710e-01            0
      636   372_2419028    Simpson  2.525559e-02 3.794393e-01            0
      637   372_2419028 invSimpson  5.811106e-01 6.622128e-01            0
      638   372_2419028        PIE  2.561547e-02 3.841744e-01            0
      639   372_2419028      DomMc -5.234195e-02 3.900512e-01            0
      640   372_2409543          S  3.500000e+00 4.065197e-01            0
      641   372_2409543          N  2.250000e+01 4.327586e-01            0
      642   372_2409543       maxN  1.500000e+00 5.934803e-01            0
      643   372_2409543    Shannon  2.184521e-01 5.600077e-01            0
      644   372_2409543 expShannon  1.507084e+00 5.079372e-01            0
      645   372_2409543    Simpson  5.350840e-02 5.939593e-01            0
      646   372_2409543 invSimpson  1.204369e+00 4.826273e-01            0
      647   372_2409543        PIE  4.947856e-02 6.007667e-01            0
      648   372_2409543      DomMc -5.049261e-02 6.680200e-01            0
      649   372_2403696          S -1.900000e+00 2.338461e-01            0
      650   372_2403696          N  6.040000e+01 6.111713e-01            0
      651   372_2403696       maxN  2.520000e+01 4.232670e-01            0
      652   372_2403696    Shannon -7.058842e-02 1.447348e-01            0
      653   372_2403696 expShannon -1.655902e+00 1.446162e-01            0
      654   372_2403696    Simpson -5.119004e-03 2.267124e-01            0
      655   372_2403696 invSimpson -1.227663e+00 2.327200e-01            0
      656   372_2403696        PIE -5.181099e-03 2.322529e-01            0
      657   372_2403696      DomMc  1.451960e-02 1.937617e-01            0
      658   372_2400777          S -1.369366e-13 1.000000e+00            0
      659   372_2400777          N -2.000000e-01 9.709222e-01            0
      660   372_2400777       maxN  4.000000e-01 8.907540e-01            0
      661   372_2400777    Shannon -4.335008e-03 9.468491e-01            0
      662   372_2400777 expShannon -1.770345e-02 9.756093e-01            0
      663   372_2400777    Simpson -2.877668e-03 8.354039e-01            0
      664   372_2400777 invSimpson  1.474643e-02 9.797095e-01            0
      665   372_2400777        PIE -2.982056e-03 8.412689e-01            0
      666   372_2400777      DomMc  8.882694e-03 7.791192e-01            0
      667   372_2394218          S -2.500000e+00 1.993592e-01            0
      668   372_2394218          N  1.210000e+01 6.003247e-01            0
      669   372_2394218       maxN  1.190000e+01 4.335581e-01            0
      670   372_2394218    Shannon -1.485801e-01 8.248296e-02            0
      671   372_2394218 expShannon -1.632551e+00 8.013406e-02            0
      672   372_2394218    Simpson -1.913405e-02 2.543004e-01            0
      673   372_2394218 invSimpson -8.257165e-01 2.730398e-01            0
      674   372_2394218        PIE -1.932137e-02 2.588805e-01            0
      675   372_2394218      DomMc  2.711512e-02 5.329526e-01            0
      676   372_2399315          S -2.900000e+00 5.439155e-02            0
      677   372_2399315          N -1.819000e+02 1.012862e-02            1
      678   372_2399315       maxN -5.380000e+01 7.266882e-02            0
      679   372_2399315    Shannon  3.884821e-02 4.412984e-01            0
      680   372_2399315 expShannon  7.570859e-01 4.577865e-01            0
      681   372_2399315    Simpson  9.338834e-03 1.563304e-01            0
      682   372_2399315 invSimpson  1.302805e+00 2.174113e-01            0
      683   372_2399315        PIE  9.625626e-03 1.470905e-01            0
      684   372_2399315      DomMc -3.785300e-02 8.405459e-02            0
      685   372_2375959          S -1.600000e+00 1.322782e-01            0
      686   372_2375959          N -4.070000e+01 2.136569e-01            0
      687   372_2375959       maxN  1.580000e+01 2.996773e-01            0
      688   372_2375959    Shannon -9.636616e-02 4.327179e-01            0
      689   372_2375959 expShannon -1.110787e+00 3.875557e-01            0
      690   372_2375959    Simpson -1.896456e-02 3.873501e-01            0
      691   372_2375959 invSimpson -1.146920e+00 3.061201e-01            0
      692   372_2375959        PIE -1.882527e-02 3.905501e-01            0
      693   372_2375959      DomMc  2.439353e-02 6.741184e-01            0
      694   372_2363562          S -3.000000e+00 1.210377e-01            0
      695   372_2363562          N -4.050000e+01 7.528237e-01            0
      696   372_2363562       maxN -7.650000e+01 2.233808e-01            0
      697   372_2363562    Shannon  1.402099e-01 2.657953e-01            0
      698   372_2363562 expShannon  2.151960e+00 2.742435e-01            0
      699   372_2363562    Simpson  3.348045e-02 1.351891e-01            0
      700   372_2363562 invSimpson  3.099525e+00 2.156340e-01            0
      701   372_2363562        PIE  3.360024e-02 1.375079e-01            0
      702   372_2363562      DomMc -9.165214e-02 3.012965e-01            0
      703   372_2365726          S  1.000000e+00 8.712907e-02            0
      704   372_2365726          N -2.100000e+00 6.225243e-01            0
      705   372_2365726       maxN -1.700000e+00 3.144938e-01            0
      706   372_2365726    Shannon  9.910709e-02 1.899201e-01            0
      707   372_2365726 expShannon  9.938147e-01 1.903446e-01            0
      708   372_2365726    Simpson  1.380669e-02 3.644158e-01            0
      709   372_2365726 invSimpson  8.654795e-01 3.982664e-01            0
      710   372_2365726        PIE  1.560449e-02 3.493189e-01            0
      711   372_2365726      DomMc -3.607111e-02 4.999011e-01            0
      712   372_2435073          S  7.000000e-01 5.482544e-01            0
      713   372_2435073          N  9.600000e+00 4.783281e-01            0
      714   372_2435073       maxN  2.600000e+00 5.312292e-01            0
      715   372_2435073    Shannon  6.608966e-02 5.190630e-01            0
      716   372_2435073 expShannon  4.302934e-01 5.962415e-01            0
      717   372_2435073    Simpson  1.053754e-02 5.244019e-01            0
      718   372_2435073 invSimpson  2.138211e-01 7.355761e-01            0
      719   372_2435073        PIE  1.012266e-02 5.403337e-01            0
      720   372_2435073      DomMc -8.684955e-03 7.801118e-01            0
      721   372_2428505          S  4.000000e-01 1.055728e-01            0
      722   372_2428505          N -7.900000e+00 4.114140e-01            0
      723   372_2428505       maxN -4.800000e+00 4.046333e-01            0
      724   372_2428505    Shannon  1.089458e-01 5.284852e-02            0
      725   372_2428505 expShannon  2.490942e-01 5.277706e-02            0
      726   372_2428505    Simpson  3.669772e-02 5.566225e-02            0
      727   372_2428505 invSimpson  1.733247e-01 5.691273e-02            0
      728   372_2428505        PIE  4.832292e-02 7.309550e-02            0
      729   372_2428505      DomMc -5.170940e-02 7.992107e-02            0
      730   402_3191117          S -3.200000e+00 9.625146e-02            0
      731   402_3191117          N -1.226000e+02 3.260568e-02            1
      732   402_3191117       maxN -5.368571e+01 7.381943e-03            1
      733   402_3191117    Shannon  3.111940e-02 6.671931e-01            0
      734   402_3191117 expShannon  4.833699e-01 6.750039e-01            0
      735   402_3191117    Simpson  1.626523e-02 1.746213e-01            0
      736   402_3191117 invSimpson  1.007419e+00 2.750141e-01            0
      737   402_3191117        PIE  1.703830e-02 1.568613e-01            0
      738   402_3191117      DomMc -2.552183e-02 3.137634e-01            0
      739   402_3191116          S -1.800000e+00 4.371885e-02            1
      740   402_3191116          N -3.294286e+01 3.429106e-02            1
      741   402_3191116       maxN -1.560000e+01 1.192741e-01            0
      742   402_3191116    Shannon -6.380536e-02 2.040116e-02            1
      743   402_3191116 expShannon -3.299276e-01 1.827408e-02            1
      744   402_3191116    Simpson -2.980417e-04 9.854839e-01            0
      745   402_3191116 invSimpson -1.899363e-02 9.177852e-01            0
      746   402_3191116        PIE  7.626240e-03 6.837172e-01            0
      747   402_3191116      DomMc  5.494374e-03 6.735007e-01            0
      748   402_3190385          S -8.000000e-01 3.015263e-02            1
      749   402_3190385          N -1.008571e+01 3.738062e-01            0
      750   402_3190385       maxN  2.600000e+00 6.184586e-01            0
      751   402_3190385    Shannon -1.212413e-01 1.624278e-02            1
      752   402_3190385 expShannon -6.796573e-01 2.170716e-02            1
      753   402_3190385    Simpson -4.282418e-02 2.593913e-02            1
      754   402_3190385 invSimpson -6.769059e-01 7.116366e-02            0
      755   402_3190385        PIE -4.228392e-02 2.756373e-02            1
      756   402_3190385      DomMc  4.953691e-02 1.298995e-01            0
      757   431_5118319          S -3.543689e-01 5.373830e-02            0
      758   431_5118319          N -1.426699e+01 1.431588e-01            0
      759   431_5118319       maxN -8.665049e+00 1.485518e-01            0
      760   431_5118319    Shannon -3.226706e-02 5.068015e-01            0
      761   431_5118319 expShannon -7.192979e-02 5.006807e-01            0
      762   431_5118319    Simpson -1.290915e-02 6.627597e-01            0
      763   431_5118319 invSimpson -6.098140e-02 6.123892e-01            0
      764   431_5118319        PIE -4.301993e-03 9.384529e-01            0
      765   431_5118319      DomMc  1.419387e-02 6.106509e-01            0
      766   431_5122694          S -1.582278e-01 6.432165e-01            0
      767   431_5122694          N  2.556962e+00 8.361211e-01            0
      768   431_5122694       maxN  5.215190e+00 6.527815e-01            0
      769   431_5122694    Shannon -8.804649e-02 1.639157e-01            0
      770   431_5122694 expShannon -1.836261e-01 7.939635e-02            0
      771   431_5122694    Simpson -4.766847e-02 3.461200e-01            0
      772   431_5122694 invSimpson -1.417304e-01 2.175045e-01            0
      773   431_5122694        PIE -3.613781e-02 7.391582e-01            0
      774   431_5122694      DomMc  1.542147e-02 2.593347e-01            0
      775   431_5103014          S -1.500000e+00 1.210377e-01            0
      776   431_5103014          N -2.150000e+01 2.796726e-01            0
      777   431_5103014       maxN -1.050000e+01 5.380248e-01            0
      778   431_5103014    Shannon -2.027132e-01 5.103884e-01            0
      779   431_5103014 expShannon -7.343003e-01 4.731240e-01            0
      780   431_5103014    Simpson -5.266878e-02 7.288733e-01            0
      781   431_5103014 invSimpson -3.936506e-01 6.218785e-01            0
      782   431_5103014        PIE -3.802610e-02 8.145116e-01            0
      783   431_5103014      DomMc  8.103448e-02 5.240974e-01            0
      784   431_4749643          S  0.000000e+00          NaN           NA
      785   431_4749643          N -3.333333e-02 7.891815e-01            0
      786   431_4749643       maxN -3.333333e-02 7.891815e-01            0
      787   431_4749643    Shannon  1.887767e-03 7.891815e-01            0
      788   431_4749643 expShannon  3.670614e-03 7.891815e-01            0
      789   431_4749643    Simpson  1.851852e-03 7.891815e-01            0
      790   431_4749643 invSimpson  6.666667e-03 7.891815e-01            0
      791   431_4749643        PIE  1.111111e-02 7.891815e-01            0
      792   431_4749643      DomMc  0.000000e+00          NaN           NA
      793   431_5132911          S  4.887218e-02 6.188153e-01            0
      794   431_5132911          N  1.360902e+00 6.388312e-01            0
      795   431_5132911       maxN  9.022556e-01 7.145180e-01            0
      796   431_5132911    Shannon  1.179186e-02 8.255263e-01            0
      797   431_5132911 expShannon  4.372112e-02 7.837526e-01            0
      798   431_5132911    Simpson  1.344507e-03 9.608994e-01            0
      799   431_5132911 invSimpson  4.002922e-02 8.305341e-01            0
      800   431_5132911        PIE -2.279494e-03 9.449490e-01            0
      801   431_5132911      DomMc -1.437488e-02 6.127235e-01            0
      802   431_5133641          S -2.289023e-17 4.785132e-02            1
      803   431_5133641          N -6.278195e-01 2.446987e-01            0
      804   431_5133641       maxN -7.030075e-01 8.788589e-02            0
      805   431_5133641    Shannon  3.359306e-02 4.785132e-02            1
      806   431_5133641 expShannon  5.567285e-02 4.785132e-02            1
      807   431_5133641    Simpson  2.894115e-02 4.785132e-02            1
      808   431_5133641 invSimpson  6.934415e-02 4.785132e-02            1
      809   431_5133641        PIE  5.570745e-02 2.773146e-01            0
      810   431_5133641      DomMc -1.144511e-17 4.785132e-02            1
      811   431_5132912          S -1.540084e-01 3.972184e-01            0
      812   431_5132912          N -4.803797e+00 7.073956e-01            0
      813   431_5132912       maxN -2.518987e+00 7.084157e-01            0
      814   431_5132912    Shannon -2.186433e-02 4.422235e-01            0
      815   431_5132912 expShannon -4.992305e-02 4.935774e-01            0
      816   431_5132912    Simpson -6.996442e-03 5.705267e-01            0
      817   431_5132912 invSimpson -3.381848e-02 6.251392e-01            0
      818   431_5132912        PIE  7.481092e-03 4.827161e-01            0
      819   431_5132912      DomMc  9.358340e-03 5.662848e-01            0
      820   431_5104466          S  4.048583e-02 5.609407e-01            0
      821   431_5104466          N  2.874494e-01 3.486451e-01            0
      822   431_5104466       maxN  2.469636e-01 3.007937e-01            0
      823   431_5104466    Shannon -1.193193e-03 9.235022e-01            0
      824   431_5104466 expShannon -1.947353e-03 9.345574e-01            0
      825   431_5104466    Simpson -6.578947e-03 2.601469e-01            0
      826   431_5104466 invSimpson -2.169188e-02 2.336984e-01            0
      827   431_5104466        PIE -3.282244e-02 6.774841e-02            0
      828   431_5104466      DomMc -5.060729e-03 5.609407e-01            0
      829   431_5122695          S -5.943536e-03 8.614569e-01            0
      830   431_5122695          N -5.686478e+00 8.688097e-01            0
      831   431_5122695       maxN -5.256315e+00 8.673532e-01            0
      832   431_5122695    Shannon  7.696829e-03 5.161210e-01            0
      833   431_5122695 expShannon  1.226711e-02 5.356313e-01            0
      834   431_5122695    Simpson  6.487905e-03 5.346095e-01            0
      835   431_5122695 invSimpson  1.395937e-02 5.824855e-01            0
      836   431_5122695        PIE  7.318082e-03 5.859466e-01            0
      837   431_5122695      DomMc  2.902117e-05 8.614569e-01            0
      838   431_5101552          S  7.127358e-17 1.544210e-01            0
      839   431_5101552          N -2.773077e+01 7.948903e-01            0
      840   431_5101552       maxN -2.750000e+01 7.946391e-01            0
      841   431_5101552    Shannon  6.201604e-02 3.888716e-01            0
      842   431_5101552 expShannon  8.033425e-02 3.635805e-01            0
      843   431_5101552    Simpson  4.106218e-02 3.462665e-01            0
      844   431_5101552 invSimpson  5.605652e-02 3.151684e-01            0
      845   431_5101552        PIE  4.874302e-02 3.285045e-01            0
      846   431_5101552      DomMc  3.563679e-17 1.544210e-01            0
      847   431_5111033          S  1.639344e-02 9.592167e-01            0
      848   431_5111033          N -3.770492e-01 9.142599e-01            0
      849   431_5111033       maxN  4.918033e-02 9.874714e-01            0
      850   431_5111033    Shannon -2.606470e-02 1.600753e-01            0
      851   431_5111033 expShannon -4.628191e-02 1.408769e-01            0
      852   431_5111033    Simpson -2.489922e-02 2.518271e-01            0
      853   431_5111033 invSimpson -6.848686e-02 2.637835e-01            0
      854   431_5111033        PIE -2.458674e-02 3.648015e-01            0
      855   431_5111033      DomMc -5.464481e-04 9.592167e-01            0
      856   431_5119779          S  3.937008e-03 9.717453e-01            0
      857   431_5119779          N  1.948819e+00 8.103903e-01            0
      858   431_5119779       maxN  1.751969e+00 8.064814e-01            0
      859   431_5119779    Shannon -2.802101e-03 7.977532e-01            0
      860   431_5119779 expShannon -4.484598e-03 7.881903e-01            0
      861   431_5119779    Simpson -2.185206e-03 3.812744e-01            0
      862   431_5119779 invSimpson -3.679263e-03 3.805287e-01            0
      863   431_5119779        PIE -2.723723e-03 4.096462e-01            0
      864   431_5119779      DomMc -1.231631e-03 8.326361e-01            0
      865   431_4748913          S  0.000000e+00          NaN           NA
      866   431_4748913          N  1.914286e+00 4.619298e-01            0
      867   431_4748913       maxN  1.857143e+00 4.632497e-01            0
      868   431_4748913    Shannon -2.944769e-02 7.590651e-01            0
      869   431_4748913 expShannon -3.510438e-02 8.195980e-01            0
      870   431_4748913    Simpson -1.870289e-02 8.152220e-01            0
      871   431_4748913 invSimpson -9.810508e-03 9.568018e-01            0
      872   431_4748913        PIE -2.385154e-02 8.008530e-01            0
      873   431_4748913      DomMc  0.000000e+00          NaN           NA
      874   431_5102284          S -4.132231e-02 5.454545e-01            0
      875   431_5102284          N -1.035813e+00 2.725626e-01            0
      876   431_5102284       maxN -8.787879e-01 2.678728e-01            0
      877   431_5102284    Shannon  1.590586e-03 8.692033e-01            0
      878   431_5102284 expShannon  2.673665e-03 8.702146e-01            0
      879   431_5102284    Simpson  3.776646e-03 7.390319e-01            0
      880   431_5102284 invSimpson  7.417455e-03 7.631893e-01            0
      881   431_5102284        PIE  5.838596e-03 6.856459e-01            0
      882   431_5102284      DomMc  2.430724e-03 5.454545e-01            0
      883   431_5113947          S -1.957295e-01 1.991776e-01            0
      884   431_5113947          N -2.199288e+00 8.567441e-01            0
      885   431_5113947       maxN -1.302491e+00 8.903519e-01            0
      886   431_5113947    Shannon -6.033239e-02 1.673038e-01            0
      887   431_5113947 expShannon -1.330346e-01 1.741347e-01            0
      888   431_5113947    Simpson -2.989973e-02 2.125586e-01            0
      889   431_5113947 invSimpson -1.158013e-01 2.019477e-01            0
      890   431_5113947        PIE -3.545660e-02 1.620091e-01            0
      891   431_5113947      DomMc  2.954554e-02 7.056195e-02            0
      892   431_5101555          S -9.793814e-02 1.699483e-01            0
      893   431_5101555          N  1.335052e+00 4.857835e-01            0
      894   431_5101555       maxN  1.479381e+00 4.163141e-01            0
      895   431_5101555    Shannon -6.079943e-02 1.112066e-01            0
      896   431_5101555 expShannon -1.199444e-01 1.271147e-01            0
      897   431_5101555    Simpson -3.842820e-02 9.863250e-02            0
      898   431_5101555 invSimpson -1.183506e-01 1.329422e-01            0
      899   431_5101555        PIE -4.576136e-02 1.127036e-01            0
      900   431_5101555      DomMc  1.224227e-02 1.699483e-01            0
      901   431_5100825          S -1.288344e-01 2.028719e-01            0
      902   431_5100825          N  2.328221e+00 8.965534e-01            0
      903   431_5100825       maxN  3.303681e+00 8.537547e-01            0
      904   431_5100825    Shannon -4.029657e-02 4.722386e-01            0
      905   431_5100825 expShannon -7.944576e-02 3.992265e-01            0
      906   431_5100825    Simpson -2.028809e-02 5.811513e-01            0
      907   431_5100825 invSimpson -5.645175e-02 4.558586e-01            0
      908   431_5100825        PIE -1.851868e-02 6.438798e-01            0
      909   431_5100825      DomMc  7.243419e-03 7.288084e-02            0
      910   431_4749644          S  6.966591e-18 9.268136e-01            0
      911   431_4749644          N -1.473684e+00 2.601469e-01            0
      912   431_4749644       maxN -8.421053e-01 2.601469e-01            0
      913   431_4749644    Shannon -1.960982e-02 2.601469e-01            0
      914   431_4749644 expShannon -3.606418e-02 2.601469e-01            0
      915   431_4749644    Simpson -1.848630e-02 2.601469e-01            0
      916   431_4749644 invSimpson -5.506073e-02 2.601469e-01            0
      917   431_4749644        PIE -1.913876e-03 2.601469e-01            0
      918   431_4749644      DomMc  3.483295e-18 9.268136e-01            0
      919   431_4749627          S  1.044989e-17 5.934803e-01            0
      920   431_4749627          N -1.197368e+00 1.211566e-02            1
      921   431_4749627       maxN -1.197368e+00 1.211566e-02            1
      922   431_4749627    Shannon  1.164984e-02 6.569371e-02            0
      923   431_4749627 expShannon  1.488945e-02 7.737799e-02            0
      924   431_4749627    Simpson  7.615570e-03 8.164751e-02            0
      925   431_4749627 invSimpson  1.006103e-02 1.014663e-01            0
      926   431_4749627        PIE  8.857371e-03 9.347574e-02            0
      927   431_4749627      DomMc  5.224943e-18 5.934803e-01            0
      928   431_5123423          S  7.798165e-02 3.944041e-01            0
      929   431_5123423          N -5.298165e+00 7.820636e-02            0
      930   431_5123423       maxN -4.527523e+00 8.111244e-02            0
      931   431_5123423    Shannon  1.579788e-02 3.703921e-01            0
      932   431_5123423 expShannon  2.979458e-02 4.065172e-01            0
      933   431_5123423    Simpson  7.634545e-03 2.588486e-01            0
      934   431_5123423 invSimpson  1.932115e-02 3.029352e-01            0
      935   431_5123423        PIE  8.286895e-03 2.545516e-01            0
      936   431_5123423      DomMc -3.266611e-03 5.367756e-01            0
      937   431_5120508          S  1.351351e-01 3.857223e-01            0
      938   431_5120508          N  2.455405e+01 2.595079e-01            0
      939   431_5120508       maxN  2.416216e+01 2.533648e-01            0
      940   431_5120508    Shannon -7.974073e-02 3.075893e-01            0
      941   431_5120508 expShannon -1.209642e-01 3.009682e-01            0
      942   431_5120508    Simpson -6.350822e-02 2.897964e-01            0
      943   431_5120508 invSimpson -1.289334e-01 2.857897e-01            0
      944   431_5120508        PIE -8.129109e-02 2.870311e-01            0
      945   431_5120508      DomMc -7.384434e-04 3.857223e-01            0
      946   431_5113218          S -5.714286e-01 1.548457e-01            0
      947   431_5113218          N  3.176790e-16 1.000000e+00            0
      948   431_5113218       maxN -2.857143e-02 9.612217e-01            0
      949   431_5113218    Shannon -1.460241e-01 2.164187e-01            0
      950   431_5113218 expShannon -3.811630e-01 2.260975e-01            0
      951   431_5113218    Simpson -4.313077e-02 3.064933e-01            0
      952   431_5113218 invSimpson -2.497106e-01 3.388985e-01            0
      953   431_5113218        PIE -4.940631e-02 3.403534e-01            0
      954   431_5113218      DomMc  7.903525e-02 1.631601e-01            0
      955   431_4752549          S -3.092784e-02 2.927506e-01            0
      956   431_4752549          N -9.649485e+00 1.837862e-01            0
      957   431_4752549       maxN -8.164948e+00 1.750011e-01            0
      958   431_4752549    Shannon -2.855610e-05 9.974812e-01            0
      959   431_4752549 expShannon  9.361549e-05 9.943883e-01            0
      960   431_4752549    Simpson  1.788882e-03 7.810577e-01            0
      961   431_4752549 invSimpson  3.815086e-03 7.240961e-01            0
      962   431_4752549        PIE  2.671434e-03 6.980767e-01            0
      963   431_4752549      DomMc  9.372071e-04 2.927506e-01            0
      964   431_5113944          S  1.941748e-01 1.091826e-01            0
      965   431_5113944          N  9.451456e+00 4.718992e-01            0
      966   431_5113944       maxN  6.936893e+00 5.030588e-01            0
      967   431_5113944    Shannon  1.763187e-02 3.683679e-01            0
      968   431_5113944 expShannon  3.374515e-02 3.503523e-01            0
      969   431_5113944    Simpson  1.847942e-03 9.121737e-01            0
      970   431_5113944 invSimpson  2.461207e-03 9.604744e-01            0
      971   431_5113944        PIE  5.866454e-04 9.773545e-01            0
      972   431_5113944      DomMc -1.006394e-02 1.091826e-01            0
      973   431_5115406          S -2.102962e-16 3.333333e-01            0
      974   431_5115406          N  1.350000e+01 6.920017e-01            0
      975   431_5115406       maxN  8.000000e+00 7.361776e-01            0
      976   431_5115406    Shannon -1.270651e-03 9.861442e-01            0
      977   431_5115406 expShannon -2.492604e-03 9.874974e-01            0
      978   431_5115406    Simpson  8.650916e-03 8.312957e-01            0
      979   431_5115406 invSimpson  2.668754e-02 8.622504e-01            0
      980   431_5115406        PIE  8.141575e-03 8.797549e-01            0
      981   431_5115406      DomMc  4.655870e-03 8.165900e-01            0
      982   431_4736507          S -8.119080e-03 8.896432e-01            0
      983   431_4736507          N -1.623816e-01 2.196597e-01            0
      984   431_4736507       maxN -1.542625e-01 6.229197e-02            0
      985   431_4736507    Shannon  8.367291e-03 6.840652e-01            0
      986   431_4736507 expShannon  1.912415e-02 6.798420e-01            0
      987   431_4736507    Simpson  8.119080e-03 3.757278e-01            0
      988   431_4736507 invSimpson  3.428056e-02 3.916627e-01            0
      989   431_4736507        PIE  2.742445e-02 4.805508e-02            1
      990   431_4736507      DomMc -1.240415e-03 9.221267e-01            0
      991   431_4776662          S -3.054582e-17 4.877543e-01            0
      992   431_4776662          N -8.076923e-01 5.530290e-01            0
      993   431_4776662       maxN -5.769231e-01 7.098418e-01            0
      994   431_4776662    Shannon  1.494273e-02 8.455790e-01            0
      995   431_4776662 expShannon  2.476418e-02 8.455790e-01            0
      996   431_4776662    Simpson  1.287349e-02 8.455790e-01            0
      997   431_4776662 invSimpson  3.084539e-02 8.455790e-01            0
      998   431_4776662        PIE  7.762238e-02 5.204131e-01            0
      999   431_4776662      DomMc -1.527291e-17 4.877543e-01            0
      1000  431_4752550          S  0.000000e+00          NaN           NA
      1001  431_4752550          N  1.315385e+01 1.377290e-01            0
      1002  431_4752550       maxN  1.300000e+01 1.433782e-01            0
      1003  431_4752550    Shannon -5.854620e-02 1.252257e-01            0
      1004  431_4752550 expShannon -8.726649e-02 1.452942e-01            0
      1005  431_4752550    Simpson -4.505288e-02 1.455878e-01            0
      1006  431_4752550 invSimpson -8.804253e-02 2.051423e-01            0
      1007  431_4752550        PIE -6.761238e-02 6.855913e-02            0
      1008  431_4752550      DomMc  0.000000e+00          NaN           NA
      1009  431_4754011          S  1.213708e-02 5.838604e-01            0
      1010  431_4754011          N -8.162780e-01 8.748023e-01            0
      1011  431_4754011       maxN -1.366016e-01 9.736250e-01            0
      1012  431_4754011    Shannon -1.728341e-02 1.085449e-01            0
      1013  431_4754011 expShannon -2.764794e-02 1.129655e-01            0
      1014  431_4754011    Simpson -1.467598e-02 9.559345e-02            0
      1015  431_4754011 invSimpson -3.309624e-02 9.830495e-02            0
      1016  431_4754011        PIE -2.020849e-02 1.342383e-01            0
      1017  431_4754011      DomMc -6.841282e-05 6.018385e-01            0
      1018  431_4745247          S  1.190476e-01 2.122956e-01            0
      1019  431_4745247          N -1.254762e+01 6.826728e-01            0
      1020  431_4745247       maxN -1.257143e+01 6.835960e-01            0
      1021  431_4745247    Shannon  1.185501e-01 2.630623e-01            0
      1022  431_4745247 expShannon  2.251146e-01 2.414978e-01            0
      1023  431_4745247    Simpson  7.428522e-02 2.493735e-01            0
      1024  431_4745247 invSimpson  2.327501e-01 2.250568e-01            0
      1025  431_4745247        PIE  1.139018e-01 2.370270e-01            0
      1026  431_4745247      DomMc -3.968254e-02 2.122956e-01            0
      1027  431_4752551          S -1.224490e-01 1.428571e-01            0
      1028  431_4752551          N -7.989796e+00 6.605508e-01            0
      1029  431_4752551       maxN -7.367347e+00 6.477447e-01            0
      1030  431_4752551    Shannon -8.040343e-03 8.458266e-01            0
      1031  431_4752551 expShannon -2.007011e-02 7.997242e-01            0
      1032  431_4752551    Simpson  4.132275e-03 8.911850e-01            0
      1033  431_4752551 invSimpson  2.354406e-03 9.776842e-01            0
      1034  431_4752551        PIE  3.015082e-03 9.287798e-01            0
      1035  431_4752551      DomMc  6.480971e-03 2.230078e-01            0
      1036  431_4753280          S -9.210526e-02 4.065197e-01            0
      1037  431_4753280          N  1.000000e+00 8.959222e-01            0
      1038  431_4753280       maxN  1.565789e+00 7.642853e-01            0
      1039  431_4753280    Shannon -1.689310e-02 4.487595e-01            0
      1040  431_4753280 expShannon -3.203163e-02 4.448311e-01            0
      1041  431_4753280    Simpson -1.112792e-02 4.626870e-01            0
      1042  431_4753280 invSimpson -3.359025e-02 4.515393e-01            0
      1043  431_4753280        PIE -1.183611e-02 2.891558e-01            0
      1044  431_4753280      DomMc  1.509922e-03 4.065197e-01            0
      1045  431_4751821          S -3.781864e-17 5.456289e-01            0
      1046  431_4751821          N -9.285714e-01 8.629851e-01            0
      1047  431_4751821       maxN -7.142857e-02 9.881448e-01            0
      1048  431_4751821    Shannon -7.428825e-02 3.737079e-01            0
      1049  431_4751821 expShannon -1.114607e-01 4.147888e-01            0
      1050  431_4751821    Simpson -5.821294e-02 4.112069e-01            0
      1051  431_4751821 invSimpson -1.106752e-01 5.135421e-01            0
      1052  431_4751821        PIE -6.429744e-02 4.707128e-01            0
      1053  431_4751821      DomMc -1.890932e-17 5.456289e-01            0
      1054  431_4756195          S  5.854801e-02 5.864122e-01            0
      1055  431_4756195          N  6.007026e-01 7.198378e-01            0
      1056  431_4756195       maxN -1.311475e-01 7.469211e-01            0
      1057  431_4756195    Shannon  3.201431e-02 5.294255e-01            0
      1058  431_4756195 expShannon  6.831358e-02 5.527226e-01            0
      1059  431_4756195    Simpson  1.833583e-02 5.169166e-01            0
      1060  431_4756195 invSimpson  6.413636e-02 5.612762e-01            0
      1061  431_4756195        PIE  1.887292e-02 5.044387e-01            0
      1062  431_4756195      DomMc -8.364001e-03 5.864122e-01            0
      1063  437_2075128          S  7.142857e-01 5.754088e-01            0
      1064  437_2075128          N  1.450000e+01 4.041786e-01            0
      1065  437_2075128       maxN -1.571429e+00 7.682289e-01            0
      1066  437_2075128    Shannon  3.353075e-02 2.631136e-01            0
      1067  437_2075128 expShannon  5.761258e-01 2.457217e-01            0
      1068  437_2075128    Simpson  4.679498e-03 3.460291e-01            0
      1069  437_2075128 invSimpson  6.601750e-01 2.924905e-01            0
      1070  437_2075128        PIE  4.524890e-03 3.720815e-01            0
      1071  437_2075128      DomMc -1.721182e-02 3.639647e-01            0
      1072  437_2077319          S -1.120482e+00 7.686546e-01            0
      1073  437_2077319          N  1.846988e+01 4.158291e-01            0
      1074  437_2077319       maxN  1.093976e+01 1.550091e-01            0
      1075  437_2077319    Shannon -8.203937e-02 4.383817e-01            0
      1076  437_2077319 expShannon -1.815596e+00 4.145974e-01            0
      1077  437_2077319    Simpson -9.085017e-03 5.177772e-01            0
      1078  437_2077319 invSimpson -1.184351e+00 3.736149e-01            0
      1079  437_2077319        PIE -9.289273e-03 5.083049e-01            0
      1080  437_2077319      DomMc  1.761583e-02 4.710555e-01            0
      1081  437_2076590          S -1.406473e-15 1.000000e+00            0
      1082  437_2076590          N  5.354217e+01 6.852185e-01            0
      1083  437_2076590       maxN  3.193976e+01 2.565170e-01            0
      1084  437_2076590    Shannon -2.974924e-02 7.164051e-01            0
      1085  437_2076590 expShannon -1.139961e+00 6.535603e-01            0
      1086  437_2076590    Simpson -4.492341e-03 2.388956e-01            0
      1087  437_2076590 invSimpson -1.103992e+00 2.766529e-01            0
      1088  437_2076590        PIE -4.547720e-03 2.282516e-01            0
      1089  437_2076590      DomMc  1.348661e-02 2.780531e-01            0
      1090  437_2078777          S  8.072289e-01 9.159670e-01            0
      1091  437_2078777          N  1.038554e+01 8.934542e-01            0
      1092  437_2078777       maxN -3.650602e+00 2.964988e-01            0
      1093  437_2078777    Shannon  4.070152e-02 8.091380e-01            0
      1094  437_2078777 expShannon  1.042707e+00 7.702185e-01            0
      1095  437_2078777    Simpson  3.779789e-03 8.420802e-01            0
      1096  437_2078777 invSimpson  5.426832e-01 7.832181e-01            0
      1097  437_2078777        PIE  3.758237e-03 8.417061e-01            0
      1098  437_2078777      DomMc -3.802460e-03 9.265046e-01            0
      1099  437_2076589          S  1.571429e+00 3.338324e-02            1
      1100  437_2076589          N  1.271429e+01 1.303031e-01            0
      1101  437_2076589       maxN  3.642857e+00 7.887005e-02            0
      1102  437_2076589    Shannon  1.547882e-02 6.204052e-01            0
      1103  437_2076589 expShannon  2.656532e-01 6.251218e-01            0
      1104  437_2076589    Simpson -5.056574e-04 8.415599e-01            0
      1105  437_2076589 invSimpson -7.577548e-02 8.358517e-01            0
      1106  437_2076589        PIE -7.286166e-04 7.822304e-01            0
      1107  437_2076589      DomMc  2.914939e-03 7.109326e-01            0
      1108  437_2075860          S  8.857143e+00 2.112364e-01            0
      1109  437_2075860          N  9.564286e+01 4.685435e-02            1
      1110  437_2075860       maxN -7.928571e+00 1.526367e-01            0
      1111  437_2075860    Shannon  2.229849e-01 1.051274e-01            0
      1112  437_2075860 expShannon  3.897473e+00 1.119665e-01            0
      1113  437_2075860    Simpson  3.115083e-02 1.138985e-01            0
      1114  437_2075860 invSimpson  2.546991e+00 4.375078e-02            1
      1115  437_2075860        PIE  3.089897e-02 1.149106e-01            0
      1116  437_2075860      DomMc -7.236363e-02 9.619146e-02            0
      1117  437_2074400          S  1.142857e+00 6.882791e-01            0
      1118  437_2074400          N  5.214286e+00 7.406458e-01            0
      1119  437_2074400       maxN -1.571429e+00 8.671915e-01            0
      1120  437_2074400    Shannon  1.264382e-02 9.050977e-01            0
      1121  437_2074400 expShannon  1.741330e-01 9.280099e-01            0
      1122  437_2074400    Simpson  2.088081e-03 8.487628e-01            0
      1123  437_2074400 invSimpson  2.177642e-01 8.842929e-01            0
      1124  437_2074400        PIE  1.988833e-03 8.595079e-01            0
      1125  437_2074400      DomMc -8.747615e-03 7.176802e-01            0
      1126  437_2074399          S  3.500000e+00 3.333333e-01            0
      1127  437_2074399          N  7.728571e+01 2.458516e-01            0
      1128  437_2074399       maxN  9.357143e+00 6.986183e-02            0
      1129  437_2074399    Shannon  4.890532e-02 5.274095e-01            0
      1130  437_2074399 expShannon  1.084920e+00 4.938032e-01            0
      1131  437_2074399    Simpson  2.091613e-03 7.424230e-01            0
      1132  437_2074399 invSimpson  4.418913e-01 7.242550e-01            0
      1133  437_2074399        PIE  1.601957e-03 7.833754e-01            0
      1134  437_2074399      DomMc -2.877749e-03 9.190108e-01            0
      1135   466_544469          S -5.919003e-02 8.560994e-01            0
      1136   466_544469          N -1.308157e+02 6.217510e-01            0
      1137   466_544469       maxN -7.772430e+01 2.867777e-01            0
      1138   466_544469    Shannon  1.872738e-02 1.563021e-01            0
      1139   466_544469 expShannon  6.943368e-02 1.621445e-01            0
      1140   466_544469    Simpson  6.936803e-03 4.236760e-01            0
      1141   466_544469 invSimpson  3.797686e-02 5.149626e-01            0
      1142   466_544469        PIE  6.957521e-03 4.224391e-01            0
      1143   466_544469      DomMc -4.625993e-03 4.750129e-01            0
      1144   466_541561          S  3.165183e-02 7.945677e-01            0
      1145   466_541561          N  2.631949e+01 5.318908e-01            0
      1146   466_541561       maxN  1.991197e+01 5.707342e-01            0
      1147   466_541561    Shannon  5.756986e-03 8.886868e-01            0
      1148   466_541561 expShannon  2.132369e-02 9.105356e-01            0
      1149   466_541561    Simpson  2.049607e-03 9.046503e-01            0
      1150   466_541561 invSimpson  3.322689e-03 9.810341e-01            0
      1151   466_541561        PIE  2.050914e-03 9.048083e-01            0
      1152   466_541561      DomMc -2.308544e-03 8.184047e-01            0
      1153   466_544468          S  4.597701e-02 7.928364e-01            0
      1154   466_544468          N -2.107905e+02 5.129029e-01            0
      1155   466_544468       maxN -1.135749e+02 4.966784e-01            0
      1156   466_544468    Shannon -1.347822e-03 8.744685e-01            0
      1157   466_544468 expShannon -1.112335e-02 7.084301e-01            0
      1158   466_544468    Simpson  1.442536e-04 9.632376e-01            0
      1159   466_544468 invSimpson -2.456205e-03 9.101685e-01            0
      1160   466_544468        PIE  1.454014e-04 9.629539e-01            0
      1161   466_544468      DomMc -3.684026e-04 9.182454e-01            0
      1162   466_541560          S  4.974986e-02 7.894562e-01            0
      1163   466_541560          N -9.225667e+01 3.622709e-01            0
      1164   466_541560       maxN -5.612437e+01 3.837693e-01            0
      1165   466_541560    Shannon  2.794439e-02 5.333545e-02            0
      1166   466_541560 expShannon  1.199688e-01 4.886908e-02            1
      1167   466_541560    Simpson  9.315129e-03 9.752087e-02            0
      1168   466_541560 invSimpson  7.749448e-02 6.775773e-02            0
      1169   466_541560        PIE  9.352452e-03 9.640795e-02            0
      1170   466_541560      DomMc -1.010843e-02 4.127352e-02            1
      1171   466_544470          S -8.491379e-02 5.976034e-01            0
      1172   466_544470          N -1.928226e+02 3.654960e-01            0
      1173   466_544470       maxN -1.716394e+02 3.426981e-01            0
      1174   466_544470    Shannon  1.803562e-02 2.921743e-01            0
      1175   466_544470 expShannon  4.495377e-02 4.461580e-01            0
      1176   466_544470    Simpson  1.100345e-02 1.051312e-01            0
      1177   466_544470 invSimpson  4.119532e-02 1.925688e-01            0
      1178   466_544470        PIE  1.102145e-02 1.050315e-01            0
      1179   466_544470      DomMc -3.636587e-03 4.144353e-01            0
      1180   466_540104          S  1.566508e-01 4.537267e-01            0
      1181   466_540104          N -1.106924e+02 3.538058e-02            1
      1182   466_540104       maxN -7.674716e+01 3.485576e-02            1
      1183   466_540104    Shannon  1.225405e-02 6.319704e-01            0
      1184   466_540104 expShannon  6.979009e-02 5.635484e-01            0
      1185   466_540104    Simpson  9.237979e-04 9.178244e-01            0
      1186   466_540104 invSimpson  5.672837e-02 5.104477e-01            0
      1187   466_540104        PIE  9.634103e-04 9.144909e-01            0
      1188   466_540104      DomMc -6.702673e-03 4.440409e-01            0
      1189   466_548115          S -2.861995e-01 9.376097e-03            1
      1190   466_548115          N -3.619394e+02 2.896988e-01            0
      1191   466_548115       maxN -2.629201e+02 2.394524e-01            0
      1192   466_548115    Shannon  1.354374e-02 5.844325e-02            0
      1193   466_548115 expShannon  4.745654e-02 3.660638e-02            1
      1194   466_548115    Simpson  5.423939e-03 1.238694e-01            0
      1195   466_548115 invSimpson  4.089562e-02 7.070457e-02            0
      1196   466_548115        PIE  5.430328e-03 1.235815e-01            0
      1197   466_548115      DomMc -5.198850e-03 1.735587e-01            0
      1198   466_560514          S  3.501946e-02 8.960523e-01            0
      1199   466_560514          N -1.139776e+02 8.138047e-02            0
      1200   466_560514       maxN -4.572860e+01 1.111874e-01            0
      1201   466_560514    Shannon  1.757613e-02 1.020108e-01            0
      1202   466_560514 expShannon  9.131331e-02 9.055735e-02            0
      1203   466_560514    Simpson  2.352421e-03 5.270018e-01            0
      1204   466_560514 invSimpson  3.769707e-02 4.531389e-01            0
      1205   466_560514        PIE  2.410372e-03 5.181401e-01            0
      1206   466_560514      DomMc -3.343600e-03 5.403760e-01            0
      1207   466_543001          S -1.230101e-02 9.344102e-01            0
      1208   466_543001          N  2.170463e+02 6.052780e-01            0
      1209   466_543001       maxN  2.287648e+02 5.756295e-01            0
      1210   466_543001    Shannon -2.376132e-02 3.906943e-01            0
      1211   466_543001 expShannon -9.782671e-02 3.086583e-01            0
      1212   466_543001    Simpson -1.113979e-02 3.890475e-01            0
      1213   466_543001 invSimpson -9.284351e-02 2.250524e-01            0
      1214   466_543001        PIE -1.113690e-02 3.897727e-01            0
      1215   466_543001      DomMc  8.233188e-03 3.066443e-01            0
      1216   466_569257          S -7.843137e-02 7.224170e-01            0
      1217   466_569257          N -2.363540e+02 1.374538e-02            1
      1218   466_569257       maxN -1.771022e+02 7.300885e-03            1
      1219   466_569257    Shannon  6.212779e-02 1.759437e-03            1
      1220   466_569257 expShannon  2.697758e-01 6.095645e-03            1
      1221   466_569257    Simpson  2.345600e-02 1.317253e-03            1
      1222   466_569257 invSimpson  2.269119e-01 3.849485e-03            1
      1223   466_569257        PIE  2.354886e-02 1.330076e-03            1
      1224   466_569257      DomMc -2.430412e-02 1.147585e-03            1
      1225   466_540834          S  1.917808e-02 9.515861e-01            0
      1226   466_540834          N  4.812877e+01 7.799469e-01            0
      1227   466_540834       maxN  2.027123e+01 8.564282e-01            0
      1228   466_540834    Shannon -7.566523e-03 7.674675e-01            0
      1229   466_540834 expShannon -4.303839e-02 7.075638e-01            0
      1230   466_540834    Simpson -2.274899e-03 7.963693e-01            0
      1231   466_540834 invSimpson -3.303892e-02 6.992006e-01            0
      1232   466_540834        PIE -2.292160e-03 7.952841e-01            0
      1233   466_540834      DomMc  1.335124e-03 8.979100e-01            0
      1234   466_540833          S -1.394737e+00 2.079746e-02            1
      1235   466_540833          N -5.378947e+01 9.237526e-01            0
      1236   466_540833       maxN -1.047368e+01 9.686336e-01            0
      1237   466_540833    Shannon -2.998044e-02 1.597328e-01            0
      1238   466_540833 expShannon -1.264710e-01 1.464832e-01            0
      1239   466_540833    Simpson -2.308791e-03 4.522839e-01            0
      1240   466_540833 invSimpson -2.383111e-02 4.542641e-01            0
      1241   466_540833        PIE -2.282521e-03 4.447935e-01            0
      1242   466_540833      DomMc -6.101013e-03 6.729757e-01            0
      1243   466_543011          S -2.265044e-01 1.760602e-01            0
      1244   466_543011          N -6.961339e+02 9.435570e-02            0
      1245   466_543011       maxN -5.213469e+02 1.357967e-01            0
      1246   466_543011    Shannon  5.135459e-02 8.203964e-03            1
      1247   466_543011 expShannon  2.391053e-01 5.687372e-03            1
      1248   466_543011    Simpson  1.578282e-02 2.216428e-02            1
      1249   466_543011 invSimpson  1.249227e-01 1.560032e-02            1
      1250   466_543011        PIE  1.594350e-02 2.116982e-02            1
      1251   466_543011      DomMc -1.346942e-02 2.114015e-02            1
      1252   466_541549          S -2.840353e-02 8.803674e-01            0
      1253   466_541549          N -7.374466e+02 4.522751e-01            0
      1254   466_541549       maxN -3.620015e+02 6.516809e-01            0
      1255   466_541549    Shannon -1.051007e-03 9.520354e-01            0
      1256   466_541549 expShannon  9.903090e-03 8.588472e-01            0
      1257   466_541549    Simpson -5.444005e-03 5.118828e-01            0
      1258   466_541549 invSimpson -3.575945e-03 9.321976e-01            0
      1259   466_541549        PIE -5.439039e-03 5.125291e-01            0
      1260   466_541549      DomMc -2.334121e-03 5.970276e-01            0
      1261   466_545198          S -2.143861e-02 8.319460e-01            0
      1262   466_545198          N -7.956888e+01 6.083885e-01            0
      1263   466_545198       maxN -3.928304e+01 6.896138e-01            0
      1264   466_545198    Shannon -7.647295e-03 5.041037e-01            0
      1265   466_545198 expShannon -2.673039e-02 5.403557e-01            0
      1266   466_545198    Simpson -1.508447e-03 7.465021e-01            0
      1267   466_545198 invSimpson -1.267738e-02 6.986544e-01            0
      1268   466_545198        PIE -1.499852e-03 7.482298e-01            0
      1269   466_545198      DomMc  1.446217e-03 7.333805e-01            0
      1270   466_559051          S -6.466984e-03 9.527931e-01            0
      1271   466_559051          N -6.482869e+02 2.626912e-02            1
      1272   466_559051       maxN -6.724370e+02 1.912869e-02            1
      1273   466_559051    Shannon  6.837852e-02 2.508523e-03            1
      1274   466_559051 expShannon  2.090677e-01 1.057176e-02            1
      1275   466_559051    Simpson  2.964693e-02 4.388450e-03            1
      1276   466_559051 invSimpson  1.382932e-01 2.213150e-02            1
      1277   466_559051        PIE  2.968431e-02 4.362131e-03            1
      1278   466_559051      DomMc -1.613180e-02 5.895280e-03            1
      1279   466_543738          S -6.153846e-01 3.667166e-01            0
      1280   466_543738          N -3.784231e+02 4.843270e-02            1
      1281   466_543738       maxN -1.221154e+02 2.029464e-01            0
      1282   466_543738    Shannon -7.951435e-02 4.033538e-01            0
      1283   466_543738 expShannon -3.401157e-01 3.694857e-01            0
      1284   466_543738    Simpson -3.373692e-02 2.083340e-01            0
      1285   466_543738 invSimpson -2.795086e-01 1.919107e-01            0
      1286   466_543738        PIE -3.368044e-02 2.091261e-01            0
      1287   466_543738      DomMc  1.217726e-02 7.069895e-01            0
      1288   466_547388          S -2.958730e-01 6.041983e-03            1
      1289   466_547388          N -2.977282e+02 9.838632e-03            1
      1290   466_547388       maxN -2.510969e+02 4.480353e-03            1
      1291   466_547388    Shannon  3.430934e-02 2.492210e-03            1
      1292   466_547388 expShannon  1.083871e-01 1.896462e-03            1
      1293   466_547388    Simpson  1.823204e-02 4.615932e-04            1
      1294   466_547388 invSimpson  9.260044e-02 5.953459e-04            1
      1295   466_547388        PIE  1.830312e-02 4.513885e-04            1
      1296   466_547388      DomMc -9.775563e-03 7.565857e-03            1
      1297   466_565614          S -3.511924e-01 1.944719e-02            1
      1298   466_565614          N -4.620697e+02 2.611561e-01            0
      1299   466_565614       maxN -3.940885e+02 3.148487e-01            0
      1300   466_565614    Shannon  3.628036e-02 2.041691e-01            0
      1301   466_565614 expShannon  1.284104e-01 2.133098e-01            0
      1302   466_565614    Simpson  1.570366e-02 1.876388e-01            0
      1303   466_565614 invSimpson  1.048277e-01 1.109713e-01            0
      1304   466_565614        PIE  1.580220e-02 1.858790e-01            0
      1305   466_565614      DomMc -1.293920e-02 6.655798e-02            0
      1306   466_562698          S -5.000000e-01 6.220355e-01            0
      1307   466_562698          N  1.465000e+02 4.358410e-01            0
      1308   466_562698       maxN  6.390000e+01 3.836980e-01            0
      1309   466_562698    Shannon -3.279451e-02 4.985184e-01            0
      1310   466_562698 expShannon -1.466259e-01 5.146834e-01            0
      1311   466_562698    Simpson -8.647110e-03 4.878068e-01            0
      1312   466_562698 invSimpson -9.432557e-02 4.785138e-01            0
      1313   466_562698        PIE -8.794672e-03 4.678786e-01            0
      1314   466_562698      DomMc  1.615467e-02 4.454497e-01            0
      1315   466_559779          S -9.716599e-02 8.480712e-01            0
      1316   466_559779          N -6.768765e+02 2.065512e-01            0
      1317   466_559779       maxN -6.285911e+02 1.611559e-01            0
      1318   466_559779    Shannon  7.619163e-02 1.344490e-01            0
      1319   466_559779 expShannon  2.906118e-01 1.265696e-01            0
      1320   466_559779    Simpson  3.565061e-02 8.249479e-02            0
      1321   466_559779 invSimpson  2.654719e-01 4.884091e-02            1
      1322   466_559779        PIE  3.567813e-02 8.245216e-02            0
      1323   466_559779      DomMc -2.649622e-02 9.103407e-02            0
      1324   466_560509          S  6.307339e-03 9.697903e-01            0
      1325   466_560509          N -3.391881e+02 1.211782e-01            0
      1326   466_560509       maxN -3.009731e+02 1.297081e-01            0
      1327   466_560509    Shannon  3.671506e-02 1.696067e-01            0
      1328   466_560509 expShannon  1.814576e-01 1.162715e-01            0
      1329   466_560509    Simpson  1.201200e-02 2.437707e-01            0
      1330   466_560509 invSimpson  1.297018e-01 1.217904e-01            0
      1331   466_560509        PIE  1.207487e-02 2.425143e-01            0
      1332   466_560509      DomMc -8.527810e-03 2.883528e-01            0
      1333   466_545919          S -2.343096e-01 2.822565e-01            0
      1334   466_545919          N  2.368898e+01 8.102066e-01            0
      1335   466_545919       maxN  3.956764e+00 9.173452e-01            0
      1336   466_545919    Shannon -9.889526e-03 4.994199e-01            0
      1337   466_545919 expShannon -6.753457e-02 4.200592e-01            0
      1338   466_545919    Simpson -3.986740e-04 9.231312e-01            0
      1339   466_545919 invSimpson -3.716697e-02 6.406911e-01            0
      1340   466_545919        PIE -4.742826e-04 9.100330e-01            0
      1341   466_545919      DomMc  3.908968e-03 6.427819e-01            0
      1342   466_545912          S  5.766621e-03 9.644669e-01            0
      1343   466_545912          N -3.769810e+01 6.433232e-01            0
      1344   466_545912       maxN -4.439993e+01 5.378665e-01            0
      1345   466_545912    Shannon  1.337449e-02 5.234950e-01            0
      1346   466_545912 expShannon  4.618107e-02 5.499120e-01            0
      1347   466_545912    Simpson  6.888021e-03 4.568837e-01            0
      1348   466_545912 invSimpson  3.211745e-02 5.805061e-01            0
      1349   466_545912        PIE  6.898881e-03 4.573299e-01            0
      1350   466_545912      DomMc -1.759653e-03 7.687286e-01            0
      1351   466_548798          S  1.250000e-02 8.314006e-01            0
      1352   466_548798          N -1.446193e+02 8.926522e-02            0
      1353   466_548798       maxN -1.179568e+02 9.551554e-02            0
      1354   466_548798    Shannon  1.972114e-02 5.155842e-02            0
      1355   466_548798 expShannon  4.260237e-02 5.588907e-02            0
      1356   466_548798    Simpson  1.109383e-02 5.239505e-02            0
      1357   466_548798 invSimpson  3.143047e-02 6.875851e-02            0
      1358   466_548798        PIE  1.112622e-02 5.199855e-02            0
      1359   466_548798      DomMc -2.834630e-03 1.493912e-01            0
      1360   466_552442          S  2.807630e-02 6.321212e-01            0
      1361   466_552442          N -1.395504e+02 4.868772e-02            1
      1362   466_552442       maxN -1.369069e+02 2.693183e-02            1
      1363   466_552442    Shannon  1.157067e-02 3.630792e-01            0
      1364   466_552442 expShannon  1.339962e-02 6.847220e-01            0
      1365   466_552442    Simpson  8.900430e-03 1.528133e-01            0
      1366   466_552442 invSimpson  1.630352e-02 4.991431e-01            0
      1367   466_552442        PIE  8.929585e-03 1.518665e-01            0
      1368   466_552442      DomMc  1.638821e-03 6.064617e-01            0
      1369   466_553900          S  2.307692e-01 4.116516e-01            0
      1370   466_553900          N  2.066154e+02 4.862828e-01            0
      1371   466_553900       maxN -6.153846e+00 9.861988e-01            0
      1372   466_553900    Shannon  1.767076e-01 2.045926e-01            0
      1373   466_553900 expShannon  3.798808e-01 1.976604e-01            0
      1374   466_553900    Simpson  9.367946e-02 2.390792e-01            0
      1375   466_553900 invSimpson  2.649822e-01 2.168041e-01            0
      1376   466_553900        PIE  9.371065e-02 2.390974e-01            0
      1377   466_553900      DomMc -2.573846e-02 1.878448e-01            0
      1378   466_555359          S -6.928406e-02 2.447491e-01            0
      1379   466_555359          N  1.053253e+02 6.425064e-01            0
      1380   466_555359       maxN  9.302512e+01 6.741640e-01            0
      1381   466_555359    Shannon  7.977340e-03 5.300146e-01            0
      1382   466_555359 expShannon  1.353226e-02 5.817365e-01            0
      1383   466_555359    Simpson  3.304346e-03 6.929583e-01            0
      1384   466_555359 invSimpson  5.771826e-03 7.894735e-01            0
      1385   466_555359        PIE  3.306565e-03 6.928674e-01            0
      1386   466_555359      DomMc -1.868085e-03 4.306575e-01            0
      1387   466_559004          S  2.271497e-01 3.754155e-05            1
      1388   466_559004          N -3.147429e+01 8.500441e-01            0
      1389   466_559004       maxN -2.763877e+01 8.156142e-01            0
      1390   466_559004    Shannon  1.173420e-02 2.895347e-01            0
      1391   466_559004 expShannon  1.900833e-02 3.482835e-01            0
      1392   466_559004    Simpson  5.514462e-03 4.167371e-01            0
      1393   466_559004 invSimpson  9.492243e-03 5.591839e-01            0
      1394   466_559004        PIE  5.520773e-03 4.162778e-01            0
      1395   466_559004      DomMc -1.256566e-03 3.700424e-01            0
      1396   466_553901          S  2.528573e-03 9.657426e-01            0
      1397   466_553901          N -1.871620e+02 4.014946e-02            1
      1398   466_553901       maxN -1.712800e+02 2.476912e-02            1
      1399   466_553901    Shannon  2.108296e-02 3.784119e-02            1
      1400   466_553901 expShannon  4.057981e-02 5.588397e-02            0
      1401   466_553901    Simpson  1.156529e-02 3.920410e-02            1
      1402   466_553901 invSimpson  2.728315e-02 6.031118e-02            0
      1403   466_553901        PIE  1.159726e-02 3.879820e-02            1
      1404   466_553901      DomMc -2.456206e-03 2.726284e-01            0
      1405   466_552446          S  6.039369e-02 2.504021e-01            0
      1406   466_552446          N -1.970510e+02 7.047093e-02            0
      1407   466_552446       maxN -2.108610e+02 4.060186e-02            1
      1408   466_552446    Shannon  4.251291e-02 1.036774e-03            1
      1409   466_552446 expShannon  8.977039e-02 8.665231e-04            1
      1410   466_552446    Simpson  2.252109e-02 1.245103e-03            1
      1411   466_552446 invSimpson  5.751368e-02 9.300283e-04            1
      1412   466_552446        PIE  2.253892e-02 1.244517e-03            1
      1413   466_552446      DomMc -7.113406e-03 3.539008e-03            1
      1414   466_553171          S  6.520247e-02 2.567077e-01            0
      1415   466_553171          N -2.736239e+02 1.204689e-02            1
      1416   466_553171       maxN -2.482052e+02 3.370049e-02            1
      1417   466_553171    Shannon  2.419471e-02 9.819199e-02            0
      1418   466_553171 expShannon  5.283946e-02 8.417391e-02            0
      1419   466_553171    Simpson  1.279345e-02 1.909903e-01            0
      1420   466_553171 invSimpson  3.841025e-02 1.635679e-01            0
      1421   466_553171        PIE  1.281456e-02 1.904604e-01            0
      1422   466_553171      DomMc -3.914392e-03 2.538082e-01            0
      1423   466_553175          S -5.936018e-02 4.736109e-01            0
      1424   466_553175          N -1.756295e+02 3.959588e-01            0
      1425   466_553175       maxN -1.624765e+02 3.826750e-01            0
      1426   466_553175    Shannon  2.273234e-02 2.274416e-01            0
      1427   466_553175 expShannon  5.832529e-02 2.362555e-01            0
      1428   466_553175    Simpson  1.241114e-02 1.813451e-01            0
      1429   466_553175 invSimpson  4.850607e-02 1.759035e-01            0
      1430   466_553175        PIE  1.244583e-02 1.808179e-01            0
      1431   466_553175      DomMc -5.271797e-03 2.415385e-01            0
      1432   466_556090          S -5.917160e-03 9.755086e-01            0
      1433   466_556090          N -6.011538e+01 7.443456e-01            0
      1434   466_556090       maxN -1.083491e+02 5.229514e-01            0
      1435   466_556090    Shannon  3.599970e-02 3.411866e-02            1
      1436   466_556090 expShannon  8.076913e-02 1.533180e-02            1
      1437   466_556090    Simpson  2.574512e-02 1.235443e-02            1
      1438   466_556090 invSimpson  7.727218e-02 1.009856e-01            0
      1439   466_556090        PIE  2.576073e-02 1.218023e-02            1
      1440   466_556090      DomMc -7.586934e-04 8.161208e-01            0
      1441   466_557547          S  1.199201e-01 1.529073e-01            0
      1442   466_557547          N -2.111053e+02 4.918019e-02            1
      1443   466_557547       maxN -1.651739e+02 5.993110e-02            0
      1444   466_557547    Shannon  1.242618e-02 3.648363e-01            0
      1445   466_557547 expShannon  3.018226e-02 3.397664e-01            0
      1446   466_557547    Simpson  4.586834e-03 5.426956e-01            0
      1447   466_557547 invSimpson  1.669520e-02 4.482289e-01            0
      1448   466_557547        PIE  4.599800e-03 5.418726e-01            0
      1449   466_557547      DomMc -3.778179e-03 2.088874e-01            0
      1450   466_554630          S -5.502063e-02 5.453826e-01            0
      1451   466_554630          N -2.990399e+02 2.976687e-01            0
      1452   466_554630       maxN -3.061176e+02 2.710251e-01            0
      1453   466_554630    Shannon  2.126313e-02 1.394427e-01            0
      1454   466_554630 expShannon  4.205106e-02 1.717648e-01            0
      1455   466_554630    Simpson  1.414269e-02 8.213106e-02            0
      1456   466_554630 invSimpson  3.438489e-02 1.735218e-01            0
      1457   466_554630        PIE  1.416929e-02 8.169180e-02            0
      1458   466_554630      DomMc -2.117330e-03 5.556714e-01            0
      1459   466_553902          S  3.640257e-02 7.536029e-01            0
      1460   466_553902          N -4.450321e+02 3.545213e-02            1
      1461   466_553902       maxN -3.769764e+02 1.108487e-02            1
      1462   466_553902    Shannon  2.322580e-03 8.957016e-01            0
      1463   466_553902 expShannon  4.060251e-03 9.032516e-01            0
      1464   466_553902    Simpson -1.752855e-03 8.806971e-01            0
      1465   466_553902 invSimpson -4.487437e-03 8.609658e-01            0
      1466   466_553902        PIE -1.751229e-03 8.808132e-01            0
      1467   466_553902      DomMc -1.950212e-03 5.458508e-01            0
      1468   466_549529          S -2.254374e-02 7.899428e-01            0
      1469   466_549529          N -9.271198e+01 8.129902e-01            0
      1470   466_549529       maxN -1.208449e+02 7.412665e-01            0
      1471   466_549529    Shannon  3.915394e-02 7.517323e-02            0
      1472   466_549529 expShannon  8.657664e-02 8.815155e-02            0
      1473   466_549529    Simpson  2.260190e-02 5.694035e-02            0
      1474   466_549529 invSimpson  6.544324e-02 8.822239e-02            0
      1475   466_549529        PIE  2.261291e-02 5.690625e-02            0
      1476   466_549529      DomMc -8.679368e-03 1.416694e-01            0
      1477   466_551714          S  1.032389e-01 1.326942e-01            0
      1478   466_551714          N -6.686987e+02 3.829424e-01            0
      1479   466_551714       maxN -6.795931e+02 3.814540e-01            0
      1480   466_551714    Shannon  5.800959e-03 8.239849e-01            0
      1481   466_551714 expShannon  9.085310e-03 8.880915e-01            0
      1482   466_551714    Simpson  3.893300e-03 7.825503e-01            0
      1483   466_551714 invSimpson  9.348562e-03 8.594826e-01            0
      1484   466_551714        PIE  3.894251e-03 7.826228e-01            0
      1485   466_551714      DomMc  7.512327e-04 9.084889e-01            0
      1486   466_550254          S -1.709469e-01 7.598204e-02            0
      1487   466_550254          N  1.477942e+02 6.184815e-01            0
      1488   466_550254       maxN  1.630777e+02 5.303321e-01            0
      1489   466_550254    Shannon -1.274102e-02 3.887126e-01            0
      1490   466_550254 expShannon -2.156307e-02 5.132018e-01            0
      1491   466_550254    Simpson -5.433213e-03 4.895276e-01            0
      1492   466_550254 invSimpson -7.946563e-03 7.525540e-01            0
      1493   466_550254        PIE -5.424986e-03 4.905679e-01            0
      1494   466_550254      DomMc  1.525394e-03 6.662719e-01            0
      1495   466_549527          S -1.141104e-01 1.385284e-01            0
      1496   466_549527          N -2.959939e+01 8.096810e-01            0
      1497   466_549527       maxN -1.184049e+00 9.914225e-01            0
      1498   466_549527    Shannon -1.104073e-02 4.412800e-01            0
      1499   466_549527 expShannon -3.810340e-02 3.933437e-01            0
      1500   466_549527    Simpson -1.838238e-03 7.917748e-01            0
      1501   466_549527 invSimpson -1.925795e-02 5.837977e-01            0
      1502   466_549527        PIE -1.822914e-03 7.936037e-01            0
      1503   466_549527      DomMc  6.263414e-03 1.762286e-01            0
      1504   466_553903          S -9.512625e-02 3.848880e-01            0
      1505   466_553903          N -2.774686e+02 2.782647e-01            0
      1506   466_553903       maxN -2.826514e+02 2.138599e-01            0
      1507   466_553903    Shannon  2.794148e-02 2.648997e-02            1
      1508   466_553903 expShannon  5.513184e-02 3.725340e-02            1
      1509   466_553903    Simpson  1.537415e-02 4.407034e-02            1
      1510   466_553903 invSimpson  3.845912e-02 6.645414e-02            0
      1511   466_553903        PIE  1.538171e-02 4.400217e-02            1
      1512   466_553903      DomMc -4.014669e-03 1.333440e-02            1
      1513   466_550258          S  2.636204e-03 9.698109e-01            0
      1514   466_550258          N -3.160105e+01 8.777053e-01            0
      1515   466_550258       maxN -9.453647e+01 4.539831e-01            0
      1516   466_550258    Shannon  3.114309e-02 2.187593e-01            0
      1517   466_550258 expShannon  5.271933e-02 2.969529e-01            0
      1518   466_550258    Simpson  1.595035e-02 3.132446e-01            0
      1519   466_550258 invSimpson  3.184428e-02 4.855297e-01            0
      1520   466_550258        PIE  1.595997e-02 3.129830e-01            0
      1521   466_550258      DomMc -5.450370e-03 3.967728e-01            0
      1522   466_556089          S  1.327739e-01 1.602597e-01            0
      1523   466_556089          N -2.080136e+02 9.137276e-02            0
      1524   466_556089       maxN -1.817853e+02 8.832058e-02            0
      1525   466_556089    Shannon  2.681679e-02 4.277835e-02            1
      1526   466_556089 expShannon  7.321525e-02 4.718908e-02            1
      1527   466_556089    Simpson  1.213602e-02 8.047659e-02            0
      1528   466_556089 invSimpson  5.758712e-02 7.659997e-02            0
      1529   466_556089        PIE  1.215108e-02 8.036413e-02            0
      1530   466_556089      DomMc -8.566565e-03 4.685136e-02            1
      1531   466_556091          S  1.466591e-01 1.537106e-02            1
      1532   466_556091          N -7.755085e+01 9.061107e-02            0
      1533   466_556091       maxN -9.440396e+01 1.958885e-02            1
      1534   466_556091    Shannon  4.765850e-02 2.469682e-03            1
      1535   466_556091 expShannon  1.321900e-01 4.552310e-03            1
      1536   466_556091    Simpson  2.387673e-02 1.280552e-03            1
      1537   466_556091 invSimpson  1.002038e-01 4.058174e-03            1
      1538   466_556091        PIE  2.393990e-02 1.282551e-03            1
      1539   466_556091      DomMc -1.043414e-02 1.398867e-02            1
      1540   466_556092          S  9.369025e-02 1.315277e-01            0
      1541   466_556092          N -1.837349e+02 2.146216e-01            0
      1542   466_556092       maxN -1.783773e+02 2.044668e-01            0
      1543   466_556092    Shannon  3.095189e-02 1.436082e-01            0
      1544   466_556092 expShannon  1.125367e-01 1.440885e-01            0
      1545   466_556092    Simpson  1.247307e-02 1.675715e-01            0
      1546   466_556092 invSimpson  1.003589e-01 1.250167e-01            0
      1547   466_556092        PIE  1.256181e-02 1.663763e-01            0
      1548   466_556092      DomMc -8.442066e-03 1.787569e-01            0
      1549   466_553904          S  3.633864e-02 4.854657e-01            0
      1550   466_553904          N -1.810348e+02 2.553042e-01            0
      1551   466_553904       maxN -1.581008e+02 3.090464e-01            0
      1552   466_553904    Shannon  2.026291e-02 3.842581e-02            1
      1553   466_553904 expShannon  4.015893e-02 2.981428e-02            1
      1554   466_553904    Simpson  8.711902e-03 1.273041e-01            0
      1555   466_553904 invSimpson  1.915071e-02 1.289306e-01            0
      1556   466_553904        PIE  8.730598e-03 1.268955e-01            0
      1557   466_553904      DomMc -5.389891e-03 1.177455e-03            1
      1558   466_552445          S -4.629630e-03 9.605141e-01            0
      1559   466_552445          N -1.633796e+02 1.792285e-01            0
      1560   466_552445       maxN -1.383345e+02 1.843398e-01            0
      1561   466_552445    Shannon  5.944529e-03 7.026871e-01            0
      1562   466_552445 expShannon  1.164791e-02 7.172116e-01            0
      1563   466_552445    Simpson  2.408091e-03 7.791717e-01            0
      1564   466_552445 invSimpson  5.118090e-03 8.058780e-01            0
      1565   466_552445        PIE  2.412871e-03 7.788322e-01            0
      1566   466_552445      DomMc -1.655460e-03 5.522417e-01            0
      1567   466_554632          S  1.597773e-01 2.451900e-02            1
      1568   466_554632          N -4.109156e+02 3.782582e-01            0
      1569   466_554632       maxN -3.951296e+02 1.780242e-01            0
      1570   466_554632    Shannon  4.924843e-02 3.355339e-04            1
      1571   466_554632 expShannon  1.008667e-01 1.905828e-04            1
      1572   466_554632    Simpson  2.280985e-02 2.722534e-03            1
      1573   466_554632 invSimpson  5.336026e-02 3.249690e-03            1
      1574   466_554632        PIE  2.283607e-02 2.698905e-03            1
      1575   466_554632      DomMc -9.896437e-03 1.627278e-03            1
      1576   466_556818          S  1.000000e+00 2.721805e-14            1
      1577   466_556818          N -2.506429e+02 5.029834e-01            0
      1578   466_556818       maxN -3.775714e+02 2.816882e-01            0
      1579   466_556818    Shannon  1.977807e-01 2.407331e-01            0
      1580   466_556818 expShannon  3.960820e-01 2.334909e-01            0
      1581   466_556818    Simpson  1.003300e-01 2.319368e-01            0
      1582   466_556818 invSimpson  2.041088e-01 2.254441e-01            0
      1583   466_556818        PIE  1.003802e-01 2.318950e-01            0
      1584   466_556818      DomMc -1.816704e-02 3.146567e-01            0
      1585   466_556088          S  1.328976e-01 3.828755e-01            0
      1586   466_556088          N -7.380185e+02 8.119958e-02            0
      1587   466_556088       maxN -4.899336e+02 4.974822e-02            1
      1588   466_556088    Shannon  1.993526e-02 1.209707e-01            0
      1589   466_556088 expShannon  5.069230e-02 1.022688e-01            0
      1590   466_556088    Simpson  7.008899e-03 3.588641e-01            0
      1591   466_556088 invSimpson  2.894357e-02 2.878659e-01            0
      1592   466_556088        PIE  7.019834e-03 3.582758e-01            0
      1593   466_556088      DomMc -4.488659e-03 2.126341e-01            0
      1594   466_550255          S -1.819580e-01 1.404040e-01            0
      1595   466_550255          N -4.525136e+02 1.814110e-02            1
      1596   466_550255       maxN -3.069329e+02 6.804948e-03            1
      1597   466_550255    Shannon  3.850710e-03 8.244656e-01            0
      1598   466_550255 expShannon -2.566596e-03 9.516498e-01            0
      1599   466_550255    Simpson  4.001036e-03 7.114048e-01            0
      1600   466_550255 invSimpson -5.551781e-03 8.970850e-01            0
      1601   466_550255        PIE  4.013838e-03 7.105652e-01            0
      1602   466_550255      DomMc  4.282722e-03 4.267378e-01            0
      1603   466_553905          S  1.131222e-01 3.830147e-01            0
      1604   466_553905          N -3.661742e+02 1.706022e-01            0
      1605   466_553905       maxN -2.894118e+02 1.080249e-01            0
      1606   466_553905    Shannon  5.235038e-02 1.932662e-02            1
      1607   466_553905 expShannon  1.291201e-01 2.421291e-02            1
      1608   466_553905    Simpson  2.229011e-02 4.157315e-02            1
      1609   466_553905 invSimpson  7.751703e-02 5.111492e-02            0
      1610   466_553905        PIE  2.237774e-02 4.126267e-02            1
      1611   466_553905      DomMc -1.297362e-02 1.408984e-02            1
      1612   466_555362          S  1.527650e-01 5.134594e-02            0
      1613   466_555362          N -9.165553e+01 1.471173e-01            0
      1614   466_555362       maxN -9.511544e+01 8.298761e-02            0
      1615   466_555362    Shannon  3.194288e-02 2.027577e-01            0
      1616   466_555362 expShannon  8.005447e-02 2.826162e-01            0
      1617   466_555362    Simpson  1.425819e-02 2.337099e-01            0
      1618   466_555362 invSimpson  4.989975e-02 3.413479e-01            0
      1619   466_555362        PIE  1.428753e-02 2.339120e-01            0
      1620   466_555362      DomMc -7.050848e-03 2.715114e-01            0
      1621   466_559733          S  4.226434e-02 5.916719e-01            0
      1622   466_559733          N -2.225569e+02 3.573527e-01            0
      1623   466_559733       maxN -1.341647e+02 3.195039e-01            0
      1624   466_559733    Shannon  5.154347e-03 7.470043e-01            0
      1625   466_559733 expShannon  6.879325e-03 8.544147e-01            0
      1626   466_559733    Simpson  1.948203e-03 8.317651e-01            0
      1627   466_559733 invSimpson -1.321576e-03 9.673428e-01            0
      1628   466_559733        PIE  1.960807e-03 8.308347e-01            0
      1629   466_559733      DomMc -1.260792e-04 9.712181e-01            0
      1630   466_557548          S  1.944530e-01 4.020659e-03            1
      1631   466_557548          N -1.257027e+02 1.750532e-01            0
      1632   466_557548       maxN -1.235244e+02 1.539584e-01            0
      1633   466_557548    Shannon  2.472026e-02 9.823900e-02            0
      1634   466_557548 expShannon  5.301157e-02 1.848001e-01            0
      1635   466_557548    Simpson  1.113330e-02 1.131018e-01            0
      1636   466_557548 invSimpson  3.044641e-02 2.608337e-01            0
      1637   466_557548        PIE  1.115338e-02 1.131271e-01            0
      1638   466_557548      DomMc -4.566641e-03 2.104938e-01            0
      1639   466_550256          S  1.550960e-02 7.894950e-01            0
      1640   466_550256          N -1.748708e+01 8.776298e-01            0
      1641   466_550256       maxN -5.039217e+01 4.870885e-01            0
      1642   466_550256    Shannon  4.055174e-02 1.242369e-02            1
      1643   466_550256 expShannon  9.409230e-02 1.589865e-02            1
      1644   466_550256    Simpson  2.257330e-02 1.126305e-02            1
      1645   466_550256 invSimpson  7.297707e-02 2.382509e-02            1
      1646   466_550256        PIE  2.258178e-02 1.125622e-02            1
      1647   466_550256      DomMc -8.131925e-03 2.706214e-02            1
      1648   466_554634          S  8.955765e-02 4.332420e-01            0
      1649   466_554634          N -1.831672e+02 1.252007e-01            0
      1650   466_554634       maxN -1.905540e+02 1.027023e-01            0
      1651   466_554634    Shannon  2.800352e-02 2.365236e-01            0
      1652   466_554634 expShannon  5.287863e-02 3.021771e-01            0
      1653   466_554634    Simpson  1.352084e-02 2.301714e-01            0
      1654   466_554634 invSimpson  2.819782e-02 3.141248e-01            0
      1655   466_554634        PIE  1.351635e-02 2.311366e-01            0
      1656   466_554634      DomMc -4.816175e-03 3.358887e-01            0
      1657   466_554631          S  1.721470e-01 4.951660e-01            0
      1658   466_554631          N -5.469130e+02 4.519147e-02            1
      1659   466_554631       maxN -3.847805e+02 8.644738e-02            0
      1660   466_554631    Shannon  2.508894e-03 9.080931e-01            0
      1661   466_554631 expShannon -2.184859e-04 9.970307e-01            0
      1662   466_554631    Simpson  1.645824e-03 8.769242e-01            0
      1663   466_554631 invSimpson -2.558356e-03 9.563118e-01            0
      1664   466_554631        PIE  1.658612e-03 8.760111e-01            0
      1665   466_554631      DomMc  6.753398e-03 4.228298e-01            0
      1666   466_553176          S  3.453307e-02 7.939738e-01            0
      1667   466_553176          N -5.802967e+01 5.902878e-01            0
      1668   466_553176       maxN -6.836673e+01 3.579405e-01            0
      1669   466_553176    Shannon  2.075922e-02 3.157093e-01            0
      1670   466_553176 expShannon  3.886721e-02 4.119493e-01            0
      1671   466_553176    Simpson  1.247456e-02 2.603718e-01            0
      1672   466_553176 invSimpson  3.410652e-02 2.955236e-01            0
      1673   466_553176        PIE  1.247913e-02 2.606439e-01            0
      1674   466_553176      DomMc -1.858553e-03 6.888375e-01            0
      1675   466_556819          S  2.914418e-01 1.075400e-03            1
      1676   466_556819          N -8.998901e+01 7.542274e-01            0
      1677   466_556819       maxN -1.732226e+02 4.871067e-01            0
      1678   466_556819    Shannon  5.115565e-02 4.165138e-03            1
      1679   466_556819 expShannon  1.109347e-01 1.459113e-02            1
      1680   466_556819    Simpson  2.823605e-02 4.813484e-04            1
      1681   466_556819 invSimpson  7.958476e-02 4.012746e-03            1
      1682   466_556819        PIE  2.826079e-02 4.885738e-04            1
      1683   466_556819      DomMc -8.123916e-03 8.884500e-02            0
      1684   466_550984          S  6.432193e-02 4.551722e-01            0
      1685   466_550984          N -2.924534e+02 2.422336e-02            1
      1686   466_550984       maxN -2.113530e+02 2.191813e-02            1
      1687   466_550984    Shannon  4.045293e-05 9.972526e-01            0
      1688   466_550984 expShannon  1.658695e-03 9.574457e-01            0
      1689   466_550984    Simpson  1.797722e-03 7.769638e-01            0
      1690   466_550984 invSimpson  7.991052e-03 7.615529e-01            0
      1691   466_550984        PIE  1.814605e-03 7.750288e-01            0
      1692   466_550984      DomMc  3.119489e-03 3.756228e-01            0
      1693   466_561188          S  3.035714e-01 2.999501e-01            0
      1694   466_561188          N -4.005357e+01 9.819930e-01            0
      1695   466_561188       maxN -8.950000e+01 9.263240e-01            0
      1696   466_561188    Shannon  2.407571e-02 2.701048e-01            0
      1697   466_561188 expShannon  5.541957e-02 2.920292e-01            0
      1698   466_561188    Simpson  9.544909e-03 9.762643e-02            0
      1699   466_561188 invSimpson  3.864285e-02 1.413554e-01            0
      1700   466_561188        PIE  9.560025e-03 9.868939e-02            0
      1701   466_561188      DomMc -4.433171e-03 3.915008e-01            0
      1702   466_558274          S  9.699170e-02 6.466084e-02            0
      1703   466_558274          N -7.687217e+02 2.190703e-01            0
      1704   466_558274       maxN -6.963846e+02 1.959377e-01            0
      1705   466_558274    Shannon  3.164643e-02 1.099101e-02            1
      1706   466_558274 expShannon  6.674140e-02 2.085579e-02            1
      1707   466_558274    Simpson  1.845005e-02 2.146134e-02            1
      1708   466_558274 invSimpson  5.238558e-02 5.209056e-02            0
      1709   466_558274        PIE  1.846215e-02 2.141723e-02            1
      1710   466_558274      DomMc -5.126513e-03 8.853438e-02            0
      1711   466_555361          S -1.242718e-02 7.092626e-01            0
      1712   466_555361          N -3.474435e+02 5.437287e-01            0
      1713   466_555361       maxN -2.976971e+02 6.062505e-01            0
      1714   466_555361    Shannon  6.239972e-02 3.243257e-02            1
      1715   466_555361 expShannon  1.628668e-01 1.463799e-02            1
      1716   466_555361    Simpson  2.670736e-02 7.451068e-02            0
      1717   466_555361 invSimpson  9.524115e-02 3.202193e-02            1
      1718   466_555361        PIE  2.679753e-02 7.390587e-02            0
      1719   466_555361      DomMc -1.454250e-02 4.564785e-03            1
      1720   466_553172          S -3.512397e-02 6.098143e-01            0
      1721   466_553172          N -3.504398e+02 1.468020e-03            1
      1722   466_553172       maxN -3.349096e+02 3.019297e-03            1
      1723   466_553172    Shannon  3.081150e-02 8.823266e-02            0
      1724   466_553172 expShannon  6.625742e-02 1.136848e-01            0
      1725   466_553172    Simpson  1.673407e-02 1.191400e-01            0
      1726   466_553172 invSimpson  4.666814e-02 1.958469e-01            0
      1727   466_553172        PIE  1.677282e-02 1.187989e-01            0
      1728   466_553172      DomMc -4.481974e-03 3.132830e-01            0
      1729   466_556087          S  2.215068e-01 7.231883e-02            0
      1730   466_556087          N  1.281165e+02 8.657649e-01            0
      1731   466_556087       maxN  1.281700e+02 8.600942e-01            0
      1732   466_556087    Shannon  7.408713e-03 6.739960e-01            0
      1733   466_556087 expShannon  1.631708e-02 6.386024e-01            0
      1734   466_556087    Simpson  1.430076e-03 9.039999e-01            0
      1735   466_556087 invSimpson  2.110328e-03 9.444832e-01            0
      1736   466_556087        PIE  1.430152e-03 9.040148e-01            0
      1737   466_556087      DomMc -4.331825e-03 4.928712e-02            1
      1738   466_548799          S  7.463405e-18 7.966236e-01            0
      1739   466_548799          N -3.853908e+02 2.878733e-02            1
      1740   466_548799       maxN -3.055210e+02 2.583434e-02            1
      1741   466_548799    Shannon  5.878286e-03 7.926370e-01            0
      1742   466_548799 expShannon  1.595308e-02 7.550000e-01            0
      1743   466_548799    Simpson  4.947798e-03 7.447388e-01            0
      1744   466_548799 invSimpson  2.094599e-02 6.812120e-01            0
      1745   466_548799        PIE  4.978049e-03 7.434690e-01            0
      1746   466_548799      DomMc  7.370133e-04 8.048638e-01            0
      1747   466_550257          S -1.137184e-01 1.280102e-01            0
      1748   466_550257          N -2.844465e+01 7.969743e-01            0
      1749   466_550257       maxN -1.070999e+01 9.261156e-01            0
      1750   466_550257    Shannon -1.416745e-03 9.538290e-01            0
      1751   466_550257 expShannon  7.463047e-03 9.038133e-01            0
      1752   466_550257    Simpson -2.844094e-03 8.258279e-01            0
      1753   466_550257 invSimpson  3.388967e-03 9.465212e-01            0
      1754   466_550257        PIE -2.838190e-03 8.263272e-01            0
      1755   466_550257      DomMc -1.774568e-03 7.662488e-01            0
      1756   466_559005          S  1.565404e-01 3.548559e-01            0
      1757   466_559005          N -5.611001e+02 1.047277e-02            1
      1758   466_559005       maxN -3.881687e+02 6.929818e-03            1
      1759   466_559005    Shannon -4.777878e-03 8.058083e-01            0
      1760   466_559005 expShannon -6.315562e-03 8.862304e-01            0
      1761   466_559005    Simpson -4.452731e-04 9.711224e-01            0
      1762   466_559005 invSimpson  8.312305e-03 8.451925e-01            0
      1763   466_559005        PIE -4.291797e-04 9.721816e-01            0
      1764   466_559005      DomMc  5.744839e-03 1.978958e-01            0
      1765   466_559734          S  3.138801e-01 5.696903e-03            1
      1766   466_559734          N -1.567156e+02 1.172901e-01            0
      1767   466_559734       maxN -1.373270e+02 1.167691e-01            0
      1768   466_559734    Shannon  3.396533e-03 8.489142e-01            0
      1769   466_559734 expShannon  5.155152e-03 8.900218e-01            0
      1770   466_559734    Simpson  4.969915e-04 9.590666e-01            0
      1771   466_559734 invSimpson  1.696031e-03 9.427929e-01            0
      1772   466_559734        PIE  5.075741e-04 9.582211e-01            0
      1773   466_559734      DomMc -3.608193e-04 9.241981e-01            0
      1774   466_551717          S  1.438535e-01 1.809204e-01            0
      1775   466_551717          N -7.429207e+01 5.419538e-01            0
      1776   466_551717       maxN -6.789756e+01 5.702656e-01            0
      1777   466_551717    Shannon  2.690977e-02 3.196703e-01            0
      1778   466_551717 expShannon  4.511710e-02 4.866276e-01            0
      1779   466_551717    Simpson  1.279578e-02 3.724817e-01            0
      1780   466_551717 invSimpson  1.692162e-02 7.644977e-01            0
      1781   466_551717        PIE  1.283462e-02 3.714991e-01            0
      1782   466_551717      DomMc -2.743798e-03 7.104986e-01            0
      1783   466_553174          S  2.285331e-01 1.579790e-02            1
      1784   466_553174          N -1.649584e+02 2.077608e-01            0
      1785   466_553174       maxN -1.756865e+02 1.528490e-01            0
      1786   466_553174    Shannon  3.515098e-02 8.561800e-04            1
      1787   466_553174 expShannon  7.160060e-02 3.688764e-04            1
      1788   466_553174    Simpson  1.649596e-02 1.851115e-03            1
      1789   466_553174 invSimpson  3.622779e-02 5.769004e-04            1
      1790   466_553174        PIE  1.651465e-02 1.843347e-03            1
      1791   466_553174      DomMc -6.605099e-03 1.535868e-03            1
      1792   466_559003          S  3.795380e-02 8.314328e-01            0
      1793   466_559003          N -5.529035e+02 6.978033e-02            0
      1794   466_559003       maxN -3.891964e+02 1.423300e-01            0
      1795   466_559003    Shannon -9.551355e-03 6.211140e-01            0
      1796   466_559003 expShannon -2.323905e-02 5.942560e-01            0
      1797   466_559003    Simpson -1.024563e-02 3.519894e-01            0
      1798   466_559003 invSimpson -3.535064e-02 3.558310e-01            0
      1799   466_559003        PIE -1.024314e-02 3.525676e-01            0
      1800   466_559003      DomMc -1.989879e-04 9.727026e-01            0
      1801   466_550988          S  1.111111e-01 1.611295e-01            0
      1802   466_550988          N -1.972164e+02 9.815364e-02            0
      1803   466_550988       maxN -1.280526e+02 4.907656e-02            1
      1804   466_550988    Shannon  2.785148e-02 5.696928e-01            0
      1805   466_550988 expShannon  1.040204e-01 5.165278e-01            0
      1806   466_550988    Simpson  1.090869e-02 6.303614e-01            0
      1807   466_550988 invSimpson  1.012576e-01 4.960043e-01            0
      1808   466_550988        PIE  1.094661e-02 6.294297e-01            0
      1809   466_550988      DomMc -1.695175e-02 3.596238e-01            0
      1810   466_556086          S  7.216495e-02 6.353422e-01            0
      1811   466_556086          N -4.322804e+02 1.391865e-01            0
      1812   466_556086       maxN -1.826887e+02 1.954809e-01            0
      1813   466_556086    Shannon -3.216626e-02 3.950675e-01            0
      1814   466_556086 expShannon -6.009590e-02 4.911938e-01            0
      1815   466_556086    Simpson -2.316616e-02 2.883859e-01            0
      1816   466_556086 invSimpson -6.023714e-02 3.924237e-01            0
      1817   466_556086        PIE -2.315988e-02 2.888035e-01            0
      1818   466_556086      DomMc -9.727227e-04 9.144637e-01            0
      1819   466_560463          S  2.511962e-02 8.531823e-01            0
      1820   466_560463          N -2.992978e+02 5.259561e-01            0
      1821   466_560463       maxN -1.103816e+02 7.362915e-01            0
      1822   466_560463    Shannon  1.788704e-02 5.696468e-01            0
      1823   466_560463 expShannon  4.876246e-02 4.376423e-01            0
      1824   466_560463    Simpson  8.525985e-03 6.925369e-01            0
      1825   466_560463 invSimpson  4.073941e-02 4.994227e-01            0
      1826   466_560463        PIE  8.547768e-03 6.918636e-01            0
      1827   466_560463      DomMc -5.829523e-03 1.886915e-01            0
      1828   466_549526          S -6.188605e-02 5.571236e-01            0
      1829   466_549526          N -5.338900e+00 8.966363e-01            0
      1830   466_549526       maxN -1.216896e+01 7.182186e-01            0
      1831   466_549526    Shannon  4.678214e-03 4.388873e-01            0
      1832   466_549526 expShannon  1.100841e-02 4.451876e-01            0
      1833   466_549526    Simpson  5.152813e-03 2.870158e-01            0
      1834   466_549526 invSimpson  1.617187e-02 2.957822e-01            0
      1835   466_549526        PIE  5.158334e-03 2.869478e-01            0
      1836   466_549526      DomMc  5.298448e-04 7.181695e-01            0
      1837   466_550259          S -5.426357e-02 4.681889e-01            0
      1838   466_550259          N  2.267054e+01 6.509393e-01            0
      1839   466_550259       maxN -5.887597e+00 8.387959e-01            0
      1840   466_550259    Shannon  3.094504e-02 8.213369e-02            0
      1841   466_550259 expShannon  6.288251e-02 1.403855e-01            0
      1842   466_550259    Simpson  1.872948e-02 8.992173e-02            0
      1843   466_550259 invSimpson  4.647936e-02 2.015313e-01            0
      1844   466_550259        PIE  1.874167e-02 8.980287e-02            0
      1845   466_550259      DomMc -4.254401e-03 3.035344e-01            0
      1846   466_542290          S  3.015075e-02 9.216369e-01            0
      1847   466_542290          N  2.185955e+02 7.392339e-02            0
      1848   466_542290       maxN  1.708266e+02 8.449175e-03            1
      1849   466_542290    Shannon -1.915456e-02 3.374241e-01            0
      1850   466_542290 expShannon -5.924945e-02 3.674767e-01            0
      1851   466_542290    Simpson -9.740914e-03 5.644039e-01            0
      1852   466_542290 invSimpson -5.371400e-02 5.739383e-01            0
      1853   466_542290        PIE -9.772135e-03 5.636447e-01            0
      1854   466_542290      DomMc  4.385415e-03 6.060730e-01            0
      1855   466_565606          S -1.132075e-01 4.420406e-01            0
      1856   466_565606          N  3.477717e+02 4.124918e-01            0
      1857   466_565606       maxN  3.325698e+02 3.929071e-01            0
      1858   466_565606    Shannon -8.865192e-02 2.024744e-02            1
      1859   466_565606 expShannon -3.600555e-01 1.527632e-02            1
      1860   466_565606    Simpson -3.470406e-02 2.555146e-02            1
      1861   466_565606 invSimpson -2.609846e-01 1.496525e-02            1
      1862   466_565606        PIE -3.484331e-02 2.536775e-02            1
      1863   466_565606      DomMc  2.342862e-02 2.222405e-02            1
      1864   466_553933          S  7.067669e-02 8.306438e-01            0
      1865   466_553933          N -7.888571e+01 3.803943e-01            0
      1866   466_553933       maxN -3.098421e+01 3.904733e-01            0
      1867   466_553933    Shannon  5.633892e-02 8.440083e-02            0
      1868   466_553933 expShannon  3.029330e-01 5.614841e-02            0
      1869   466_553933    Simpson  1.410400e-02 2.791424e-01            0
      1870   466_553933 invSimpson  2.433498e-01 8.443249e-02            0
      1871   466_553933        PIE  1.423736e-02 2.755253e-01            0
      1872   466_553933      DomMc -2.652928e-02 5.389068e-02            0
      1873   466_562687          S -2.832640e-01 2.337286e-01            0
      1874   466_562687          N -4.715177e+00 8.547684e-01            0
      1875   466_562687       maxN -5.972453e+00 5.903731e-01            0
      1876   466_562687    Shannon  5.019724e-05 9.966434e-01            0
      1877   466_562687 expShannon -1.876599e-03 9.787675e-01            0
      1878   466_562687    Simpson  4.672235e-03 2.748338e-01            0
      1879   466_562687 invSimpson  2.670593e-02 6.627978e-01            0
      1880   466_562687        PIE  4.663793e-03 2.787981e-01            0
      1881   466_562687      DomMc  4.171216e-04 9.387945e-01            0
      1882   466_556851          S  1.000000e-01 9.210877e-01            0
      1883   466_556851          N  4.918500e+03 1.859394e-01            0
      1884   466_556851       maxN  4.759900e+03 1.914596e-01            0
      1885   466_556851    Shannon -1.259951e-01 4.399000e-01            0
      1886   466_556851 expShannon -2.147646e-01 5.730149e-01            0
      1887   466_556851    Simpson -5.408485e-02 5.376749e-01            0
      1888   466_556851 invSimpson -8.609912e-02 7.697133e-01            0
      1889   466_556851        PIE -5.415625e-02 5.375990e-01            0
      1890   466_556851      DomMc  2.218216e-02 4.343899e-01            0
      1891   466_571439          S -3.833333e-01 5.443532e-01            0
      1892   466_571439          N -1.049833e+02 2.302151e-01            0
      1893   466_571439       maxN -2.638333e+01 5.556234e-01            0
      1894   466_571439    Shannon -9.398356e-03 8.668898e-01            0
      1895   466_571439 expShannon -9.236428e-02 7.692480e-01            0
      1896   466_571439    Simpson -6.116396e-03 7.517633e-01            0
      1897   466_571439 invSimpson -1.146152e-01 6.225260e-01            0
      1898   466_571439        PIE -5.993639e-03 7.575163e-01            0
      1899   466_571439      DomMc  4.634136e-03 7.776538e-01            0
      1900   466_565610          S -1.867523e-01 3.641634e-01            0
      1901   466_565610          N -1.947791e+03 1.228418e-01            0
      1902   466_565610       maxN -1.736020e+03 1.574662e-01            0
      1903   466_565610    Shannon  6.149452e-02 6.943167e-02            0
      1904   466_565610 expShannon  2.164818e-01 5.945237e-02            0
      1905   466_565610    Simpson  2.642444e-02 6.301925e-02            0
      1906   466_565610 invSimpson  1.845792e-01 2.402377e-02            1
      1907   466_565610        PIE  2.652684e-02 6.231157e-02            0
      1908   466_565610      DomMc -2.088574e-02 1.770590e-02            1
      1909   466_565611          S  1.190476e-02 9.778175e-01            0
      1910   466_565611          N -9.900000e+01 9.037442e-01            0
      1911   466_565611       maxN  5.735714e+01 9.301584e-01            0
      1912   466_565611    Shannon  5.716483e-02 4.524882e-01            0
      1913   466_565611 expShannon  2.183669e-01 3.812167e-01            0
      1914   466_565611    Simpson  2.271819e-02 5.117402e-01            0
      1915   466_565611 invSimpson  1.919114e-01 2.642238e-01            0
      1916   466_565611        PIE  2.274560e-02 5.115327e-01            0
      1917   466_565611      DomMc -2.381896e-02 2.251954e-01            0
      1918   466_541545          S -2.085967e-01 3.862127e-01            0
      1919   466_541545          N -4.645377e+03 3.354081e-03            1
      1920   466_541545       maxN -4.482671e+03 4.191244e-03            1
      1921   466_541545    Shannon  1.542465e-01 4.497103e-02            1
      1922   466_541545 expShannon  5.071240e-01 9.869125e-02            0
      1923   466_541545    Simpson  6.471175e-02 3.555330e-02            1
      1924   466_541545 invSimpson  3.368332e-01 1.513874e-01            0
      1925   466_541545        PIE  6.488579e-02 3.552697e-02            1
      1926   466_541545      DomMc -3.593631e-02 1.010670e-01            0
      1927   466_546649          S -4.354839e-01 7.461538e-01            0
      1928   466_546649          N -6.364516e+01 7.066969e-01            0
      1929   466_546649       maxN -2.292581e+02 2.217761e-02            1
      1930   466_546649    Shannon  6.664818e-02 4.004291e-01            0
      1931   466_546649 expShannon  2.951673e-01 3.532150e-01            0
      1932   466_546649    Simpson  3.718202e-02 3.247880e-01            0
      1933   466_546649 invSimpson  3.803506e-01 2.185927e-01            0
      1934   466_546649        PIE  3.719597e-02 3.246910e-01            0
      1935   466_546649      DomMc -3.007522e-02 3.328217e-01            0
      1936   466_566335          S -2.024573e-01 2.733555e-01            0
      1937   466_566335          N  3.557949e+02 1.220987e-01            0
      1938   466_566335       maxN  3.610107e+02 1.061006e-01            0
      1939   466_566335    Shannon -4.758449e-02 1.755372e-01            0
      1940   466_566335 expShannon -1.470145e-01 2.721801e-01            0
      1941   466_566335    Simpson -2.375100e-02 1.085639e-01            0
      1942   466_566335 invSimpson -1.170173e-01 2.421782e-01            0
      1943   466_566335        PIE -2.379106e-02 1.090202e-01            0
      1944   466_566335      DomMc  9.665933e-03 3.387043e-01            0
      1945   466_543008          S -1.176471e-01 9.284801e-01            0
      1946   466_543008          N -4.846588e+03 3.183514e-01            0
      1947   466_543008       maxN -3.674794e+03 3.279393e-01            0
      1948   466_543008    Shannon -1.811485e-02 8.962070e-01            0
      1949   466_543008 expShannon -3.294113e-03 9.932041e-01            0
      1950   466_543008    Simpson -1.704306e-02 7.898431e-01            0
      1951   466_543008 invSimpson  8.383245e-03 9.709423e-01            0
      1952   466_543008        PIE -1.703052e-02 7.901346e-01            0
      1953   466_543008      DomMc  5.317075e-03 8.358377e-01            0
      1954   466_542272          S -1.067207e-01 5.869410e-01            0
      1955   466_542272          N -4.432793e+02 4.296929e-02            1
      1956   466_542272       maxN -2.967606e+02 6.209414e-02            0
      1957   466_542272    Shannon  1.778436e-02 2.319355e-01            0
      1958   466_542272 expShannon  4.256733e-02 2.611647e-01            0
      1959   466_542272    Simpson  2.630981e-03 7.152811e-01            0
      1960   466_542272 invSimpson -1.517540e-03 9.504352e-01            0
      1961   466_542272        PIE  2.689907e-03 7.094765e-01            0
      1962   466_542272      DomMc -4.104621e-03 2.622083e-01            0
      1963   466_564884          S -9.765625e-02 8.690529e-01            0
      1964   466_564884          N  7.961328e+01 6.823110e-01            0
      1965   466_564884       maxN  2.731250e+01 8.869931e-01            0
      1966   466_564884    Shannon -6.028944e-04 9.941075e-01            0
      1967   466_564884 expShannon  2.649189e-02 9.254925e-01            0
      1968   466_564884    Simpson  2.285871e-03 9.526852e-01            0
      1969   466_564884 invSimpson  8.210830e-02 6.410834e-01            0
      1970   466_564884        PIE  2.238938e-03 9.537426e-01            0
      1971   466_564884      DomMc -5.649567e-03 7.596257e-01            0
      1972   466_558310          S -1.304461e-01 4.292760e-01            0
      1973   466_558310          N  6.239104e+02 7.011500e-02            0
      1974   466_558310       maxN  5.938511e+02 6.655143e-02            0
      1975   466_558310    Shannon -5.780664e-02 8.440058e-04            1
      1976   466_558310 expShannon -1.558681e-01 6.105503e-04            1
      1977   466_558310    Simpson -2.436021e-02 4.595939e-03            1
      1978   466_558310 invSimpson -1.024227e-01 3.450774e-03            1
      1979   466_558310        PIE -2.453157e-02 4.483055e-03            1
      1980   466_558310      DomMc  1.424038e-02 8.495206e-04            1
      1981   466_541548          S  8.782201e-04 9.964791e-01            0
      1982   466_541548          N -3.470685e+02 2.581820e-01            0
      1983   466_541548       maxN -2.081493e+02 3.381875e-01            0
      1984   466_541548    Shannon  1.633163e-02 2.701106e-01            0
      1985   466_541548 expShannon  6.254340e-02 2.368930e-01            0
      1986   466_541548    Simpson  3.869440e-03 5.680479e-01            0
      1987   466_541548 invSimpson  3.483005e-02 4.043173e-01            0
      1988   466_541548        PIE  3.882882e-03 5.670109e-01            0
      1989   466_541548      DomMc -7.514195e-03 1.056227e-01            0
      1990   466_568522          S -1.727049e-01 3.163997e-01            0
      1991   466_568522          N  1.368299e+01 2.401383e-01            0
      1992   466_568522       maxN  1.204820e+01 3.030904e-02            1
      1993   466_568522    Shannon -3.361591e-02 1.375902e-02            1
      1994   466_568522 expShannon -1.610796e-01 1.757327e-02            1
      1995   466_568522    Simpson -1.007266e-02 2.344679e-02            1
      1996   466_568522 invSimpson -1.001437e-01 2.827244e-02            1
      1997   466_568522        PIE -1.002820e-02 2.072890e-02            1
      1998   466_568522      DomMc  1.115310e-02 1.866746e-02            1
      1999   466_561970          S -1.401869e-02 9.839907e-01            0
      2000   466_561970          N -6.075888e+02 1.823999e-01            0
      2001   466_561970       maxN -4.143925e+02 2.799762e-01            0
      2002   466_561970    Shannon  6.576260e-02 4.224230e-01            0
      2003   466_561970 expShannon  2.349837e-01 4.452652e-01            0
      2004   466_561970    Simpson  1.281983e-02 7.218873e-01            0
      2005   466_561970 invSimpson  8.080665e-02 7.497509e-01            0
      2006   466_561970        PIE  1.294990e-02 7.193179e-01            0
      2007   466_561970      DomMc -1.646399e-02 5.340782e-01            0
      2008   466_568523          S  6.706943e-15 1.000000e+00            0
      2009   466_568523          N  2.675000e+01 7.034120e-01            0
      2010   466_568523       maxN  4.040000e+01 5.867050e-01            0
      2011   466_568523    Shannon -2.253961e-02 7.969784e-01            0
      2012   466_568523 expShannon -5.219387e-02 8.890747e-01            0
      2013   466_568523    Simpson -1.598369e-02 6.342081e-01            0
      2014   466_568523 invSimpson -4.666647e-02 8.670035e-01            0
      2015   466_568523        PIE -1.600105e-02 6.348350e-01            0
      2016   466_568523      DomMc  6.471902e-04 9.838907e-01            0
      2017   466_553937          S -4.022989e-02 7.665226e-01            0
      2018   466_553937          N -3.119943e+02 2.147067e-02            1
      2019   466_553937       maxN -2.348247e+02 4.597593e-02            1
      2020   466_553937    Shannon  2.327736e-02 2.066508e-01            0
      2021   466_553937 expShannon  8.457435e-02 2.354025e-01            0
      2022   466_553937    Simpson  7.544416e-03 3.238720e-01            0
      2023   466_553937 invSimpson  4.295368e-02 3.581787e-01            0
      2024   466_553937        PIE  7.598033e-03 3.212822e-01            0
      2025   466_553937      DomMc -6.058324e-03 2.086960e-01            0
      2026   466_564158          S -1.238095e+00 1.243632e-01            0
      2027   466_564158          N  7.692857e+01 4.957116e-01            0
      2028   466_564158       maxN  6.413095e+01 4.177044e-01            0
      2029   466_564158    Shannon -4.843862e-02 2.482719e-01            0
      2030   466_564158 expShannon -2.033186e-01 2.135574e-01            0
      2031   466_564158    Simpson -9.029834e-03 5.399057e-01            0
      2032   466_564158 invSimpson -5.704899e-02 4.729475e-01            0
      2033   466_564158        PIE -8.945297e-03 5.467374e-01            0
      2034   466_564158      DomMc  1.859586e-03 8.859305e-01            0
      2035   466_564876          S -1.616541e-01 5.022224e-01            0
      2036   466_564876          N  2.382707e+01 4.296174e-01            0
      2037   466_564876       maxN  2.612782e+00 5.256726e-01            0
      2038   466_564876    Shannon -1.406323e-02 6.269808e-01            0
      2039   466_564876 expShannon -6.128323e-02 6.139537e-01            0
      2040   466_564876    Simpson  5.445762e-04 9.573051e-01            0
      2041   466_564876 invSimpson  1.331853e-02 8.953952e-01            0
      2042   466_564876        PIE  5.168348e-04 9.594378e-01            0
      2043   466_564876      DomMc  4.529947e-03 8.075675e-01            0
      2044   466_545927          S -1.546610e-01 3.553578e-01            0
      2045   466_545927          N  1.526271e+01 8.844913e-01            0
      2046   466_545927       maxN -1.114407e+00 9.835702e-01            0
      2047   466_545927    Shannon  3.820676e-03 6.768103e-01            0
      2048   466_545927 expShannon  1.532025e-02 6.473162e-01            0
      2049   466_545927    Simpson  2.775078e-03 5.358830e-01            0
      2050   466_545927 invSimpson  2.833003e-02 3.935134e-01            0
      2051   466_545927        PIE  2.767844e-03 5.367220e-01            0
      2052   466_545927      DomMc -4.186066e-03 2.374134e-01            0
      2053   466_551018          S -1.245947e-01 5.260813e-01            0
      2054   466_551018          N -8.446723e+01 5.313708e-01            0
      2055   466_551018       maxN -2.867161e+01 8.237602e-01            0
      2056   466_551018    Shannon  1.810277e-02 4.049134e-01            0
      2057   466_551018 expShannon  1.064962e-01 1.625190e-01            0
      2058   466_551018    Simpson  4.315452e-03 6.527899e-01            0
      2059   466_551018 invSimpson  8.102516e-02 1.761256e-01            0
      2060   466_551018        PIE  4.393374e-03 6.476478e-01            0
      2061   466_551018      DomMc -6.260213e-03 3.210814e-01            0
      2062   466_569984          S -2.500000e+00 6.666667e-01            0
      2063   466_569984          N  5.100000e+01 9.774430e-01            0
      2064   466_569984       maxN  2.300000e+01 9.883837e-01            0
      2065   466_569984    Shannon -4.635094e-02 9.413032e-01            0
      2066   466_569984 expShannon -2.473388e-01 9.126136e-01            0
      2067   466_569984    Simpson  2.707309e-03 9.923932e-01            0
      2068   466_569984 invSimpson  3.155145e-02 9.822080e-01            0
      2069   466_569984        PIE  2.482778e-03 9.930540e-01            0
      2070   466_569984      DomMc -1.503831e-02 9.354988e-01            0
      2071   466_556135          S  5.708824e-14 1.000000e+00            0
      2072   466_556135          N -2.024000e+02 9.195430e-01            0
      2073   466_556135       maxN -1.899000e+02 9.178852e-01            0
      2074   466_556135    Shannon  1.246669e-01 4.625827e-01            0
      2075   466_556135 expShannon  3.279276e-01 3.601603e-01            0
      2076   466_556135    Simpson  7.725373e-02 3.507810e-01            0
      2077   466_556135 invSimpson  2.702634e-01 2.257754e-01            0
      2078   466_556135        PIE  7.732176e-02 3.508055e-01            0
      2079   466_556135      DomMc -1.245964e-02 6.294000e-01            0
      2080   466_558313          S -1.965679e-01 2.655488e-01            0
      2081   466_558313          N -2.241966e+01 1.270263e-01            0
      2082   466_558313       maxN -1.111778e+01 1.979088e-01            0
      2083   466_558313    Shannon  2.099709e-03 8.927719e-01            0
      2084   466_558313 expShannon  3.171551e-05 9.996531e-01            0
      2085   466_558313    Simpson -8.072390e-04 8.494233e-01            0
      2086   466_558313 invSimpson -1.376089e-02 7.367857e-01            0
      2087   466_558313        PIE -6.357134e-04 8.811151e-01            0
      2088   466_558313      DomMc -3.568231e-03 3.815641e-01            0
      2089   466_557581          S -2.230769e-01 3.831183e-01            0
      2090   466_557581          N  4.988846e+01 2.114014e-01            0
      2091   466_557581       maxN  5.519231e+01 8.594654e-02            0
      2092   466_557581    Shannon -5.011460e-02 2.597825e-03            1
      2093   466_557581 expShannon -1.608233e-01 1.015024e-02            1
      2094   466_557581    Simpson -2.231685e-02 1.550818e-03            1
      2095   466_557581 invSimpson -9.701655e-02 1.976984e-02            1
      2096   466_557581        PIE -2.237898e-02 1.409234e-03            1
      2097   466_557581      DomMc  1.336751e-02 5.528796e-02            0
      2098   466_547368          S -8.666403e-02 6.551079e-01            0
      2099   466_547368          N -4.778670e+01 9.301322e-01            0
      2100   466_547368       maxN -2.941828e+01 9.543877e-01            0
      2101   466_547368    Shannon -3.662316e-03 9.126825e-01            0
      2102   466_547368 expShannon -2.112126e-02 8.368583e-01            0
      2103   466_547368    Simpson -9.254740e-04 9.475370e-01            0
      2104   466_547368 invSimpson -6.739261e-03 9.056378e-01            0
      2105   466_547368        PIE -9.413122e-04 9.468351e-01            0
      2106   466_547368      DomMc  1.443376e-03 8.640487e-01            0
      2107   466_548098          S -1.941964e-01 2.139168e-01            0
      2108   466_548098          N -4.476406e+02 3.759169e-01            0
      2109   466_548098       maxN -3.328549e+02 4.952778e-01            0
      2110   466_548098    Shannon  2.199118e-02 2.651085e-01            0
      2111   466_548098 expShannon  8.510365e-02 1.385051e-01            0
      2112   466_548098    Simpson  8.247752e-03 3.982885e-01            0
      2113   466_548098 invSimpson  6.945734e-02 1.183022e-01            0
      2114   466_548098        PIE  8.282941e-03 3.971856e-01            0
      2115   466_548098      DomMc -7.717634e-03 1.032486e-01            0
      2116   466_544455          S  5.148741e-02 7.696420e-01            0
      2117   466_544455          N -2.484439e+01 4.897616e-01            0
      2118   466_544455       maxN -2.403661e+01 4.096685e-01            0
      2119   466_544455    Shannon  2.585083e-02 3.862139e-01            0
      2120   466_544455 expShannon  9.415542e-02 4.104608e-01            0
      2121   466_544455    Simpson  1.001132e-02 4.330258e-01            0
      2122   466_544455 invSimpson  5.245231e-02 4.956894e-01            0
      2123   466_544455        PIE  1.013952e-02 4.338366e-01            0
      2124   466_544455      DomMc -2.708383e-03 7.267002e-01            0
      2125   466_554676          S -2.435233e-01 6.626819e-03            1
      2126   466_554676          N -7.180699e+01 4.085722e-01            0
      2127   466_554676       maxN -6.999093e+01 3.556307e-01            0
      2128   466_554676    Shannon -9.816299e-03 6.059568e-01            0
      2129   466_554676 expShannon -5.681482e-02 4.493104e-01            0
      2130   466_554676    Simpson -1.727848e-03 8.343360e-01            0
      2131   466_554676 invSimpson -2.349555e-02 6.678629e-01            0
      2132   466_554676        PIE -1.731430e-03 8.345047e-01            0
      2133   466_554676      DomMc  1.428397e-03 8.011330e-01            0
      2134   466_565605          S -8.831711e-02 6.318182e-01            0
      2135   466_565605          N  4.383171e+01 8.756147e-01            0
      2136   466_565605       maxN  4.614256e+01 8.678575e-01            0
      2137   466_565605    Shannon -3.463757e-02 3.309622e-01            0
      2138   466_565605 expShannon -7.362077e-02 4.448227e-01            0
      2139   466_565605    Simpson -1.604915e-02 3.244238e-01            0
      2140   466_565605 invSimpson -4.000947e-02 5.106278e-01            0
      2141   466_565605        PIE -1.610600e-02 3.237465e-01            0
      2142   466_565605      DomMc  6.035871e-03 3.739175e-01            0
      2143   466_561962          S  1.244518e-01 4.185145e-01            0
      2144   466_561962          N -3.281837e+02 3.635758e-02            1
      2145   466_561962       maxN -2.934009e+02 3.953338e-02            1
      2146   466_561962    Shannon  4.258237e-02 1.681710e-02            1
      2147   466_561962 expShannon  1.548772e-01 3.470149e-02            1
      2148   466_561962    Simpson  1.718728e-02 1.558727e-02            1
      2149   466_561962 invSimpson  1.024031e-01 5.708601e-02            0
      2150   466_561962        PIE  1.729317e-02 1.532729e-02            1
      2151   466_561962      DomMc -1.095353e-02 3.682958e-02            1
      2152   466_548097          S -8.512897e-02 4.042675e-01            0
      2153   466_548097          N  1.643807e+00 9.835737e-01            0
      2154   466_548097       maxN  1.845169e+00 9.798731e-01            0
      2155   466_548097    Shannon  3.666111e-03 8.036962e-01            0
      2156   466_548097 expShannon  1.740269e-02 7.619692e-01            0
      2157   466_548097    Simpson  9.412581e-04 8.817841e-01            0
      2158   466_548097 invSimpson  1.145616e-02 7.990598e-01            0
      2159   466_548097        PIE  9.608886e-04 8.796547e-01            0
      2160   466_548097      DomMc -1.042106e-03 8.155825e-01            0
      2161   466_564146          S  9.638554e-01 3.790796e-01            0
      2162   466_564146          N  8.708434e+01 1.088527e-02            1
      2163   466_564146       maxN  4.807229e+01 1.518465e-01            0
      2164   466_564146    Shannon  1.282083e-03 9.909702e-01            0
      2165   466_564146 expShannon  3.142358e-02 9.665821e-01            0
      2166   466_564146    Simpson -8.289600e-03 7.874006e-01            0
      2167   466_564146 invSimpson -4.328301e-02 9.418964e-01            0
      2168   466_564146        PIE -9.136106e-03 7.663720e-01            0
      2169   466_564146      DomMc  1.252836e-02 7.840431e-01            0
      2170   466_544471          S -1.341772e-01 4.066316e-01            0
      2171   466_544471          N -1.640608e+02 3.396929e-01            0
      2172   466_544471       maxN -9.632785e+01 4.988812e-01            0
      2173   466_544471    Shannon  5.230754e-02 2.333878e-01            0
      2174   466_544471 expShannon  3.177148e-01 1.408605e-01            0
      2175   466_544471    Simpson  1.239046e-02 4.601389e-01            0
      2176   466_544471 invSimpson  2.221755e-01 1.689785e-01            0
      2177   466_544471        PIE  1.261485e-02 4.549237e-01            0
      2178   466_544471      DomMc -1.682050e-02 2.083714e-01            0
      2179   466_557584          S -5.051546e-01 6.931496e-02            0
      2180   466_557584          N -8.551546e+00 9.070368e-01            0
      2181   466_557584       maxN  9.649485e+00 8.202377e-01            0
      2182   466_557584    Shannon -1.997624e-02 4.833199e-01            0
      2183   466_557584 expShannon -8.973200e-02 5.506406e-01            0
      2184   466_557584    Simpson -6.929485e-03 4.093647e-01            0
      2185   466_557584 invSimpson -6.369670e-02 5.671652e-01            0
      2186   466_557584        PIE -6.859917e-03 4.191461e-01            0
      2187   466_557584      DomMc  6.527343e-03 4.998161e-01            0
      2188   466_543726          S -5.223368e-01 3.393363e-02            1
      2189   466_543726          N -5.728210e+00 5.682934e-01            0
      2190   466_543726       maxN -7.636988e+00 2.350642e-01            0
      2191   466_543726    Shannon -6.140999e-03 7.731256e-01            0
      2192   466_543726 expShannon -6.839724e-02 5.961730e-01            0
      2193   466_543726    Simpson  3.018104e-03 6.514966e-01            0
      2194   466_543726 invSimpson -1.152209e-02 9.008588e-01            0
      2195   466_543726        PIE  3.044120e-03 6.488345e-01            0
      2196   466_543726      DomMc  1.237791e-03 8.458977e-01            0
      2197   466_553207          S -1.588629e-01 4.574009e-01            0
      2198   466_553207          N -3.242124e+02 8.221933e-02            0
      2199   466_553207       maxN -2.199114e+02 2.005632e-01            0
      2200   466_553207    Shannon  2.694960e-02 5.625209e-01            0
      2201   466_553207 expShannon  1.392887e-01 5.243293e-01            0
      2202   466_553207    Simpson  5.706004e-03 7.646208e-01            0
      2203   466_553207 invSimpson  7.465958e-02 6.035632e-01            0
      2204   466_553207        PIE  5.820062e-03 7.611303e-01            0
      2205   466_553207      DomMc -8.231722e-03 5.267628e-01            0
      2206   466_551748          S -2.230997e-01 5.430265e-02            0
      2207   466_551748          N -1.740516e+02 4.850602e-01            0
      2208   466_551748       maxN -1.143986e+02 6.419034e-01            0
      2209   466_551748    Shannon  1.302614e-02 5.839746e-01            0
      2210   466_551748 expShannon  5.540725e-02 4.909693e-01            0
      2211   466_551748    Simpson  4.419021e-03 6.907948e-01            0
      2212   466_551748 invSimpson  3.941742e-02 5.099932e-01            0
      2213   466_551748        PIE  4.477522e-03 6.873799e-01            0
      2214   466_551748      DomMc -4.627779e-03 4.315170e-01            0
      2215   466_551015          S -7.788051e-02 6.720356e-01            0
      2216   466_551015          N -6.678272e+01 8.987636e-01            0
      2217   466_551015       maxN  3.841394e+00 9.935975e-01            0
      2218   466_551015    Shannon  1.549748e-02 5.633255e-01            0
      2219   466_551015 expShannon  9.053432e-02 3.177864e-01            0
      2220   466_551015    Simpson  4.323087e-03 7.068431e-01            0
      2221   466_551015 invSimpson  6.489012e-02 2.456427e-01            0
      2222   466_551015        PIE  4.399863e-03 7.025818e-01            0
      2223   466_551015      DomMc -6.871503e-03 2.955106e-01            0
      2224   466_559044          S -3.026183e-01 1.448196e-01            0
      2225   466_559044          N -6.306088e+02 2.621782e-01            0
      2226   466_559044       maxN -5.738157e+02 2.937600e-01            0
      2227   466_559044    Shannon  4.633136e-03 9.350354e-01            0
      2228   466_559044 expShannon  1.311823e-02 9.580788e-01            0
      2229   466_559044    Simpson  2.321355e-03 9.137186e-01            0
      2230   466_559044 invSimpson  7.008095e-03 9.640901e-01            0
      2231   466_559044        PIE  2.390049e-03 9.114666e-01            0
      2232   466_559044      DomMc  4.232548e-03 7.852814e-01            0
      2233   466_557595          S -1.500000e+00 1.266662e-01            0
      2234   466_557595          N -1.786000e+02 6.686357e-01            0
      2235   466_557595       maxN  1.256000e+02 7.625335e-01            0
      2236   466_557595    Shannon -1.311252e-01 1.905057e-01            0
      2237   466_557595 expShannon -3.169755e-01 2.144835e-01            0
      2238   466_557595    Simpson -9.296403e-02 2.223304e-01            0
      2239   466_557595 invSimpson -2.684533e-01 2.991308e-01            0
      2240   466_557595        PIE -9.298600e-02 2.223925e-01            0
      2241   466_557595      DomMc  2.065622e-02 7.737913e-02            0
      2242   466_559773          S -4.285714e-01 4.078435e-01            0
      2243   466_559773          N -1.917619e+02 3.077705e-01            0
      2244   466_559773       maxN -9.609524e+01 4.788599e-01            0
      2245   466_559773    Shannon -3.391297e-02 8.449864e-01            0
      2246   466_559773 expShannon  2.587731e-02 9.648821e-01            0
      2247   466_559773    Simpson -2.712820e-02 7.236199e-01            0
      2248   466_559773 invSimpson  9.012519e-03 9.783378e-01            0
      2249   466_559773        PIE -2.700372e-02 7.255806e-01            0
      2250   466_559773      DomMc -6.662420e-03 8.594610e-01            0
      2251   466_554666          S -1.654676e-01 6.457711e-01            0
      2252   466_554666          N  5.273921e+02 4.555258e-01            0
      2253   466_554666       maxN  4.615701e+02 5.008609e-01            0
      2254   466_554666    Shannon -6.748715e-02 1.792489e-01            0
      2255   466_554666 expShannon -2.841805e-01 6.883537e-02            0
      2256   466_554666    Simpson -2.496346e-02 3.125393e-01            0
      2257   466_554666 invSimpson -2.227687e-01 6.215635e-02            0
      2258   466_554666        PIE -2.497930e-02 3.124115e-01            0
      2259   466_554666      DomMc  2.684315e-02 6.220888e-02            0
      2260   466_547369          S  1.592742e-01 6.539364e-01            0
      2261   466_547369          N -2.410081e+02 3.046593e-01            0
      2262   466_547369       maxN -2.087480e+02 2.963371e-01            0
      2263   466_547369    Shannon  2.622757e-02 4.281348e-01            0
      2264   466_547369 expShannon  6.926470e-02 4.387005e-01            0
      2265   466_547369    Simpson  1.200401e-02 4.101704e-01            0
      2266   466_547369 invSimpson  4.378168e-02 3.686046e-01            0
      2267   466_547369        PIE  1.203746e-02 4.092180e-01            0
      2268   466_547369      DomMc -6.276263e-03 4.444179e-01            0
      2269   466_550285          S -8.045977e-02 8.327993e-01            0
      2270   466_550285          N -2.890977e+02 1.501546e-01            0
      2271   466_550285       maxN -1.006954e+02 4.551872e-01            0
      2272   466_550285    Shannon -2.107077e-03 9.681101e-01            0
      2273   466_550285 expShannon  2.602478e-02 8.940410e-01            0
      2274   466_550285    Simpson -1.179563e-02 5.772449e-01            0
      2275   466_550285 invSimpson -5.881938e-02 6.088242e-01            0
      2276   466_550285        PIE -1.167171e-02 5.819225e-01            0
      2277   466_550285      DomMc  1.084798e-03 9.411679e-01            0
      2278   466_561232          S -4.878543e-01 1.510251e-02            1
      2279   466_561232          N -2.712166e+02 2.746645e-02            1
      2280   466_561232       maxN -2.534393e+02 3.271417e-02            1
      2281   466_561232    Shannon  6.117849e-02 1.075623e-01            0
      2282   466_561232 expShannon  1.824801e-01 2.262213e-01            0
      2283   466_561232    Simpson  3.077640e-02 5.591901e-02            0
      2284   466_561232 invSimpson  1.516625e-01 1.325000e-01            0
      2285   466_561232        PIE  3.091243e-02 5.538109e-02            0
      2286   466_561232      DomMc -1.603590e-02 9.727476e-02            0
      2287   466_557594          S  1.433566e-01 5.921788e-01            0
      2288   466_557594          N -4.981783e+02 2.261769e-01            0
      2289   466_557594       maxN -3.605385e+02 3.585651e-01            0
      2290   466_557594    Shannon -2.541015e-03 9.437167e-01            0
      2291   466_557594 expShannon -7.521900e-03 9.484180e-01            0
      2292   466_557594    Simpson -4.147503e-03 8.135546e-01            0
      2293   466_557594 invSimpson -1.969038e-02 8.405356e-01            0
      2294   466_557594        PIE -4.083661e-03 8.166691e-01            0
      2295   466_557594      DomMc  6.641747e-03 5.730853e-01            0
      2296   466_559050          S -4.236111e-01 1.536465e-01            0
      2297   466_559050          N -2.925903e+02 3.174272e-01            0
      2298   466_559050       maxN -2.003264e+02 4.816214e-01            0
      2299   466_559050    Shannon -9.432529e-03 8.391016e-01            0
      2300   466_559050 expShannon -3.774962e-02 7.989918e-01            0
      2301   466_559050    Simpson -4.177730e-03 8.352070e-01            0
      2302   466_559050 invSimpson -3.066167e-02 7.340128e-01            0
      2303   466_559050        PIE -4.149000e-03 8.365197e-01            0
      2304   466_559050      DomMc  5.651559e-03 6.283811e-01            0
      2305   466_546657          S -8.571429e-01 5.456289e-01            0
      2306   466_546657          N  1.399571e+03 1.694356e-01            0
      2307   466_546657       maxN  1.619500e+03 2.324902e-01            0
      2308   466_546657    Shannon -1.571148e-01 3.032905e-01            0
      2309   466_546657 expShannon -3.678945e-01 2.690799e-01            0
      2310   466_546657    Simpson -9.526770e-02 3.041988e-01            0
      2311   466_546657 invSimpson -3.167684e-01 2.228853e-01            0
      2312   466_546657        PIE -9.529783e-02 3.041469e-01            0
      2313   466_546657      DomMc  1.817075e-02 3.450821e-01            0
      2314   466_565615          S -9.677419e-01 4.940550e-01            0
      2315   466_565615          N -6.048548e+02 2.283666e-02            1
      2316   466_565615       maxN -5.207419e+02 7.505966e-02            0
      2317   466_565615    Shannon  1.710581e-01 2.626440e-01            0
      2318   466_565615 expShannon  7.251032e-01 3.470277e-01            0
      2319   466_565615    Simpson  8.203418e-02 1.518707e-01            0
      2320   466_565615 invSimpson  6.332102e-01 2.739428e-01            0
      2321   466_565615        PIE  8.266060e-02 1.473400e-01            0
      2322   466_565615      DomMc -5.757234e-02 2.251155e-01            0
      2323   466_555405          S -2.201835e-01 9.965563e-02            0
      2324   466_555405          N -5.919266e+01 8.124784e-01            0
      2325   466_555405       maxN -4.601835e+01 8.211056e-01            0
      2326   466_555405    Shannon -3.731496e-03 8.138758e-01            0
      2327   466_555405 expShannon -9.703305e-03 8.323796e-01            0
      2328   466_555405    Simpson  1.216250e-03 8.871998e-01            0
      2329   466_555405 invSimpson  1.191525e-02 7.792718e-01            0
      2330   466_555405        PIE  1.269272e-03 8.824839e-01            0
      2331   466_555405      DomMc  5.774409e-03 2.798369e-01            0
      2332   466_559043          S -3.690476e-01 1.438815e-01            0
      2333   466_559043          N  4.771429e+01 4.657533e-01            0
      2334   466_559043       maxN  4.422619e+01 2.754843e-01            0
      2335   466_559043    Shannon -9.766778e-02 3.406385e-02            1
      2336   466_559043 expShannon -6.539617e-01 2.936835e-02            1
      2337   466_559043    Simpson -2.485794e-02 1.098731e-01            0
      2338   466_559043 invSimpson -5.155162e-01 5.697537e-02            0
      2339   466_559043        PIE -2.523184e-02 1.077652e-01            0
      2340   466_559043      DomMc  3.751726e-02 7.007635e-02            0
      2341   466_543012          S -7.500000e-01 2.078903e-01            0
      2342   466_543012          N -1.512500e+02 3.111425e-01            0
      2343   466_543012       maxN -1.628929e+02 1.258629e-01            0
      2344   466_543012    Shannon  1.086834e-01 5.294580e-02            0
      2345   466_543012 expShannon  4.780968e-01 5.399645e-02            0
      2346   466_543012    Simpson  4.533559e-02 4.671484e-03            1
      2347   466_543012 invSimpson  3.931466e-01 3.881932e-03            1
      2348   466_543012        PIE  4.540786e-02 4.777708e-03            1
      2349   466_543012      DomMc -2.769339e-02 9.797604e-02            0
      2350   466_549575          S -3.723653e-01 6.866664e-04            1
      2351   466_549575          N -4.970023e+01 3.470089e-01            0
      2352   466_549575       maxN -2.745199e+01 5.688833e-01            0
      2353   466_549575    Shannon -5.356889e-03 7.252190e-01            0
      2354   466_549575 expShannon -1.564100e-02 7.563359e-01            0
      2355   466_549575    Simpson -6.658122e-04 9.243855e-01            0
      2356   466_549575 invSimpson  8.890334e-03 8.034117e-01            0
      2357   466_549575        PIE -3.296631e-04 9.630906e-01            0
      2358   466_549575      DomMc -2.943006e-03 4.885905e-01            0
      2359   466_547385          S -1.988491e-01 1.637012e-01            0
      2360   466_547385          N  2.995780e+01 9.248715e-01            0
      2361   466_547385       maxN -3.804220e+01 8.524336e-01            0
      2362   466_547385    Shannon  3.228219e-02 7.403538e-02            0
      2363   466_547385 expShannon  8.618393e-02 8.403978e-02            0
      2364   466_547385    Simpson  1.675981e-02 6.041165e-02            0
      2365   466_547385 invSimpson  5.823178e-02 6.154165e-02            0
      2366   466_547385        PIE  1.677885e-02 6.043671e-02            0
      2367   466_547385      DomMc -6.945518e-03 2.038602e-01            0
      2368   466_551017          S -1.028571e+00 3.172984e-01            0
      2369   466_551017          N -3.322857e+01 7.926025e-01            0
      2370   466_551017       maxN -5.028571e+00 9.357335e-01            0
      2371   466_551017    Shannon -8.007449e-02 4.164399e-01            0
      2372   466_551017 expShannon -4.561563e-01 4.891115e-01            0
      2373   466_551017    Simpson -1.334389e-02 5.466755e-01            0
      2374   466_551017 invSimpson -2.087439e-01 6.804834e-01            0
      2375   466_551017        PIE -1.328603e-02 5.517269e-01            0
      2376   466_551017      DomMc  2.559081e-02 4.903774e-01            0
      2377   466_543725          S -3.000000e-01 7.763932e-01            0
      2378   466_543725          N -4.120000e+01 7.493320e-01            0
      2379   466_543725       maxN  1.590000e+01 8.783534e-01            0
      2380   466_543725    Shannon -1.531828e-01 2.847368e-01            0
      2381   466_543725 expShannon -6.995349e-01 2.779363e-01            0
      2382   466_543725    Simpson -7.429461e-02 1.928692e-01            0
      2383   466_543725 invSimpson -5.981877e-01 2.177373e-01            0
      2384   466_543725        PIE -7.442351e-02 1.933213e-01            0
      2385   466_543725      DomMc  5.270706e-02 2.640333e-01            0
      2386   466_558321          S -3.477011e-01 1.215269e-02            1
      2387   466_558321          N -1.163736e+02 3.112420e-01            0
      2388   466_558321       maxN -1.032672e+02 3.321674e-01            0
      2389   466_558321    Shannon -2.366873e-02 3.856757e-01            0
      2390   466_558321 expShannon -1.462168e-01 1.646853e-01            0
      2391   466_558321    Simpson -3.968730e-03 7.311741e-01            0
      2392   466_558321 invSimpson -9.026998e-02 1.851146e-01            0
      2393   466_558321        PIE -3.991336e-03 7.301147e-01            0
      2394   466_558321      DomMc  8.502519e-03 2.554385e-01            0
      2395   466_559780          S  4.285714e-01 7.451764e-01            0
      2396   466_559780          N -6.021143e+02 3.539737e-01            0
      2397   466_559780       maxN -4.438571e+02 3.203247e-01            0
      2398   466_559780    Shannon  9.384649e-02 5.724962e-01            0
      2399   466_559780 expShannon  4.332943e-01 6.599233e-01            0
      2400   466_559780    Simpson  3.749680e-02 4.719283e-01            0
      2401   466_559780 invSimpson  3.467697e-01 6.841134e-01            0
      2402   466_559780        PIE  3.762807e-02 4.717633e-01            0
      2403   466_559780      DomMc -9.511018e-03 8.964673e-01            0
      2404   466_541551          S -2.250000e+00 1.210377e-01            0
      2405   466_541551          N -4.682500e+02 3.102024e-01            0
      2406   466_541551       maxN -2.537500e+02 2.496288e-01            0
      2407   466_541551    Shannon  4.389020e-02 4.985349e-01            0
      2408   466_541551 expShannon  1.920224e-01 5.149109e-01            0
      2409   466_541551    Simpson  1.685199e-02 7.348891e-02            0
      2410   466_541551 invSimpson  1.855181e-01 1.110222e-01            0
      2411   466_541551        PIE  1.700972e-02 7.071204e-02            0
      2412   466_541551      DomMc -2.392235e-02 2.799167e-01            0
      2413   466_548114          S -3.281520e-02 8.972011e-01            0
      2414   466_548114          N -3.132435e+02 4.742671e-01            0
      2415   466_548114       maxN -1.928446e+02 2.868208e-01            0
      2416   466_548114    Shannon  4.093059e-02 6.838704e-02            0
      2417   466_548114 expShannon  1.346154e-01 4.564741e-02            1
      2418   466_548114    Simpson  1.832748e-02 1.997220e-01            0
      2419   466_548114 invSimpson  1.073195e-01 1.987732e-01            0
      2420   466_548114        PIE  1.835498e-02 1.990961e-01            0
      2421   466_548114      DomMc -1.191444e-02 3.134041e-01            0
      2422   466_546656          S -5.000000e-01 9.005747e-01            0
      2423   466_546656          N -5.250000e+01 9.309023e-01            0
      2424   466_546656       maxN  5.000000e+00 9.877769e-01            0
      2425   466_546656    Shannon -1.457541e-01 5.785848e-01            0
      2426   466_546656 expShannon -7.219114e-01 5.400031e-01            0
      2427   466_546656    Simpson -7.135638e-02 2.898997e-01            0
      2428   466_546656 invSimpson -8.006056e-01 3.058503e-01            0
      2429   466_546656        PIE -7.113822e-02 2.987476e-01            0
      2430   466_546656      DomMc  8.659317e-02 4.381296e-01            0
      2431   466_554678          S -2.413793e-01 2.204039e-01            0
      2432   466_554678          N -3.524483e+02 6.905370e-02            0
      2433   466_554678       maxN -1.196207e+02 4.003758e-02            1
      2434   466_554678    Shannon -2.845935e-02 3.154139e-01            0
      2435   466_554678 expShannon -1.161337e-01 2.915533e-01            0
      2436   466_554678    Simpson -1.505021e-02 2.884278e-01            0
      2437   466_554678 invSimpson -1.413500e-01 2.414648e-01            0
      2438   466_554678        PIE -1.493297e-02 2.916824e-01            0
      2439   466_554678      DomMc  1.133619e-02 4.339135e-01            0
      2440   466_555360          S  1.932295e-01 2.149952e-01            0
      2441   466_555360          N -1.124095e+02 8.152851e-01            0
      2442   466_555360       maxN -1.702687e+02 7.044353e-01            0
      2443   466_555360    Shannon  3.264682e-02 5.762236e-02            0
      2444   466_555360 expShannon  7.773027e-02 2.774124e-02            1
      2445   466_555360    Simpson  2.020453e-02 4.714475e-02            1
      2446   466_555360 invSimpson  7.377748e-02 1.151460e-02            1
      2447   466_555360        PIE  2.021123e-02 4.714726e-02            1
      2448   466_555360      DomMc -5.990577e-03 1.216558e-01            0
      2449   466_554629          S  2.500000e-01 1.004276e-15            1
      2450   466_554629          N  3.178750e+02 1.312261e-01            0
      2451   466_554629       maxN  3.457500e+02 1.368474e-01            0
      2452   466_554629    Shannon -6.760396e-02 2.767832e-02            1
      2453   466_554629 expShannon -1.509309e-01 2.174517e-02            1
      2454   466_554629    Simpson -4.143443e-02 5.618272e-02            0
      2455   466_554629 invSimpson -1.405955e-01 5.325865e-02            0
      2456   466_554629        PIE -4.146581e-02 5.610111e-02            0
      2457   466_554629      DomMc  1.531152e-02 2.083901e-01            0
      2458   466_551718          S -2.931034e-01 3.117823e-01            0
      2459   466_551718          N  2.057759e+01 9.775538e-01            0
      2460   466_551718       maxN -2.387931e+00 9.973519e-01            0
      2461   466_551718    Shannon  2.918694e-02 2.647268e-01            0
      2462   466_551718 expShannon  4.967743e-02 2.042559e-01            0
      2463   466_551718    Simpson  1.592181e-02 2.568826e-01            0
      2464   466_551718 invSimpson  2.739113e-02 1.962204e-01            0
      2465   466_551718        PIE  1.592061e-02 2.570534e-01            0
      2466   466_551718      DomMc -4.742740e-03 1.399091e-01            0
      2467   466_551716          S -8.769231e-02 3.915130e-01            0
      2468   466_551716          N -1.540462e+02 3.525905e-01            0
      2469   466_551716       maxN -1.471646e+02 3.651660e-01            0
      2470   466_551716    Shannon  1.856907e-02 3.995094e-01            0
      2471   466_551716 expShannon  3.943243e-02 3.809523e-01            0
      2472   466_551716    Simpson  9.778409e-03 3.319656e-01            0
      2473   466_551716 invSimpson  2.435719e-02 2.767485e-01            0
      2474   466_551716        PIE  9.791005e-03 3.317201e-01            0
      2475   466_551716      DomMc -4.505633e-03 3.567582e-01            0
      2476   466_558275          S -3.580902e-02 5.029713e-01            0
      2477   466_558275          N -1.157029e+02 2.813780e-01            0
      2478   466_558275       maxN -1.018780e+02 2.064145e-01            0
      2479   466_558275    Shannon  1.214963e-02 5.118827e-01            0
      2480   466_558275 expShannon  2.130706e-02 5.131668e-01            0
      2481   466_558275    Simpson  4.753304e-03 5.861753e-01            0
      2482   466_558275 invSimpson  8.134781e-03 5.737965e-01            0
      2483   466_558275        PIE  4.759751e-03 5.857383e-01            0
      2484   466_558275      DomMc -3.955073e-03 3.165829e-01            0
      2485   466_552443          S -3.418803e-02 7.677317e-01            0
      2486   466_552443          N -4.168625e+02 2.080015e-01            0
      2487   466_552443       maxN -4.211484e+02 1.489745e-01            0
      2488   466_552443    Shannon  2.451569e-02 1.542004e-01            0
      2489   466_552443 expShannon  4.576299e-02 1.501907e-01            0
      2490   466_552443    Simpson  1.969124e-02 8.553122e-02            0
      2491   466_552443 invSimpson  4.487925e-02 9.811951e-02            0
      2492   466_552443        PIE  1.969895e-02 8.552791e-02            0
      2493   466_552443      DomMc  4.137735e-05 9.862221e-01            0
      2494   466_557546          S  9.937311e-02 5.669755e-01            0
      2495   466_557546          N -2.640323e+02 1.902523e-01            0
      2496   466_557546       maxN -2.003197e+02 1.799730e-01            0
      2497   466_557546    Shannon  8.443864e-03 5.934381e-01            0
      2498   466_557546 expShannon  2.037906e-02 5.521567e-01            0
      2499   466_557546    Simpson  2.231436e-03 8.091943e-01            0
      2500   466_557546 invSimpson  8.238358e-03 7.517714e-01            0
      2501   466_557546        PIE  2.239689e-03 8.086154e-01            0
      2502   466_557546      DomMc -2.050302e-03 4.955048e-01            0
      2503   466_553173          S  4.171867e-02 4.675063e-01            0
      2504   466_553173          N  3.967923e+02 4.911442e-01            0
      2505   466_553173       maxN  3.761503e+02 5.001514e-01            0
      2506   466_553173    Shannon  1.549566e-02 2.710829e-01            0
      2507   466_553173 expShannon  3.917322e-02 1.816770e-01            0
      2508   466_553173    Simpson  8.676506e-03 2.856884e-01            0
      2509   466_553173 invSimpson  3.121762e-02 1.726876e-01            0
      2510   466_553173        PIE  8.682044e-03 2.856056e-01            0
      2511   466_553173      DomMc -3.689039e-03 1.201719e-01            0
      2512   466_564882          S -1.134615e-01 8.384311e-01            0
      2513   466_564882          N  6.027979e+03 1.764467e-03            1
      2514   466_564882       maxN  6.054319e+03 1.560805e-03            1
      2515   466_564882    Shannon -1.168843e-01 1.092029e-01            0
      2516   466_564882 expShannon -4.266612e-01 2.333321e-01            0
      2517   466_564882    Simpson -4.760123e-02 3.384701e-02            1
      2518   466_564882 invSimpson -2.797251e-01 2.509940e-01            0
      2519   466_564882        PIE -4.770897e-02 3.475431e-02            1
      2520   466_564882      DomMc  2.254453e-02 2.917103e-01            0
      2521   466_556816          S  2.221507e-01 1.554183e-01            0
      2522   466_556816          N -5.951178e+02 1.259614e-02            1
      2523   466_556816       maxN -5.235023e+02 4.173390e-02            1
      2524   466_556816    Shannon  3.105516e-02 2.679567e-01            0
      2525   466_556816 expShannon  5.355249e-02 3.128982e-01            0
      2526   466_556816    Simpson  1.318104e-02 3.948190e-01            0
      2527   466_556816 invSimpson  1.831530e-02 6.161044e-01            0
      2528   466_556816        PIE  1.320418e-02 3.941887e-01            0
      2529   466_556816      DomMc -5.338809e-03 2.667487e-01            0
      2530   466_557544          S -3.656716e-01 3.765085e-01            0
      2531   466_557544          N  6.151493e+01 7.888545e-01            0
      2532   466_557544       maxN  1.072015e+02 5.806597e-01            0
      2533   466_557544    Shannon -1.377652e-01 1.423684e-01            0
      2534   466_557544 expShannon -3.743050e-01 3.435474e-02            1
      2535   466_557544    Simpson -6.904557e-02 1.370718e-01            0
      2536   466_557544 invSimpson -3.043642e-01 3.434486e-02            1
      2537   466_557544        PIE -6.913279e-02 1.368014e-01            0
      2538   466_557544      DomMc  3.576288e-02 1.194091e-02            1
      2539   466_550987          S -6.043956e-02 5.083108e-01            0
      2540   466_550987          N -1.815934e+02 4.888063e-01            0
      2541   466_550987       maxN -1.847033e+02 1.348734e-01            0
      2542   466_550987    Shannon  7.875281e-02 8.043506e-03            1
      2543   466_550987 expShannon  2.263225e-01 3.375007e-02            1
      2544   466_550987    Simpson  3.790276e-02 3.792315e-02            1
      2545   466_550987 invSimpson  2.140617e-01 3.268393e-02            1
      2546   466_550987        PIE  3.796851e-02 3.758640e-02            1
      2547   466_550987      DomMc -2.780052e-02 1.262360e-01            0
      2548   466_558277          S -2.631579e-02 9.268136e-01            0
      2549   466_558277          N -1.756316e+02 1.627854e-01            0
      2550   466_558277       maxN -1.199474e+02 4.610826e-01            0
      2551   466_558277    Shannon  8.641946e-02 4.766143e-01            0
      2552   466_558277 expShannon  2.886584e-01 3.854112e-01            0
      2553   466_558277    Simpson  3.327980e-02 6.072259e-01            0
      2554   466_558277 invSimpson  1.807697e-01 4.639949e-01            0
      2555   466_558277        PIE  3.360125e-02 6.047700e-01            0
      2556   466_558277      DomMc -2.527156e-02 2.106941e-01            0
      2557   466_559732          S -5.294609e-16 3.333333e-01            0
      2558   466_559732          N -1.219000e+03 2.986109e-01            0
      2559   466_559732       maxN -1.561000e+03 1.459625e-01            0
      2560   466_559732    Shannon  2.602792e-01 2.475063e-01            0
      2561   466_559732 expShannon  4.714381e-01 2.663103e-01            0
      2562   466_559732    Simpson  2.031350e-01 2.774309e-01            0
      2563   466_559732 invSimpson  4.876074e-01 3.024672e-01            0
      2564   466_559732        PIE  2.032544e-01 2.773943e-01            0
      2565   466_559732      DomMc  1.220250e-03 8.871754e-01            0
      2566   466_562648          S  1.000000e-01 7.418011e-01            0
      2567   466_562648          N  1.025500e+03 3.432856e-01            0
      2568   466_562648       maxN  9.072000e+02 3.701533e-01            0
      2569   466_562648    Shannon  5.071126e-02 5.349680e-02            0
      2570   466_562648 expShannon  7.118387e-02 5.290401e-02            0
      2571   466_562648    Simpson  2.439417e-02 1.499352e-02            1
      2572   466_562648 invSimpson  3.205011e-02 1.474247e-02            1
      2573   466_562648        PIE  2.438719e-02 1.506035e-02            1
      2574   466_562648      DomMc -9.248962e-03 2.636050e-01            0
               intercept
      1     2.332857e+02
      2     1.835584e+05
      3     9.215793e+04
      4     1.094391e+00
      5     2.240499e+00
      6     5.602721e-01
      7     1.155550e+00
      8     5.427301e-01
      9    -7.453550e-02
      10   -1.029210e+02
      11   -1.486837e+04
      12   -2.308460e+03
      13   -3.926969e-02
      14   -1.680343e+01
      15   -9.733307e-01
      16   -6.545918e+01
      17   -9.232533e-01
      18    3.106645e+00
      19    5.368935e+02
      20    3.854565e+03
      21   -8.242593e+02
      22    3.179601e+01
      23    8.984978e+02
      24    3.386410e+00
      25    1.301187e+03
      26    3.167031e+00
      27   -1.411255e+01
      28    8.765197e+01
      29    1.201147e+03
      30    7.104488e+02
      31   -7.441081e+00
      32   -5.649365e+01
      33    2.301861e-02
      34   -6.732495e+01
      35   -2.239074e+01
      36    1.327550e+01
      37    7.573162e+01
      38   -2.972930e+03
      39   -2.400136e+03
      40    2.270696e+01
      41    8.562077e+01
      42    9.085805e+00
      43    4.495038e+01
      44    9.313223e+00
      45   -1.127589e-01
      46    3.986000e+03
      47   -3.506593e+04
      48   -1.281880e+04
      49    2.008247e+02
      50    1.686005e+03
      51    3.064552e+01
      52    6.302732e+02
      53    3.088559e+01
      54   -4.638877e+01
      55    7.317246e+02
      56    7.463980e+04
      57    2.922163e+04
      58    9.013658e+01
      59    3.878567e+02
      60    3.199439e+01
      61    3.297605e+02
      62    2.956230e+01
      63   -3.603240e+01
      64   -3.260171e+02
      65   -2.298938e+04
      66   -7.411880e+03
      67   -6.649948e+01
      68   -6.959222e+02
      69   -1.626279e+01
      70   -7.951352e+02
      71   -1.590347e+01
      72    4.694589e+01
      73   -2.731071e+02
      74   -1.761929e+04
      75   -1.705607e+03
      76   -2.813668e+01
      77   -1.419108e+02
      78   -1.302042e+01
      79   -2.358765e+02
      80   -1.404665e+01
      81    3.377040e+01
      82    1.197900e+03
      83   -2.149460e+04
      84    5.996000e+03
      85   -1.722539e+02
      86   -6.320593e+02
      87   -1.338389e+02
      88   -1.016454e+03
      89   -1.336168e+02
      90    4.992758e+01
      91   -4.156100e+03
      92   -1.576936e+05
      93   -9.964880e+04
      94   -9.689258e+01
      95   -1.863703e+02
      96   -9.460456e+00
      97    7.340578e+01
      98   -3.890393e+00
      99    2.311449e+01
      100   2.079138e+02
      101  -6.985034e+03
      102  -1.924034e+03
      103   1.897345e+01
      104   3.473758e+02
      105   2.387143e+00
      106   4.031603e+02
      107   2.428709e+00
      108  -7.509051e+00
      109   4.336000e+02
      110   2.768060e+04
      111   1.494200e+04
      112  -1.463166e+02
      113  -1.782746e+03
      114  -2.220073e+01
      115  -1.917474e+03
      116  -2.235058e+01
      117   6.137022e+01
      118   3.443600e+03
      119  -6.126630e+04
      120  -3.871890e+04
      121   2.061315e+02
      122   2.269366e+03
      123   3.885122e+01
      124   1.441655e+03
      125   3.994531e+01
      126  -2.565150e+01
      127   2.236600e+03
      128  -1.842840e+04
      129  -2.153800e+03
      130   9.701122e+01
      131   1.447852e+03
      132   1.004001e+01
      133   5.602122e+02
      134   1.014767e+01
      135   1.587937e+00
      136   7.477600e+03
      137   4.185878e+05
      138   6.531800e+03
      139   2.027072e+02
      140   2.627699e+03
      141   3.138069e+01
      142   1.935271e+03
      143   3.117452e+01
      144  -5.177452e+01
      145   1.648400e+03
      146   2.625980e+04
      147  -5.733180e+04
      148   2.209848e+02
      149   3.473117e+03
      150   2.979574e+01
      151   3.356789e+03
      152   2.979604e+01
      153  -7.230356e+01
      154   2.210000e+02
      155   1.091000e+04
      156   1.775525e+04
      157  -8.034129e+01
      158  -8.733152e+02
      159  -2.233658e+01
      160  -1.171774e+03
      161  -2.256186e+01
      162   4.479297e+01
      163   5.641600e+03
      164   2.417500e+04
      165   2.221200e+03
      166   4.989548e+02
      167   4.273755e+03
      168   7.750920e+01
      169   3.462976e+03
      170   5.342479e+01
      171  -1.696920e+02
      172   6.069000e+03
      173   1.554590e+05
      174  -2.882000e+03
      175   2.735717e+02
      176   4.851284e+03
      177   2.879460e+01
      178   3.704510e+03
      179   2.847815e+01
      180  -6.045804e+01
      181   3.034500e+03
      182   1.684721e+05
      183   4.970010e+04
      184  -7.498639e+01
      185  -7.370507e+02
      186  -2.120074e+01
      187  -1.479583e+03
      188  -2.756152e+01
      189   7.898509e+01
      190  -2.579400e+03
      191   9.536300e+04
      192   1.870600e+03
      193   1.758507e+01
      194   3.887304e+02
      195   4.044639e+00
      196   8.920425e+02
      197   3.724182e+00
      198  -1.406482e+01
      199   1.833200e+03
      200  -3.453200e+03
      201  -6.800600e+03
      202   1.251137e+02
      203   2.044893e+03
      204   1.589633e+01
      205   1.998096e+03
      206   1.616354e+01
      207  -4.576838e+01
      208   4.440400e+03
      209   3.346560e+04
      210   7.463800e+03
      211   1.365152e+02
      212   1.449126e+03
      213   8.798478e+00
      214   6.055766e+02
      215   5.652273e+00
      216  -4.802851e+00
      217  -2.586200e+03
      218   1.915724e+05
      219   5.121020e+04
      220  -7.688043e+01
      221  -9.530568e+02
      222  -2.836416e+00
      223  -5.244046e+02
      224  -3.363926e+00
      225   2.087287e+01
      226  -1.863952e+03
      227  -1.357091e+05
      228  -3.017738e+04
      229   4.984963e+01
      230   6.616598e+02
      231   1.011181e+01
      232   6.688428e+02
      233   1.271500e+01
      234  -1.637200e+01
      235  -1.379600e+03
      236  -2.400980e+04
      237   3.891700e+03
      238  -9.079320e+01
      239  -1.500462e+03
      240  -6.875987e+00
      241  -1.031423e+03
      242  -6.677204e+00
      243  -4.902197e-02
      244  -2.195800e+03
      245   8.153500e+03
      246   5.867200e+03
      247  -2.126701e+02
      248  -1.862807e+03
      249  -3.587065e+01
      250  -1.227892e+03
      251  -3.699897e+01
      252   8.477590e+01
      253   8.168000e+02
      254   4.485800e+03
      255  -4.606000e+03
      256   1.788058e+02
      257   1.394795e+03
      258   4.636456e+01
      259   1.676220e+03
      260   4.703688e+01
      261  -8.017957e+01
      262   4.857700e+03
      263   3.943600e+04
      264   2.638900e+03
      265   5.404908e+01
      266   9.037821e+02
      267   1.963998e+00
      268   1.197648e+02
      269   1.240455e+00
      270   7.974942e+00
      271  -9.814000e+02
      272  -3.363300e+04
      273  -1.498800e+03
      274   2.202073e+01
      275   5.126496e+02
      276  -9.821811e+00
      277   2.761426e+02
      278  -9.571152e+00
      279  -2.414676e+01
      280  -6.815300e+03
      281  -3.124820e+04
      282  -6.398400e+03
      283  -3.863684e+02
      284  -3.091973e+03
      285  -5.814549e+01
      286  -1.584498e+03
      287  -5.620174e+01
      288   1.162549e+02
      289   2.011467e+04
      290   1.357540e+05
      291   2.916400e+04
      292   1.941993e+03
      293   1.120090e+04
      294   4.474072e+02
      295   7.242583e+03
      296   2.306739e+02
      297  -6.184319e+02
      298   2.045500e+03
      299  -6.189520e+04
      300  -6.989500e+03
      301   1.491520e+02
      302   2.762186e+03
      303   7.389086e+00
      304   6.804577e+02
      305   8.656157e+00
      306   6.139849e-01
      307   1.672964e+03
      308  -1.747071e+03
      309   1.626429e+02
      310   9.895957e+01
      311   1.183525e+03
      312   9.487101e+00
      313   7.532523e+02
      314   1.160201e+01
      315  -1.251984e+01
      316   5.241200e+03
      317   2.861920e+04
      318   5.446400e+03
      319   3.866555e+02
      320   3.475061e+03
      321   5.189008e+01
      322   2.279247e+03
      323   4.490378e+01
      324  -1.079013e+02
      325   1.402114e+03
      326  -4.480357e+04
      327  -4.831851e+04
      328   1.273368e+02
      329   1.512319e+03
      330   3.934508e+01
      331   1.661445e+03
      332   3.965497e+01
      333  -3.160919e+01
      334   4.445400e+03
      335   3.233850e+04
      336   9.085500e+03
      337   1.816966e+02
      338   2.350893e+03
      339   1.052095e+01
      340   9.466047e+02
      341   9.140139e+00
      342  -1.353860e+01
      343  -1.387600e+03
      344  -1.030917e+05
      345  -3.250360e+04
      346   2.060660e+02
      347   2.115200e+03
      348   3.656903e+01
      349   1.837857e+03
      350   3.807603e+01
      351  -8.617776e+01
      352   5.042000e+03
      353   6.639533e+04
      354   1.509067e+04
      355   2.919909e+01
      356   3.032863e+02
      357  -2.657870e+00
      358  -2.117651e+02
      359  -1.359982e+01
      360  -2.161214e+01
      361  -5.391100e+03
      362  -7.279000e+03
      363   1.946480e+04
      364  -1.285138e+02
      365  -2.302144e+03
      366  -1.437270e+01
      367  -1.276744e+03
      368  -1.436871e+01
      369   1.954990e+01
      370   5.269300e+03
      371   1.738610e+05
      372   4.800090e+04
      373   1.037477e+02
      374   1.836474e+03
      375   7.104042e+00
      376   8.918124e+02
      377   6.941491e+00
      378  -8.195925e+00
      379   3.055333e+03
      380   2.298730e+05
      381   8.156800e+04
      382  -1.906832e+02
      383  -3.167865e+03
      384  -1.425951e+01
      385  -1.284945e+03
      386  -1.466029e+01
      387  -1.640880e+01
      388  -3.681000e+02
      389  -8.456870e+04
      390  -3.767240e+04
      391   1.026931e+02
      392   1.252389e+03
      393   1.462739e+01
      394   9.169373e+02
      395   1.483158e+01
      396  -1.555433e+01
      397   8.202000e+02
      398  -5.909000e+03
      399  -8.809700e+03
      400   2.843398e+02
      401   1.834256e+03
      402   7.974214e+01
      403   1.518326e+03
      404   8.051215e+01
      405  -1.322719e+02
      406   5.042400e+03
      407   8.456500e+04
      408   4.951720e+04
      409  -1.195527e+02
      410  -1.505965e+02
      411  -1.015090e+02
      412  -6.344423e+02
      413  -1.101038e+02
      414   8.130692e+01
      415  -1.243893e+03
      416   6.356357e+03
      417   3.832143e+03
      418  -9.054047e+01
      419  -9.255960e+02
      420  -1.049108e+01
      421  -5.952300e+02
      422  -1.065898e+01
      423   1.479153e+01
      424  -1.186200e+03
      425   3.096564e+04
      426   9.676933e+03
      427  -1.790455e+02
      428  -1.997869e+03
      429  -2.429253e+01
      430  -1.756225e+03
      431  -2.635383e+01
      432   4.847213e+01
      433   9.209952e+03
      434   4.857832e+04
      435   1.799010e+03
      436   4.496744e+02
      437   5.841172e+03
      438   5.061616e+01
      439   4.132112e+03
      440   4.696294e+01
      441  -1.029596e+02
      442   2.326381e+03
      443   1.427214e+05
      444   7.621571e+03
      445   1.001111e+02
      446   1.117790e+03
      447   1.529544e+01
      448   9.231767e+02
      449   1.497947e+01
      450  -4.054032e+01
      451  -4.534577e+03
      452  -8.187869e+04
      453  -5.177773e+04
      454  -2.986550e+01
      455  -7.287307e+02
      456   2.707461e+01
      457   3.551343e+02
      458   2.765942e+01
      459  -4.355467e+01
      460  -1.808000e+02
      461   2.867160e+04
      462   4.650000e+03
      463   8.595705e+00
      464   7.905487e+01
      465   1.441390e+00
      466   5.541105e+01
      467   1.000130e-01
      468  -5.407960e-01
      469  -1.161000e+03
      470  -1.166332e+05
      471  -1.058680e+04
      472  -5.162577e+01
      473  -1.251132e+03
      474  -4.955232e+00
      475  -1.518848e+03
      476  -4.688366e+00
      477   4.057792e-01
      478   6.668400e+03
      479   9.721000e+03
      480  -7.665200e+03
      481   9.693300e+01
      482   1.337660e+03
      483   6.669093e+00
      484   4.280474e+02
      485   6.646015e+00
      486   7.977857e+00
      487  -2.170300e+03
      488  -1.463608e+05
      489   3.102000e+03
      490  -1.334924e+02
      491  -2.542409e+03
      492  -1.463676e+01
      493  -2.653120e+03
      494  -1.426610e+01
      495   5.495227e+01
      496   3.653900e+03
      497  -8.541860e+04
      498  -9.172710e+04
      499   3.588508e+02
      500   5.111893e+03
      501   6.475955e+01
      502   3.690167e+03
      503   6.499762e+01
      504  -1.030383e+02
      505  -2.796800e+03
      506   9.538000e+02
      507   2.844000e+03
      508  -1.016727e+02
      509  -1.266190e+03
      510  -8.797788e+00
      511  -8.732461e+02
      512  -8.855673e+00
      513   3.060705e+01
      514   1.835700e+03
      515  -2.878520e+04
      516  -1.142710e+04
      517   9.690899e+01
      518   1.666966e+03
      519   1.028295e+01
      520   1.549465e+03
      521   1.142329e+01
      522  -3.801357e+01
      523   1.409300e+04
      524   2.052040e+05
      525   2.516700e+04
      526   6.045792e+02
      527   7.400810e+03
      528   7.394491e+01
      529   4.852642e+03
      530   6.616207e+01
      531  -1.391344e+02
      532   1.646900e+03
      533   1.433667e+05
      534  -3.142560e+04
      535   1.663183e+02
      536   2.610935e+03
      537   2.844516e+01
      538   2.957038e+03
      539   2.828511e+01
      540  -1.022869e+02
      541   2.435800e+03
      542   4.436840e+04
      543   3.642600e+03
      544   9.454958e+01
      545   1.428199e+03
      546   1.079005e+01
      547   1.325426e+03
      548   8.532015e+00
      549  -2.803473e+01
      550   1.844700e+03
      551   6.423343e+05
      552   3.351764e+05
      553  -2.649087e+02
      554  -2.789424e+03
      555  -4.231955e+01
      556  -2.070863e+03
      557  -4.242065e+01
      558   1.009567e+02
      559  -4.998000e+03
      560  -2.205230e+05
      561  -1.594450e+04
      562  -1.120726e+02
      563  -1.462238e+03
      564  -1.731458e+01
      565  -1.370909e+03
      566  -1.680609e+01
      567   4.716755e+01
      568   3.036000e+03
      569   2.393780e+04
      570   7.683800e+03
      571   6.089142e+01
      572   6.057228e+02
      573   3.415675e+00
      574   9.921943e+01
      575   3.072759e+00
      576   1.434401e+01
      577  -7.832000e+02
      578  -3.012080e+04
      579  -7.997000e+03
      580   6.989243e+00
      581   9.339459e+00
      582   2.552239e+00
      583   1.286318e+02
      584   3.061236e+00
      585   3.929826e+00
      586   2.198000e+02
      587   1.135099e+05
      588   2.442530e+04
      589   1.238949e+02
      590   1.159694e+03
      591   2.124189e+01
      592   1.341572e+03
      593   2.024595e+01
      594  -6.114116e+01
      595  -1.203300e+04
      596   4.091662e+05
      597   4.723197e+05
      598  -2.032319e+03
      599  -1.347320e+04
      600  -6.127805e+02
      601  -9.027404e+03
      602  -6.165458e+02
      603   5.796543e+02
      604   2.666667e+01
      605  -1.745263e+05
      606  -1.034565e+05
      607   3.950976e+02
      608   5.910163e+03
      609   6.947939e+01
      610   6.487330e+03
      611   7.065613e+01
      612  -1.528152e+02
      613   2.037667e+03
      614   1.509657e+05
      615   3.420667e+04
      616  -1.490052e+02
      617  -2.362464e+03
      618  -2.135808e+01
      619  -3.179725e+03
      620  -2.424175e+01
      621   6.057801e+01
      622   4.245800e+03
      623  -5.452900e+03
      624  -1.483120e+04
      625   2.177235e+02
      626   2.667673e+03
      627   3.615726e+01
      628   2.449785e+03
      629   3.659338e+01
      630  -8.046062e+01
      631  -1.588600e+03
      632   5.342000e+02
      633   1.370260e+04
      634  -1.826915e+02
      635  -1.296536e+03
      636  -4.990241e+01
      637  -1.159359e+03
      638  -5.061865e+01
      639   1.056220e+02
      640  -7.027500e+03
      641  -4.519350e+04
      642  -2.996167e+03
      643  -4.375361e+02
      644  -3.024630e+03
      645  -1.068645e+02
      646  -2.417749e+03
      647  -9.874452e+01
      648   1.021361e+02
      649   3.865200e+03
      650  -1.206172e+05
      651  -5.054160e+04
      652   1.450744e+02
      653   3.352777e+03
      654   1.122884e+01
      655   2.484319e+03
      656   1.135488e+01
      657  -2.894390e+01
      658   1.240000e+01
      659   4.512000e+02
      660  -7.898000e+02
      661   1.089256e+01
      662   4.451874e+01
      663   6.632958e+00
      664  -2.275729e+01
      665   6.861578e+00
      666  -1.741530e+01
      667   5.052000e+03
      668  -2.406480e+04
      669  -2.385670e+04
      670   3.011585e+02
      671   3.293877e+03
      672   3.933053e+01
      673   1.667586e+03
      674   3.971048e+01
      675  -5.406245e+01
      676   5.868800e+03
      677   3.664290e+05
      678   1.082900e+05
      679  -7.510482e+01
      680  -1.501908e+03
      681  -1.785045e+01
      682  -2.605429e+03
      683  -1.842563e+01
      684   7.639167e+01
      685   3.239300e+03
      686   8.229810e+04
      687  -3.163440e+04
      688   1.960577e+02
      689   2.243536e+03
      690   3.897429e+01
      691   2.312788e+03
      692   3.869609e+01
      693  -4.858710e+01
      694   6.065667e+03
      695   8.217067e+04
      696   1.539477e+05
      697  -2.791302e+02
      698  -4.310562e+03
      699  -6.640907e+01
      700  -6.220567e+03
      701  -6.664867e+01
      702   1.846075e+02
      703  -1.997500e+03
      704   4.255300e+03
      705   3.425100e+03
      706  -1.969398e+02
      707  -1.987846e+03
      708  -2.688146e+01
      709  -1.731607e+03
      710  -3.046769e+01
      711   7.290938e+01
      712  -1.393400e+03
      713  -1.915680e+04
      714  -5.186800e+03
      715  -1.308023e+02
      716  -8.569902e+02
      717  -2.035411e+01
      718  -4.237043e+02
      719  -1.951389e+01
      720   1.794025e+01
      721  -8.017000e+02
      722   1.591070e+04
      723   9.665900e+03
      724  -2.182315e+02
      725  -4.985508e+02
      726  -7.325100e+01
      727  -3.463237e+02
      728  -9.659613e+01
      729   1.049094e+02
      730   6.479000e+03
      731   2.472037e+05
      732   1.081800e+05
      733  -5.991411e+01
      734  -9.572661e+02
      735  -3.185791e+01
      736  -2.018352e+03
      737  -3.341118e+01
      738   5.176083e+01
      739   3.634000e+03
      740   6.641933e+04
      741   3.145533e+04
      742   1.300513e+02
      743   6.691895e+02
      744   1.308933e+00
      745   4.176846e+01
      746  -1.462435e+01
      747  -1.041444e+01
      748   1.620667e+03
      749   2.040600e+04
      750  -5.190667e+03
      751   2.457522e+02
      752   1.373742e+03
      753   8.693054e+01
      754   1.366712e+03
      755   8.585115e+01
      756  -9.911071e+01
      757   7.141602e+02
      758   2.868196e+04
      759   1.742222e+04
      760   6.547789e+01
      761   1.464732e+02
      762   2.636363e+01
      763   1.243681e+02
      764   9.202128e+00
      765  -2.756481e+01
      766   3.211772e+02
      767  -5.076304e+03
      768  -1.042148e+04
      769   1.773566e+02
      770   3.705883e+02
      771   9.605193e+01
      772   2.863037e+02
      773   7.308433e+01
      774  -3.000472e+01
      775   2.996667e+03
      776   4.291333e+04
      777   2.096333e+04
      778   4.053695e+02
      779   1.467477e+03
      780   1.055850e+02
      781   7.873649e+02
      782   7.640791e+01
      783  -1.608133e+02
      784   2.000000e+00
      785   6.941667e+01
      786   6.841667e+01
      787  -3.124862e+00
      788  -5.423817e+00
      789  -3.245370e+00
      790  -1.148333e+01
      791  -2.147222e+01
      792   1.000000e+00
      793  -9.468797e+01
      794  -2.709850e+03
      795  -1.797624e+03
      796  -2.261004e+01
      797  -8.477688e+01
      798  -2.105198e+00
      799  -7.760161e+01
      800   5.217819e+00
      801   2.960793e+01
      802   2.000000e+00
      803   1.265530e+03
      804   1.414665e+03
      805  -6.681284e+01
      806  -1.098758e+02
      807  -5.765788e+01
      808  -1.373486e+02
      809  -1.111366e+02
      810   1.000000e+00
      811   3.121561e+02
      812   9.701253e+03
      813   5.086266e+03
      814   4.465932e+01
      815   1.024228e+02
      816   1.454213e+01
      817   6.995323e+01
      818  -1.441390e+01
      819  -1.784297e+01
      820  -7.897571e+01
      821  -5.726275e+02
      822  -4.926518e+02
      823   3.060030e+00
      824   5.858115e+00
      825   1.363980e+01
      826   4.532593e+01
      827   6.657316e+01
      828   1.112196e+01
      829   1.412036e+01
      830   1.162040e+04
      831   1.073807e+04
      832  -1.501516e+01
      833  -2.306161e+01
      834  -1.275268e+01
      835  -2.659422e+01
      836  -1.438849e+01
      837   9.408186e-01
      838   2.000000e+00
      839   5.579481e+04
      840   5.532950e+04
      841  -1.243005e+02
      842  -1.600441e+02
      843  -8.233058e+01
      844  -1.114111e+02
      845  -9.773943e+01
      846   1.000000e+00
      847  -3.021311e+01
      848   7.719016e+02
      849  -8.663934e+01
      850   5.285995e+01
      851   9.462588e+01
      852   5.029519e+01
      853   1.389563e+02
      854   4.970688e+01
      855   2.073770e+00
      856  -5.224409e+00
      857  -3.846083e+03
      858  -3.458862e+03
      859   6.049263e+00
      860   1.053212e+01
      861   4.603816e+00
      862   8.663448e+00
      863   5.689154e+00
      864   3.433839e+00
      865   2.000000e+00
      866  -3.808229e+03
      867  -3.696714e+03
      868   5.925263e+01
      869   7.171223e+01
      870   3.764648e+01
      871   2.114005e+01
      872   4.796711e+01
      873   1.000000e+00
      874   8.480165e+01
      875   2.084295e+03
      876   1.767848e+03
      877  -2.673451e+00
      878  -3.682930e+00
      879  -7.234740e+00
      880  -1.335399e+01
      881  -1.132287e+01
      882  -3.870685e+00
      883   3.950498e+02
      884   4.465342e+03
      885   2.649804e+03
      886   1.215980e+02
      887   2.686647e+02
      888   6.034860e+01
      889   2.339358e+02
      890   7.149514e+01
      891  -5.825802e+01
      892   1.982423e+02
      893  -2.651881e+03
      894  -2.943923e+03
      895   1.221898e+02
      896   2.417764e+02
      897   7.720918e+01
      898   2.384092e+02
      899   9.191255e+01
      900  -2.353028e+01
      901   2.608405e+02
      902  -4.574546e+03
      903  -6.534767e+03
      904   8.120304e+01
      905   1.608368e+02
      906   4.092646e+01
      907   1.145867e+02
      908   3.740772e+01
      909  -1.353225e+01
      910   2.000000e+00
      911   2.945842e+03
      912   1.684053e+03
      913   3.970843e+01
      914   7.374789e+01
      915   3.727827e+01
      916   1.115150e+02
      917   4.320574e+00
      918   1.000000e+00
      919   2.000000e+00
      920   2.411934e+03
      921   2.410934e+03
      922  -2.304215e+01
      923  -2.848041e+01
      924  -1.509486e+01
      925  -1.895940e+01
      926  -1.756511e+01
      927   1.000000e+00
      928  -1.532752e+02
      929   1.068119e+04
      930   9.123156e+03
      931  -3.098647e+01
      932  -5.772380e+01
      933  -1.490942e+01
      934  -3.705820e+01
      935  -1.620633e+01
      936   7.502854e+00
      937  -2.680270e+02
      938  -4.904781e+04
      939  -4.826643e+04
      940   1.598428e+02
      941   2.434184e+02
      942   1.272521e+02
      943   2.592956e+02
      944   1.628701e+02
      945   2.475558e+00
      946   1.145143e+03
      947   9.000000e+00
      948   6.185714e+01
      949   2.928158e+02
      950   7.645348e+02
      951   8.678030e+01
      952   5.015684e+02
      953   9.939878e+01
      954  -1.571113e+02
      955   6.418409e+01
      956   1.942687e+04
      957   1.643860e+04
      958   4.542259e-01
      959   1.307054e+00
      960  -3.357956e+00
      961  -6.341989e+00
      962  -5.117839e+00
      963  -8.843665e-01
      964  -3.863301e+02
      965  -1.884342e+04
      966  -1.382824e+04
      967  -3.467161e+01
      968  -6.567592e+01
      969  -3.292465e+00
      970  -3.216308e+00
      971  -7.510991e-01
      972   2.112686e+01
      973   3.000000e+00
      974  -2.703467e+04
      975  -1.601400e+04
      976   3.292667e+00
      977   7.113365e+00
      978  -1.690384e+01
      979  -5.169118e+01
      980  -1.586422e+01
      981  -8.384133e+00
      982   1.866712e+01
      983   3.273424e+02
      984   3.096752e+02
      985  -1.587068e+01
      986  -3.583988e+01
      987  -1.566712e+01
      988  -6.619450e+01
      989  -5.387560e+01
      990   3.365810e+00
      991   2.000000e+00
      992   1.627372e+03
      993   1.162551e+03
      994  -2.942642e+01
      995  -4.791632e+01
      996  -2.544866e+01
      997  -6.017403e+01
      998  -1.551942e+02
      999   1.000000e+00
      1000  2.000000e+00
      1001 -2.637042e+04
      1002 -2.606400e+04
      1003  1.179957e+02
      1004  1.768204e+02
      1005  9.075434e+01
      1006  1.783001e+02
      1007  1.361293e+02
      1008  1.000000e+00
      1009 -2.221180e+01
      1010  1.726402e+03
      1011  3.395407e+02
      1012  3.520046e+01
      1013  5.718638e+01
      1014  2.979412e+01
      1015  6.801573e+01
      1016  4.094581e+01
      1017  1.136442e+00
      1018 -2.361190e+02
      1019  2.523855e+04
      1020  2.528457e+04
      1021 -2.370401e+02
      1022 -4.491856e+02
      1023 -1.485512e+02
      1024 -4.645109e+02
      1025 -2.277919e+02
      1026  8.037302e+01
      1027  2.485612e+02
      1028  1.614824e+04
      1029  1.488168e+04
      1030  1.676216e+01
      1031  4.219371e+01
      1032 -7.928551e+00
      1033 -3.052298e+00
      1034 -5.668091e+00
      1035 -1.204812e+01
      1036  1.869737e+02
      1037 -1.960000e+03
      1038 -3.107553e+03
      1039  3.446645e+01
      1040  6.604519e+01
      1041  2.270316e+01
      1042  6.900961e+01
      1043  2.414183e+01
      1044 -2.032355e+00
      1045  2.000000e+00
      1046  1.879190e+03
      1047  1.581429e+02
      1048  1.493396e+02
      1049  2.249900e+02
      1050  1.169636e+02
      1051  2.233090e+02
      1052  1.291899e+02
      1053  1.000000e+00
      1054 -1.144098e+02
      1055 -1.178205e+03
      1056  2.759180e+02
      1057 -6.341753e+01
      1058 -1.345598e+02
      1059 -3.633773e+01
      1060 -1.263851e+02
      1061 -3.739711e+01
      1062  1.762998e+01
      1063 -1.403524e+03
      1064 -2.891817e+04
      1065  3.210619e+03
      1066 -6.466035e+01
      1067 -1.142623e+03
      1068 -8.504795e+00
      1069 -1.316942e+03
      1070 -8.190101e+00
      1071  3.493325e+01
      1072  2.297940e+03
      1073 -3.686727e+04
      1074 -2.193553e+04
      1075  1.679935e+02
      1076  3.672895e+03
      1077  1.917014e+01
      1078  2.393785e+03
      1079  1.958433e+01
      1080 -3.506395e+01
      1081  7.100000e+01
      1082 -1.066642e+05
      1083 -6.407753e+04
      1084  6.319210e+01
      1085  2.322660e+03
      1086  9.974362e+00
      1087  2.237517e+03
      1088  1.008680e+01
      1089 -2.687076e+01
      1090 -1.558096e+03
      1091 -2.018281e+04
      1092  7.496675e+03
      1093 -7.874014e+01
      1094 -2.072027e+03
      1095 -6.702976e+00
      1096 -1.078670e+03
      1097 -6.658211e+00
      1098  8.004023e+00
      1099 -3.130952e+03
      1100 -2.537152e+04
      1101 -7.291738e+03
      1102 -2.828610e+01
      1103 -5.170431e+02
      1104  1.933117e+00
      1105  1.643661e+02
      1106  2.386132e+00
      1107 -5.555538e+00
      1108 -1.778176e+04
      1109 -1.920371e+05
      1110  1.607588e+04
      1111 -4.462224e+02
      1112 -7.829582e+03
      1113 -6.185606e+01
      1114 -5.117954e+03
      1115 -6.134710e+01
      1116  1.461035e+02
      1117 -2.266238e+03
      1118 -1.025802e+04
      1119  3.211286e+03
      1120 -2.250688e+01
      1121 -3.312056e+02
      1122 -3.285147e+00
      1123 -4.255317e+02
      1124 -3.081423e+00
      1125  1.790898e+01
      1126 -7.006167e+03
      1127 -1.552141e+05
      1128 -1.878960e+04
      1129 -9.539033e+01
      1130 -2.162442e+03
      1131 -3.278559e+00
      1132 -8.744691e+02
      1133 -2.289666e+00
      1134  6.049826e+00
      1135  1.375670e+02
      1136  2.654210e+05
      1137  1.571540e+05
      1138 -3.606936e+01
      1139 -1.347888e+02
      1140 -1.324558e+01
      1141 -7.302929e+01
      1142 -1.328666e+01
      1143  9.971242e+00
      1144 -4.616914e+01
      1145 -5.155486e+04
      1146 -3.918256e+04
      1147 -9.961176e+00
      1148 -3.756122e+01
      1149 -3.464752e+00
      1150 -3.341603e+00
      1151 -3.466547e+00
      1152  5.314991e+00
      1153 -7.429885e+01
      1154  4.291154e+05
      1155  2.310955e+05
      1156  3.916648e+00
      1157  2.569984e+01
      1158  3.228719e-01
      1159  7.583015e+00
      1160  3.207454e-01
      1161  1.519609e+00
      1162 -8.438994e+01
      1163  1.868552e+05
      1164  1.135700e+05
      1165 -5.459056e+01
      1166 -2.360696e+02
      1167 -1.802073e+01
      1168 -1.521642e+02
      1169 -1.809477e+01
      1170  2.099688e+01
      1171  1.885690e+02
      1172  3.904061e+05
      1173  3.466232e+05
      1174 -3.486446e+01
      1175 -8.636554e+01
      1176 -2.145076e+01
      1177 -7.994642e+01
      1178 -2.148640e+01
      1179  8.083821e+00
      1180 -2.963498e+02
      1181  2.228374e+05
      1182  1.543852e+05
      1183 -2.314112e+01
      1184 -1.350965e+02
      1185 -1.265734e+00
      1186 -1.103977e+02
      1187 -1.344193e+00
      1188  1.415179e+01
      1189  5.907092e+02
      1190  7.336555e+05
      1191  5.313584e+05
      1192 -2.590795e+01
      1193 -9.160228e+01
      1194 -1.024575e+01
      1195 -7.914780e+01
      1196 -1.025841e+01
      1197  1.118862e+01
      1198 -5.156031e+01
      1199  2.294611e+05
      1200  9.206416e+04
      1201 -3.352938e+01
      1202 -1.774810e+02
      1203 -3.976042e+00
      1204 -7.156326e+01
      1205 -4.091163e+00
      1206  7.333002e+00
      1207  4.061650e+01
      1208 -4.291816e+05
      1209 -4.533289e+05
      1210  4.851430e+01
      1211  1.985262e+02
      1212  2.271920e+01
      1213  1.876667e+02
      1214  2.271390e+01
      1215 -1.561056e+01
      1216  1.749346e+02
      1217  4.745406e+05
      1218  3.551959e+05
      1219 -1.226518e+02
      1220 -5.340796e+02
      1221 -4.622156e+01
      1222 -4.497038e+02
      1223 -4.640605e+01
      1224  4.925098e+01
      1225 -2.020822e+01
      1226 -9.385991e+04
      1227 -3.924949e+04
      1228  1.652019e+01
      1229  9.024446e+01
      1230  5.187928e+00
      1231  6.908828e+01
      1232  5.222931e+00
      1233 -1.895652e+00
      1234  2.802158e+03
      1235  1.094803e+05
      1236  2.180579e+04
      1237  6.130304e+01
      1238  2.567584e+02
      1239  5.301135e+00
      1240  5.082294e+01
      1241  5.249080e+00
      1242  1.291640e+01
      1243  4.727187e+02
      1244  1.397577e+06
      1245  1.046318e+06
      1246 -1.012603e+02
      1247 -4.736308e+02
      1248 -3.093453e+01
      1249 -2.467854e+02
      1250 -3.125520e+01
      1251  2.765926e+01
      1252  7.595397e+01
      1253  1.488487e+06
      1254  7.341287e+05
      1255  3.138636e+00
      1256 -1.687906e+01
      1257  1.138035e+01
      1258  9.271264e+00
      1259  1.137052e+01
      1260  5.529864e+00
      1261  6.200199e+01
      1262  1.624552e+05
      1263  8.047780e+04
      1264  1.657910e+01
      1265  5.718294e+01
      1266  3.617973e+00
      1267  2.801441e+01
      1268  3.601146e+00
      1269 -2.114908e+00
      1270  3.244531e+01
      1271  1.300491e+06
      1272  1.347635e+06
      1273 -1.354667e+02
      1274 -4.139945e+02
      1275 -5.873195e+01
      1276 -2.735969e+02
      1277 -5.880628e+01
      1278  3.301654e+01
      1279  1.249154e+03
      1280  7.599122e+05
      1281  2.456052e+05
      1282  1.606790e+02
      1283  6.854184e+02
      1284  6.821067e+01
      1285  5.626914e+02
      1286  6.809790e+01
      1287 -2.364155e+01
      1288  6.067078e+02
      1289  5.986472e+05
      1290  5.044181e+05
      1291 -6.753205e+01
      1292 -2.136374e+02
      1293 -3.593868e+01
      1294 -1.828302e+02
      1295 -3.608026e+01
      1296  2.038994e+01
      1297  7.202177e+02
      1298  9.299461e+05
      1299  7.932537e+05
      1300 -7.125777e+01
      1301 -2.524057e+02
      1302 -3.085554e+01
      1303 -2.065485e+02
      1304 -3.105161e+01
      1305  2.662217e+01
      1306  1.015000e+03
      1307 -2.932935e+05
      1308 -1.279267e+05
      1309  6.726415e+01
      1310  2.985287e+02
      1311  1.803886e+01
      1312  1.924837e+02
      1313  1.833659e+01
      1314 -3.170521e+01
      1315  2.156599e+02
      1316  1.357881e+06
      1317  1.259534e+06
      1318 -1.508084e+02
      1319 -5.761354e+02
      1320 -7.060628e+01
      1321 -5.271313e+02
      1322 -7.066103e+01
      1323  5.363983e+01
      1324  6.520757e+00
      1325  6.824252e+05
      1326  6.051018e+05
      1327 -7.203388e+01
      1328 -3.580957e+02
      1329 -2.344108e+01
      1330 -2.559967e+02
      1331 -2.356608e+01
      1332  1.778013e+01
      1333  4.818201e+02
      1334 -4.610041e+04
      1335 -7.433349e+03
      1336  2.143935e+01
      1337  1.404267e+02
      1338  1.550162e+00
      1339  7.858127e+01
      1340  1.702726e+00
      1341 -7.196559e+00
      1342  5.869064e+00
      1343  7.739332e+04
      1344  9.024724e+04
      1345 -2.545999e+01
      1346 -8.834352e+01
      1347 -1.322721e+01
      1348 -6.148336e+01
      1349 -1.324811e+01
      1350  4.284840e+00
      1351 -1.518472e+01
      1352  2.921614e+05
      1353  2.381100e+05
      1354 -3.863100e+01
      1355 -8.286179e+01
      1356 -2.177027e+01
      1357 -6.101254e+01
      1358 -2.183462e+01
      1359  6.583832e+00
      1360 -4.563017e+01
      1361  2.813758e+05
      1362  2.753111e+05
      1363 -2.220094e+01
      1364 -2.413622e+01
      1365 -1.730798e+01
      1366 -3.048893e+01
      1367 -1.736585e+01
      1368 -2.377721e+00
      1369 -4.488846e+02
      1370 -4.079742e+05
      1371  1.444092e+04
      1372 -3.506957e+02
      1373 -7.532394e+02
      1374 -1.859436e+02
      1375 -5.252061e+02
      1376 -1.860055e+02
      1377  5.210669e+01
      1378  1.476305e+02
      1379 -2.039130e+05
      1380 -1.808967e+05
      1381 -1.517080e+01
      1382 -2.482770e+01
      1383 -6.183819e+00
      1384 -9.702647e+00
      1385 -6.188135e+00
      1386  4.661217e+00
      1387 -4.440273e+02
      1388  6.767470e+04
      1389  5.907239e+04
      1390 -2.294324e+01
      1391 -3.626065e+01
      1392 -1.078653e+01
      1393 -1.757906e+01
      1394 -1.079904e+01
      1395  3.460686e+00
      1396  4.009305e+00
      1397  3.772267e+05
      1398  3.447025e+05
      1399 -4.131715e+01
      1400 -7.876890e+01
      1401 -2.270131e+01
      1402 -5.274422e+01
      1403 -2.276492e+01
      1404  5.812972e+00
      1405 -1.097199e+02
      1406  3.973136e+05
      1407  4.243628e+05
      1408 -8.421326e+01
      1409 -1.771599e+02
      1410 -4.465871e+01
      1411 -1.132628e+02
      1412 -4.469415e+01
      1413  1.511005e+01
      1414 -1.203452e+02
      1415  5.503716e+05
      1416  4.986524e+05
      1417 -4.753661e+01
      1418 -1.032623e+02
      1419 -2.513578e+01
      1420 -7.486029e+01
      1421 -2.517776e+01
      1422  8.732835e+00
      1423  1.291943e+02
      1424  3.551589e+05
      1425  3.283155e+05
      1426 -4.470912e+01
      1427 -1.142886e+02
      1428 -2.448184e+01
      1429 -9.521993e+01
      1430 -2.455090e+01
      1431  1.142597e+01
      1432  2.247337e+01
      1433  1.229162e+05
      1434  2.184009e+05
      1435 -7.103611e+01
      1436 -1.588920e+02
      1437 -5.098281e+01
      1438 -1.524301e+02
      1439 -5.101381e+01
      1440  2.419846e+00
      1441 -2.289576e+02
      1442  4.249214e+05
      1443  3.322759e+05
      1444 -2.394873e+01
      1445 -5.778358e+01
      1446 -8.743505e+00
      1447 -3.148788e+01
      1448 -8.769154e+00
      1449  8.430671e+00
      1450  1.193862e+02
      1451  6.041463e+05
      1452  6.170305e+05
      1453 -4.174692e+01
      1454 -8.184059e+01
      1455 -2.787904e+01
      1456 -6.696420e+01
      1457 -2.793196e+01
      1458  5.144596e+00
      1459 -6.332762e+01
      1460  8.958813e+05
      1461  7.585653e+05
      1462 -4.077340e+00
      1463 -6.309805e+00
      1464  3.760846e+00
      1465  1.037504e+01
      1466  3.757636e+00
      1467  4.828399e+00
      1468  5.562752e+01
      1469  1.932825e+05
      1470  2.479901e+05
      1471 -7.741316e+01
      1472 -1.705813e+02
      1473 -4.475402e+01
      1474 -1.288901e+02
      1475 -4.477588e+01
      1476  1.821685e+01
      1477 -1.957773e+02
      1478  1.344578e+06
      1479  1.365034e+06
      1480 -1.074698e+01
      1481 -1.561247e+01
      1482 -7.337640e+00
      1483 -1.654984e+01
      1484 -7.339369e+00
      1485 -6.176164e-01
      1486  3.522919e+02
      1487 -2.900695e+05
      1488 -3.217552e+05
      1489  2.623072e+01
      1490  4.534939e+01
      1491  1.125266e+01
      1492  1.766366e+01
      1493  1.123639e+01
      1494 -2.129456e+00
      1495  2.379166e+02
      1496  6.287671e+04
      1497  5.111807e+03
      1498  2.297332e+01
      1499  7.875343e+01
      1500  4.132005e+00
      1501  4.051224e+01
      1502  4.101620e+00
      1503 -1.164253e+01
      1504  1.997669e+02
      1505  5.607801e+05
      1506  5.701100e+05
      1507 -5.523793e+01
      1508 -1.082731e+02
      1509 -3.044389e+01
      1510 -7.536631e+01
      1511 -3.045892e+01
      1512  8.960273e+00
      1513  4.413005e+00
      1514  6.813783e+04
      1515  1.921635e+05
      1516 -6.151820e+01
      1517 -1.032137e+02
      1518 -3.152077e+01
      1519 -6.191377e+01
      1520 -3.153987e+01
      1521  1.178354e+01
      1522 -2.535301e+02
      1523  4.195539e+05
      1524  3.660691e+05
      1525 -5.266696e+01
      1526 -1.436590e+02
      1527 -2.378546e+01
      1528 -1.129762e+02
      1529 -2.381534e+01
      1530  1.800080e+01
      1531 -2.821195e+02
      1532  1.568786e+05
      1533  1.901647e+05
      1534 -9.434212e+01
      1535 -2.613270e+02
      1536 -4.731351e+01
      1537 -1.980853e+02
      1538 -4.743909e+01
      1539  2.169481e+01
      1540 -1.768859e+02
      1541  3.697149e+05
      1542  3.587454e+05
      1543 -6.097464e+01
      1544 -2.219282e+02
      1545 -2.455735e+01
      1546 -1.982864e+02
      1547 -2.473372e+01
      1548  1.770923e+01
      1549 -6.295109e+01
      1550  3.669713e+05
      1551  3.206930e+05
      1552 -3.998007e+01
      1553 -7.850068e+01
      1554 -1.717822e+01
      1555 -3.689058e+01
      1556 -1.721541e+01
      1557  1.171022e+01
      1558  1.955556e+01
      1559  3.308156e+05
      1560  2.799834e+05
      1561 -1.121199e+01
      1562 -2.123598e+01
      1563 -4.499211e+00
      1564 -8.676517e+00
      1565 -4.508652e+00
      1566  4.227009e+00
      1567 -3.093716e+02
      1568  8.266612e+05
      1569  7.935400e+05
      1570 -9.758334e+01
      1571 -1.991443e+02
      1572 -4.519109e+01
      1573 -1.048778e+02
      1574 -4.524320e+01
      1575  2.065954e+01
      1576 -1.978000e+03
      1577  5.011119e+05
      1578  7.532914e+05
      1579 -3.928680e+02
      1580 -7.860789e+02
      1581 -1.993536e+02
      1582 -4.046838e+02
      1583 -1.994535e+02
      1584  3.707300e+01
      1585 -2.547462e+02
      1586  1.481557e+06
      1587  9.835579e+05
      1588 -3.894676e+01
      1589 -9.882309e+01
      1590 -1.353274e+01
      1591 -5.587102e+01
      1592 -1.355447e+01
      1593  9.876231e+00
      1594  3.747227e+02
      1595  9.100372e+05
      1596  6.170949e+05
      1597 -6.809776e+00
      1598  7.629075e+00
      1599 -7.536853e+00
      1600  1.310484e+01
      1601 -7.562323e+00
      1602 -7.675022e+00
      1603 -2.152908e+02
      1604  7.356218e+05
      1605  5.814187e+05
      1606 -1.038653e+02
      1607 -2.556383e+02
      1608 -4.421647e+01
      1609 -1.531628e+02
      1610 -4.439102e+01
      1611  2.680528e+01
      1612 -2.951979e+02
      1613  1.850589e+05
      1614  1.915899e+05
      1615 -6.297641e+01
      1616 -1.573331e+02
      1617 -2.812120e+01
      1618 -9.779937e+01
      1619 -2.817937e+01
      1620  1.494034e+01
      1621 -7.461014e+01
      1622  4.481457e+05
      1623  2.703820e+05
      1624 -9.524836e+00
      1625 -1.145005e+01
      1626 -3.511905e+00
      1627  4.459377e+00
      1628 -3.536773e+00
      1629  1.153725e+00
      1630 -3.784649e+02
      1631  2.535424e+05
      1632  2.488471e+05
      1633 -4.859800e+01
      1634 -1.035075e+02
      1635 -2.189501e+01
      1636 -5.909705e+01
      1637 -2.193473e+01
      1638  1.000130e+01
      1639 -2.120212e+01
      1640  3.786239e+04
      1641  1.024582e+05
      1642 -8.004318e+01
      1643 -1.851823e+02
      1644 -4.460715e+01
      1645 -1.435797e+02
      1646 -4.462385e+01
      1647  1.710859e+01
      1648 -1.688941e+02
      1649  3.685049e+05
      1650  3.830401e+05
      1651 -5.537000e+01
      1652 -1.037464e+02
      1653 -2.677841e+01
      1654 -5.494743e+01
      1655 -2.676918e+01
      1656  1.053524e+01
      1657 -3.355106e+02
      1658  1.098530e+06
      1659  7.726107e+05
      1660 -4.042678e+00
      1661  3.151736e+00
      1662 -2.775631e+00
      1663  7.283705e+00
      1664 -2.801033e+00
      1665 -1.262922e+01
      1666 -5.819893e+01
      1667  1.179216e+05
      1668  1.379443e+05
      1669 -4.057557e+01
      1670 -7.511804e+01
      1671 -2.448014e+01
      1672 -6.622656e+01
      1673 -2.448894e+01
      1674  4.612717e+00
      1675 -5.724981e+02
      1676  1.843230e+05
      1677  3.496154e+05
      1678 -1.014145e+02
      1679 -2.192281e+02
      1680 -5.602148e+01
      1681 -1.571409e+02
      1682 -5.607056e+01
      1683  1.713434e+01
      1684 -1.171835e+02
      1685  5.884687e+05
      1686  4.249397e+05
      1687  8.887646e-01
      1688 -6.398090e-01
      1689 -3.078796e+00
      1690 -1.383699e+01
      1691 -3.112344e+00
      1692 -5.344990e+00
      1693 -5.945536e+02
      1694  8.845580e+04
      1695  1.833935e+05
      1696 -4.718350e+01
      1697 -1.082079e+02
      1698 -1.852534e+01
      1699 -7.500559e+01
      1700 -1.855534e+01
      1701  9.808264e+00
      1702 -1.837277e+02
      1703  1.543560e+06
      1704  1.397461e+06
      1705 -6.247454e+01
      1706 -1.311562e+02
      1707 -3.647679e+01
      1708 -1.029165e+02
      1709 -3.650085e+01
      1710  1.115690e+01
      1711  3.480932e+01
      1712  7.018356e+05
      1713  6.016618e+05
      1714 -1.238160e+02
      1715 -3.226940e+02
      1716 -5.296640e+01
      1717 -1.882871e+02
      1718 -5.314601e+01
      1719  2.992181e+01
      1720  8.045455e+01
      1721  7.041349e+05
      1722  6.724375e+05
      1723 -6.081479e+01
      1724 -1.301303e+02
      1725 -3.305922e+01
      1726 -9.141464e+01
      1727 -3.313631e+01
      1728  9.859900e+00
      1729 -4.322762e+02
      1730 -2.452087e+05
      1731 -2.472332e+05
      1732 -1.409159e+01
      1733 -3.051353e+01
      1734 -2.490446e+00
      1735 -2.555834e+00
      1736 -2.490540e+00
      1737  9.587721e+00
      1738  1.000000e+01
      1739  7.728610e+05
      1740  6.125890e+05
      1741 -1.100570e+01
      1742 -2.975141e+01
      1743 -9.500180e+00
      1744 -4.015738e+01
      1745 -9.560393e+00
      1746 -5.279647e-01
      1747  2.379519e+02
      1748  5.942625e+04
      1749  2.341558e+04
      1750  3.769585e+00
      1751 -1.206216e+01
      1752  6.140274e+00
      1753 -4.475653e+00
      1754  6.128798e+00
      1755  4.386248e+00
      1756 -3.026862e+02
      1757  1.126516e+06
      1758  7.793089e+05
      1759  1.045265e+01
      1760  1.513651e+01
      1761  1.348479e+00
      1762 -1.466844e+01
      1763  1.316455e+00
      1764 -1.060801e+01
      1765 -6.173580e+02
      1766  3.158243e+05
      1767  2.765991e+05
      1768 -6.128666e+00
      1769 -8.277363e+00
      1770 -6.875594e-01
      1771 -1.857027e+00
      1772 -7.085255e-01
      1773  1.640827e+00
      1774 -2.771683e+02
      1775  1.509449e+05
      1776  1.377351e+05
      1777 -5.305321e+01
      1778 -8.790649e+01
      1779 -2.523604e+01
      1780 -3.205472e+01
      1781 -2.531340e+01
      1782  6.359845e+00
      1783 -4.456682e+02
      1784  3.339092e+05
      1785  3.547119e+05
      1786 -6.956229e+01
      1787 -1.410161e+02
      1788 -3.265561e+01
      1789 -7.088543e+01
      1790 -3.269279e+01
      1791  1.411481e+01
      1792 -6.463036e+01
      1793  1.112113e+06
      1794  7.831090e+05
      1795  1.988369e+01
      1796  4.873945e+01
      1797  2.090829e+01
      1798  7.255236e+01
      1799  2.090349e+01
      1800  1.321323e+00
      1801 -2.128889e+02
      1802  3.970533e+05
      1803  2.576952e+05
      1804 -5.468381e+01
      1805 -2.052827e+02
      1806 -2.128825e+01
      1807 -2.004234e+02
      1808 -2.136389e+01
      1809  3.478851e+01
      1810 -1.341031e+02
      1811  8.677633e+05
      1812  3.674694e+05
      1813  6.522651e+01
      1814  1.227409e+02
      1815  4.677214e+01
      1816  1.224227e+02
      1817  4.675976e+01
      1818  2.821199e+00
      1819 -4.114593e+01
      1820  6.052629e+05
      1821  2.253750e+05
      1822 -3.495249e+01
      1823 -9.513481e+01
      1824 -1.660300e+01
      1825 -7.943626e+01
      1826 -1.664639e+01
      1827  1.256937e+01
      1828  1.337308e+02
      1829  1.269957e+04
      1830  2.569047e+04
      1831 -8.487983e+00
      1832 -1.962426e+01
      1833 -9.829988e+00
      1834 -3.040540e+01
      1835 -9.840771e+00
      1836 -1.256303e-01
      1837  1.181357e+02
      1838 -4.342009e+04
      1839  1.308847e+04
      1840 -6.107770e+01
      1841 -1.234110e+02
      1842 -3.705652e+01
      1843 -9.112141e+01
      1844 -3.708068e+01
      1845  9.414079e+00
      1846 -4.508040e+01
      1847 -4.334786e+05
      1848 -3.389695e+05
      1849  3.930093e+01
      1850  1.212015e+02
      1851  1.993865e+01
      1852  1.092789e+02
      1853  2.000125e+01
      1854 -7.937839e+00
      1855  2.423962e+02
      1856 -6.898049e+05
      1857 -6.599777e+05
      1858  1.783663e+02
      1859  7.241469e+02
      1860  6.983402e+01
      1861  5.249763e+02
      1862  7.011340e+01
      1863 -4.607506e+01
      1864 -1.250135e+02
      1865  1.590479e+05
      1866  6.250928e+04
      1867 -1.113165e+02
      1868 -6.018707e+02
      1869 -2.757092e+01
      1870 -4.837732e+02
      1871 -2.783700e+01
      1872  5.383654e+01
      1873  5.841065e+02
      1874  1.004242e+04
      1875  1.219423e+04
      1876  1.681441e+00
      1877  9.791592e+00
      1878 -8.599149e+00
      1879 -4.919337e+01
      1880 -8.580546e+00
      1881 -2.169057e-01
      1882 -1.822000e+02
      1883 -9.840799e+06
      1884 -9.523808e+06
      1885  2.531481e+02
      1886  4.326075e+02
      1887  1.087101e+02
      1888  1.743605e+02
      1889  1.088534e+02
      1890 -4.351354e+01
      1891  7.880889e+02
      1892  2.113934e+05
      1893  5.334898e+04
      1894  2.055052e+01
      1895  1.910378e+02
      1896  1.295849e+01
      1897  2.336588e+02
      1898  1.271357e+01
      1899 -8.640470e+00
      1900  3.908985e+02
      1901  3.909135e+06
      1902  3.483991e+06
      1903 -1.215936e+02
      1904 -4.282477e+02
      1905 -5.224952e+01
      1906 -3.657219e+02
      1907 -5.245374e+01
      1908  4.247738e+01
      1909 -5.369048e+00
      1910  2.039759e+05
      1911 -1.103809e+05
      1912 -1.131534e+02
      1913 -4.329216e+02
      1914 -4.492597e+01
      1915 -3.810174e+02
      1916 -4.498052e+01
      1917  4.841940e+01
      1918  4.333767e+02
      1919  9.319587e+06
      1920  8.992848e+06
      1921 -3.077837e+02
      1922 -1.011499e+03
      1923 -1.291256e+02
      1924 -6.714902e+02
      1925 -1.294733e+02
      1926  7.273053e+01
      1927  8.886774e+02
      1928  1.307462e+05
      1929  4.602343e+05
      1930 -1.318396e+02
      1931 -5.859353e+02
      1932 -7.371089e+01
      1933 -7.574422e+02
      1934 -7.373860e+01
      1935  6.083019e+01
      1936  4.209311e+02
      1937 -7.079602e+05
      1938 -7.187719e+05
      1939  9.627963e+01
      1940  2.977362e+02
      1941  4.796331e+01
      1942  2.366857e+02
      1943  4.804430e+01
      1944 -1.855060e+01
      1945  2.558235e+02
      1946  9.725937e+06
      1947  7.374430e+06
      1948  3.730953e+01
      1949  9.493696e+00
      1950  3.460245e+01
      1951 -1.484769e+01
      1952  3.457746e+01
      1953 -9.806881e+00
      1954  2.264228e+02
      1955  8.912382e+05
      1956  5.967330e+05
      1957 -3.457043e+01
      1958 -8.233953e+01
      1959 -4.795022e+00
      1960  5.002682e+00
      1961 -4.912499e+00
      1962  9.062879e+00
      1963  2.112969e+02
      1964 -1.567930e+05
      1965 -5.327875e+04
      1966  2.547160e+00
      1967 -4.855420e+01
      1968 -3.974210e+00
      1969 -1.606088e+02
      1970 -3.880150e+00
      1971  1.201184e+01
      1972  2.737369e+02
      1973 -1.243573e+06
      1974 -1.183856e+06
      1975  1.163740e+02
      1976  3.141105e+02
      1977  4.905376e+01
      1978  2.065731e+02
      1979  4.939726e+01
      1980 -2.759111e+01
      1981  1.758197e+01
      1982  6.979806e+05
      1983  4.186041e+05
      1984 -3.132079e+01
      1985 -1.211254e+02
      1986 -7.126402e+00
      1987 -6.683511e+01
      1988 -7.153018e+00
      1989  1.578694e+01
      1990  3.613726e+02
      1991 -2.677419e+04
      1992 -2.380931e+04
      1993  6.875297e+01
      1994  3.270844e+02
      1995  2.079834e+01
      1996  2.035869e+02
      1997  2.071259e+01
      1998 -2.158189e+01
      1999  4.665421e+01
      2000  1.219306e+06
      2001  8.315023e+05
      2002 -1.304250e+02
      2003 -4.667054e+02
      2004 -2.513073e+01
      2005 -1.592068e+02
      2006 -2.539064e+01
      2007  3.374418e+01
      2008  1.700000e+01
      2009 -5.234917e+04
      2010 -7.997053e+04
      2011  4.625950e+01
      2012  1.083500e+02
      2013  3.247127e+01
      2014  9.628174e+01
      2015  3.250673e+01
      2016 -5.195593e-01
      2017  9.917931e+01
      2018  6.265854e+05
      2019  4.713899e+05
      2020 -4.515096e+01
      2021 -1.646971e+02
      2022 -1.449542e+01
      2023 -8.296891e+01
      2024 -1.460193e+01
      2025  1.286039e+01
      2026  2.495012e+03
      2027 -1.530998e+05
      2028 -1.278639e+05
      2029  9.836840e+01
      2030  4.112328e+02
      2031  1.868539e+01
      2032  1.168487e+02
      2033  1.851686e+01
      2034 -2.946450e+00
      2035  3.375977e+02
      2036 -4.680587e+04
      2037 -4.872801e+03
      2038  2.957622e+01
      2039  1.268687e+02
      2040 -4.087608e-01
      2041 -2.342889e+01
      2042 -3.524551e-01
      2043 -8.321828e+00
      2044  3.242154e+02
      2045 -2.785389e+04
      2046  3.644019e+03
      2047 -6.357263e+00
      2048 -2.696832e+01
      2049 -4.943955e+00
      2050 -5.393651e+01
      2051 -4.929206e+00
      2052  9.140541e+00
      2053  2.659884e+02
      2054  1.714950e+05
      2055  5.924233e+04
      2056 -3.474113e+01
      2057 -2.081245e+02
      2058 -8.004345e+00
      2059 -1.585251e+02
      2060 -8.159094e+00
      2061  1.321396e+01
      2062  4.984500e+03
      2063 -1.001073e+05
      2064 -4.477533e+04
      2065  9.348405e+01
      2066  4.957684e+02
      2067 -4.803170e+00
      2068 -5.993039e+01
      2069 -4.355788e+00
      2070  3.060379e+01
      2071  1.840000e+01
      2072  4.072912e+05
      2073  3.818124e+05
      2074 -2.471086e+02
      2075 -6.496738e+02
      2076 -1.532769e+02
      2077 -5.356842e+02
      2078 -1.534119e+02
      2079  2.567204e+01
      2080  4.070702e+02
      2081  4.528701e+04
      2082  2.246536e+04
      2083 -2.679837e+00
      2084  4.645100e+00
      2085  2.276050e+00
      2086  3.060436e+01
      2087  1.935739e+00
      2088  7.860947e+00
      2089  4.602615e+02
      2090 -9.849412e+04
      2091 -1.093668e+05
      2092  1.011590e+02
      2093  3.243595e+02
      2094  4.502598e+01
      2095  1.958483e+02
      2096  4.515075e+01
      2097 -2.587420e+01
      2098  1.891389e+02
      2099  1.003351e+05
      2100  6.312042e+04
      2101  8.420653e+00
      2102  4.556220e+01
      2103  2.312815e+00
      2104  1.563511e+01
      2105  2.345364e+00
      2106 -2.071100e+00
      2107  4.060448e+02
      2108  9.019413e+05
      2109  6.713390e+05
      2110 -4.299968e+01
      2111 -1.673019e+02
      2112 -1.605991e+01
      2113 -1.368267e+02
      2114 -1.612987e+01
      2115  1.627503e+01
      2116 -8.965561e+01
      2117  5.007295e+04
      2118  4.827260e+04
      2119 -5.031664e+01
      2120 -1.841571e+02
      2121 -1.938986e+01
      2122 -1.020275e+02
      2123 -1.964321e+01
      2124  6.230124e+00
      2125  5.023078e+02
      2126  1.450658e+05
      2127  1.410058e+05
      2128  2.083259e+01
      2129  1.172943e+02
      2130  3.980043e+00
      2131  4.959390e+01
      2132  3.988149e+00
      2133 -2.076199e+00
      2134  1.904722e+02
      2135 -8.399472e+04
      2136 -8.892553e+04
      2137  7.006844e+01
      2138  1.499121e+02
      2139  3.243290e+01
      2140  8.193127e+01
      2141  3.254712e+01
      2142 -1.120021e+01
      2143 -2.306771e+02
      2144  6.582881e+05
      2145  5.881873e+05
      2146 -8.362768e+01
      2147 -3.047107e+02
      2148 -3.372844e+01
      2149 -2.014059e+02
      2150 -3.393864e+01
      2151  2.260097e+01
      2152  1.861505e+02
      2153 -1.832224e+03
      2154 -2.684974e+03
      2155 -5.845952e+00
      2156 -3.008202e+01
      2157 -1.245908e+00
      2158 -1.965568e+01
      2159 -1.283933e+00
      2160  2.774736e+00
      2161 -1.904723e+03
      2162 -1.731043e+05
      2163 -9.559555e+04
      2164 -8.355654e-01
      2165 -5.671366e+01
      2166  1.723766e+01
      2167  9.032277e+01
      2168  1.892708e+01
      2169 -2.431774e+01
      2170  2.854316e+02
      2171  3.307370e+05
      2172  1.945156e+05
      2173 -1.031784e+02
      2174 -6.303176e+02
      2175 -2.416954e+01
      2176 -4.405689e+02
      2177 -2.461657e+01
      2178  3.435114e+01
      2179  1.028120e+03
      2180  1.817240e+04
      2181 -1.878607e+04
      2182  4.160316e+01
      2183  1.848750e+02
      2184  1.457081e+01
      2185  1.311589e+02
      2186  1.443304e+01
      2187 -1.240942e+01
      2188  1.059639e+03
      2189  1.175423e+04
      2190  1.542212e+04
      2191  1.390957e+01
      2192  1.422219e+02
      2193 -5.354974e+00
      2194  2.665360e+01
      2195 -5.403323e+00
      2196 -1.791994e+00
      2197  3.371572e+02
      2198  6.512854e+05
      2199  4.418939e+05
      2200 -5.258449e+01
      2201 -2.743431e+02
      2202 -1.087347e+01
      2203 -1.465522e+02
      2204 -1.110063e+01
      2205  1.722229e+01
      2206  4.653337e+02
      2207  3.504486e+05
      2208  2.304566e+05
      2209 -2.459252e+01
      2210 -1.062562e+02
      2211 -8.197942e+00
      2212 -7.562990e+01
      2213 -8.314177e+00
      2214  9.984252e+00
      2215  1.724513e+02
      2216  1.428930e+05
      2217  1.345149e+02
      2218 -2.994625e+01
      2219 -1.777439e+02
      2220 -8.196884e+00
      2221 -1.275065e+02
      2222 -8.349855e+00
      2223  1.456217e+01
      2224  6.252175e+02
      2225  1.264599e+06
      2226  1.150500e+06
      2227 -7.828336e+00
      2228 -2.108721e+01
      2229 -4.059478e+00
      2230 -1.061133e+01
      2231 -4.195724e+00
      2232 -7.734105e+00
      2233  3.011000e+03
      2234  3.595937e+05
      2235 -2.480167e+05
      2236  2.624206e+02
      2237  6.346868e+02
      2238  1.858217e+02
      2239  5.372062e+02
      2240  1.858657e+02
      2241 -4.032974e+01
      2242  8.755714e+02
      2243  3.843444e+05
      2244  1.927932e+05
      2245  6.894819e+01
      2246 -4.793542e+01
      2247  5.469318e+01
      2248 -1.557200e+01
      2249  5.444527e+01
      2250  1.412583e+01
      2251  3.487266e+02
      2252 -1.044090e+06
      2253 -9.151737e+05
      2254  1.357886e+02
      2255  5.703745e+02
      2256  5.034301e+01
      2257  4.470070e+02
      2258  5.037473e+01
      2259 -5.275002e+01
      2260 -3.040121e+02
      2261  4.846975e+05
      2262  4.194709e+05
      2263 -5.143634e+01
      2264 -1.356731e+02
      2265 -2.355005e+01
      2266 -8.564322e+01
      2267 -2.361665e+01
      2268  1.342168e+01
      2269  1.805517e+02
      2270  5.813367e+05
      2271  2.031113e+05
      2272  5.582204e+00
      2273 -4.777204e+01
      2274  2.420635e+01
      2275  1.206720e+02
      2276  2.395895e+01
      2277 -1.427158e+00
      2278  9.954302e+02
      2279  5.442329e+05
      2280  5.082982e+05
      2281 -1.209414e+02
      2282 -3.602020e+02
      2283 -6.098130e+01
      2284 -3.002325e+02
      2285 -6.125238e+01
      2286  3.281040e+01
      2287 -2.694883e+02
      2288  1.001225e+06
      2289  7.245514e+05
      2290  6.275445e+00
      2291  1.857279e+01
      2292  8.866071e+00
      2293  4.211849e+01
      2294  8.738682e+00
      2295 -1.250491e+01
      2296  8.669931e+02
      2297  5.890825e+05
      2298  4.034614e+05
      2299  2.002829e+01
      2300  7.904934e+01
      2301  8.883265e+00
      2302  6.381461e+01
      2303  8.826172e+00
      2304 -1.051539e+01
      2305  1.727143e+03
      2306 -2.790441e+06
      2307 -3.231939e+06
      2308  3.148922e+02
      2309  7.377465e+02
      2310  1.908575e+02
      2311  6.350312e+02
      2312  1.909178e+02
      2313 -3.540150e+01
      2314  1.954097e+03
      2315  1.212226e+06
      2316  1.043435e+06
      2317 -3.408247e+02
      2318 -1.446028e+03
      2319 -1.635545e+02
      2320 -1.263475e+03
      2321 -1.648062e+02
      2322  1.158886e+02
      2323  4.569205e+02
      2324  1.217123e+05
      2325  9.435538e+04
      2326  8.519229e+00
      2327  2.234346e+01
      2328 -1.940659e+00
      2329 -2.175068e+01
      2330 -2.046343e+00
      2331 -1.070968e+01
      2332  7.581310e+02
      2333 -9.502154e+04
      2334 -8.840102e+04
      2335  1.976260e+02
      2336  1.317518e+03
      2337  5.059191e+01
      2338  1.038185e+03
      2339  5.134336e+01
      2340 -7.461939e+01
      2341  1.522286e+03
      2342  3.044797e+05
      2343  3.272179e+05
      2344 -2.163116e+02
      2345 -9.534849e+02
      2346 -9.021423e+01
      2347 -7.848735e+02
      2348 -9.035841e+01
      2349  5.623792e+01
      2350  7.588859e+02
      2351  1.007434e+05
      2352  5.594638e+04
      2353  1.180446e+01
      2354  3.453145e+01
      2355  1.822378e+00
      2356 -1.545376e+01
      2357  1.153279e+00
      2358  6.707125e+00
      2359  4.126682e+02
      2360 -5.395483e+04
      2361  8.019117e+04
      2362 -6.359654e+01
      2363 -1.696452e+02
      2364 -3.305618e+01
      2365 -1.144854e+02
      2366 -3.309407e+01
      2367  1.475345e+01
      2368  2.081438e+03
      2369  6.736150e+04
      2370  1.037644e+04
      2371  1.624939e+02
      2372  9.220129e+02
      2373  2.753093e+01
      2374  4.235801e+02
      2375  2.741654e+01
      2376 -5.072925e+01
      2377  6.172000e+02
      2378  8.327605e+04
      2379 -3.144460e+04
      2380  3.083282e+02
      2381  1.405969e+03
      2382  1.494697e+02
      2383  1.201569e+03
      2384  1.497290e+02
      2385 -1.048655e+02
      2386  7.139579e+02
      2387  2.353077e+05
      2388  2.084777e+05
      2389  4.842211e+01
      2390  2.957384e+02
      2391  8.420756e+00
      2392  1.828376e+02
      2393  8.466339e+00
      2394 -1.618819e+01
      2395 -8.428571e+02
      2396  1.209249e+06
      2397  8.911337e+05
      2398 -1.866272e+02
      2399 -8.638115e+02
      2400 -7.452389e+01
      2401 -6.918335e+02
      2402 -7.478642e+01
      2403  1.976596e+01
      2404  4.529250e+03
      2405  9.403263e+05
      2406  5.094751e+05
      2407 -8.647476e+01
      2408 -3.803863e+02
      2409 -3.309377e+01
      2410 -3.686629e+02
      2411 -3.340938e+01
      2412  4.867342e+01
      2413  8.032297e+01
      2414  6.300679e+05
      2415  3.873879e+05
      2416 -8.056635e+01
      2417 -2.654836e+02
      2418 -3.601912e+01
      2419 -2.116557e+02
      2420 -3.607380e+01
      2421  2.459272e+01
      2422  1.019833e+03
      2423  1.059262e+05
      2424 -9.757667e+03
      2425  2.940169e+02
      2426  1.453391e+03
      2427  1.438851e+02
      2428  1.610018e+03
      2429  1.434492e+02
      2430 -1.730792e+02
      2431  4.967241e+02
      2432  7.085016e+05
      2433  2.407237e+05
      2434  5.833880e+01
      2435  2.364888e+02
      2436  3.078034e+01
      2437  2.860853e+02
      2438  3.054594e+01
      2439 -2.194996e+01
      2440 -3.761911e+02
      2441  2.322319e+05
      2442  3.463569e+05
      2443 -6.446422e+01
      2444 -1.530399e+02
      2445 -3.996744e+01
      2446 -1.455375e+02
      2447 -3.998073e+01
      2448  1.288030e+01
      2449 -4.917500e+02
      2450 -6.336596e+05
      2451 -6.903146e+05
      2452  1.362085e+02
      2453  3.045894e+02
      2454  8.343402e+01
      2455  2.835115e+02
      2456  8.349705e+01
      2457 -2.973902e+01
      2458  5.937586e+02
      2459 -3.511822e+04
      2460  1.021258e+04
      2461 -5.773464e+01
      2462 -9.743658e+01
      2463 -3.154013e+01
      2464 -5.333464e+01
      2465 -3.153765e+01
      2466  1.041609e+01
      2467  1.859154e+02
      2468  3.106922e+05
      2469  2.964211e+05
      2470 -3.622804e+01
      2471 -7.631076e+01
      2472 -1.914022e+01
      2473 -4.694263e+01
      2474 -1.916515e+01
      2475  9.869558e+00
      2476  8.273873e+01
      2477  2.334654e+05
      2478  2.055115e+05
      2479 -2.365515e+01
      2480 -4.069075e+01
      2481 -9.236434e+00
      2482 -1.488874e+01
      2483 -9.249194e+00
      2484  8.816833e+00
      2485  7.767521e+01
      2486  8.370776e+05
      2487  8.444978e+05
      2488 -4.824533e+01
      2489 -8.932021e+01
      2490 -3.892959e+01
      2491 -8.791978e+01
      2492 -3.894488e+01
      2493  8.711481e-01
      2494 -1.878725e+02
      2495  5.320409e+05
      2496  4.034850e+05
      2497 -1.606211e+01
      2498 -3.839359e+01
      2499 -4.047465e+00
      2500 -1.464827e+01
      2501 -4.063766e+00
      2502  5.008977e+00
      2503 -7.279979e+01
      2504 -7.846843e+05
      2505 -7.445078e+05
      2506 -3.024577e+01
      2507 -7.613827e+01
      2508 -1.698573e+01
      2509 -6.071491e+01
      2510 -1.699669e+01
      2511  8.293089e+00
      2512  2.426596e+02
      2513 -1.198148e+07
      2514 -1.203438e+07
      2515  2.341371e+02
      2516  8.553033e+02
      2517  9.534532e+01
      2518  5.609809e+02
      2519  9.556242e+01
      2520 -4.416786e+01
      2521 -4.346162e+02
      2522  1.195627e+06
      2523  1.051443e+06
      2524 -6.144197e+01
      2525 -1.050267e+02
      2526 -2.603064e+01
      2527 -3.501013e+01
      2528 -2.607673e+01
      2529  1.160900e+01
      2530  7.432612e+02
      2531 -1.218721e+05
      2532 -2.138059e+05
      2533  2.769676e+02
      2534  7.529180e+02
      2535  1.387740e+02
      2536  6.121715e+02
      2537  1.389492e+02
      2538 -7.082855e+01
      2539  1.304478e+02
      2540  3.668005e+05
      2541  3.713650e+05
      2542 -1.563656e+02
      2543 -4.491114e+02
      2544 -7.520820e+01
      2545 -4.248723e+02
      2546 -7.533915e+01
      2547  5.636319e+01
      2548  6.142105e+01
      2549  3.510218e+05
      2550  2.397162e+05
      2551 -1.710620e+02
      2552 -5.717882e+02
      2553 -6.578083e+01
      2554 -3.576887e+02
      2555 -6.642008e+01
      2556  5.118660e+01
      2557  8.000000e+00
      2558  2.428651e+06
      2559  3.108759e+06
      2560 -5.174345e+02
      2561 -9.364308e+02
      2562 -4.039698e+02
      2563 -9.688593e+02
      2564 -4.042075e+02
      2565 -1.462253e+00
      2566 -1.906000e+02
      2567 -2.040208e+06
      2568 -1.804667e+06
      2569 -1.007565e+02
      2570 -1.405026e+02
      2571 -4.850206e+01
      2572 -6.274432e+01
      2573 -4.848811e+01
      2574  1.940053e+01

---

    Code
      set.seed(42)
      getLinearRegressions(getAlphaMetrics(resampling(gridding(meta, btf), measure = "BIOMASS",
      resamps = 1L), measure = "BIOMASS"), divType = "alpha")
    Message
      OK: all SL studies have 1 grid cell
    Condition
      Warning in `resampling()`:
      NA values found and removed.
      Only a subset of `x` is used.
    Output
          assemblageID     metric         slope     pvalue significance     intercept
      1     211_529239          S -1.911765e+00 0.06351243            0  3.811541e+03
      2     211_529239          N  7.290853e+00 0.23933085            0 -1.439048e+04
      3     211_529239       maxN  2.105206e+00 0.75240417            0 -4.134429e+03
      4     211_529239    Shannon -7.067557e-03 0.95333575            0  1.562470e+01
      5     211_529239 expShannon -2.097038e-01 0.69448212            0  4.215898e+02
      6     211_529239    Simpson  1.250130e-02 0.79990906            0 -2.415666e+01
      7     211_529239 invSimpson -6.081466e-02 0.85927668            0  1.242750e+02
      8     211_529239        PIE  9.744472e-03 0.84902987            0 -1.867404e+01
      9     211_529239      DomMc -3.133189e-03 0.92193219            0  6.894481e+00
      10    211_525598          S  1.123188e-01 0.86436852            0 -2.074746e+02
      11    211_525598          N  9.392217e+00 0.64074505            0 -1.853032e+04
      12    211_525598       maxN  7.926007e+00 0.57494085            0 -1.566064e+04
      13    211_525598    Shannon -8.788826e-02 0.12814372            0  1.756348e+02
      14    211_525598 expShannon -3.436620e-01 0.16851491            0  6.855707e+02
      15    211_525598    Simpson -3.374674e-02 0.16180198            0  6.749936e+01
      16    211_525598 invSimpson -2.245661e-01 0.23325051            0  4.480209e+02
      17    211_525598        PIE -3.594719e-02 0.14876731            0  7.188405e+01
      18    211_525598      DomMc  2.741801e-02 0.06548162            0 -5.360677e+01
      19    211_521960          S -9.383562e-01 0.12638609            0  1.883582e+03
      20    211_521960          N  1.090548e+01 0.39674589            0 -2.155166e+04
      21    211_521960       maxN  5.708158e+00 0.49757763            0 -1.128345e+04
      22    211_521960    Shannon -6.698794e-02 0.37876385            0  1.348086e+02
      23    211_521960 expShannon -5.108660e-01 0.32946713            0  1.020834e+03
      24    211_521960    Simpson -1.657237e-02 0.47382350            0  3.361993e+01
      25    211_521960 invSimpson -2.345783e-01 0.53273829            0  4.702099e+02
      26    211_521960        PIE -2.029510e-02 0.39846134            0  4.102133e+01
      27    211_521960      DomMc  1.190137e-02 0.62429357            0 -2.303203e+01
      28    211_523410          S -1.229508e-01 0.88353363            0  2.536311e+02
      29    211_523410          N -1.153545e+01 0.33243400            0  2.293799e+04
      30    211_523410       maxN -1.519226e+01 0.14983488            0  3.017498e+04
      31    211_523410    Shannon  1.205090e-01 0.19779984            0 -2.378131e+02
      32    211_523410 expShannon  3.184938e-01 0.31718214            0 -6.279386e+02
      33    211_523410    Simpson  6.404909e-02 0.12393854            0 -1.264659e+02
      34    211_523410 invSimpson  2.339985e-01 0.34224259            0 -4.611118e+02
      35    211_523410        PIE  6.053685e-02 0.18524820            0 -1.194548e+02
      36    211_523410      DomMc -1.595861e-02 0.58379709            0  3.239652e+01
      37    211_517585          S -8.100000e+00 0.28222960            0  1.606540e+04
      38    211_517585          N -4.107570e+01 0.30354215            0  8.147040e+04
      39    211_517585       maxN -3.104810e+01 0.28500737            0  6.158202e+04
      40    211_517585    Shannon -4.005274e-02 0.85312909            0  8.024095e+01
      41    211_517585 expShannon -1.730226e-01 0.73417433            0  3.453567e+02
      42    211_517585    Simpson  2.846898e-02 0.73172947            0 -5.605328e+01
      43    211_517585 invSimpson  7.187258e-02 0.70797767            0 -1.408074e+02
      44    211_517585        PIE  3.155250e-02 0.70394454            0 -6.215584e+01
      45    211_517585      DomMc  2.811972e-02 0.46684338            0 -5.484201e+01
      46    211_516855          S  2.400000e+00 0.11774245            0 -4.751900e+03
      47    211_516855          N  2.755660e+01 0.49204126            0 -5.460246e+04
      48    211_516855       maxN  2.336700e+01 0.55569906            0 -4.630065e+04
      49    211_516855    Shannon -8.258913e-02 0.78187135            0  1.648112e+02
      50    211_516855 expShannon -2.018194e-01 0.78991357            0  4.032430e+02
      51    211_516855    Simpson -6.913214e-02 0.64465612            0  1.375865e+02
      52    211_516855 invSimpson -2.794113e-01 0.64149830            0  5.564012e+02
      53    211_516855        PIE -1.035756e-01 0.53044954            0  2.059505e+02
      54    211_516855      DomMc  2.039186e-02 0.81400255            0 -3.963007e+01
      55   437_2075128          S  3.571429e+00 0.37568068            0 -7.161619e+03
      56   437_2075128          N  3.567555e+03 0.53356355            0 -7.159572e+06
      57   437_2075128       maxN  1.025837e+03 0.08534134            0 -2.060557e+06
      58   437_2075128    Shannon  2.849485e-02 0.86904696            0 -5.498831e+01
      59   437_2075128 expShannon  1.532591e-01 0.93612972            0 -2.973033e+02
      60   437_2075128    Simpson  6.675859e-03 0.80743628            0 -1.257577e+01
      61   437_2075128 invSimpson  7.024539e-02 0.96729134            0 -1.331094e+02
      62   437_2075128        PIE  6.659487e-03 0.80772572            0 -1.254275e+01
      63   437_2075128      DomMc -1.276453e-02 0.85045068            0  2.609115e+01
      64   437_2077319          S  3.975904e-01 0.84512503            0 -7.603012e+02
      65   437_2077319          N  9.775647e+03 0.00557985            1 -1.963961e+07
      66   437_2077319       maxN  1.773273e+03 0.13978616            0 -3.560434e+06
      67   437_2077319    Shannon -3.005516e-02 0.70320392            0  6.306294e+01
      68   437_2077319 expShannon -4.628513e-01 0.69401817            0  9.450090e+02
      69   437_2077319    Simpson  2.122870e-04 0.99009460            0  4.375835e-01
      70   437_2077319 invSimpson -1.950326e-01 0.87398361            0  4.010466e+02
      71   437_2077319        PIE  2.036851e-04 0.99049697            0  4.549336e-01
      72   437_2077319      DomMc -1.772932e-03 0.96240126            0  3.974004e+00
      73   437_2076590          S  4.819277e-02 0.99539237            0 -2.597590e+01
      74   437_2076590          N  6.721535e+03 0.16419572            0 -1.343331e+07
      75   437_2076590       maxN -8.855904e+00 0.99206612            0  3.353006e+04
      76   437_2076590    Shannon  5.769677e-02 0.32995115            0 -1.130239e+02
      77   437_2076590 expShannon  1.404966e+00 0.28684743            0 -2.805031e+03
      78   437_2076590    Simpson  6.543689e-03 0.08090861            0 -1.224747e+01
      79   437_2076590 invSimpson  1.224651e+00 0.04107477            1 -2.451214e+03
      80   437_2076590        PIE  6.543156e-03 0.08092701            0 -1.224639e+01
      81   437_2076590      DomMc -1.905933e-02 0.29055069            0  3.866818e+01
      82   437_2078777          S -2.108434e+00 0.77516324            0  4.302446e+03
      83   437_2078777          N  5.746165e+03 0.18831257            0 -1.148912e+07
      84   437_2078777       maxN  6.616122e+03 0.06881635            0 -1.328309e+07
      85   437_2078777    Shannon -9.282819e-02 0.38815987            0  1.891460e+02
      86   437_2078777 expShannon -1.031922e+00 0.37403571            0  2.087634e+03
      87   437_2078777    Simpson -3.241143e-02 0.23655544            0  6.599889e+01
      88   437_2078777 invSimpson -8.025152e-01 0.41332820            0  1.620685e+03
      89   437_2078777        PIE -3.241247e-02 0.23654455            0  6.600100e+01
      90   437_2078777      DomMc  3.003652e-02 0.42391606            0 -5.992348e+01
      91   437_2076589          S  1.571429e+00 0.03338324            1 -3.130952e+03
      92   437_2076589          N  1.421394e+03 0.47616699            0 -2.839737e+06
      93   437_2076589       maxN  7.596407e+02 0.52578106            0 -1.523031e+06
      94   437_2076589    Shannon -4.703992e-02 0.54335839            0  9.733068e+01
      95   437_2076589 expShannon -6.395930e-01 0.57433063            0  1.301675e+03
      96   437_2076589    Simpson -8.358841e-03 0.54878801            0  1.770479e+01
      97   437_2076589 invSimpson -5.542033e-01 0.63497050            0  1.124337e+03
      98   437_2076589        PIE -8.361745e-03 0.54879592            0  1.771068e+01
      99   437_2076589      DomMc  1.247050e-02 0.62255038            0 -2.470392e+01
      100  437_2075860          S  8.857143e+00 0.21123639            0 -1.778176e+04
      101  437_2075860          N  1.054104e+04 0.05890918            0 -2.114494e+07
      102  437_2075860       maxN  8.881564e+02 0.31794564            0 -1.757952e+06
      103  437_2075860    Shannon  1.916651e-01 0.02901090            1 -3.835970e+02
      104  437_2075860 expShannon  2.063282e+00 0.02431841            1 -4.143262e+03
      105  437_2075860    Simpson  3.842527e-02 0.25010674            0 -7.658824e+01
      106  437_2075860 invSimpson  9.064480e-01 0.07892402            0 -1.819764e+03
      107  437_2075860        PIE  3.842438e-02 0.25011110            0 -7.658645e+01
      108  437_2075860      DomMc -5.299857e-02 0.04894332            1  1.072597e+02
      109  437_2074400          S  1.142857e+00 0.68827910            0 -2.266238e+03
      110  437_2074400          N  4.734568e+02 0.74042016            0 -9.368738e+05
      111  437_2074400       maxN  4.662000e+01 0.94210064            0 -9.119890e+04
      112  437_2074400    Shannon -3.139575e-02 0.72833767            0  6.602287e+01
      113  437_2074400 expShannon -6.032863e-01 0.70148443            0  1.231479e+03
      114  437_2074400    Simpson -2.104224e-03 0.82393528            0  5.152212e+00
      115  437_2074400 invSimpson -4.860387e-01 0.74077749            0  9.908823e+02
      116  437_2074400        PIE -2.106614e-03 0.82384893            0  5.157081e+00
      117  437_2074400      DomMc  4.051863e-03 0.90634243            0 -7.875449e+00
      118  437_2074399          S  3.500000e+00 0.33333333            0 -7.006167e+03
      119  437_2074399          N  1.512423e+04 0.08618974            0 -3.040342e+07
      120  437_2074399       maxN  3.964162e+03 0.09289128            0 -7.970328e+06
      121  437_2074399    Shannon -5.223990e-02 0.63592417            0  1.078477e+02
      122  437_2074399 expShannon -8.656709e-01 0.61786975            0  1.757645e+03
      123  437_2074399    Simpson -8.154281e-03 0.44788194            0  1.730745e+01
      124  437_2074399 invSimpson -8.301166e-01 0.48580372            0  1.680895e+03
      125  437_2074399        PIE -8.163397e-03 0.44757751            0  1.732584e+01
      126  437_2074399      DomMc  2.131072e-02 0.31334874            0 -4.253882e+01

