% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{genapply}
\alias{genapply}
\title{Apply a function to each SNP in a
gen, impute2, file}
\usage{
genapply(geninfo, func, ...)
}
\arguments{
\item{geninfo}{List with information about the
gen, impute2, file returned from \link{getgeninfo}}

\item{func}{A user supplied function to apply
to the data for each snp. The function must be
provide with the following parameters, dosage,
p0, p1, and p2, where dosage is the dosage values
for each subject and p0, p1, and p2 are the
probabilities that a subject has zero, one,
and two copies of the alternate allele,
respectively.}

\item{...}{Additional parameters needed by the
user supplied function}
}
\value{
A list with length equal to the number
of SNPs in the vcf file. Each element
of the list is the value returned by the user
supplied function
}
\description{
A routine that reads in the SNP data serially
from a gen file and applies a user
specified function to the data.
}
\examples{
# Get information about a gen, impute2, file

gen1afile <- system.file("extdata", "set1a.imp", package = "BinaryDosage")
geninfo <- getgeninfo(genfiles = gen1afile,
                      snpcolumns = c(1L, 3L, 2L, 4L, 5L),
                      header = TRUE)


aaf <- genapply(geninfo = geninfo,
                func = BinaryDosage:::getaaf)
}
\seealso{
Other Iterating functions: 
\code{\link{bdapply}()},
\code{\link{vcfapply}()}
}
\concept{Iterating functions}
