% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_func.R
\name{qRankPar}
\alias{qRankPar}
\title{Bar plot for time-averaged log-q estimates over quantile-representative counties (descending order)}
\usage{
qRankPar(state.set,cname,bstfit,vn=12,
               cex.title=18, cex.lab=18, cex.legend=18)
}
\arguments{
\item{state.set}{character vector of set of states on which the the graphics is to be made}

\item{cname}{character vector of the names of the counties}

\item{bstfit}{the fitted data for BSTP, BSTNB or BSTZINB}

\item{vn}{positive integer, number of sample counties to display}

\item{cex.title}{Positive number to control the size of the text of the main title. Defaults to 18.}

\item{cex.lab}{Positive number to control the size of the text in the axes labels. Defaults to 18.}

\item{cex.legend}{Positive number to control the size of the text in the legend. Defaults to 18.}
}
\value{
bar graph
}
\description{
Produce a descending order of bar plot for time-averaged log-q estimates over quantile-representative counties
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
qRankPar(state.set=c("IA"),cname=countyname,bstfit=res3,vn=12,
         cex.title=18, cex.lab=12, cex.legend=12)
}

}
