% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictBL.R
\name{predictBL}
\alias{predictBL}
\title{Predict boundary response}
\usage{
predictBL(object, x)
}
\arguments{
\item{object}{An output in form of a list from the boundary line fitting using
the \code{blqr()}, \code{blbin()}, \code{bolides()} or \code{cbvn()} functions.}

\item{x}{A numeric vector of values for the factor with which response is
to be predicted.}
}
\value{
A vector predicted value of response.
}
\description{
This function predicts the most efficient response at a level of factor,
\code{x}, given the parameters of the fitted boundary line.
}
\examples{

x<-evapotranspiration$`ET(mm)`
y<-evapotranspiration$`yield(t/ha)`
z<-bolides(x,y, start = c(0.5,0.02), model= "blm", xmax = 350)

Results<-predictBL(z,x)

head(Results) # prediction for first 6 lines


}
\author{
Chawezi Miti <chawezi.miti@nottingham.ac.uk>
}
