% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{meanG}
\alias{meanG}
\title{Mean genetic values}
\usage{
meanG(pop)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or \code{\link{HybridPop-class}}}
}
\description{
Returns the mean genetic values for all traits
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

}
