% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sample.zi1}
\alias{sample.zi1}
\title{Generate random deviates from zero-inflated}
\usage{
sample.zi1(N,phi,dist="poisson",lambda=NA,r=NA,p=NA,
alpha1=NA,alpha2=NA,n=NA,mean=NA,sigma=NA)
}
\arguments{
\item{N}{The sample size. Should be a positive number. If it is not an integer, N will be automatically rounded up to the smallest integer that no less than N.}

\item{phi}{The structural parameter \eqn{\phi}, should be a positive value within (0,1).}

\item{dist}{The corresponding standard distribution. Can be one of {'poisson', 'geometric','nb','bb', 'bnb','normal', 'lognormal', 'halfnormal','exponential'}, which corresponds to Poisson, geometric, negative binomial, beta binomial, beta negative binomial, normal, log normal, hal fnormal, and exponential distributions respectively.}

\item{lambda}{A value for the parameter of Poisson distribution. Should be a positive number.}

\item{r}{the number of success before which m failures are observed, where m is a random variable from negative binomial or beta negative binomial distribution. Must be a positive number. If it is not an integer, r will be automatically rounded up to the smallest integer that no less than r.}

\item{p}{The probability of success, should be a positive value within (0,1).}

\item{alpha1}{The first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{The second shape parameter of beta distribution. Should be a positive number.}

\item{n}{The number of trials. Must be a positive number. If it is not an integer, n will be automatically rounded up to the smallest integer that no less than n.}

\item{mean}{A value for parameter of the mean or expectation.}

\item{sigma}{A value of parameter for standard deviation. Must be a positive real number.}
}
\value{
A vector of length N containing non-negative integers from the zero-inflated version of distribution determined by dist.
}
\description{
Generate random deviates from zero-inflated Poisson, geometric, negative binomial, beta binomial, beta negative binomial, normal, log normal, half normal, and exponential models.
}
\details{
\itemize{\item Setting dist=poisson and lambda, sample.zi1 simulates N random deviates from zero-inflated Poisson distribution, respectively, and so on forth.

\item Setting the dist=geometric and the argument p is for the use of zero-inflated geometric distributions.
\item ASetting the dist=nb and the arguments r and p are for the use of zero-inflated negative binomial distributions.
\item Setting the dist=bb and the arguments n, alpha1, and alpha2 are for zero-inflated beta binomial distributions.
\item Setting the dist=bnb and the arguments r, alpha1, and alpha2 are used in zero-inflated beta negative binomial distributions.
\item Setting the dist=normal and the arguments mean and sigma are used in zero-inflated normal distributions.
\item Setting the dist=lognormal and the arguments mean and sigma are used in zero-inflated log normal distributions.
\item Setting the dist=halfnormal and the argument sigma is used in zero-inflated half normal distributions.
\item Setting the dist=exponential and the argument lambda is used in zero-inflated exponential distributions.}

Random deviates from standard Poisson, geometric, negative binomial, normal, log normal, and exponential distributions can be generated by basic R
function rpois, rgeom, rnbinom, rnorm, rlnorm, and rexp in R package stats.

Functions rbbinom and rbnbinom, and rhnorm are available for standard beta binomial, beta negative binomial, and half normal distributions in R package extraDistr.
}
\examples{
x1=sample.zi1(2000,phi=0.3,dist='poisson',lambda=10)         #zero-inflated Poisson
x2=sample.zi1(2000,phi=0.2,dist='geometric',p=0.2)           #zero-inflated geometric
x3=sample.zi1(2000,phi=0.3,dist='bb',n=10,alpha1=2,alpha2=4) #zero-inflated beta binomial
x4=sample.zi1(2000,phi=0.3,dist="normal",mean=10,sigma=2)    #zero-inflated normal
x5=sample.zi1(2000,phi=0.3,dist="exponential",lambda=20)     #zero-inflated exponential
}
\references{
\itemize{\item H. Aldirawi, J. Yang, A. A. Metwally, Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data, accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI) (2019).
\item T. Wolodzko, extraDistr: Additional Univariate and Multivariate Distributions, R package version 1.8.11 (2019), https://CRAN.R-project.org/package=extraDistr.}
}
