% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{full_scenarios_core}
\alias{full_scenarios_core}
\title{Exported version of full_scenarios_core}
\usage{
full_scenarios_core(
  big_b,
  big_M,
  obs,
  path,
  shocks,
  h,
  n_var,
  g_ = NULL,
  Sigma_g_ = NULL
)
}
\arguments{
\item{big_b}{Cube of B matrices}

\item{big_M}{Cube of M matrices}

\item{obs}{Indices of constrained observables}

\item{path}{Flattened path for observables}

\item{shocks}{Indices of shocks to be recovered}

\item{h}{Forecast horizon}

\item{n_var}{Number of variables}

\item{g_}{Optional vector of non-driving shocks}

\item{Sigma_g_}{Optional covariance matrix of non-driving shocks}
}
\value{
A list with elements depending on the input configuration. Typically includes:
\describe{
\item{mu_eps}{Matrix of mean structural shocks}
\item{Sigma_eps}{Covariance matrix of structural shocks}
\item{mu_y}{Matrix of conditional means of observables}
\item{Sigma_y}{Covariance matrix of observables}
\item{big_b}{Slice of B matrices used}
\item{big_M}{Slice of M matrices used}
\item{draws_used}{Indices of posterior draws used in the simulation}
}
}
\description{
This function wraps the Rcpp-exported version of \code{full_scenarios_core}
and allows external users to call it with correct argument checks.
}
\examples{
\dontrun{
# This function is typically called internally by scenarios()
# Example usage with simulated data:
big_b <- array(rnorm(9*4*10), dim = c(9, 4, 10))
big_M <- array(rnorm(9*9*10), dim = c(9, 9, 10))
result <- full_scenarios_core(big_b, big_M, obs = 1:2, 
                              path = c(1.0, 1.1), shocks = NA, 
                              h = 2, n_var = 3)
}
}
