% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{mendelianSampling}
\alias{mendelianSampling}
\title{Calculate Mendelian sampling}
\usage{
mendelianSampling(
  pop,
  parents = NULL,
  mothers = NULL,
  fathers = NULL,
  use = "gv",
  simParam = NULL
)
}
\arguments{
\item{pop}{\code{\link{Pop-class}} with individuals whose parent average
will be calculated}

\item{parents}{\code{\link{Pop-class}} with mothers and fathers of individuals
in \code{pop}; if \code{NULL} must provide \code{mothers} and \code{fathers}}

\item{mothers}{\code{\link{Pop-class}} with mothers of individuals in \code{pop};
if \code{NULL} must provide \code{parents}}

\item{fathers}{\code{\link{Pop-class}} with fathers of individuals in \code{pop};
if \code{NULL} must provide \code{parents}}

\item{use}{character, calculate using \code{"\link{gv}"}, \code{"\link{bv}"},
\code{"\link{ebv}"}, or \code{"\link{pheno}"}}

\item{simParam}{\code{\link{SimParam}} object}
}
\value{
a matrix of Mendelian samplings with dimensions nInd by nTraits
}
\description{
Calculate Mendelian sampling
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
pop2 = randCross(pop, nCrosses=10, nProgeny=2)
mendelianSampling(pop2, parents = pop)
mendelianSampling(pop2, mothers = pop, fathers = pop)

}
