% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdaptiveBoxplot.R
\name{holm_boxplot}
\alias{holm_boxplot}
\title{Family-Wise Error Rate (FWER) Boxplot}
\usage{
holm_boxplot(
  data,
  alpha = 0.05,
  kfwer = 1,
  group_col = NULL,
  value_col = NULL,
  ...
)
}
\arguments{
\item{data}{A numeric vector for a single boxplot, or a data frame for grouped boxplots.}

\item{alpha}{The target FWER level. Defaults to 0.05.}

\item{kfwer}{The "k" in k-FWER control. Defaults to 1 for standard FWER.}

\item{group_col}{A string specifying the name of the grouping column in `data`.}

\item{value_col}{A string specifying the name of the value column in `data`.}

\item{...}{Additional arguments passed to the base \code{\link[graphics]{boxplot}} function.}
}
\value{
A plot is drawn on the current graphics device.
}
\description{
Generates a boxplot where whisker lengths are determined by the Holm procedure
to control the Family-Wise Error Rate (FWER), providing a conservative yet
principled approach to outlier detection.
}
\details{
This function is a graphical implementation of the p-value pipeline
proposed by Gang, Lin, and Tong (2025). It uses robust estimators for the
mean and standard deviation based on quartiles to calculate p-values for each
observation, then applies the Holm procedure to determine a p-value threshold
that controls the FWER. This method is generally more conservative than the
FDR boxplot.
}
\examples{
# Single group example
set.seed(123)
data_single <- c(rnorm(50), 10, 12)
holm_boxplot(data_single, alpha = 0.05, main = "FWER Boxplot (Single Group)")

# Grouped data example
data_grouped <- data.frame(
  Category = rep(c("A", "B"), each = 100),
  Value = c(rnorm(100), rnorm(100, mean = 2, sd = 1.5))
)
holm_boxplot(data_grouped, group_col = "Category", value_col = "Value")
}
\references{
Gang, B., Lin, H., & Tong, T. (2025). Unifying Boxplots: A Multiple Testing Perspective.
}
\seealso{
\code{\link{bh_boxplot}}
}
