% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabscreen_gpt.R
\name{tabscreen_gpt.tools}
\alias{tabscreen_gpt.tools}
\alias{tabscreen_gpt}
\title{Title and abstract screening with GPT API models using function calls via the tools argument}
\usage{
tabscreen_gpt.tools(data, prompt, studyid, title, abstract,
   model = "gpt-4o-mini", role = "user", tools = NULL, tool_choice = NULL, top_p = 1,
   time_info = TRUE, token_info = TRUE, api_key = get_api_key(), max_tries = 16,
   max_seconds = NULL, is_transient = gpt_is_transient, backoff = NULL,
   after = NULL, rpm = 10000, reps = 1, seed_par = NULL, progress = TRUE,
   decision_description = FALSE, messages = TRUE, incl_cutoff_upper = NULL,
   incl_cutoff_lower = NULL, force = FALSE, fine_tuned = FALSE, ...)

tabscreen_gpt(data, prompt, studyid, title, abstract,
   model = "gpt-4o-mini", role = "user", tools = NULL, tool_choice = NULL, top_p = 1,
   time_info = TRUE, token_info = TRUE, api_key = get_api_key(), max_tries = 16,
   max_seconds = NULL, is_transient = gpt_is_transient, backoff = NULL,
   after = NULL, rpm = 10000, reps = 1, seed_par = NULL, progress = TRUE,
   decision_description = FALSE, messages = TRUE, incl_cutoff_upper = NULL,
   incl_cutoff_lower = NULL, force = FALSE, fine_tuned = FALSE, ...)
}
\arguments{
\item{data}{Dataset containing the titles and abstracts.}

\item{prompt}{Prompt(s) to be added before the title and abstract.}

\item{studyid}{Unique Study ID. If missing, this is generated
automatically.}

\item{title}{Name of the variable containing the title information.}

\item{abstract}{Name of variable containing the abstract information.}

\item{model}{Character string with the name of the completion model. Can take
multiple models. Default is the latest \code{"gpt-4o-mini"}.
Find available model at
\url{https://platform.openai.com/docs/models/model-endpoint-compatibility}.}

\item{role}{Character string indicating the role of the user. Default is \code{"user"}.}

\item{tools}{This argument allows this user to apply customized functions.
See \url{https://platform.openai.com/docs/api-reference/chat/create#chat-create-tools}.
Default is \code{NULL}. If not specified the default function calls from \code{AIscreenR} are used.}

\item{tool_choice}{If a customized function is provided this argument
'controls which (if any) tool is called by the model' (OpenAI). Default is \code{NULL}.
If set to \code{NULL} when using a customized function, the default is \code{"auto"}.
See \url{https://platform.openai.com/docs/api-reference/chat/create#chat-create-tool_choice}.}

\item{top_p}{'An alternative to sampling with temperature, called nucleus sampling,
where the model considers the results of the tokens with top_p probability mass.
So 0.1 means only the tokens comprising the top 10\% probability mass are considered.
We generally recommend altering this or temperature but not both.' (OpenAI). Default is 1.
Find documentation at
\url{https://platform.openai.com/docs/api-reference/chat/create#chat/create-top_p}.}

\item{time_info}{Logical indicating whether the run time of each
request/question should be included in the data. Default is \code{TRUE}.}

\item{token_info}{Logical indicating whether token information should be included
in the output data. Default is \code{TRUE}. When \code{TRUE}, the output object will
include price information of the conducted screening.}

\item{api_key}{Numerical value with your personal API key. Default setting draws
on the \code{\link[=get_api_key]{get_api_key()}} to retrieve the API key from the R environment, so that the key is not
compromised. The API key can be added to the R environment via \code{\link[=set_api_key]{set_api_key()}}
or by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}. In the \code{.Renviron} file, write \code{CHATGPT_KEY=INSERT_YOUR_KEY_HERE}.
After entering the API key, close and save the \code{.Renviron} file and restart \code{RStudio} (ctrl + shift + F10).
Alternatively, one can use \code{\link[httr2:secrets]{httr2::secret_make_key()}}, \code{\link[httr2:secrets]{httr2::secret_encrypt()}}, and
\code{\link[httr2:secrets]{httr2::secret_decrypt()}} to scramble and decrypt the API key.}

\item{max_tries, max_seconds}{'Cap the maximum number of attempts with
\code{max_tries} or the total elapsed time from the first request with
\code{max_seconds}. If neither option is supplied (the default), \code{\link[httr2:req_perform]{httr2::req_perform()}}
will not retry' (Wickham, 2023). The default of \code{max_tries} is 16.}

\item{is_transient}{'A predicate function that takes a single argument
(the response) and returns \code{TRUE} or \code{FALSE} specifying whether or not
the response represents a transient error' (Wickham, 2023). This function runs
automatically in the AIscreenR but can be customized by the user if necessary.}

\item{backoff}{'A function that takes a single argument (the number of failed
attempts so far) and returns the number of seconds to wait' (Wickham, 2023).}

\item{after}{'A function that takes a single argument (the response) and
returns either a number of seconds to wait or \code{NULL}, which indicates
that a precise wait time is not available that the \code{backoff} strategy
should be used instead' (Wickham, 2023).}

\item{rpm}{Numerical value indicating the number of requests per minute (rpm)
available for the specified model. Find more information at
\url{https://platform.openai.com/docs/guides/rate-limits/what-are-the-rate-limits-for-our-api}.
Alternatively, use \code{\link[=rate_limits_per_minute]{rate_limits_per_minute()}}.}

\item{reps}{Numerical value indicating the number of times the same
question should be send to the server. This can be useful to test consistency
between answers, and/or can be used to make inclusion judgments based on how many times
a study has been included across a the given number of screenings.
Default is \code{1} but when using gpt-3.5-turbo models or gpt-4o-mini,
we recommend setting this value to \code{10} to catch model uncertainty.}

\item{seed_par}{Numerical value for a seed to ensure that proper,
parallel-safe random numbers are produced.}

\item{progress}{Logical indicating whether a progress line should be shown when running
the title and abstract screening in parallel. Default is \code{TRUE}.}

\item{decision_description}{Logical indicating whether a detailed description should follow
the decision made by GPT. Default is \code{FALSE}. When conducting large-scale screening,
we generally recommend not using this feature as it will substantially increase the cost of the
screening. We generally recommend using it when encountering disagreements between GPT and
human decisions.}

\item{messages}{Logical indicating whether to print messages embedded in the function.
Default is \code{TRUE}.}

\item{incl_cutoff_upper}{Numerical value indicating the probability threshold
for which a studies should be included. ONLY relevant when the same questions is requested
multiple times (i.e., when any reps > 1). Default is 0.5, indicating that
titles and abstracts should only be included if GPT has included the study more than 50 percent of the times.}

\item{incl_cutoff_lower}{Numerical value indicating the probability threshold
above which studies should be check by a human. ONLY relevant when the same questions is requested
multiple times (i.e., when any reps > 1). Default is 0.4, meaning
that if you ask GPT the same questions 10 times and it includes the
title and abstract 4 times, we suggest that the study should be check by a human.}

\item{force}{Logical argument indicating whether to force the function to use more than
10 iterations for gpt-3.5 models and more than 1 iteration for gpt-4 models other than gpt-4o-mini.
This argument is developed to avoid the conduct of wrong and extreme sized screening.
Default is \code{FALSE}.}

\item{fine_tuned}{Logical indicating whether a fine-tuned model is used. Default is \code{FALSE}.}

\item{...}{Further argument to pass to the request body.
See \url{https://platform.openai.com/docs/api-reference/chat/create}.}
}
\value{
An object of class \code{'gpt'}. The object is a list containing the following
datasets and components:
\item{answer_data}{dataset of class \code{'gpt_tbl'} with all individual answers.}
\item{price_dollar}{numerical value indicating the total price (in USD) of the screening.}
\item{price_data}{dataset with prices across all gpt models used for screening.}
\item{run_date}{string indicating the date when the screening was ran. In some frameworks,
time details are considered important to report (see e.g., Thomas et al., 2024).}
\item{...}{some additional attributed values/components, including an attributed list with the arguments used in the function.
These are used in  \code{\link[=screen_errors]{screen_errors()}} to re-screen transient errors.}

If the same question is requested multiple times, the object will also contain the
following dataset with results aggregated across the iterated requests/questions.

\item{answer_data_aggregated}{dataset of class \code{'gpt_agg_tbl'} with the summarized, probabilistic inclusion decision
for each title and abstract across multiple repeated questions.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}
This function supports the conduct of title and abstract screening with GPT API models in R.
Specifically, it allows the user to draw on GPT-3.5, GPT-4, GPT-4o, GPT-4o-mini, and fine-tuned models.
The function allows to run title and abstract screening across multiple prompts and with
repeated questions to check for consistency across answers. All of which can be done in parallel.
The function draws on the newly developed function calling which is called via the
tools argument in the request body. This is the main different between \code{\link[=tabscreen_gpt.tools]{tabscreen_gpt.tools()}}
and \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}. Function calls ensure more reliable and consistent responses to ones
requests. See \href{https://osf.io/preprints/osf/yrhzm}{Vembye, Christensen, Mølgaard, and Schytt. (2025)}
for guidance on how adequately to conduct title and abstract screening with GPT models.
}
\note{
The \code{answer_data} data contains the following \emph{mandatory} variables:
\tabular{lll}{
\bold{studyid} \tab \code{integer} \tab indicating the study ID of the reference. \cr
\bold{title} \tab \code{character} \tab indicating the title of the reference. \cr
\bold{abstract} \tab \code{character}   \tab indicating the abstract of the reference. \cr
\bold{promptid} \tab \code{integer} \tab indicating the prompt ID. \cr
\bold{prompt} \tab \code{character} \tab indicating the prompt. \cr
\bold{model} \tab \code{character}   \tab indicating the specific gpt-model used. \cr
\bold{iterations} \tab \code{numeric} \tab indicating the number of times the same question has been sent to OpenAI's GPT API models. \cr
\bold{question} \tab \code{character} \tab indicating the final question sent to OpenAI's GPT API models. \cr
\bold{top_p}  \tab \code{numeric} \tab indicating the applied top_p. \cr
\bold{decision_gpt}  \tab \code{character} \tab indicating the raw gpt decision - either \code{"1", "0", "1.1"} for inclusion, exclusion, or uncertainty, respectively. \cr
\bold{detailed_description}  \tab \code{character} \tab indicating detailed description of the given decision made by OpenAI's GPT API models.
ONLY included if the detailed function calling function is used. See 'Examples' below for how to use this function. \cr
\bold{decision_binary}  \tab \code{integer} \tab indicating the binary gpt decision,
that is 1 for inclusion and 0 for exclusion. 1.1 decision are coded equal to 1 in this case. \cr
\bold{prompt_tokens}  \tab \code{integer} \tab indicating the number of prompt tokens sent to the server for the given request. \cr
\bold{completion_tokens}  \tab \code{integer} \tab indicating the number of completion tokens sent to the server for the given request. \cr
\bold{submodel} \tab \code{character} \tab indicating the exact (sub)model used for screening. \cr
\bold{run_time}  \tab \code{numeric} \tab indicating the time it took to obtain a response from the server for the given request. \cr
\bold{run_date}  \tab \code{character} \tab indicating the date the given response was received. \cr
\bold{n} \tab \code{integer} \tab indicating iteration ID. Is only different from 1, when \code{reps > 1}.  \cr
}
\if{html}{\out{<br>}}
If any requests failed, the \code{gpt} object contains an
error dataset (\code{error_data}) containing the same variables as \code{answer_data}
but with failed request references only.\if{html}{\out{
<br>
}}


When the same question is requested multiple times, the \code{answer_data_aggregated} data contains the following \emph{mandatory} variables:
\tabular{lll}{
\bold{studyid} \tab \code{integer} \tab indicating the study ID of the reference. \cr
\bold{title} \tab \code{character} \tab indicating the title of the reference. \cr
\bold{abstract} \tab \code{character}   \tab indicating the abstract of the reference. \cr
\bold{promptid} \tab \code{integer} \tab indicating the prompt ID. \cr
\bold{prompt} \tab \code{character} \tab indicating the prompt. \cr
\bold{model} \tab \code{character}   \tab indicating the specific gpt-model used. \cr
\bold{question} \tab \code{character} \tab indicating the final question sent to OpenAI's GPT API models. \cr
\bold{top_p} \tab \code{numeric}  \tab indicating the applied top_p. \cr
\bold{incl_p} \tab \code{numeric}  \tab indicating the probability of inclusion calculated across multiple repeated responses on the same title and abstract. \cr
\bold{final_decision_gpt} \tab \code{character} \tab indicating the final decision reached by gpt - either 'Include', 'Exclude', or 'Check'. \cr
\bold{final_decision_gpt_num}  \tab \code{integer}  \tab indicating the final numeric decision reached by gpt - either 1 or 0. \cr
\bold{longest_answer}  \tab \code{character} \tab indicating the longest gpt response obtained
across multiple repeated responses on the same title and abstract. Only included when \code{decision_description = TRUE}.
See 'Examples' below for how to use this function. \cr
\bold{reps}  \tab \code{integer}  \tab indicating the number of times the same question has been sent to OpenAI's GPT API models. \cr
\bold{n_mis_answers} \tab \code{integer} \tab indicating the number of missing responses. \cr
\bold{submodel} \tab \code{character} \tab indicating the exact (sub)model used for screening. \cr
}
\if{html}{\out{<br>}}

The \code{price_data} data contains the following variables:
\tabular{lll}{
\bold{prompt} \tab \code{character} \tab if multiple prompts are used this variable indicates the given prompt-id. \cr
\bold{model} \tab \code{character} \tab the specific gpt model used. \cr
\bold{iterations} \tab \code{integer} \tab indicating the number of times the same question was requested.  \cr
\bold{input_price_dollar} \tab \code{integer} \tab price for all prompt/input tokens for the correspondent gpt-model. \cr
\bold{output_price_dollar}  \tab \code{integer} \tab price for all completion/output tokens for the correspondent gpt-model. \cr
\bold{total_price_dollar} \tab \code{integer} \tab total price for all tokens for the correspondent gpt-model. \cr
}

Find current token pricing at \url{https://openai.com/pricing} or \link{model_prizes}.
}
\examples{
\dontrun{

library(future)

set_api_key()

prompt <- "Is this study about a Functional Family Therapy (FFT) intervention?"

plan(multisession)

tabscreen_gpt(
  data = filges2015_dat[1:2,],
  prompt = prompt,
  studyid = studyid,
  title = title,
  abstract = abstract
  )

plan(sequential)

 # Get detailed descriptions of the gpt decisions.

 plan(multisession)

 tabscreen_gpt(
   data = filges2015_dat[1:2,],
   prompt = prompt,
   studyid = studyid,
   title = title,
   abstract = abstract,
   decision_description = TRUE
 )

plan(sequential)

}
}
\references{
Vembye, M. H., Christensen, J., Mølgaard, A. B., & Schytt, F. L. W. (2025)
\emph{GPT API Models Can Function as Highly Reliable Second Screeners of Titles and Abstracts in Systematic Reviews:
A Proof of Concept and Common Guidelines} \url{https://osf.io/preprints/osf/yrhzm}

Thomas, J. et al. (2024).
Responsible AI in Evidence SynthEsis (RAISE): guidance and recommendations.
\url{https://osf.io/cn7x4}

Wickham H (2023).
\emph{httr2: Perform HTTP Requests and Process the Responses}.
\url{https://httr2.r-lib.org}, \url{https://github.com/r-lib/httr2}.
}
