/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class DataBlocksResults {
    private DataBlockStorage data;
    private int[] cdims;
    private int start;

    public void clear() {
        this.data = null;
    }

    public int getRowsDim() {
        return this.data.getDim();
    }

    public int getColumnsDim(int t) {
        int st = t - this.start;
        if (st < 0) {
            return 0;
        }
        return this.cdims[st + 1] - this.cdims[st];
    }

    public void prepare(int dim, int cmax, int n) {
        this.clear();
        this.data = new DataBlockStorage(dim, cmax * (n - this.start));
        this.cdims = new int[n - this.start + 1];
    }

    public FastMatrix matrix(int t) {
        int st = t - this.start;
        if (st < 0) {
            return null;
        }
        int c0 = this.cdims[st];
        int c1 = this.cdims[st + 1];
        return this.data.matrix(c0, c1);
    }

    public void save(int t, FastMatrix P) {
        int st = t - this.start;
        if (st < 0) {
            return;
        }
        int icur = this.cdims[st];
        this.redimc(st + 2);
        int capacity = this.data.getCapacity();
        int ncapacity = icur + P.getColumnsCount();
        if (capacity <= ncapacity) {
            this.data.resize(ncapacity << 1);
        }
        DataBlockIterator cols = P.columnsIterator();
        while (cols.hasNext()) {
            this.data.save(icur++, cols.next());
        }
        this.cdims[st + 1] = icur;
    }

    public int getStartSaving() {
        return this.start;
    }

    public void setStartSaving(int p) {
        this.start = p;
        this.data = null;
    }

    private void redimc(int ndim) {
        if (ndim <= this.cdims.length) {
            return;
        }
        int n = Math.max(this.cdims.length << 1, DataBlockStorage.calcSize(ndim));
        int[] tmp = new int[n];
        System.arraycopy(this.cdims, 0, tmp, 0, this.cdims.length);
        this.cdims = tmp;
    }

    public void rescale(double factor) {
        this.data.rescale(factor);
    }
}

