/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

public class Cholesky
implements SymmetricMatrix.CholeskyProcessor {
    @Override
    public void ucholesky(FastMatrix U) {
        this.ucholesky(U, 0.0);
    }

    @Override
    public void ucholesky(FastMatrix U, double zero) {
        int n = U.getRowsCount();
        if (n == 0) {
            return;
        }
        double[] pu = U.getStorage();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        if (n == 1) {
            double d = pu[start];
            if (d <= -zero) {
                throw new MatrixException("m_err_chol");
            }
            pu[start] = d < zero ? 0.0 : Math.sqrt(d);
            return;
        }
        int rend = start + n * lda;
        int j = 1;
        int jd = start;
        int jc = start;
        while (j <= n) {
            double ajj = pu[jd];
            for (int i = jc; i < jd; ++i) {
                double d = pu[i];
                ajj -= d * d;
            }
            if (ajj <= -zero || Double.isNaN(ajj)) {
                throw new MatrixException("m_err_chol");
            }
            if (ajj < zero) {
                pu[jd] = 0.0;
                if (j < n) {
                    for (jcc = jc + lda; jcc < rend; jcc += lda) {
                        s = 0.0;
                        ic1 = jcc;
                        ic0 = jc;
                        while (ic0 < jd) {
                            s += pu[ic0] * pu[ic1];
                            ++ic0;
                            ++ic1;
                        }
                        if (Math.abs(pu[ic1] - s) > zero) {
                            throw new MatrixException("m_err_chol");
                        }
                        pu[ic1] = 0.0;
                    }
                }
            } else {
                pu[jd] = ajj = Math.sqrt(ajj);
                if (j < n) {
                    for (jcc = jc + lda; jcc < rend; jcc += lda) {
                        s = 0.0;
                        ic1 = jcc;
                        ic0 = jc;
                        while (ic0 < jd) {
                            s += pu[ic0] * pu[ic1];
                            ++ic0;
                            ++ic1;
                        }
                        pu[ic1] = (pu[ic1] - s) / ajj;
                    }
                }
            }
            ++j;
            jd += lda + 1;
            jc += lda;
        }
    }

    @Override
    public void lcholesky(FastMatrix L, double zero) {
        int n = L.getRowsCount();
        if (n == 0) {
            return;
        }
        double[] pl = L.getStorage();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        if (n == 1) {
            double d = pl[start];
            if (d <= -zero) {
                throw new MatrixException("m_err_chol");
            }
            pl[start] = d < zero ? 0.0 : Math.sqrt(d);
            return;
        }
        int dinc = 1 + lda;
        int end = start + n * dinc;
        int idiag = start;
        int irow = start;
        int cend = start + n;
        while (idiag != end) {
            double aii = pl[idiag];
            for (int j = irow; j != idiag; j += lda) {
                double x = pl[j];
                aii -= x * x;
            }
            if (aii <= -zero) {
                throw new MatrixException("m_err_chol");
            }
            if (aii < zero) {
                pl[idiag] = 0.0;
                for (jx = irow; jx != idiag; jx += lda) {
                    temp = pl[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy = idiag + 1;
                    while (iy < cend) {
                        int n2 = iy++;
                        pl[n2] = pl[n2] - temp * pl[ia];
                        ++ia;
                    }
                }
                for (int iy = idiag + 1; iy < cend; ++iy) {
                    if (Math.abs(pl[iy]) > zero) {
                        throw new MatrixException("m_err_chol");
                    }
                    pl[iy] = 0.0;
                }
            } else {
                pl[idiag] = aii = Math.sqrt(aii);
                for (jx = irow; jx != idiag; jx += lda) {
                    temp = pl[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy = idiag + 1;
                    while (iy < cend) {
                        int n3 = iy++;
                        pl[n3] = pl[n3] - temp * pl[ia];
                        ++ia;
                    }
                }
                double scale = 1.0 / aii;
                int iy = idiag + 1;
                while (iy < cend) {
                    int n4 = iy++;
                    pl[n4] = pl[n4] * scale;
                }
            }
            ++irow;
            idiag += dinc;
            cend += lda;
        }
    }
}

