/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class AlgorithmDescriptor
implements Comparable<AlgorithmDescriptor> {
    private final String family;
    private final String name;
    private final String version;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.family != null && this.family.length() > 0) {
            builder.append(this.family).append('/');
        }
        builder.append(this.name);
        if (this.version != null && this.version.length() > 0) {
            builder.append(" (").append(this.version).append(')');
        }
        return builder.toString();
    }

    public boolean match(String family, String name, String version) {
        if (family != null && !family.equalsIgnoreCase(this.family)) {
            return false;
        }
        if (!name.equalsIgnoreCase(this.name)) {
            return false;
        }
        return version == null || version.equalsIgnoreCase(this.version);
    }

    public boolean isCompatible(AlgorithmDescriptor information) {
        return this.match(information.family, information.name, information.version);
    }

    @Override
    public int compareTo(AlgorithmDescriptor o) {
        int cmp = this.family.compareToIgnoreCase(o.family);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareToIgnoreCase(o.name);
        if (cmp != 0) {
            return cmp;
        }
        if (this.version == null) {
            if (o.version == null) {
                return 0;
            }
            return -1;
        }
        if (o.version == null) {
            return 1;
        }
        return this.version.compareToIgnoreCase(o.version);
    }

    @Generated
    public AlgorithmDescriptor(String family, String name, String version) {
        this.family = family;
        this.name = name;
        this.version = version;
    }

    @Generated
    public String getFamily() {
        return this.family;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlgorithmDescriptor)) {
            return false;
        }
        AlgorithmDescriptor other = (AlgorithmDescriptor)o;
        String this$family = this.getFamily();
        String other$family = other.getFamily();
        if (this$family == null ? other$family != null : !this$family.equals(other$family)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $family = this.getFamily();
        result = result * 59 + ($family == null ? 43 : $family.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

