/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.ArimaSeriesGenerator;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.random.XorshiftRNG;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.SarimaUtility;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.regarima.RegArimaEstimationProto;
import jdplus.toolkit.base.protobuf.regarima.RegArimaProtos;
import lombok.Generated;

public final class SarimaModels {
    public static SarimaModel of(int period, double[] phi, int d, double[] theta, double[] bphi, int bd, double[] btheta) {
        return SarimaModel.builder((int)period).phi(phi).differencing(d, bd).theta(theta).bphi(bphi).btheta(btheta).build();
    }

    public static double[] random(int length, int period, double[] phi, int d, double[] theta, double[] bphi, int bd, double[] btheta, double stde, int tdegree, int seed) {
        if (stde == 0.0) {
            stde = 1.0;
        }
        XorshiftRNG rnd = seed < 0 ? XorshiftRNG.fromSystemNanoTime() : new XorshiftRNG(seed);
        SarimaModel sarima = SarimaModel.builder((int)period).differencing(d, bd).phi(phi).theta(theta).bphi(bphi).btheta(btheta).build();
        ArimaSeriesGenerator generator = ArimaSeriesGenerator.builder((RandomNumberGenerator)rnd).distribution((ContinuousDistribution)(tdegree <= 0 ? new Normal(0.0, stde) : new T((double)tdegree))).startMean(10.0 * stde).startStdev(stde).build();
        return generator.generate((IArimaModel)sarima, length);
    }

    public static SarimaModel hannanRissanen(double[] data, int[] regular, int period, int[] seasonal, String initialization, boolean biasCorrection, boolean finalCorrection) {
        DataBlock x;
        BackFilter ur;
        SarimaOrders spec = new SarimaOrders(period);
        spec.setRegular(regular[0], regular[1], regular[2]);
        if (seasonal != null) {
            spec.setSeasonal(seasonal[0], seasonal[1], seasonal[2]);
            ur = SarimaUtility.differencingFilter((int)period, (int)regular[1], (int)seasonal[1]);
        } else {
            ur = SarimaUtility.differencingFilter((int)1, (int)regular[1], (int)0);
        }
        SarmaOrders dspec = spec.doStationary();
        HannanRissanen hr = HannanRissanen.builder().initialization(HannanRissanen.Initialization.valueOf((String)initialization)).biasCorrection(biasCorrection).finalCorrection(finalCorrection).build();
        int d = ur.getDegree();
        if (d > 0) {
            double[] tmp = new double[data.length - d];
            x = DataBlock.of((double[])tmp);
            ur.apply(DataBlock.of((double[])data), x);
        } else {
            x = DataBlock.of((double[])data);
        }
        hr.process((DoubleSeq)x, dspec);
        SarimaModel model = hr.getModel();
        if (d > 0) {
            model = model.toBuilder().differencing(spec.getD(), spec.getBd()).build();
        }
        return model;
    }

    public static RegArimaEstimation<SarimaModel> estimate(double[] data, int[] regular, int period, int[] seasonal, boolean mean, Matrix X, double[] parameters, double eps) {
        SarimaSpec.Builder builder = SarimaSpec.builder().period(period);
        if (parameters != null) {
            int q;
            int cur = 0;
            int p = regular[0];
            if (p > 0) {
                builder.phi(Parameter.of((DoubleSeq)DoubleSeq.of((double[])parameters, (int)cur, (int)p), (ParameterType)ParameterType.Fixed));
                cur += p;
            }
            if ((q = regular[2]) > 0) {
                builder.theta(Parameter.of((DoubleSeq)DoubleSeq.of((double[])parameters, (int)cur, (int)q), (ParameterType)ParameterType.Fixed));
                cur += q;
            }
            if (seasonal != null) {
                int bq;
                int bp = seasonal[0];
                if (bp > 0) {
                    builder.bphi(Parameter.of((DoubleSeq)DoubleSeq.of((double[])parameters, (int)cur, (int)bp), (ParameterType)ParameterType.Fixed));
                    cur += bp;
                }
                if ((bq = seasonal[2]) > 0) {
                    builder.theta(Parameter.of((DoubleSeq)DoubleSeq.of((double[])parameters, (int)cur, (int)bq), (ParameterType)ParameterType.Fixed));
                }
            }
        } else {
            builder.p(regular[0]).d(regular[1]).q(regular[2]);
            if (seasonal != null) {
                builder.bp(seasonal[0]).bd(seasonal[1]).bq(seasonal[2]);
            }
        }
        SarimaSpec sarima = (SarimaSpec)builder.build();
        RegArimaModel regarima = RegArimaModel.builder().arima((IArimaModel)SarimaModel.builder((SarimaSpec)sarima).build()).y(DoubleSeq.of((double[])data)).meanCorrection(mean).addX(FastMatrix.of((Matrix)X)).build();
        RegSarimaComputer processor = RegSarimaComputer.builder().startingPoint(RegSarimaComputer.StartingPoint.HannanRissanen).computeExactFinalDerivatives(true).useParallelProcessing(true).precision(eps).build();
        RegArimaEstimation rslt = processor.process(regarima, (IArimaMapping)SarimaMapping.of((SarimaOrders)sarima.orders()));
        return rslt;
    }

    public static double[] spectrum(SarimaModel m, int n) {
        DoubleUnaryOperator s = m.getSpectrum().asFunction();
        double[] g = new double[n];
        double q = Math.PI / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double w = q * (double)i;
            g[i] = s.applyAsDouble(w);
        }
        return g;
    }

    public static ArimaModel convert(SarimaModel model) {
        return ArimaModel.of((IArimaModel)model);
    }

    public static double[] acf(SarimaModel m, int n) {
        AutoCovarianceFunction acf = ((SarimaModel)m.stationaryTransformation().getStationaryModel()).getAutoCovarianceFunction();
        acf.prepare(n);
        double[] g = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            g[i] = acf.get(i);
        }
        return g;
    }

    public static byte[] toBuffer(SarimaModel model) {
        int i;
        ModellingProtos.SarimaModel.Builder builder = ModellingProtos.SarimaModel.newBuilder().setName("sarima").setPeriod(model.getPeriod()).setD(model.getD()).setBd(model.getBd());
        for (i = 1; i <= model.getP(); ++i) {
            builder.addPhi(model.phi(i));
        }
        for (i = 1; i <= model.getBp(); ++i) {
            builder.addBphi(model.bphi(i));
        }
        for (i = 1; i <= model.getQ(); ++i) {
            builder.addTheta(model.theta(i));
        }
        for (i = 1; i <= model.getBq(); ++i) {
            builder.addBtheta(model.btheta(i));
        }
        return builder.build().toByteArray();
    }

    public static byte[] toBuffer(RegArimaEstimation<SarimaModel> regarima) {
        RegArimaProtos.RegArimaModel.Estimation estimation = RegArimaEstimationProto.convert(regarima);
        return estimation.toByteArray();
    }

    @Generated
    private SarimaModels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

