## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----libname------------------------------------------------------------------
datdir <- file.path(gsub("\\","/",tempdir(),fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
adamdata <- repfun::ru_libname(datdir)

## ----subset-------------------------------------------------------------------
adsl <- adamdata$adsl.rda() %>% dplyr::filter(SAFFL=='Y') -> adsl1

## ----display------------------------------------------------------------------
knitr::kable(head(adsl[,c(1:10)],10), caption = "Libname Style Access to ADSL")

