/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MachineAccuracy;
import dr.math.MultivariateFunction;
import dr.math.UnivariateFunction;
import dr.math.UnivariateMinimum;

public class LineFunction
implements UnivariateFunction {
    private MultivariateFunction f;
    private int lowerBoundParam;
    private int upperBoundParam;
    private int dim;
    private double lowerBound;
    private double upperBound;
    private double[] s;
    private double[] d;
    private double[] x;
    private UnivariateMinimum um = null;

    public LineFunction(MultivariateFunction multivariateFunction) {
        this.f = multivariateFunction;
        this.dim = this.f.getNumArguments();
        this.x = new double[this.dim];
    }

    public void update(double[] dArray, double[] dArray2) {
        this.s = dArray;
        this.d = dArray2;
        this.computeBounds();
    }

    public void getPoint(double d, double[] dArray) {
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.s[i] + d * this.d[i];
        }
    }

    @Override
    public double evaluate(double d) {
        this.getPoint(d, this.x);
        return this.f.evaluate(this.x);
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    public double findMinimum() {
        if (this.um == null) {
            this.um = new UnivariateMinimum();
        }
        return this.um.findMinimum(this);
    }

    public int getUpperBoundParameter() {
        return this.upperBoundParam;
    }

    public int getLowerBoundParameter() {
        return this.lowerBoundParam;
    }

    public boolean checkPoint(double[] dArray) {
        boolean bl = false;
        for (int i = 0; i < this.dim; ++i) {
            if (dArray[i] < this.f.getLowerBound(i)) {
                dArray[i] = this.f.getLowerBound(i);
                bl = true;
            }
            if (!(dArray[i] > this.f.getUpperBound(i))) continue;
            dArray[i] = this.f.getUpperBound(i);
            bl = true;
        }
        return bl;
    }

    public int checkVariables(double[] dArray, double[] dArray2, boolean[] blArray) {
        double d = MachineAccuracy.SQRT_EPSILON;
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            blArray[i] = true;
            if (dArray[i] <= this.f.getLowerBound(i) + d) {
                if (!(dArray2[i] > 0.0)) continue;
                blArray[i] = false;
                continue;
            }
            if (dArray[i] >= this.f.getUpperBound(i) - d) {
                if (!(dArray2[i] < 0.0)) continue;
                blArray[i] = false;
                continue;
            }
            ++n;
        }
        return n;
    }

    public int checkDirection(double[] dArray, double[] dArray2) {
        double d = MachineAccuracy.SQRT_EPSILON;
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (dArray[i] <= this.f.getLowerBound(i) + d) {
                if (!(dArray2[i] < 0.0)) continue;
                dArray2[i] = 0.0;
                ++n;
                continue;
            }
            if (!(dArray[i] >= this.f.getUpperBound(i) - d) || !(dArray2[i] > 0.0)) continue;
            dArray2[i] = 0.0;
            ++n;
        }
        return n;
    }

    private void computeBounds() {
        boolean bl = true;
        for (int i = 0; i < this.dim; ++i) {
            if (this.d[i] == 0.0) continue;
            double d = (this.f.getUpperBound(i) - this.s[i]) / this.d[i];
            double d2 = (this.f.getLowerBound(i) - this.s[i]) / this.d[i];
            if (d2 > d) {
                double d3 = d;
                d = d2;
                d2 = d3;
            }
            if (bl) {
                this.lowerBound = d2;
                this.lowerBoundParam = i;
                this.upperBound = d;
                this.upperBoundParam = i;
                bl = false;
                continue;
            }
            if (d2 > this.lowerBound) {
                this.lowerBound = d2;
                this.lowerBoundParam = i;
            }
            if (!(d < this.upperBound)) continue;
            this.upperBound = d;
            this.upperBoundParam = i;
        }
    }
}

