/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import lombok.NonNull;

public final class MultivariateT {
    private static final Normal N = new Normal(0.0, 1.0);
    private final DataBlock location;
    private final FastMatrix scale;
    private final Chi2 chi2;
    private volatile FastMatrix lchol;

    public MultivariateT(DoubleSeq location, FastMatrix scale, double df) {
        this.location = DataBlock.of(location);
        this.scale = scale.deepClone();
        this.chi2 = new Chi2(df);
    }

    public DataBlock getLocation() {
        return this.location;
    }

    public FastMatrix getScale() {
        return this.scale;
    }

    public double getDegreesOfFreedom() {
        return this.chi2.getDegreesofFreedom();
    }

    public void random(@NonNull RandomNumberGenerator rng, DataBlock rnd) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        rnd.set(() -> N.random(rng));
        FastMatrix lm = this.l();
        LowerTriangularMatrix.xL(lm, rnd);
        double z = this.chi2.random(rng);
        rnd.mul(Math.sqrt(this.chi2.getDegreesofFreedom() / z));
        rnd.add(this.location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastMatrix l() {
        FastMatrix tmp = this.lchol;
        if (tmp == null) {
            MultivariateT multivariateT = this;
            synchronized (multivariateT) {
                tmp = this.lchol;
                if (tmp == null) {
                    tmp = this.scale.deepClone();
                    SymmetricMatrix.lcholesky(tmp, Constants.getEpsilon());
                    this.lchol = tmp;
                }
            }
        }
        return this.lchol;
    }
}

