/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.ILinearProcess;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IRationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalFilter;

public final class CrossCovarianceFunction {
    private final RationalFilter m_r;
    private final double m_c;

    public static CrossCovarianceFunction create(IArimaModel m1, IArimaModel m2) {
        try {
            return new CrossCovarianceFunction(RationalFilter.of(FiniteFilter.multiply((IFiniteFilter)new FiniteFilter(m1.getMa()), m2.getMa().mirror()), m1.getAr(), m2.getAr().mirror()), Math.sqrt(m1.getInnovationVariance() * m2.getInnovationVariance()));
        }
        catch (ArimaException ex) {
            return null;
        }
    }

    public CrossCovarianceFunction(ILinearProcess m1, ILinearProcess m2) {
        IRationalFilter f1 = m1.getFilter();
        IRationalFilter f2 = m2.getFilter();
        FiniteFilter n1 = new FiniteFilter(f1.getNumerator());
        FiniteFilter n2 = new FiniteFilter(f2.getNumerator()).mirror();
        BackFilter db1 = f1.getRationalBackFilter().getDenominator();
        BackFilter db2 = f2.getRationalBackFilter().getDenominator();
        ForeFilter df1 = f1.getRationalForeFilter().getDenominator();
        ForeFilter df2 = f2.getRationalForeFilter().getDenominator();
        this.m_r = RationalFilter.of(FiniteFilter.multiply((IFiniteFilter)n1, n2), db1.times(df2.mirror()), df1.times(db2.mirror()));
        this.m_c = Math.sqrt(m1.getInnovationVariance() * m2.getInnovationVariance());
    }

    private CrossCovarianceFunction(RationalFilter r, double c) {
        this.m_r = r;
        this.m_c = c;
    }

    public double get(int k) {
        return this.m_r.weight(k) * this.m_c;
    }

    public int getLBound() {
        return this.m_r.getLBound();
    }

    public int getUBound() {
        return this.m_r.getUBound();
    }

    public boolean hasLBound() {
        return this.m_r.hasLowerBound();
    }

    public boolean hasUBound() {
        return this.m_r.hasUpperBound();
    }

    public void prepare(int n, int m) {
        this.m_r.prepare(n, m);
    }
}

