/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.NormalStatisticsProvider;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.repeatedMeasures.MultiplicativeGammaGibbsHelper;
import dr.math.distributions.NormalDistribution;
import dr.xml.Reportable;

public class IndependentNormalDistributionModel
extends AbstractModelLikelihood
implements NormalStatisticsProvider,
MultiplicativeGammaGibbsHelper,
GradientWrtParameterProvider,
Reportable {
    Parameter mean;
    Parameter variance;
    Parameter precision;
    Parameter data;
    boolean usePrecision;
    public static String INDEPENDENT_NORMAL_DISTRIBUTION_MODEL = "independentNormalDistributionModel";

    public IndependentNormalDistributionModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(string);
        this.addVariable(parameter);
        this.mean = parameter;
        if (parameter3 != null) {
            this.usePrecision = true;
            this.addVariable(parameter3);
        } else {
            this.usePrecision = false;
            this.addVariable(parameter2);
        }
        this.precision = parameter3;
        this.variance = parameter2;
        this.data = parameter4;
        this.addVariable(parameter4);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.data.getDimension(); ++i) {
            double d2 = this.getNormalSD(i);
            d += NormalDistribution.logPdf(this.data.getParameterValue(i), this.mean.getParameterValue(i), d2);
        }
        return d;
    }

    @Override
    public void makeDirty() {
    }

    public boolean precisionUsed() {
        return this.usePrecision;
    }

    public Parameter getPrecision() {
        return this.precision;
    }

    public Parameter getVariance() {
        return this.variance;
    }

    public Parameter getMean() {
        return this.mean;
    }

    public Parameter getData() {
        return this.data;
    }

    @Override
    public double getNormalMean(int n) {
        return this.mean.getParameterValue(n);
    }

    @Override
    public double getNormalSD(int n) {
        if (this.usePrecision) {
            return 1.0 / Math.sqrt(this.precision.getParameterValue(n));
        }
        return Math.sqrt(this.variance.getParameterValue(n));
    }

    @Override
    public double computeSumSquaredErrors(int n) {
        double d = this.mean.getParameterValue(n) - this.data.getParameterValue(n);
        return d * d;
    }

    @Override
    public int getRowDimension() {
        return 1;
    }

    @Override
    public int getColumnDimension() {
        return this.data.getDimension();
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.data;
    }

    @Override
    public int getDimension() {
        return this.data.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            double d = this.getNormalSD(i);
            dArray[i] = NormalDistribution.gradLogPdf(this.data.getParameterValue(i), this.mean.getParameterValue(i), d);
        }
        return dArray;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder(INDEPENDENT_NORMAL_DISTRIBUTION_MODEL + " report:\n");
        stringBuilder.append("\tlogLikelihood: " + this.getLogLikelihood() + "\n");
        stringBuilder.append("\tgradient: ");
        double[] dArray = this.getGradientLogDensity();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i] + " ");
        }
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

