/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.epidemiology.casetocase.AbstractOutbreak;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.model.ParameterParser;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class PartitionedTreeModelParser
extends AbstractXMLObjectParser {
    public static final String ROOT_HEIGHT = "rootHeight";
    public static final String LEAF_HEIGHT = "leafHeight";
    public static final String LEAF_TRAIT = "leafTrait";
    public static final String NODE_HEIGHTS = "nodeHeights";
    public static final String NODE_RATES = "nodeRates";
    public static final String NODE_TRAITS = "nodeTraits";
    public static final String MULTIVARIATE_TRAIT = "traitDimension";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String ROOT_NODE = "rootNode";
    public static final String INTERNAL_NODES = "internalNodes";
    public static final String LEAF_NODES = "leafNodes";
    public static final String LEAF_HEIGHTS = "leafHeights";
    public static final String FIRE_TREE_EVENTS = "fireTreeEvents";
    public static final String TAXON = "taxon";
    public static final String NAME = "name";
    public static final String OUTBREAK = "outbreak";
    public static final String STARTING_TT_FILE = "startingTransmissionTreeFile";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Tree.class), new ElementRule("rootHeight", Parameter.class, "A parameter definition with id only (cannot be a reference!)", false), new ElementRule("nodeHeights", new XMLSyntaxRule[]{AttributeRule.newBooleanRule("rootNode", true, "If true the root height is included in the parameter"), AttributeRule.newBooleanRule("internalNodes", true, "If true the internal node heights (minus the root) are included in the parameter"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 1, Integer.MAX_VALUE), new ElementRule("leafHeight", new XMLSyntaxRule[]{AttributeRule.newStringRule("taxon", false, "The name of the taxon for the leaf"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 0, Integer.MAX_VALUE), new ElementRule("nodeTraits", new XMLSyntaxRule[]{AttributeRule.newStringRule("name", false, "The name of the trait attribute in the taxa"), AttributeRule.newBooleanRule("rootNode", true, "If true the root trait is included in the parameter"), AttributeRule.newBooleanRule("internalNodes", true, "If true the internal node traits (minus the root) are included in the parameter"), AttributeRule.newBooleanRule("leafNodes", true, "If true the leaf node traits are included in the parameter"), AttributeRule.newIntegerRule("traitDimension", true, "The number of dimensions (if multivariate)"), AttributeRule.newDoubleRule("initialValue", true, "The initial value(s)"), AttributeRule.newBooleanRule("fireTreeEvents", true, "Whether to fire tree events if the traits change"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 0, Integer.MAX_VALUE), new ElementRule("nodeRates", new XMLSyntaxRule[]{AttributeRule.newBooleanRule("rootNode", true, "If true the root rate is included in the parameter"), AttributeRule.newBooleanRule("internalNodes", true, "If true the internal node rate (minus the root) are included in the parameter"), AttributeRule.newBooleanRule("leafNodes", true, "If true the leaf node rate are included in the parameter"), AttributeRule.newDoubleRule("initialValue", true, "The initial value(s)"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 0, Integer.MAX_VALUE), new ElementRule("leafTrait", new XMLSyntaxRule[]{AttributeRule.newStringRule("taxon", false, "The name of the taxon for the leaf"), AttributeRule.newStringRule("name", false, "The name of the trait attribute in the taxa"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 0, Integer.MAX_VALUE), new ElementRule("leafHeights", new XMLSyntaxRule[]{new ElementRule(TaxonList.class, "A set of taxa for which leaf heights are required"), new ElementRule(Parameter.class, "A compound parameter containing the leaf heights")}, true), new ElementRule("outbreak", AbstractOutbreak.class, "The case data"), AttributeRule.newStringRule("startingTransmissionTreeFile", true)};

    @Override
    public String getParserName() {
        return "partitionedTreeModel";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Tree tree = (Tree)xMLObject.getChild(Tree.class);
        AbstractOutbreak abstractOutbreak = (AbstractOutbreak)xMLObject.getElementFirstChild(OUTBREAK);
        PartitionedTreeModel partitionedTreeModel = xMLObject.hasAttribute(STARTING_TT_FILE) ? new PartitionedTreeModel(xMLObject.getId(), tree, abstractOutbreak, xMLObject.getStringAttribute(STARTING_TT_FILE)) : new PartitionedTreeModel(xMLObject.getId(), tree, abstractOutbreak);
        Logger.getLogger("dr.evomodel").info("Creating the partitioned tree model, '" + xMLObject.getId() + "'");
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            if (xMLObject.getChild(i) instanceof XMLObject) {
                Object object;
                int n;
                Object object22;
                XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                if (xMLObject2.getName().equals(ROOT_HEIGHT)) {
                    ParameterParser.replaceParameter(xMLObject2, partitionedTreeModel.getRootHeightParameter());
                    continue;
                }
                if (xMLObject2.getName().equals(LEAF_HEIGHT)) {
                    if (!xMLObject2.hasAttribute(TAXON)) {
                        throw new XMLParseException("taxa element missing from leafHeight element in treeModel element");
                    }
                    String string = xMLObject2.getStringAttribute(TAXON);
                    int n2 = partitionedTreeModel.getTaxonIndex(string);
                    if (n2 == -1) {
                        throw new XMLParseException("taxon " + string + " not found for leafHeight element in treeModel element");
                    }
                    NodeRef nodeRef = partitionedTreeModel.getExternalNode(n2);
                    Parameter parameter = partitionedTreeModel.getLeafHeightParameter(nodeRef);
                    ParameterParser.replaceParameter(xMLObject2, parameter);
                    object22 = partitionedTreeModel.getTaxon(n2);
                    this.setPrecisionBounds(parameter, (Taxon)object22);
                    continue;
                }
                if (xMLObject2.getName().equals(LEAF_HEIGHTS)) {
                    TaxonList taxonList = (TaxonList)xMLObject2.getChild(TaxonList.class);
                    Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
                    CompoundParameter compoundParameter = new CompoundParameter(LEAF_HEIGHTS);
                    for (Object object22 : taxonList) {
                        n = partitionedTreeModel.getTaxonIndex((Taxon)object22);
                        if (n == -1) {
                            throw new XMLParseException("taxon " + ((Taxon)object22).getId() + " not found for leafHeight element in treeModel element");
                        }
                        object = partitionedTreeModel.getExternalNode(n);
                        Parameter parameter2 = partitionedTreeModel.getLeafHeightParameter((NodeRef)object);
                        compoundParameter.addParameter(parameter2);
                        this.setPrecisionBounds(parameter2, (Taxon)object22);
                    }
                    ParameterParser.replaceParameter(xMLObject2, compoundParameter);
                    continue;
                }
                if (xMLObject2.getName().equals(NODE_HEIGHTS)) {
                    boolean bl = xMLObject2.getAttribute(ROOT_NODE, false);
                    boolean bl2 = xMLObject2.getAttribute(INTERNAL_NODES, false);
                    boolean bl3 = xMLObject2.getAttribute(LEAF_NODES, false);
                    if (!(bl || bl2 || bl3)) {
                        throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeHeights element");
                    }
                    ParameterParser.replaceParameter(xMLObject2, partitionedTreeModel.createNodeHeightsParameter(bl, bl2, bl3));
                    continue;
                }
                if (xMLObject2.getName().equals(NODE_RATES)) {
                    boolean bl = xMLObject2.getAttribute(ROOT_NODE, false);
                    boolean bl4 = xMLObject2.getAttribute(INTERNAL_NODES, false);
                    boolean bl5 = xMLObject2.getAttribute(LEAF_NODES, false);
                    double[] dArray = null;
                    if (xMLObject2.hasAttribute(INITIAL_VALUE)) {
                        dArray = xMLObject2.getDoubleArrayAttribute(INITIAL_VALUE);
                    }
                    if (!(bl || bl4 || bl5)) {
                        throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeRates element");
                    }
                    ParameterParser.replaceParameter(xMLObject2, partitionedTreeModel.createNodeRatesParameter(dArray, bl, bl4, bl5));
                    continue;
                }
                if (xMLObject2.getName().equals(NODE_TRAITS)) {
                    boolean bl = xMLObject2.getAttribute(ROOT_NODE, false);
                    boolean bl6 = xMLObject2.getAttribute(INTERNAL_NODES, false);
                    boolean bl7 = xMLObject2.getAttribute(LEAF_NODES, false);
                    boolean bl8 = xMLObject2.getAttribute(FIRE_TREE_EVENTS, false);
                    object22 = xMLObject2.getAttribute(NAME, "trait");
                    n = xMLObject2.getAttribute(MULTIVARIATE_TRAIT, 1);
                    object = null;
                    if (xMLObject2.hasAttribute(INITIAL_VALUE)) {
                        object = xMLObject2.getDoubleArrayAttribute(INITIAL_VALUE);
                    }
                    if (!(bl || bl6 || bl7)) {
                        throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeTraits element");
                    }
                    ParameterParser.replaceParameter(xMLObject2, partitionedTreeModel.createNodeTraitsParameter((String)object22, n, (double[])object, bl, bl6, bl7, bl8));
                    continue;
                }
                if (xMLObject2.getName().equals(LEAF_TRAIT)) {
                    String string = xMLObject2.getAttribute(NAME, "trait");
                    if (!xMLObject2.hasAttribute(TAXON)) {
                        throw new XMLParseException("taxa element missing from leafTrait element in treeModel element");
                    }
                    String string2 = xMLObject2.getStringAttribute(TAXON);
                    int n3 = partitionedTreeModel.getTaxonIndex(string2);
                    if (n3 == -1) {
                        throw new XMLParseException("taxon '" + string2 + "' not found for leafTrait element in treeModel element");
                    }
                    NodeRef nodeRef = partitionedTreeModel.getExternalNode(n3);
                    object22 = partitionedTreeModel.getNodeTraitParameter(nodeRef, string);
                    if (object22 == null) {
                        throw new XMLParseException("trait '" + string + "' not found for leafTrait (taxon, " + string2 + ") element in treeModel element");
                    }
                    ParameterParser.replaceParameter(xMLObject2, (Parameter)object22);
                    continue;
                }
                if (xMLObject2.getName().equals(OUTBREAK)) continue;
                throw new XMLParseException("illegal child element in " + this.getParserName() + ": " + xMLObject2.getName());
            }
            if (xMLObject.getChild(i) instanceof Tree) continue;
            throw new XMLParseException("illegal child element in  " + this.getParserName() + ": " + xMLObject.getChildName(i) + " " + xMLObject.getChild(i));
        }
        Logger.getLogger("dr.evomodel").info("  initial tree topology = " + TreeUtils.uniqueNewick(partitionedTreeModel, partitionedTreeModel.getRoot()));
        Logger.getLogger("dr.evomodel").info("  tree height = " + partitionedTreeModel.getNodeHeight(partitionedTreeModel.getRoot()));
        return partitionedTreeModel;
    }

    private void setPrecisionBounds(Parameter parameter, Taxon taxon) {
        double d;
        Date date = taxon.getDate();
        if (date != null && (d = date.getUncertainty()) > 0.0) {
            double d2 = Taxon.getHeightFromDate(date);
            double d3 = Taxon.getHeightFromDate(date);
            if (date.isBackwards()) {
                d2 += d;
            } else {
                d3 -= d;
            }
            parameter.addBounds(new Parameter.DefaultBounds(d2, d3, 1));
            parameter.setParameterValue(0, (d2 + d3) / 2.0);
        }
    }

    @Override
    public String getParserDescription() {
        return "This element represents a model of a phylogenetic tree together with the partitioning of its nodes into connected subgraphs to represent the transmission tree.";
    }

    @Override
    public Class getReturnType() {
        return PartitionedTreeModel.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

