/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.sa.base.core.diagnostics.ResidualSeasonalityTests;
import jdplus.sa.base.core.diagnostics.SaDiagnosticsUtility;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;

public class AdvancedResidualSeasonalityDiagnostics
implements Diagnostics {
    private StatisticalTest qs_sa;
    private StatisticalTest qs_i;
    private StatisticalTest f_sa;
    private StatisticalTest f_i;
    private double sev;
    private double bad;
    private double unc;

    public static AdvancedResidualSeasonalityDiagnostics of(AdvancedResidualSeasonalityDiagnosticsConfiguration config, GenericSaTests data) {
        if (data == null) {
            return null;
        }
        try {
            AdvancedResidualSeasonalityDiagnostics test = new AdvancedResidualSeasonalityDiagnostics();
            ResidualSeasonalityTests rsa = data.residualSeasonalityTestsOnSa();
            ResidualSeasonalityTests ri = data.residualSeasonalityTestsOnIrregular();
            if (rsa == null || ri == null) {
                return null;
            }
            TsData sa = rsa.getSeries();
            TsData i = ri.getSeries();
            if (sa == null || i == null) {
                return null;
            }
            boolean isignif = SaDiagnosticsUtility.isSignificant(i.getValues(), sa.getValues());
            if (config.isQs()) {
                test.qs_sa = rsa.qsTest();
                if (isignif) {
                    test.qs_i = ri.qsTest();
                }
            }
            if (config.isFtest()) {
                test.f_sa = rsa.fTest();
                if (isignif) {
                    test.f_i = ri.fTest();
                }
            }
            test.sev = config.getSevereThreshold();
            test.bad = config.getBadThreshold();
            test.unc = config.getUncertainThreshold();
            return test;
        }
        catch (Exception err) {
            return null;
        }
    }

    public String getName() {
        return "Residual seasonality tests";
    }

    public List<String> getTests() {
        ArrayList<String> tests = new ArrayList<String>();
        if (this.qs_sa != null) {
            tests.add("Qs test on SA");
        }
        if (this.f_sa != null) {
            tests.add("F-Test on SA (seasonal dummies)");
        }
        if (this.qs_i != null) {
            tests.add("Qs test on I");
        }
        if (this.f_i != null) {
            tests.add("F-Test on I (seasonal dummies)");
        }
        return tests;
    }

    public ProcQuality getDiagnostic(String test) {
        switch (test) {
            case "Qs test on SA": {
                return this.quality(this.qs_sa);
            }
            case "F-Test on SA (seasonal dummies)": {
                return this.quality(this.f_sa);
            }
            case "Qs test on I": {
                return this.quality(this.qs_i);
            }
            case "F-Test on I (seasonal dummies)": {
                return this.quality(this.f_i);
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        switch (test) {
            case "Qs test on SA": {
                return this.pvalue(this.qs_sa);
            }
            case "F-Test on SA (seasonal dummies)": {
                return this.pvalue(this.f_sa);
            }
            case "Qs test on I": {
                return this.pvalue(this.qs_i);
            }
            case "F-Test on I (seasonal dummies)": {
                return this.pvalue(this.f_i);
            }
        }
        return Double.NaN;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    public StatisticalTest QsTestOnSa() {
        return this.qs_sa;
    }

    public StatisticalTest QsTestOnI() {
        return this.qs_i;
    }

    public StatisticalTest FTestOnSa() {
        return this.f_sa;
    }

    public StatisticalTest FTestOnI() {
        return this.f_i;
    }

    private ProcQuality quality(StatisticalTest test) {
        if (test == null) {
            return ProcQuality.Undefined;
        }
        double pval = test.getPvalue();
        if (pval < this.sev) {
            return ProcQuality.Severe;
        }
        if (pval < this.bad) {
            return ProcQuality.Bad;
        }
        if (pval < this.unc) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    private double pvalue(StatisticalTest test) {
        return test == null ? Double.NaN : test.getPvalue();
    }
}

