/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.analysis;

import java.util.Arrays;
import jdplus.toolkit.base.core.math.splines.CubicSpline;

public class PiecewiseBicubicSplineInterpolatingFunction {
    private static final int MIN_NUM_POINTS = 5;
    private final double[] xval;
    private final double[] yval;
    private final double[][] fval;

    public PiecewiseBicubicSplineInterpolatingFunction(double[] x, double[] y, double[][] f) {
        int xLen = x.length;
        int yLen = y.length;
        this.xval = x;
        this.yval = y;
        this.fval = f;
    }

    public double value(double x, double y) {
        int offset = 2;
        int count = 5;
        int i = this.searchIndex(x, this.xval, 2, 5);
        int j = this.searchIndex(y, this.yval, 2, 5);
        double[] xArray = new double[5];
        double[] yArray = new double[5];
        double[] zArray = new double[5];
        double[] interpArray = new double[5];
        for (int index = 0; index < 5; ++index) {
            xArray[index] = this.xval[i + index];
            yArray[index] = this.yval[j + index];
        }
        for (int zIndex = 0; zIndex < 5; ++zIndex) {
            double fx;
            for (int index = 0; index < 5; ++index) {
                zArray[index] = this.fval[i + index][j + zIndex];
            }
            interpArray[zIndex] = fx = CubicSpline.of(xArray, zArray).applyAsDouble(x);
        }
        return CubicSpline.of(yArray, interpArray).applyAsDouble(y);
    }

    public boolean isValidPoint(double x, double y) {
        return !(x < this.xval[0] || x > this.xval[this.xval.length - 1] || y < this.yval[0]) && !(y > this.yval[this.yval.length - 1]);
    }

    private int searchIndex(double c, double[] val, int offset, int count) {
        int r = Arrays.binarySearch(val, c);
        if (r == -1 || r == -val.length - 1) {
            return -1;
        }
        r = r < 0 ? -r - offset - 1 : (r -= offset);
        if (r < 0) {
            r = 0;
        }
        if (r + count >= val.length) {
            r = val.length - count;
        }
        return r;
    }
}

