/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class BrentSolver
extends FSolver {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double fa;
    private double fb;
    private double fc;

    public BrentSolver(DoubleUnaryOperator fn, double xLower, double xUpper) {
        this.function = fn;
        this.lower = xLower;
        this.upper = xUpper;
        this.root = 0.5 * (xLower + xUpper);
        double fLower = fn.applyAsDouble(xLower);
        double fUpper = fn.applyAsDouble(xUpper);
        this.a = xLower;
        this.fa = fLower;
        this.b = xUpper;
        this.fb = fUpper;
        this.c = xUpper;
        this.fc = fUpper;
        this.d = xUpper - xLower;
        this.e = xUpper - xLower;
        if (fLower < 0.0 && fUpper < 0.0 || fLower > 0.0 && fUpper > 0.0) {
            throw new GslRootException("Endpoints do not straddle y=0");
        }
    }

    @Override
    public void iterate() {
        boolean ac_equal = false;
        if (this.fb < 0.0 && this.fc < 0.0 || this.fb > 0.0 && this.fc > 0.0) {
            ac_equal = true;
            this.c = this.a;
            this.fc = this.fa;
            this.d = this.b - this.a;
            this.e = this.b - this.a;
        }
        if (Math.abs(this.fc) < Math.abs(this.fb)) {
            ac_equal = true;
            this.a = this.b;
            this.b = this.c;
            this.c = this.a;
            this.fa = this.fb;
            this.fb = this.fc;
            this.fc = this.fa;
        }
        double tol = 0.5 * Math.ulp(1.0) * Math.abs(this.b);
        double m = 0.5 * (this.c - this.b);
        if (this.fb == 0.0) {
            this.root = this.b;
            this.lower = this.b;
            this.upper = this.b;
            return;
        }
        if (Math.abs(m) <= tol) {
            this.root = this.b;
            if (this.b < this.c) {
                this.lower = this.b;
                this.upper = this.c;
            } else {
                this.lower = this.c;
                this.upper = this.b;
            }
            return;
        }
        if (Math.abs(this.e) < tol || Math.abs(this.fa) <= Math.abs(this.fb)) {
            this.d = m;
            this.e = m;
        } else {
            double q;
            double p;
            double s = this.fb / this.fa;
            if (ac_equal) {
                p = 2.0 * m * s;
                q = 1.0 - s;
            } else {
                q = this.fa / this.fc;
                double r = this.fb / this.fc;
                p = s * (2.0 * m * q * (q - r) - (this.b - this.a) * (r - 1.0));
                q = (q - 1.0) * (r - 1.0) * (s - 1.0);
            }
            if (p > 0.0) {
                q = -q;
            } else {
                p = -p;
            }
            if (2.0 * p < Math.min(3.0 * m * q - Math.abs(tol * q), Math.abs(this.e * q))) {
                this.e = this.d;
                this.d = p / q;
            } else {
                this.d = m;
                this.e = m;
            }
        }
        this.a = this.b;
        this.fa = this.fb;
        this.b = Math.abs(this.d) > tol ? (this.b += this.d) : (this.b += m > 0.0 ? tol : -tol);
        this.fb = this.function.applyAsDouble(this.b);
        this.root = this.b;
        if (this.fb < 0.0 && this.fc < 0.0 || this.fb > 0.0 && this.fc > 0.0) {
            this.c = this.a;
        }
        if (this.b < this.c) {
            this.lower = this.b;
            this.upper = this.c;
        } else {
            this.lower = this.c;
            this.upper = this.b;
        }
    }
}

