/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;

public final class AmongGAC
extends AbstractLargeIntSConstraint {
    private final int[] values;
    private final int nb_vars;
    private final IStateBitSet both;
    private final IStateInt LB;
    private final IStateInt UB;
    private TIntHashSet setValues;
    private IStateInt[] occs;

    public AmongGAC(IntDomainVar[] vars, int[] values, IEnvironment environment) {
        super(ConstraintEvent.QUADRATIC, vars);
        this.nb_vars = vars.length - 1;
        this.values = values;
        this.both = environment.makeBitSet(this.nb_vars);
        this.LB = environment.makeInt(0);
        this.UB = environment.makeInt(0);
        this.setValues = new TIntHashSet(values);
        this.occs = new IStateInt[this.nb_vars];
        for (int i = 0; i < this.nb_vars; ++i) {
            this.occs[i] = environment.makeInt(0);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == this.nb_vars) {
            return 11;
        }
        return 12;
    }

    protected void init() {
        this.LB.set(0);
        this.UB.set(0);
        this.both.clear();
        for (int i = 0; i < this.nb_vars; ++i) {
            this.occs[i].set(0);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.init();
        int lb = 0;
        int ub = this.nb_vars;
        for (int i = 0; i < this.nb_vars; ++i) {
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            int nb = 0;
            for (int value : this.values) {
                nb += var.canBeInstantiatedTo(value) ? 1 : 0;
            }
            this.occs[i].set(nb);
            if (nb == var.getDomainSize()) {
                ++lb;
                continue;
            }
            if (nb == 0) {
                --ub;
                continue;
            }
            if (nb <= 0) continue;
            this.both.set(i, true);
        }
        this.LB.set(lb);
        this.UB.set(ub);
        this.filter();
    }

    private void filter() throws ContradictionException {
        int lb = this.LB.get();
        int ub = this.UB.get();
        ((IntDomainVar[])this.vars)[this.nb_vars].updateInf(lb, this, false);
        ((IntDomainVar[])this.vars)[this.nb_vars].updateSup(ub, this, false);
        int min = Math.max(((IntDomainVar[])this.vars)[this.nb_vars].getInf(), lb);
        int max = Math.min(((IntDomainVar[])this.vars)[this.nb_vars].getSup(), ub);
        if (max < min) {
            this.fail();
        }
        if (lb == min && lb == max) {
            this.removeOnlyValues();
            this.setEntailed();
        }
        if (ub == min && ub == max) {
            this.removeButValues();
            this.setEntailed();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == this.nb_vars) {
            this.filter();
        } else if (this.both.get(idx)) {
            IntDomainVar var = ((IntDomainVar[])this.vars)[idx];
            int val = var.getVal();
            if (this.setValues.contains(val)) {
                this.LB.add(1);
                this.both.set(idx, false);
                this.filter();
            } else {
                this.UB.add(-1);
                this.both.set(idx, false);
                this.filter();
            }
        }
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        if (varIdx < this.nb_vars && this.both.get(varIdx)) {
            if (this.setValues.contains(val)) {
                this.occs[varIdx].add(-1);
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[varIdx];
            int nb = this.occs[varIdx].get();
            if (nb == var.getDomainSize()) {
                this.LB.add(1);
                this.both.set(varIdx, false);
                this.filter();
            } else if (nb == 0) {
                this.UB.add(-1);
                this.both.set(varIdx, false);
                this.filter();
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        if (varIdx == this.nb_vars) {
            this.filter();
        }
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        if (varIdx == this.nb_vars) {
            this.filter();
        }
    }

    private void removeOnlyValues() throws ContradictionException {
        int i = this.both.nextSetBit(0);
        while (i >= 0) {
            IntDomainVar v = ((IntDomainVar[])this.vars)[i];
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            for (int value : this.values) {
                if (this.setValues.contains(value)) {
                    this.occs[i].add(-1);
                }
                if (value == right + 1) {
                    right = value;
                    continue;
                }
                v.removeInterval(left, right, this, false);
                left = right = value;
            }
            v.removeInterval(left, right, this, false);
            i = this.both.nextSetBit(i + 1);
        }
    }

    private void removeButValues() throws ContradictionException {
        int i = this.both.nextSetBit(0);
        while (i >= 0) {
            IntDomainVar v = ((IntDomainVar[])this.vars)[i];
            DisposableIntIterator it = v.getDomain().getIterator();
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            while (it.hasNext()) {
                int value = it.next();
                if (this.setValues.contains(value)) continue;
                if (value == right + 1) {
                    right = value;
                    continue;
                }
                v.removeInterval(left, right, this, false);
                left = right = value;
            }
            v.removeInterval(left, right, this, false);
            it.dispose();
            i = this.both.nextSetBit(i + 1);
        }
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer("AMONG(");
        sb.append("[");
        for (int i = 0; i < this.nb_vars; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((IntDomainVar[])this.vars)[i].pretty());
        }
        sb.append("],{");
        StringUtils.pretty(this.values);
        sb.append("},");
        sb.append(((IntDomainVar[])this.vars)[this.nb_vars].pretty()).append(")");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied() {
        if (this.isCompletelyInstantiated()) {
            int nb = 0;
            for (int i = 0; i < this.nb_vars; ++i) {
                if (!this.setValues.contains(((IntDomainVar[])this.vars)[i].getVal())) continue;
                ++nb;
            }
            return ((IntDomainVar[])this.vars)[this.nb_vars].getVal() == nb;
        }
        return false;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int nb = 0;
        for (int i = 0; i < this.nb_vars; ++i) {
            if (!this.setValues.contains(tuple[i])) continue;
            ++nb;
        }
        return tuple[this.nb_vars] == nb;
    }
}

