/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.math.LowPriorityOrderingImplicits;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import sparklyr.BoundedPriorityQueue;
import sparklyr.SamplingUtils;
import sparklyr.Utils$;

public final class SamplingUtils$ {
    public static final SamplingUtils$ MODULE$ = new SamplingUtils$();

    public RDD<Row> sampleWithoutReplacement(RDD<Row> rdd, String weightColumn, int k, long seed) {
        SparkContext sc = rdd.context();
        if (0 == k) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        }
        ConcurrentHashMap prngState = new ConcurrentHashMap();
        BoundedPriorityQueue samples = (BoundedPriorityQueue)rdd.aggregate(new BoundedPriorityQueue(k, LowPriorityOrderingImplicits.ordered$((LowPriorityOrderingImplicits)Ordering$.MODULE$, (Function1)$less$colon$less$.MODULE$.refl())), (Function2 & Serializable)(pq, row) -> {
            double weight = MODULE$.extractWeightValue((Row)row, weightColumn);
            if (weight > 0.0) {
                long sampleSeed = seed + (long)TaskContext$.MODULE$.getPartitionId();
                Random random = prngState.computeIfAbsent(sampleSeed, new SamplingUtils.PRNG());
                SamplingUtils.Sample sample = new SamplingUtils.Sample(MODULE$.genSamplePriority(weight, random), (Row)row);
                if (pq == null) {
                    throw null;
                }
                pq.addOne(sample);
            }
            return pq;
        }, (Function2 & Serializable)(pq1, pq2) -> {
            pq1.$plus$plus$eq(pq2);
            return pq1;
        }, ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
        return sc.parallelize((Seq)samples.toSeq().map((Function1 & Serializable)x -> x.row()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> sampleWithReplacement(RDD<Row> rdd, String weightColumn, int k, long seed) {
        SparkContext sc = rdd.context();
        if (0 == k) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        }
        RDD mapRDDs = rdd.mapPartitionsWithIndex((Function2 & Serializable)(index, iter) -> SamplingUtils$.$anonfun$sampleWithReplacement$1(seed, k, weightColumn, BoxesRunTime.unboxToInt((Object)index), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(SamplingUtils.Sample.class)));
        if (0 == mapRDDs.partitions().length) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        }
        Object[] map$extension_$this = (Object[])mapRDDs.reduce((Function2 & Serializable)(s1, s2) -> {
            void apply_start;
            boolean bl = false;
            if (package$.MODULE$.Range() == null) {
                throw null;
            }
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive((int)apply_start, k, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    SamplingUtils$.$anonfun$sampleWithReplacement$6(s1, s2, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            return s1;
        });
        int map$extension_len = map$extension_$this.length;
        Row[] map$extension_ys = new Row[map$extension_len];
        if (map$extension_len > 0) {
            for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                Row array_update_value;
                map$extension_ys[map$extension_i] = array_update_value = ((SamplingUtils.Sample)map$extension_$this[map$extension_i]).row();
                Object var12_11 = null;
            }
        }
        Object var8_7 = null;
        Object var10_9 = null;
        return sc.parallelize((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)map$extension_ys), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public double genSamplePriority(double weight, Random random) {
        return StrictMath.log(random.nextDouble()) / weight;
    }

    public double extractWeightValue(Row row, String weightColumn) {
        if (weightColumn == null || weightColumn.isEmpty()) {
            return 1.0;
        }
        return Utils$.MODULE$.asDouble(row.get(row.fieldIndex(weightColumn)));
    }

    public static final /* synthetic */ SamplingUtils.Sample $anonfun$sampleWithReplacement$2() {
        return new SamplingUtils.Sample(Double.NEGATIVE_INFINITY, null);
    }

    public static final /* synthetic */ void $anonfun$sampleWithReplacement$4(DoubleRef weight$1, Random random$1, Row row$1, SamplingUtils.Sample[] samples$1, int idx) {
        SamplingUtils.Sample replacement = new SamplingUtils.Sample(MODULE$.genSamplePriority(weight$1.elem, random$1), row$1);
        if (samples$1[idx].$less(replacement)) {
            samples$1[idx] = replacement;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sampleWithReplacement$3(String weightColumn$2, int k$1, Random random$1, SamplingUtils.Sample[] samples$1, Row row) {
        void var7_5;
        double create_e = MODULE$.extractWeightValue(row, weightColumn$2);
        if (var7_5 > 0.0) {
            void apply_start;
            boolean bl = false;
            if (package$.MODULE$.Range() == null) {
                throw null;
            }
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive((int)apply_start, k$1, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    SamplingUtils.Sample $anonfun$sampleWithReplacement$4_replacement;
                    if (samples$1[foreach$mVc$sp_i].$less($anonfun$sampleWithReplacement$4_replacement = new SamplingUtils.Sample(MODULE$.genSamplePriority((double)var7_5, random$1), row))) {
                        samples$1[foreach$mVc$sp_i] = $anonfun$sampleWithReplacement$4_replacement;
                    }
                    Object var10_9 = null;
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            return;
        }
    }

    public static final /* synthetic */ Iterator $anonfun$sampleWithReplacement$1(long seed$2, int k$1, String weightColumn$2, int index, Iterator iter) {
        SamplingUtils.Sample[] sampleArray;
        Random random = new Random(seed$2 + (long)index);
        if (k$1 <= 0) {
            sampleArray = new SamplingUtils.Sample[]{};
        } else {
            SamplingUtils.Sample[] fill_array = new SamplingUtils.Sample[k$1];
            for (int fill_i = 0; fill_i < k$1; ++fill_i) {
                SamplingUtils.Sample array_update_value;
                fill_array[fill_i] = array_update_value = SamplingUtils$.$anonfun$sampleWithReplacement$2();
                Object var10_8 = null;
            }
            sampleArray = fill_array;
        }
        Object var8_6 = null;
        SamplingUtils.Sample[] samples = sampleArray;
        iter.foreach((Function1 & Serializable)row -> {
            SamplingUtils$.$anonfun$sampleWithReplacement$3(weightColumn$2, k$1, random, samples, row);
            return BoxedUnit.UNIT;
        });
        if (package$.MODULE$.Iterator() == null) {
            throw null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final /* synthetic */ void $anonfun$sampleWithReplacement$6(SamplingUtils.Sample[] s1$1, SamplingUtils.Sample[] s2$1, int idx) {
        if (s1$1[idx].$less(s2$1[idx])) {
            s1$1[idx] = s2$1[idx];
            return;
        }
    }

    public static final /* synthetic */ Row $anonfun$sampleWithReplacement$7(SamplingUtils.Sample x) {
        return x.row();
    }

    private SamplingUtils$() {
    }
}

