/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching.domwdeg;

import choco.cp.solver.search.integer.branching.IRandomBreakTies;
import choco.cp.solver.search.integer.branching.domwdeg.DomWDegUtils;
import choco.cp.solver.search.integer.varselector.ratioselector.IntVarRatioSelector;
import choco.cp.solver.search.integer.varselector.ratioselector.MinRatioSelector;
import choco.cp.solver.search.integer.varselector.ratioselector.RandMinRatioSelector;
import choco.cp.solver.search.integer.varselector.ratioselector.ratios.IntRatio;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranchingStrategy;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.listener.PropagationEngineListener;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractDomOverWDegBranching
extends AbstractLargeIntBranchingStrategy
implements PropagationEngineListener,
IRandomBreakTies {
    protected final Solver solver;
    protected final IntRatio[] varRatios;
    private IntVarRatioSelector ratioSelector;
    protected int updateWeightsCount;

    public AbstractDomOverWDegBranching(Solver solver, IntRatio[] varRatios, Number seed) {
        this.solver = solver;
        this.varRatios = varRatios;
        DomWDegUtils.initConstraintExtensions(this.solver);
        DomWDegUtils.initVarExtensions(this.solver);
        this.solver.getPropagationEngine().addPropagationEngineListener(this);
        if (seed == null) {
            this.cancelRandomBreakTies();
        } else {
            this.setRandomBreakTies(seed.longValue());
        }
    }

    public final Solver getSolver() {
        return this.solver;
    }

    public final IntVarRatioSelector getRatioSelector() {
        return this.ratioSelector;
    }

    @Override
    public void cancelRandomBreakTies() {
        this.ratioSelector = new MinRatioSelector(this.solver, this.varRatios);
    }

    @Override
    public void setRandomBreakTies(long seed) {
        this.ratioSelector = new RandMinRatioSelector(this.solver, this.varRatios, seed);
    }

    @Override
    public void initConstraintForBranching(SConstraint c) {
        DomWDegUtils.addConstraintExtension(c);
        DomWDegUtils.addConstraintToVarWeights(c);
    }

    protected abstract int getExpectedUpdateWeightsCount();

    @Override
    public final void initBranching() {
        int n = this.solver.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            IntDomainVar v = this.solver.getIntVar(i);
            DomWDegUtils.getVarExtension(v).set(DomWDegUtils.computeWeightedDegreeFromScratch(v));
        }
        this.updateWeightsCount = this.getExpectedUpdateWeightsCount();
    }

    protected final void reinitBranching() {
        if (this.updateWeightsCount != this.getExpectedUpdateWeightsCount()) {
            this.initBranching();
        }
    }

    private void updateVarWeights(Var currentVar, SConstraint<?> cstr, int delta) {
        if (delta != 0) {
            int n = cstr.getNbVars();
            for (int k = 0; k < n; ++k) {
                AbstractVar var = (AbstractVar)cstr.getVarQuick(k);
                if (var == currentVar || var.isInstantiated()) continue;
                DomWDegUtils.getVarExtension(var).add(delta);
                assert (DomWDegUtils.getVarExtension(var).get() >= 0) : "" + var.getName() + " weight is negative (" + DomWDegUtils.getVarExtension(var).get() + "). This is due to incremental computation of weights in Dom/WDeg.";
            }
        }
    }

    private boolean isDisconnected(SConstraint<?> cstr) {
        return SConstraintType.INTEGER.equals((Object)cstr.getConstraintType()) && DomWDegUtils.hasTwoNotInstVars(cstr);
    }

    protected final void increaseVarWeights(Var currentVar) {
        --this.updateWeightsCount;
        DisposableIterator<SConstraint> iter = currentVar.getConstraintsIterator();
        while (iter.hasNext()) {
            SConstraint cstr = (SConstraint)iter.next();
            if (!this.isDisconnected(cstr)) continue;
            this.updateVarWeights(currentVar, cstr, DomWDegUtils.getConstraintExtension(cstr).get());
        }
        iter.dispose();
    }

    protected final void decreaseVarWeights(Var currentVar) {
        ++this.updateWeightsCount;
        DisposableIterator<SConstraint> iter = currentVar.getConstraintsIterator();
        while (iter.hasNext()) {
            SConstraint cstr = (SConstraint)iter.next();
            if (!this.isDisconnected(cstr)) continue;
            this.updateVarWeights(currentVar, cstr, -DomWDegUtils.getConstraintExtension(cstr).get());
        }
        iter.dispose();
    }

    @Override
    public final void contradictionOccured(ContradictionException e) {
        if (this.updateWeightsCount == this.getExpectedUpdateWeightsCount()) {
            DomWDegUtils.addIncFailure(e.getDomOverDegContradictionCause());
        } else {
            DomWDegUtils.addFailure(e.getDomOverDegContradictionCause());
        }
    }

    @Override
    public final void safeDelete() {
        this.solver.getPropagationEngine().removePropagationEngineListener(this);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        this.reinitBranching();
        return this.ratioSelector.selectVar();
    }

    public String toString() {
        return "nbUpdates: " + this.updateWeightsCount + "\n" + DomWDegUtils.getVariableIncWDeg(this.solver) + "\n" + DomWDegUtils.getConstraintFailures(this.solver);
    }
}

