/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.variables.integer.BitSetIntDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.CspBinSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class AC3rmBitBinSConstraint
extends CspBinSConstraint {
    protected int offset0;
    protected int offset1;
    protected int minS0;
    protected int minS1;
    protected int initDomSize0;
    protected int initDomSize1;
    protected BitSetIntDomain v0Domain;
    protected BitSetIntDomain v1Domain;

    public AC3rmBitBinSConstraint(IntDomainVar x0, IntDomainVar x1, CouplesBitSetTable relation) {
        super(x0, x1, relation);
        this.v0Domain = (BitSetIntDomain)this.v0.getDomain();
        this.v1Domain = (BitSetIntDomain)this.v1.getDomain();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public void fastInitNbSupports() {
        int[] initS1 = new int[this.v1.getSup() - this.v1.getInf() + 1];
        this.minS0 = Integer.MAX_VALUE;
        this.minS1 = Integer.MAX_VALUE;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            int initS0 = 0;
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++initS0;
                int n = val1 - this.offset1;
                initS1[n] = initS1[n] + 1;
            }
            if (initS0 < this.minS0) {
                this.minS0 = initS0;
            }
            itv1.dispose();
        }
        itv0.dispose();
        for (int i = 0; i < initS1.length; ++i) {
            if (initS1[i] >= this.minS1) continue;
            this.minS1 = initS1[i];
        }
    }

    @Override
    public Object clone() {
        return new AC3rmBitBinSConstraint(this.v0, this.v1, (CouplesBitSetTable)this.relation);
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new AC3rmBitBinSConstraint(this.v0, this.v1, (CouplesBitSetTable)((ConsistencyRelation)((Object)this.relation)).getOpposite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV1() throws ContradictionException {
        int v0Size = this.v0Domain.getSize();
        if (this.minS1 <= this.initDomSize0 - v0Size) {
            int left;
            int right = left = Integer.MIN_VALUE;
            DisposableIntIterator itv1 = this.v1Domain.getIterator();
            try {
                while (itv1.hasNext()) {
                    int y = itv1.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(1, y, this.v0Domain)) continue;
                    if (y == right + 1) {
                        right = y;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this, false);
                    left = right = y;
                }
                this.v1.removeInterval(left, right, this, false);
            }
            finally {
                itv1.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV0() throws ContradictionException {
        int v1Size = this.v1Domain.getSize();
        if (this.minS0 <= this.initDomSize1 - v1Size) {
            int left;
            int right = left = Integer.MIN_VALUE;
            DisposableIntIterator itv0 = this.v0Domain.getIterator();
            try {
                while (itv0.hasNext()) {
                    int x = itv0.next();
                    if (((CouplesBitSetTable)this.relation).checkValue(0, x, this.v1Domain)) continue;
                    if (x == right + 1) {
                        right = x;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this, false);
                    left = right = x;
                }
                this.v0.removeInterval(left, right, this, false);
            }
            finally {
                itv0.dispose();
            }
        }
    }

    public void init() {
        this.offset0 = this.v0.getInf();
        this.offset1 = this.v1.getInf();
        this.initDomSize0 = this.v0.getDomainSize();
        this.initDomSize1 = this.v1.getDomainSize();
        this.fastInitNbSupports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awake() throws ContradictionException {
        int left;
        this.init();
        int right = left = Integer.MIN_VALUE;
        DisposableIntIterator itv0 = this.v0Domain.getIterator();
        try {
            while (itv0.hasNext()) {
                int val0 = itv0.next();
                if (((CouplesBitSetTable)this.relation).checkValue(0, val0, this.v1Domain)) continue;
                if (val0 == right + 1) {
                    right = val0;
                    continue;
                }
                this.v0.removeInterval(left, right, this, false);
                left = right = val0;
            }
            this.v0.removeInterval(left, right, this, false);
        }
        finally {
            itv0.dispose();
        }
        itv0 = this.v1Domain.getIterator();
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        try {
            while (itv0.hasNext()) {
                int val1 = itv0.next();
                if (((CouplesBitSetTable)this.relation).checkValue(1, val1, this.v0Domain)) continue;
                if (val1 == right + 1) {
                    right = val1;
                    continue;
                }
                this.v1.removeInterval(left, right, this, false);
                left = right = val1;
            }
            this.v1.removeInterval(left, right, this, false);
        }
        finally {
            itv0.dispose();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.revise(varIndex);
    }

    public void revise(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int left;
        if (idx == 0) {
            int left2;
            int value = this.v0.getVal();
            int right = left2 = Integer.MIN_VALUE;
            DisposableIntIterator itv1 = this.v1Domain.getIterator();
            try {
                while (itv1.hasNext()) {
                    int val = itv1.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    this.v1.removeInterval(left2, right, this, false);
                    left2 = right = val;
                }
                this.v1.removeInterval(left2, right, this, false);
            }
            finally {
                itv1.dispose();
            }
        }
        int value = this.v1.getVal();
        int right = left = Integer.MIN_VALUE;
        DisposableIntIterator itv0 = this.v0Domain.getIterator();
        try {
            while (itv0.hasNext()) {
                int val = itv0.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v0.removeInterval(left, right, this, false);
                left = right = val;
            }
            this.v0.removeInterval(left, right, this, false);
        }
        finally {
            itv0.dispose();
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AC3rmBitSet(").append(this.v0.pretty()).append(", ").append(this.v1.pretty()).append(", ").append(this.relation.getClass().getSimpleName()).append(")");
        return sb.toString();
    }
}

