# autoFlagR 1.0.0

## Version 1.0.0 (2025-12-22)

### Core Functionality
- `prep_for_anomaly()`: Automated data preprocessing for anomaly detection
- `score_anomaly()`: Anomaly scoring using Isolation Forest and Local Outlier Factor
- `flag_top_anomalies()`: Flagging records as anomalous based on threshold or contamination rate
- `generate_audit_report()`: Generate comprehensive PDF, HTML, and DOCX audit reports

### Benchmarking
- `extract_benchmark_metrics()`: Extract performance metrics (AUC-ROC, AUC-PR, Top-K Recall)
- `calculate_benchmark_metrics()`: Calculate metrics from scored data with ground truth

### Utilities
- `get_top_anomalies()`: Retrieve top N most anomalous records
- Feature importance calculation for explaining anomalies

### Features
- Support for multiple anomaly detection algorithms (Isolation Forest, LOF)
- Automated preprocessing (ID handling, scaling, encoding)
- Professional report generation with visualizations
- Benchmarking capabilities for validation studies
- Tidyverse-compatible interface

### Documentation
- Comprehensive function documentation
- Getting started vignette
- Healthcare example vignette
- Benchmarking tutorial

