/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.DiscreteTraitBranchRateGradient;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.Loggable;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class LocalBranchRateGradientForDiscreteTrait
extends DiscreteTraitBranchRateGradient
implements GradientWrtParameterProvider,
Reportable,
Loggable {
    public LocalBranchRateGradientForDiscreteTrait(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, Parameter parameter, boolean bl) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, parameter, bl);
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = super.getGradientLogDensity();
        double[] dArray2 = new double[this.tree.getNodeCount() - 1];
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            if (this.tree.isRoot(nodeRef)) continue;
            int n = this.branchRateModel.getParameterIndexFromNode(nodeRef);
            dArray2[n] = this.getSubTreeGradient(this.tree, nodeRef, dArray);
        }
        return dArray2;
    }

    private double getSubTreeGradient(Tree tree, NodeRef nodeRef, double[] dArray) {
        double d = this.branchRateModel.getBranchRateDifferential(tree, nodeRef);
        double d2 = dArray[this.branchRateModel.getParameterIndexFromNode(nodeRef)];
        if (tree.isExternal(nodeRef)) {
            return d * d2;
        }
        double d3 = d * d2;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            d3 += this.getSubTreeGradient(tree, tree.getChild(nodeRef, i), dArray);
        }
        return d3;
    }
}

