/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.util.Units;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;

public class EpidemiologyStatistic
extends Statistic.Abstract
implements Units {
    private final StatisticType statisticType;
    private final Parameter growthRate;
    private final Units.Type growthRateUnits;
    private final double[] w;
    private final double a;
    private final double b;

    public EpidemiologyStatistic(String string, Parameter parameter, Units.Type type) {
        this(string, StatisticType.DOUBLING_TIME, parameter, type, 0.0, 0.0, null);
    }

    public EpidemiologyStatistic(String string, Parameter parameter, Units.Type type, double d, double d2) {
        this(string, StatisticType.R0, parameter, type, d, d2, null);
    }

    public EpidemiologyStatistic(String string, Parameter parameter, Units.Type type, double[] dArray) {
        this(string, StatisticType.R0, parameter, type, 0.0, 0.0, dArray);
    }

    private EpidemiologyStatistic(String string, StatisticType statisticType, Parameter parameter, Units.Type type, double d, double d2, double[] dArray) {
        super(string);
        this.statisticType = statisticType;
        this.growthRate = parameter;
        if (type != Units.Type.YEARS && type != Units.Type.MONTHS && type != Units.Type.WEEKS && type != Units.Type.DAYS) {
            throw new UnsupportedOperationException("Growth rate time units should be years, months, weeks, or days");
        }
        this.growthRateUnits = type;
        this.a = d * d;
        this.b = d / (d2 * d2);
        if (dArray != null) {
            this.w = new double[dArray.length];
            double d3 = 0.0;
            for (double d4 : dArray) {
                d3 += d4;
            }
            for (int i = 0; i < this.w.length; ++i) {
                this.w[i] = dArray[i] / d3;
            }
        } else {
            this.w = null;
        }
    }

    @Override
    public String getDimensionName(int n) {
        return super.getDimensionName(n) + "." + this.statisticType.toString();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        double d;
        switch (this.growthRateUnits) {
            case DAYS: {
                d = this.growthRate.getParameterValue(0);
                break;
            }
            case WEEKS: {
                d = this.growthRate.getParameterValue(0) / 7.0;
                break;
            }
            case MONTHS: {
                d = this.growthRate.getParameterValue(0) / 30.0;
                break;
            }
            case YEARS: {
                d = this.growthRate.getParameterValue(0) / 365.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported time unit");
            }
        }
        if (this.statisticType == StatisticType.DOUBLING_TIME) {
            return Math.log(2.0) / d;
        }
        double d2 = 1.0;
        if (this.w != null) {
            throw new UnsupportedOperationException("R0 estimate based on empirical serial interval not implemented yet");
        }
        d2 = Math.pow(1.0 + d / this.b, this.a);
        return d2;
    }

    @Override
    public Units.Type getUnits() {
        return Units.Type.DAYS;
    }

    @Override
    public void setUnits(Units.Type type) {
        throw new UnsupportedOperationException("Cannot set units");
    }

    public static enum StatisticType {
        DOUBLING_TIME("doublingTime"),
        R0("R0");

        String name;

        private StatisticType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

