/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima.estimation;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SarimaMapping2
implements IArimaMapping<SarimaModel> {
    public static final double ARMAX = 0.99999;
    public static final double MAMAX = 1.0;
    public static final double STEP = Math.sqrt(2.220446E-16);
    private final double arLimit;
    private final double maLimit;
    private final boolean checkAll;
    private final double epsilon;
    private final SarimaOrders orders;
    public static final String PHI = "phi";
    public static final String BPHI = "bphi";
    public static final String TH = "th";
    public static final String BTH = "bth";

    public static Builder builder(SarimaOrders orders) {
        return new Builder().orders(orders).arLimit(0.99999).maLimit(1.0).checkAll(true).epsilon(STEP);
    }

    public static SarimaModel stabilize(SarimaModel m) {
        DataBlock np = DataBlock.of(m.parameters());
        SarimaOrders mspec = m.orders();
        SarimaMapping2 mapping = SarimaMapping2.of(mspec);
        if (mapping.stabilize(np)) {
            return SarimaModel.builder(mspec).parameters((DoubleSeq)np).build();
        }
        return m;
    }

    public static SarimaMapping2 of(SarimaOrders spec) {
        return SarimaMapping2.builder(spec).build();
    }

    public static SarimaMapping2 ofStationary(SarimaOrders spec) {
        SarimaOrders nspec = spec.clone();
        nspec.setD(0);
        nspec.setBd(0);
        return SarimaMapping2.of(nspec);
    }

    public boolean stabilize(DoubleSeq.Mutable p) {
        boolean rslt = false;
        int start = 0;
        int len = this.orders.getP();
        if (len > 0 && FilterUtility.stabilize(p.extract(start, len), this.arLimit)) {
            rslt = true;
        }
        start += len;
        len = this.orders.getBp();
        if (len > 0 && FilterUtility.stabilize(p.extract(start, len), this.arLimit)) {
            rslt = true;
        }
        if (this.checkAll) {
            start += len;
            len = this.orders.getQ();
            if (len > 0 && FilterUtility.stabilize(p.extract(start, len), this.maLimit)) {
                rslt = true;
            }
            start += len;
            len = this.orders.getBq();
            if (len > 0 && FilterUtility.stabilize(p.extract(start, len), this.maLimit)) {
                rslt = true;
            }
        }
        return rslt;
    }

    @Override
    public boolean checkBoundaries(DoubleSeq p) {
        int start = 0;
        int len = this.orders.getP();
        if (len > 0 && !FilterUtility.checkRoots(p.extract(start, len), this.arLimit)) {
            return false;
        }
        start += len;
        len = this.orders.getBp();
        if (len > 0 && !FilterUtility.checkRoots(p.extract(start, len), this.arLimit)) {
            return false;
        }
        if (this.checkAll) {
            start += len;
            len = this.orders.getQ();
            if (len > 0 && !FilterUtility.checkRoots(p.extract(start, len), this.maLimit)) {
                return false;
            }
            start += len;
            len = this.orders.getBq();
            if (len > 0 && !FilterUtility.checkRoots(p.extract(start, len), this.maLimit)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        double p = inparams.get(idx);
        if (p < 0.0) {
            return this.epsilon * Math.max(1.0, -p);
        }
        return -this.epsilon * Math.max(1.0, p);
    }

    @Override
    public int getDim() {
        return this.orders.getParametersCount();
    }

    public boolean isCheckingAll() {
        return this.checkAll;
    }

    @Override
    public double lbound(int idx) {
        if (this.orders.getP() > 0) {
            if (idx < this.orders.getP()) {
                if (this.orders.getP() == 1) {
                    return -this.arLimit;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.orders.getP();
        }
        if (this.orders.getBp() > 0) {
            if (idx < this.orders.getBp()) {
                if (this.orders.getBp() == 1) {
                    return -this.arLimit;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.orders.getBp();
        }
        if (this.orders.getQ() > 0 && idx < this.orders.getQ()) {
            if (this.orders.getQ() == 1) {
                return -this.maLimit;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (this.orders.getBq() == 1) {
            return -this.maLimit;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SarimaModel map(DoubleSeq p) {
        if (p.length() != this.orders.getParametersCount()) {
            return null;
        }
        return SarimaModel.builder(this.orders).parameters(p).build();
    }

    @Override
    public double ubound(int idx) {
        if (this.orders.getP() > 0) {
            if (idx < this.orders.getP()) {
                if (this.orders.getP() == 1) {
                    return this.arLimit;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.orders.getP();
        }
        if (this.orders.getBp() > 0) {
            if (idx < this.orders.getBp()) {
                if (this.orders.getBp() == 1) {
                    return this.arLimit;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.orders.getBp();
        }
        if (this.orders.getQ() > 0 && idx < this.orders.getQ()) {
            if (this.orders.getQ() == 1) {
                return this.maLimit;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.orders.getBq() == 1) {
            return this.maLimit;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(DataBlock value) {
        if (value.length() != this.orders.getParametersCount()) {
            return ParamValidation.Invalid;
        }
        if (this.stabilize(value)) {
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    @Override
    public DoubleSeq parametersOf(SarimaModel m) {
        return m.parameters();
    }

    @Override
    public IArimaMapping<SarimaModel> stationaryMapping() {
        if (this.orders.isStationary()) {
            return this;
        }
        SarimaOrders norders = this.orders.clone();
        norders.setD(0);
        norders.setBd(0);
        return this.toBuilder().orders(norders).build();
    }

    @Override
    public DoubleSeq getDefaultParameters() {
        int i;
        double[] p = new double[this.orders.getParametersCount()];
        int nar = this.orders.getP() + this.orders.getBp();
        for (i = 0; i < nar; ++i) {
            p[i] = -0.1;
        }
        for (i = nar; i < p.length; ++i) {
            p[i] = -0.2;
        }
        return DoubleSeq.of((double[])p);
    }

    @Override
    public String getDescription(int idx) {
        return SarimaMapping2.getDescription(this.orders, idx);
    }

    static String getDescription(SarimaOrders orders, int idx) {
        int i = idx;
        if (i < orders.getP()) {
            return SarimaMapping2.desc(PHI, i);
        }
        if ((i -= orders.getP()) < orders.getBp()) {
            return SarimaMapping2.desc(BPHI, i);
        }
        if ((i -= orders.getBp()) < orders.getQ()) {
            return SarimaMapping2.desc(TH, i);
        }
        if ((i -= orders.getQ()) < orders.getBq()) {
            return SarimaMapping2.desc(BTH, i);
        }
        return "";
    }

    static String desc(String prefix, int idx) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append('(').append(idx + 1).append(')');
        return builder.toString();
    }

    @Generated
    SarimaMapping2(double arLimit, double maLimit, boolean checkAll, double epsilon, SarimaOrders orders) {
        this.arLimit = arLimit;
        this.maLimit = maLimit;
        this.checkAll = checkAll;
        this.epsilon = epsilon;
        this.orders = orders;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().arLimit(this.arLimit).maLimit(this.maLimit).checkAll(this.checkAll).epsilon(this.epsilon).orders(this.orders);
    }

    @Generated
    public double getArLimit() {
        return this.arLimit;
    }

    @Generated
    public double getMaLimit() {
        return this.maLimit;
    }

    @Generated
    public boolean isCheckAll() {
        return this.checkAll;
    }

    @Generated
    public double getEpsilon() {
        return this.epsilon;
    }

    @Generated
    public SarimaOrders getOrders() {
        return this.orders;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SarimaMapping2)) {
            return false;
        }
        SarimaMapping2 other = (SarimaMapping2)o;
        if (Double.compare(this.getArLimit(), other.getArLimit()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaLimit(), other.getMaLimit()) != 0) {
            return false;
        }
        if (this.isCheckAll() != other.isCheckAll()) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        SarimaOrders this$orders = this.getOrders();
        SarimaOrders other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !this$orders.equals(other$orders));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $arLimit = Double.doubleToLongBits(this.getArLimit());
        result = result * 59 + (int)($arLimit >>> 32 ^ $arLimit);
        long $maLimit = Double.doubleToLongBits(this.getMaLimit());
        result = result * 59 + (int)($maLimit >>> 32 ^ $maLimit);
        result = result * 59 + (this.isCheckAll() ? 79 : 97);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        SarimaOrders $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : $orders.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SarimaMapping2(arLimit=" + this.getArLimit() + ", maLimit=" + this.getMaLimit() + ", checkAll=" + this.isCheckAll() + ", epsilon=" + this.getEpsilon() + ", orders=" + String.valueOf(this.getOrders()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private double arLimit;
        @Generated
        private double maLimit;
        @Generated
        private boolean checkAll;
        @Generated
        private double epsilon;
        @Generated
        private SarimaOrders orders;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder arLimit(double arLimit) {
            this.arLimit = arLimit;
            return this;
        }

        @Generated
        public @NonNull Builder maLimit(double maLimit) {
            this.maLimit = maLimit;
            return this;
        }

        @Generated
        public @NonNull Builder checkAll(boolean checkAll) {
            this.checkAll = checkAll;
            return this;
        }

        @Generated
        public @NonNull Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Generated
        public @NonNull Builder orders(SarimaOrders orders) {
            this.orders = orders;
            return this;
        }

        @Generated
        public @NonNull SarimaMapping2 build() {
            return new SarimaMapping2(this.arLimit, this.maLimit, this.checkAll, this.epsilon, this.orders);
        }

        @Generated
        public @NonNull String toString() {
            return "SarimaMapping2.Builder(arLimit=" + this.arLimit + ", maLimit=" + this.maLimit + ", checkAll=" + this.checkAll + ", epsilon=" + this.epsilon + ", orders=" + String.valueOf(this.orders) + ")";
        }
    }
}

