/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleList;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.function.BiDoublePredicate;
import jdplus.toolkit.base.core.data.DataWindow;
import lombok.NonNull;

public final class DataBlock
implements DoubleSeq.Mutable {
    public static final DataBlock EMPTY = new DataBlock(DoubleSeq.EMPTYARRAY, 0, 0, 1);
    final double[] data;
    final int inc;
    int beg;
    int end;

    public static DataBlock make(int n) {
        return n == 0 ? EMPTY : new DataBlock(new double[n], 0, n, 1);
    }

    public static DataBlock make(int n, double val) {
        if (n == 0) {
            return EMPTY;
        }
        double[] data = new double[n];
        if (val != 0.0) {
            for (int i = 0; i < n; ++i) {
                data[i] = val;
            }
        }
        return new DataBlock(data, 0, n, 1);
    }

    public static DataBlock of(@NonNull double[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new DataBlock(data, 0, data.length, 1);
    }

    public static DataBlock of(@NonNull double[] data, int start, int end) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (end < start) {
            throw new IllegalArgumentException("Invalid DoubleArray");
        }
        return new DataBlock(data, start, end, 1);
    }

    public static DataBlock of(@NonNull double[] data, int start, int end, int inc) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (inc == 1) {
            return DataBlock.of(data, start, end);
        }
        Objects.requireNonNull(data);
        if ((end - start) % inc != 0) {
            throw new IllegalArgumentException("Invalid DoubleArray");
        }
        if ((end - start) / inc < 0) {
            throw new IllegalArgumentException("Invalid DoubleArray");
        }
        return new DataBlock(data, start, end, inc);
    }

    public static DataBlock of(@NonNull DoubleSeq data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        double[] x = new double[data.length()];
        data.copyTo(x, 0);
        return new DataBlock(x, 0, x.length, 1);
    }

    public static DataBlock of(int n, @NonNull DoubleSupplier fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = fn.getAsDouble();
        }
        return new DataBlock(x, 0, x.length, 1);
    }

    public static DataBlock of(int n, @NonNull IntToDoubleFunction fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = fn.applyAsDouble(i);
        }
        return new DataBlock(x, 0, x.length, 1);
    }

    public static DataBlock copyOf(@NonNull double[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new DataBlock((double[])data.clone(), 0, data.length, 1);
    }

    public static DataBlock select(@NonNull DoubleSeq data, @NonNull DoublePredicate pred) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        DoubleList list = new DoubleList();
        int n = data.length();
        for (int i = 0; i < n; ++i) {
            double cur = data.get(i);
            if (!pred.test(cur)) continue;
            list.add(cur);
        }
        return DataBlock.of(list.toArray());
    }

    public static DataBlock select(@NonNull DoubleSeq data, @NonNull int[] sel) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (sel == null) {
            throw new NullPointerException("sel is marked non-null but is null");
        }
        if (sel.length == 0) {
            return EMPTY;
        }
        double[] s = new double[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            s[i] = data.get(sel[i]);
        }
        return DataBlock.of(s);
    }

    DataBlock(double[] data, int start, int end, int inc) {
        this.data = data;
        this.beg = start;
        this.end = end;
        this.inc = inc;
    }

    public String toString() {
        return DoubleSeq.format((DoubleSeq)this);
    }

    public DoubleSeqCursor reverseReader() {
        return DoubleSeqCursor.of((double[])this.data, (int)(this.end - this.inc), (int)(-this.inc));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull DoubleSeqCursor.OnMutable cursor() {
        return DoubleSeqCursor.OnMutable.of((double[])this.data, (int)this.beg, (int)this.inc);
    }

    public void copyFrom(@NonNull double[] buffer, int start) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int i = this.beg;
        int j = start;
        while (i != this.end) {
            this.data[i] = buffer[j];
            i += this.inc;
            ++j;
        }
    }

    public void copyTo(double @NonNull [] buffer, int start) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int i = this.beg;
        int j = start;
        while (i != this.end) {
            buffer[j] = this.data[i];
            i += this.inc;
            ++j;
        }
    }

    @NonNull
    public DataBlock extract(int start, int length) {
        return new DataBlock(this.data, this.beg + start * this.inc, this.beg + (start + length) * this.inc, this.inc);
    }

    public double norm2() {
        int n = this.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(this.data[this.beg]);
            }
        }
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double s;
            double cur = this.data[i];
            if (cur == 0.0) continue;
            double absxi = Math.abs(cur);
            if (scale < absxi) {
                s = scale / absxi;
                ssq = 1.0 + ssq * s * s;
                scale = absxi;
                continue;
            }
            s = absxi / scale;
            ssq += s * s;
        }
        return scale * Math.sqrt(ssq);
    }

    public double norm1() {
        int n = this.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(this.data[this.beg]);
            }
        }
        double nrm = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            nrm += Math.abs(this.data[i]);
        }
        return nrm;
    }

    public double normInf() {
        int n = this.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(this.data[this.beg]);
            }
        }
        double nrm = Math.abs(this.data[this.beg]);
        for (int i = this.beg + this.inc; i != this.end; i += this.inc) {
            double tmp = Math.abs(this.data[i]);
            if (!(tmp > nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public double fastNorm2() {
        int n = this.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(this.data[this.beg]);
            }
        }
        double ssq = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (cur == 0.0) continue;
            ssq += cur * cur;
        }
        return Math.sqrt(ssq);
    }

    @NonNull
    public DataBlock extract(int start, int count, int inc) {
        int i1;
        int i0 = this.beg + start * this.inc;
        int ninc = inc * this.inc;
        if (count == -1) {
            int n = 0;
            if (this.inc > 0 && i0 <= this.end - this.inc || this.inc < 0 && i0 >= this.end - this.inc) {
                n = inc > 0 ? 1 + (this.end - this.inc - i0) / ninc : 1 + (this.beg - i0) / ninc;
            }
            i1 = i0 + n * ninc;
        } else {
            i1 = i0 + ninc * count;
        }
        return new DataBlock(this.data, i0, i1, ninc);
    }

    public DataBlock range(int beg, int end) {
        return new DataBlock(this.data, this.beg + beg * this.inc, this.beg + end * this.inc, this.inc);
    }

    public DataBlock drop(int beg, int end) {
        return new DataBlock(this.data, this.beg + beg * this.inc, this.end - end * this.inc, this.inc);
    }

    public DataBlock reverse() {
        return new DataBlock(this.data, this.end - this.inc, this.beg - this.inc, -this.inc);
    }

    public DataBlock extend(int beg, int end) {
        return new DataBlock(this.data, this.beg - beg * this.inc, this.end + end * this.inc, this.inc);
    }

    public DataWindow window() {
        return new DataWindow(this.data, this.beg, this.end, this.inc);
    }

    public DataWindow window(int beg, int end) {
        return new DataWindow(this.data, this.beg + beg * this.inc, this.beg + end * this.inc, this.inc);
    }

    public DataWindow left() {
        return new DataWindow(this.data, this.beg, this.beg, this.inc);
    }

    public DataBlock deepClone() {
        double[] copy = this.toArray();
        return new DataBlock(copy, 0, copy.length, 1);
    }

    public void bshiftAndNegSum() {
        int imax = this.end - this.inc;
        double s = this.data[this.beg];
        if (this.inc == 1) {
            for (int i = this.beg; i < imax; ++i) {
                double z;
                this.data[i] = z = this.data[i + 1];
                s += z;
            }
        } else {
            for (int i = this.beg; i != imax; i += this.inc) {
                double z;
                this.data[i] = z = this.data[i + this.inc];
                s += z;
            }
        }
        this.data[imax] = -s;
    }

    public void bshiftAndSum() {
        int imax = this.end - this.inc;
        double s = this.data[this.beg];
        if (this.inc == 1) {
            for (int i = this.beg; i < imax; ++i) {
                double z;
                this.data[i] = z = this.data[i + 1];
                s += z;
            }
        } else {
            for (int i = this.beg; i != imax; i += this.inc) {
                double z;
                this.data[i] = z = this.data[i + this.inc];
                s += z;
            }
        }
        this.data[imax] = s;
    }

    public void bshiftAndZero() {
        int imax = this.end - this.inc;
        if (this.inc == 1) {
            for (int i = this.beg; i < imax; ++i) {
                double z;
                this.data[i] = z = this.data[i + 1];
            }
        } else {
            for (int i = this.beg; i != imax; i += this.inc) {
                double z;
                this.data[i] = z = this.data[i + this.inc];
            }
        }
        this.data[imax] = 0.0;
    }

    public void brotate() {
        int imax = this.end - this.inc;
        double s = this.data[this.beg];
        if (this.inc == 1) {
            for (int i = this.beg; i < imax; ++i) {
                double z;
                this.data[i] = z = this.data[i + 1];
            }
        } else {
            for (int i = this.beg; i != imax; i += this.inc) {
                double z;
                this.data[i] = z = this.data[i + this.inc];
            }
        }
        this.data[imax] = s;
    }

    public void bshift(int n) {
        if (this.inc == 1) {
            int i0 = this.beg;
            int i1 = this.end - n;
            for (int i = i0; i < i1; ++i) {
                this.data[i] = this.data[i + n];
            }
        } else {
            int i0 = this.beg;
            int ninc = n * this.inc;
            int i1 = this.end - ninc;
            for (int i = i0; i != i1; i += this.inc) {
                this.data[i] = this.data[i + ninc];
            }
        }
    }

    public void fshift(int n) {
        if (this.inc == 1) {
            int i0 = this.end - this.inc;
            int i1 = this.beg + n;
            for (int i = i0; i >= i1; --i) {
                this.data[i] = this.data[i - n];
            }
        } else {
            int i0 = this.end - this.inc;
            int i1 = this.beg + (n - 1) * this.inc;
            int ninc = n * this.inc;
            for (int i = i0; i != i1; i -= this.inc) {
                this.data[i] = this.data[i - ninc];
            }
        }
    }

    public void fshiftAndNegSum() {
        double s = this.data[this.beg];
        if (this.inc == 1) {
            for (int i = this.end - 1; i > this.beg; --i) {
                s += this.data[i];
                this.data[i] = this.data[i - 1];
            }
        } else {
            for (int i = this.end - this.inc; i != this.beg; i -= this.inc) {
                s += this.data[i];
                this.data[i] = this.data[i - this.inc];
            }
        }
        this.data[this.beg] = -s;
    }

    public void fshiftAndSum() {
        double s = this.data[this.beg];
        if (this.inc == 1) {
            for (int i = this.end - 1; i > this.beg; --i) {
                s += this.data[i];
                this.data[i] = this.data[i - 1];
            }
        } else {
            for (int i = this.end - this.inc; i != this.beg; i -= this.inc) {
                s += this.data[i];
                this.data[i] = this.data[i - this.inc];
            }
        }
        this.data[this.beg] = s;
    }

    public void frotate() {
        int last = this.end - this.inc;
        double s = this.data[last];
        if (this.inc == 1) {
            for (int i = last; i > this.beg; --i) {
                this.data[i] = this.data[i - 1];
            }
        } else {
            for (int i = last; i != this.beg; i -= this.inc) {
                this.data[i] = this.data[i - this.inc];
            }
        }
        this.data[this.beg] = s;
    }

    public void fshiftAndZero() {
        if (this.inc == 1) {
            for (int i = this.end - this.inc; i > this.beg; --i) {
                this.data[i] = this.data[i - 1];
            }
        } else {
            for (int i = this.end - this.inc; i != this.beg; i -= this.inc) {
                this.data[i] = this.data[i - this.inc];
            }
        }
        this.data[this.beg] = 0.0;
    }

    public void set(int idx, double value) {
        this.data[this.beg + idx * this.inc] = value;
    }

    public double get(int idx) {
        return this.data[this.beg + idx * this.inc];
    }

    public int length() {
        return (this.end - this.beg) / this.inc;
    }

    public double first() {
        return this.data[this.beg];
    }

    public double last() {
        return this.data[this.end - this.inc];
    }

    public double[] getStorage() {
        return this.data;
    }

    public int getStartPosition() {
        return this.beg;
    }

    public int getEndPosition() {
        return this.end;
    }

    public int getLastPosition() {
        return this.end - this.inc;
    }

    public int getIncrement() {
        return this.inc;
    }

    public double dot(DataBlock x) {
        double s = 0.0;
        if (this.inc == 1) {
            if (x.inc == 1) {
                int i = this.beg;
                int j = x.beg;
                while (i != this.end) {
                    s += this.data[i] * x.data[j];
                    ++i;
                    ++j;
                }
            } else {
                int i = this.beg;
                int j = x.beg;
                while (i != this.end) {
                    s += this.data[i] * x.data[j];
                    ++i;
                    j += x.inc;
                }
            }
        } else if (x.inc == 1) {
            int i = this.beg;
            int j = x.beg;
            while (i != this.end) {
                s += this.data[i] * x.data[j];
                i += this.inc;
                ++j;
            }
        } else {
            int i = this.beg;
            int j = x.beg;
            while (i != this.end) {
                s += this.data[i] * x.data[j];
                i += this.inc;
                j += x.inc;
            }
        }
        return s;
    }

    public double jdot(DataBlock x, int l) {
        double s = 0.0;
        int i = this.beg;
        int j = x.beg;
        if (this.inc == 1) {
            int il = this.beg + l;
            if (x.inc == 1) {
                while (i < il) {
                    s += this.data[i] * x.data[j];
                    ++i;
                    ++j;
                }
                while (i < this.end) {
                    s -= this.data[i] * x.data[j];
                    ++i;
                    ++j;
                }
            } else {
                while (i < il) {
                    s += this.data[i] * x.data[j];
                    ++i;
                    j += x.inc;
                }
                while (i < this.end) {
                    s -= this.data[i] * x.data[j];
                    ++i;
                    j += x.inc;
                }
            }
        } else {
            int il = this.beg + l * this.inc;
            if (x.inc == 1) {
                while (i != il) {
                    s += this.data[i] * x.data[j];
                    i += this.inc;
                    ++j;
                }
                while (i != this.end) {
                    s -= this.data[i] * x.data[j];
                    i += this.inc;
                    ++j;
                }
            } else {
                while (i != il) {
                    s += this.data[i] * x.data[j];
                    i += this.inc;
                    j += x.inc;
                }
                while (i != this.end) {
                    s -= this.data[i] * x.data[j];
                    i += this.inc;
                    j += x.inc;
                }
            }
        }
        return s;
    }

    public double sum() {
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (!Double.isFinite(cur)) continue;
            s += cur;
        }
        return s;
    }

    public void correctForMean() {
        double s = this.average();
        this.sub(s);
    }

    public double ssq() {
        int n = this.length();
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (!Double.isFinite(cur)) continue;
            s += cur * cur;
        }
        return s;
    }

    public double ssqc(double mean) {
        int n = this.length();
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (!Double.isFinite(cur)) continue;
            s += (cur -= mean) * cur;
        }
        return s;
    }

    public double average() {
        int n = this.length();
        int m = 0;
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (Double.isFinite(cur)) {
                s += cur;
                continue;
            }
            ++m;
        }
        if (m == n) {
            return Double.NaN;
        }
        return s / (double)(n - m);
    }

    public void copy(DataBlock x) {
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        int i = this.beg;
        int j = xbeg;
        while (i != this.end) {
            this.data[i] = xdata[j];
            i += this.inc;
            j += xinc;
        }
    }

    public void copy(DoubleSeq x) {
        DoubleSeqCursor cell = x.cursor();
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.data[i] = cell.getAndNext();
        }
    }

    public void copy(Matrix X) {
        int nr = X.getRowsCount();
        int nc = X.getColumnsCount();
        int i = 0;
        int j = 0;
        while (i < nc) {
            DoubleSeq x = X.column(i);
            this.extract(j, nr).copy(x);
            ++i;
            j += nr;
        }
    }

    public void swap(DataBlock x) {
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        int i = this.beg;
        int j = xbeg;
        while (i != this.end) {
            double tmp = xdata[j];
            xdata[j] = this.data[i];
            this.data[i] = tmp;
            i += this.inc;
            j += xinc;
        }
    }

    public void swap(int i, int j) {
        int xj;
        int xi;
        if (i == j) {
            return;
        }
        if (this.inc == 1) {
            xi = this.beg + i;
            xj = this.beg + j;
        } else {
            xi = this.beg + i * this.inc;
            xj = this.beg + j * this.inc;
        }
        double tmp = this.data[xj];
        this.data[xj] = this.data[xi];
        this.data[xi] = tmp;
    }

    public void product(DataBlock row, Iterator<DataBlock> cols) {
        int idx = this.beg;
        while (cols.hasNext()) {
            this.data[idx] = cols.next().dot(row);
            idx += this.inc;
        }
    }

    public void product(Iterator<DataBlock> rows, DataBlock column) {
        int idx = this.beg;
        while (rows.hasNext()) {
            this.data[idx] = column.dot(rows.next());
            idx += this.inc;
        }
    }

    public void AProduct(double a, DataBlock row, Iterator<DataBlock> cols) {
        if (a == 0.0) {
            this.set(0.0);
            return;
        }
        int idx = this.beg;
        while (cols.hasNext()) {
            this.data[idx] = a * cols.next().dot(row);
            idx += this.inc;
        }
    }

    public void AProduct(double a, Iterator<DataBlock> rows, DataBlock column) {
        if (a == 0.0) {
            this.set(0.0);
            return;
        }
        int idx = this.beg;
        while (rows.hasNext()) {
            this.data[idx] = a * column.dot(rows.next());
            idx += this.inc;
        }
    }

    public void addProduct(DataBlock row, Iterator<DataBlock> cols) {
        int idx = this.beg;
        while (cols.hasNext()) {
            int n = idx;
            this.data[n] = this.data[n] + cols.next().dot(row);
            idx += this.inc;
        }
    }

    public void addProduct(Iterator<DataBlock> rows, DataBlock column) {
        int idx = this.beg;
        while (rows.hasNext()) {
            int n = idx;
            this.data[n] = this.data[n] + column.dot(rows.next());
            idx += this.inc;
        }
    }

    public void addAProduct(double a, DataBlock row, Iterator<DataBlock> cols) {
        int idx = this.beg;
        while (cols.hasNext()) {
            int n = idx;
            this.data[n] = this.data[n] + a * cols.next().dot(row);
            idx += this.inc;
        }
    }

    public void addAProduct(double a, Iterator<DataBlock> rows, DataBlock column) {
        int idx = this.beg;
        while (rows.hasNext()) {
            int n = idx;
            this.data[n] = this.data[n] + a * column.dot(rows.next());
            idx += this.inc;
        }
    }

    public boolean isZero(double zero) {
        return this.allMatch(x -> !Double.isFinite(x) || Math.abs(x) <= zero);
    }

    public boolean isConstant(double cnt) {
        return this.allMatch(x -> x == cnt);
    }

    public void apply(int pos, @NonNull DoubleUnaryOperator fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int idx = this.beg + pos * this.inc;
        this.data[idx] = fn.applyAsDouble(this.data[idx]);
    }

    public void add(int pos, double d) {
        int n = this.beg + pos * this.inc;
        this.data[n] = this.data[n] + d;
    }

    public void mul(int pos, double d) {
        int n = this.beg + pos * this.inc;
        this.data[n] = this.data[n] * d;
    }

    public void sub(int pos, double d) {
        int n = this.beg + pos * this.inc;
        this.data[n] = this.data[n] - d;
    }

    public void div(int pos, double d) {
        if (d != 1.0) {
            int n = this.beg + pos * this.inc;
            this.data[n] = this.data[n] / d;
        }
    }

    public void normalize() {
        int n = this.length();
        int m = 0;
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (Double.isFinite(cur)) {
                s += cur;
                continue;
            }
            ++m;
        }
        if (m == n) {
            return;
        }
        double mean = s / (double)(n - m);
        s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.data[i];
            if (!Double.isFinite(cur)) continue;
            s += (cur -= mean) * cur;
        }
        double se = Math.sqrt(s / (double)(n - m));
        if (se == 0.0) {
            this.set(1.0);
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                if (!Double.isFinite(this.data[i])) continue;
                this.data[i] = (this.data[i] - mean) / se;
            }
        }
    }

    public void set(Iterator<DataBlock> blocks, DataBlockFunction fn) {
        int pos = this.beg;
        if (this.inc == 1) {
            while (blocks.hasNext()) {
                this.data[pos++] = fn.apply(blocks.next());
            }
        } else {
            while (blocks.hasNext()) {
                this.data[pos] = fn.apply(blocks.next());
                pos += this.inc;
            }
        }
    }

    public void apply(Iterator<DataBlock> blocks, DataBlockFunction fn, DoubleBinaryOperator op) {
        int pos = this.beg;
        while (blocks.hasNext()) {
            this.data[pos] = op.applyAsDouble(this.data[pos], fn.apply(blocks.next()));
            pos += this.inc;
        }
    }

    public void apply(@NonNull DataBlock x, @NonNull DoubleBinaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        int i = this.beg;
        int j = xbeg;
        while (i != this.end) {
            this.data[i] = fn.applyAsDouble(this.data[i], xdata[j]);
            i += this.inc;
            j += xinc;
        }
    }

    public void apply(@NonNull DoubleSeq x, @NonNull DoubleBinaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        DoubleSeqCursor cell = x.cursor();
        if (this.inc == 1) {
            for (int i = this.beg; i < this.end; ++i) {
                this.data[i] = fn.applyAsDouble(this.data[i], cell.getAndNext());
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.data[i] = fn.applyAsDouble(this.data[i], cell.getAndNext());
            }
        }
    }

    public void apply(@NonNull DoubleUnaryOperator fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (this.inc == 1) {
            for (int i = this.beg; i < this.end; ++i) {
                this.data[i] = fn.applyAsDouble(this.data[i]);
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.data[i] = fn.applyAsDouble(this.data[i]);
            }
        }
    }

    public void add(double d) {
        if (d == 0.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] + d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.data[n] = this.data[n] + d;
            }
        }
    }

    public void add(IntToDoubleFunction fn) {
        if (this.inc == 1) {
            int i = this.beg;
            int j = 0;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] + fn.applyAsDouble(j);
                ++j;
            }
        } else {
            int i = this.beg;
            int j = 0;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + fn.applyAsDouble(j);
                i += this.inc;
                ++j;
            }
        }
    }

    public void chs() {
        if (this.inc == 1) {
            for (int i = this.beg; i < this.end; ++i) {
                this.data[i] = -this.data[i];
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.data[i] = -this.data[i];
            }
        }
    }

    public void sub(double d) {
        if (d == 0.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] - d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.data[n] = this.data[n] - d;
            }
        }
    }

    public void mul(double d) {
        if (d == 1.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] * d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.data[n] = this.data[n] * d;
            }
        }
    }

    public void div(double d) {
        if (d == 1.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] / d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.data[n] = this.data[n] / d;
            }
        }
    }

    public void set(@NonNull DataBlock x, @NonNull DoubleUnaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        int i = this.beg;
        int j = xbeg;
        while (i != this.end) {
            this.data[i] = fn.applyAsDouble(xdata[j]);
            i += this.inc;
            j += xinc;
        }
    }

    public void set(@NonNull DataBlock x, @NonNull DataBlock y, @NonNull DoubleBinaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int ybeg = y.getStartPosition();
        int yinc = y.getIncrement();
        double[] ydata = y.getStorage();
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        int i = this.beg;
        int j = xbeg;
        int k = ybeg;
        while (i != this.end) {
            this.data[i] = fn.applyAsDouble(xdata[j], ydata[k]);
            i += this.inc;
            j += xinc;
            k += yinc;
        }
    }

    public void set(@NonNull DoubleSeq x, @NonNull DoubleUnaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        DoubleSeqCursor xcell = x.cursor();
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.data[i] = fn.applyAsDouble(xcell.getAndNext());
        }
    }

    public void set(@NonNull DoubleSeq x, @NonNull DoubleSeq y, @NonNull DoubleBinaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        DoubleSeqCursor xcell = x.cursor();
        DoubleSeqCursor ycell = y.cursor();
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.data[i] = fn.applyAsDouble(xcell.getAndNext(), ycell.getAndNext());
        }
    }

    public void add(@NonNull DoubleSeq x, @NonNull DoubleSeq y, @NonNull DoubleBinaryOperator fn) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        DoubleSeqCursor xcell = x.cursor();
        DoubleSeqCursor ycell = y.cursor();
        for (int i = this.beg; i != this.end; i += this.inc) {
            int n = i;
            this.data[n] = this.data[n] + fn.applyAsDouble(xcell.getAndNext(), ycell.getAndNext());
        }
    }

    public void setAY(double a, @NonNull DataBlock y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (a == 0.0) {
            this.set(0.0);
        } else if (a == 1.0) {
            this.copy(y);
        } else if (a == -1.0) {
            this.set(y, (double u) -> -u);
        } else if (this.inc == 1 && y.inc == 1) {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                this.data[i] = a * y.data[j];
                ++i;
                ++j;
            }
        } else {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                this.data[i] = a * y.data[j];
                i += this.inc;
                j += y.inc;
            }
        }
    }

    public void addAY(double a, @NonNull DataBlock y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (a == 0.0) {
            return;
        }
        if (a == 1.0) {
            this.add(y);
        } else if (a == -1.0) {
            this.sub(y);
        } else if (this.inc == 1) {
            if (y.inc == 1) {
                int i = this.beg;
                int j = y.beg;
                while (i < this.end) {
                    int n = i++;
                    this.data[n] = this.data[n] + a * y.data[j];
                    ++j;
                }
            } else {
                int i = this.beg;
                int j = y.beg;
                while (i < this.end) {
                    int n = i++;
                    this.data[n] = this.data[n] + a * y.data[j];
                    j += y.inc;
                }
            }
        } else if (y.inc == 1) {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + a * y.data[j];
                i += this.inc;
                ++j;
            }
        } else {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + a * y.data[j];
                i += this.inc;
                j += y.inc;
            }
        }
    }

    public void addAXY(double a, DataBlock x, DataBlock y) {
        if (a == 0.0) {
            return;
        }
        if (a == 1.0) {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + x.data[j] * y.data[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        } else if (a == -1.0) {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] - x.data[j] * y.data[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        } else {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + a * x.data[j] * y.data[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        }
    }

    public void add(@NonNull DataBlock x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        if (this.inc == 1 && xinc == 1) {
            int i = this.beg;
            int j = xbeg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] + xdata[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = xbeg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] + xdata[j];
                i += this.inc;
                j += xinc;
            }
        }
    }

    public void sub(@NonNull DataBlock x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        if (this.inc == 1 && xinc == 1) {
            int i = this.beg;
            int j = xbeg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] - xdata[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = xbeg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] - xdata[j];
                i += this.inc;
                j += xinc;
            }
        }
    }

    public void mul(@NonNull DataBlock x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        if (this.inc == 1 && xinc == 1) {
            int i = this.beg;
            int j = xbeg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] * xdata[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = xbeg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] * xdata[j];
                i += this.inc;
                j += xinc;
            }
        }
    }

    public void div(@NonNull DataBlock x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        int xbeg = x.getStartPosition();
        int xinc = x.getIncrement();
        double[] xdata = x.getStorage();
        if (this.inc == 1 && xinc == 1) {
            int i = this.beg;
            int j = xbeg;
            while (i < this.end) {
                int n = i++;
                this.data[n] = this.data[n] / xdata[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = xbeg;
            while (i != this.end) {
                int n = i;
                this.data[n] = this.data[n] / xdata[j];
                i += this.inc;
                j += xinc;
            }
        }
    }

    public void set(@NonNull DoubleSupplier fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.data[i] = fn.getAsDouble();
        }
    }

    public void set(IntToDoubleFunction fn) {
        if (this.inc == 1) {
            int i = this.beg;
            int j = 0;
            while (i < this.end) {
                this.data[i] = fn.applyAsDouble(j);
                ++i;
                ++j;
            }
        } else {
            int i = this.beg;
            int j = 0;
            while (i != this.end) {
                this.data[i] = fn.applyAsDouble(j);
                i += this.inc;
                ++j;
            }
        }
    }

    public void set(double val) {
        if (this.inc == 1) {
            for (int i = this.beg; i < this.end; ++i) {
                this.data[i] = val;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.data[i] = val;
            }
        }
    }

    public double getLast() {
        return this.data[this.end - this.inc];
    }

    public void setLast(double x) {
        this.data[this.end - this.inc] = x;
    }

    public void addLast(double x) {
        int n = this.end - this.inc;
        this.data[n] = this.data[n] + x;
    }

    public double reduce(double initial, @NonNull DoubleBinaryOperator fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        double cur = initial;
        for (int i = this.beg; i != this.end; i += this.inc) {
            cur = fn.applyAsDouble(cur, this.data[i]);
        }
        return cur;
    }

    public void autoApply(int del, @NonNull DoubleBinaryOperator fn) {
        block6: {
            block5: {
                if (fn == null) {
                    throw new NullPointerException("fn is marked non-null but is null");
                }
                if (del <= 0) break block5;
                if (this.length() <= del) {
                    return;
                }
                int cur = this.beg;
                for (int dcur = cur + this.inc * del; dcur != this.end; dcur += this.inc) {
                    this.data[cur] = fn.applyAsDouble(this.data[cur], this.data[dcur]);
                    cur += this.inc;
                }
                break block6;
            }
            if (del >= 0) break block6;
            if (this.length() <= -del) {
                return;
            }
            int cur = this.end;
            int dcur = cur + this.inc * del;
            while (dcur != this.beg) {
                this.data[cur -= this.inc] = fn.applyAsDouble(this.data[cur], this.data[dcur -= this.inc]);
            }
        }
    }

    public void applyRecursively(int del, @NonNull DoubleBinaryOperator fn) {
        block6: {
            block5: {
                if (fn == null) {
                    throw new NullPointerException("fn is marked non-null but is null");
                }
                if (del <= 0) break block5;
                if (this.length() <= del) {
                    return;
                }
                int cur = this.beg;
                for (int dcur = cur + this.inc * del; dcur != this.end; dcur += this.inc) {
                    this.data[dcur] = fn.applyAsDouble(this.data[cur], this.data[dcur]);
                    cur += this.inc;
                }
                break block6;
            }
            if (del >= 0) break block6;
            if (this.length() <= -del) {
                return;
            }
            int cur = this.end;
            int dcur = cur + this.inc * del;
            while (dcur != this.beg) {
                this.data[dcur -= this.inc] = fn.applyAsDouble(this.data[cur -= this.inc], this.data[dcur]);
            }
        }
    }

    public void cumul() {
        this.applyRecursively(1, (a, b) -> a + b);
    }

    public boolean allMatch(DataBlock d, @NonNull BiDoublePredicate p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        int i = this.beg;
        int j = d.beg;
        while (i != this.end) {
            if (!p.test(this.data[i], d.data[j])) {
                return false;
            }
            i += this.inc;
            j += d.inc;
        }
        return true;
    }

    public boolean allMatch(@NonNull DoublePredicate p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (p.test(this.data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean anyMatch(@NonNull DoublePredicate p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (!p.test(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public double min() {
        if (this.beg == this.end) {
            return 0.0;
        }
        double nrm = this.data[this.beg];
        for (int ix = this.beg + this.inc; ix != this.end; ix += this.inc) {
            double tmp = this.data[ix];
            if (!(tmp < nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public double max() {
        if (this.beg == this.end) {
            return 0.0;
        }
        double nrm = this.data[this.beg];
        for (int ix = this.beg + this.inc; ix != this.end; ix += this.inc) {
            double tmp = this.data[ix];
            if (!(tmp > nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public DoubleSeq unmodifiable() {
        return DoubleSeq.of((double[])this.data, (int)this.beg, (int)this.length(), (int)this.inc);
    }

    public String toString(String fmt) {
        return DoubleSeq.format((DoubleSeq)this, (String)fmt);
    }

    void slide(int del) {
        this.beg += del;
        this.end += del;
    }

    @FunctionalInterface
    public static interface DataBlockFunction {
        public double apply(@NonNull DataBlock var1);
    }
}

