/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.jsoup.select;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.org.jsoup.helper.Validate;
import standalone_spreadsheet.org.jsoup.nodes.Element;
import standalone_spreadsheet.org.jsoup.parser.TokenQueue;
import standalone_spreadsheet.org.jsoup.select.Collector;
import standalone_spreadsheet.org.jsoup.select.Elements;
import standalone_spreadsheet.org.jsoup.select.Evaluator;
import standalone_spreadsheet.org.jsoup.select.QueryParser;

public class Selector {
    private Selector() {
    }

    public static Elements select(String query, Element root) {
        Validate.notEmpty(query);
        return Selector.select(Selector.evaluatorOf(query), root);
    }

    public static Elements select(Evaluator evaluator, Element root) {
        Validate.notNull(evaluator);
        Validate.notNull(root);
        return Collector.collect(evaluator, root);
    }

    public static Stream<Element> selectStream(String query, Element root) {
        Validate.notEmpty(query);
        return Selector.selectStream(Selector.evaluatorOf(query), root);
    }

    public static Stream<Element> selectStream(Evaluator evaluator, Element root) {
        Validate.notNull(evaluator);
        Validate.notNull(root);
        return Collector.stream(evaluator, root);
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        Evaluator evaluator = Selector.evaluatorOf(query);
        Elements elements = new Elements();
        HashSet seenElements = new HashSet();
        for (Element root : roots) {
            Selector.selectStream(evaluator, root).filter(seenElements::add).forEach(elements::add);
        }
        return elements;
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static @Nullable Element selectFirst(String cssQuery, Element root) {
        Validate.notEmpty(cssQuery);
        return Collector.findFirst(Selector.evaluatorOf(cssQuery), root);
    }

    public static @Nullable Element selectFirst(String cssQuery, Iterable<Element> roots) {
        Validate.notEmpty(cssQuery);
        Validate.notNull(roots);
        Evaluator evaluator = Selector.evaluatorOf(cssQuery);
        for (Element root : roots) {
            Element first = Collector.findFirst(evaluator, root);
            if (first == null) continue;
            return first;
        }
        return null;
    }

    public static String escapeCssIdentifier(String in) {
        return TokenQueue.escapeCssIdentifier(in);
    }

    public static String unescapeCssIdentifier(String in) {
        try (TokenQueue tq = new TokenQueue(in);){
            String string = tq.consumeCssIdentifier();
            return string;
        }
    }

    public static Evaluator evaluatorOf(String css) {
        return QueryParser.parse(css);
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg) {
            super(msg);
        }

        public SelectorParseException(String msg, Object ... msgArgs) {
            super(String.format(msg, msgArgs));
        }

        public SelectorParseException(Throwable cause, String msg, Object ... msgArgs) {
            super(String.format(msg, msgArgs), cause);
        }
    }
}

