/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets;

import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataView;

public class PeriodIterator
implements Iterator<TsDataView> {
    private final TsDataView data_;
    private TsDataView cur_;

    public static PeriodIterator fullYears(TsData series) {
        TsDomain domain = series.getDomain();
        int ifreq = domain.getAnnualFrequency();
        int nbeg = series.getStart().annualPosition();
        int nend = series.getEnd().annualPosition();
        domain = domain.drop(nbeg == 0 ? 0 : ifreq - nbeg, nend);
        return new PeriodIterator(series, domain);
    }

    public PeriodIterator(TsData series) {
        if (!series.isEmpty()) {
            this.data_ = TsDataView.all(series);
            this.initialize();
        } else {
            this.data_ = null;
        }
    }

    public PeriodIterator(TsData series, TsDomain domain) {
        this.data_ = TsDataView.select(series, domain);
    }

    public PeriodIterator(TsData series, TimeSelector selector) {
        this.data_ = TsDataView.select(series, selector);
    }

    @Override
    public boolean hasNext() {
        if (this.data_ == null) {
            return false;
        }
        return this.cur_ != null;
    }

    @Override
    public TsDataView next() {
        TsDataView view = this.cur_;
        if (view == null) {
            return null;
        }
        int freq = this.data_.getStart().annualFrequency();
        int pstart = view.getStart().annualPosition();
        if (++pstart == freq) {
            this.cur_ = null;
        } else {
            TsPeriod nstart = view.getStart().next();
            int del = this.data_.getStart().until(nstart);
            if (del >= freq) {
                nstart = nstart.plus((long)(-freq));
                del -= freq;
            }
            int nyears = 1 + (this.data_.getData().length() - del - 1) / freq;
            this.cur_ = new TsDataView(nstart, this.data_.getData().extract(del, nyears, freq), freq);
        }
        return view;
    }

    public void reset() {
        this.initialize();
    }

    private void initialize() {
        int freq = this.data_.getStart().annualFrequency();
        int istart = this.data_.getStart().annualPosition();
        if (istart != 0) {
            istart = freq - istart;
        }
        int nyears = 1 + (this.data_.getData().length() - istart - 1) / freq;
        this.cur_ = new TsDataView(this.data_.getStart().plus((long)istart), this.data_.getData().extract(istart, nyears, freq), freq);
    }
}

