/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.regression.SwitchOutlier;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;

public class SwitchOutlierFactory
implements IOutlierFactory {
    public static final SwitchOutlierFactory FACTORY = new SwitchOutlierFactory();

    private SwitchOutlierFactory() {
    }

    public SwitchOutlier make(LocalDateTime position) {
        return new SwitchOutlier(position);
    }

    @Override
    public void fill(int outlierPosition, DataBlock buffer) {
        buffer.set(outlierPosition, 1.0);
        buffer.set(outlierPosition + 1, -1.0);
    }

    @Override
    public IOutlierFactory.FilterRepresentation getFilterRepresentation() {
        return new IOutlierFactory.FilterRepresentation(new RationalBackFilter(BackFilter.D1, BackFilter.ONE, 0), 0.0);
    }

    @Override
    public int excludingZoneAtStart() {
        return 0;
    }

    @Override
    public int excludingZoneAtEnd() {
        return 1;
    }

    @Override
    public String getCode() {
        return "WO";
    }
}

