/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.cmd;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Random;
import usf.saav.cmd.TestResults;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphVertex;

public class RandomLoopTestCLI {
    public static String[] testSet = new String[]{"100_tree_iterations.txt", "500_tree_iterations.txt", "1000_tree_iterations.txt", "3000_tree_iterations.txt", "5000_tree_iterations.txt"};

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{100, 500, 1000, 3000, 5000};
        int n = 0;
        for (String string : testSet) {
            try {
                int n2;
                int n3 = nArray[n++];
                String string2 = string.substring(0, string.length() - 4) + "-rand" + n3 + ".txt";
                RandomLoopTestCLI.generateFile("test/" + string, "test/" + string2, n3);
                int n4 = 10;
                double d = 0.0;
                double d2 = 0.0;
                TestResults testResults = null;
                for (n2 = 0; n2 < n4; ++n2) {
                    testResults = TestResults.testPerformance("test/" + string2, false);
                    if (testResults == null) {
                        System.out.println("test FAILED: " + string2);
                        break;
                    }
                    if (testResults.ppTimer.getElapsedMilliseconds() < 50.0) {
                        n4 = 100;
                    }
                    if (testResults.ppTimer.getElapsedMilliseconds() < 1.0) {
                        n4 = 1000;
                    }
                    d += testResults.mergeTimer.getElapsedMilliseconds();
                    d2 += testResults.ppTimer.getElapsedMilliseconds();
                }
                if (n2 != n4) continue;
                TestResults.savePersistentDiagram(testResults.rgMP, "pd/" + string2);
                System.out.print(string2.split("\\.")[0].replace("_", "\\_") + " & & & ");
                System.out.print(testResults.initial_verts + " & ");
                System.out.print(testResults.conditioned_verts + " & ");
                System.out.print(testResults.loops + " & ");
                if (d / (double)n4 > 0.1) {
                    System.out.printf("%.2f & ", d / (double)n4);
                } else {
                    System.out.printf("%.2e & ", d / (double)n4);
                }
                if (d2 / (double)n4 > 0.1) {
                    System.out.printf("%.2f \\\\ ", d2 / (double)n4);
                } else {
                    System.out.printf("%.2e \\\\ ", d2 / (double)n4);
                }
                System.out.println("\n\\hline");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static void generateFile(String string, String string2, int n) throws Exception {
        String string3;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        ReebGraph reebGraph = new ReebGraph();
        ReebGraphVertex reebGraphVertex = null;
        Random random = new Random();
        while ((string3 = bufferedReader.readLine()) != null) {
            String[] stringArray = string3.split("\\s");
            if (stringArray.length == 0) continue;
            if (stringArray[0].trim().equals("v")) {
                if (stringArray.length != 3) {
                    bufferedReader.close();
                    throw new Exception("Invalid edge input");
                }
                int n2 = Integer.parseInt(stringArray[1].trim());
                float f = Float.parseFloat(stringArray[2].trim());
                ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(f, f, n2);
                reebGraph.add(reebGraphVertex2);
                hashMap.put(n2, reebGraphVertex2);
                if (reebGraphVertex == null || reebGraphVertex2.getRealValue() > reebGraphVertex.getRealValue()) {
                    reebGraphVertex = reebGraphVertex2;
                }
            }
            if (!stringArray[0].trim().equals("e")) continue;
            if (stringArray.length != 3) {
                bufferedReader.close();
                throw new Exception("Invalid edge input");
            }
            ReebGraphVertex reebGraphVertex3 = (ReebGraphVertex)hashMap.get(Integer.parseInt(stringArray[1]));
            ReebGraphVertex reebGraphVertex4 = (ReebGraphVertex)hashMap.get(Integer.parseInt(stringArray[2]));
            if (reebGraphVertex3 == null || reebGraphVertex4 == null) {
                bufferedReader.close();
                throw new Exception("WARNING: Edge not found " + stringArray[1] + " " + stringArray[2]);
            }
            reebGraphVertex3.addNeighbor(reebGraphVertex4);
            reebGraphVertex4.addNeighbor(reebGraphVertex3);
        }
        bufferedReader.close();
        for (int i = 0; i < n; ++i) {
            ReebGraphVertex reebGraphVertex5 = (ReebGraphVertex)reebGraph.get(random.nextInt(reebGraph.size()));
            ReebGraphVertex reebGraphVertex6 = RandomLoopTestCLI.walk(random, reebGraphVertex5, random.nextInt(100));
            reebGraphVertex5.addNeighbor(reebGraphVertex6);
            reebGraphVertex6.addNeighbor(reebGraphVertex5);
        }
        PrintWriter printWriter = new PrintWriter(string2);
        for (ReebGraphVertex reebGraphVertex7 : reebGraph) {
            printWriter.println("v " + reebGraphVertex7.getGlobalID() + " " + reebGraphVertex7.getRealValue());
        }
        for (ReebGraphVertex reebGraphVertex8 : reebGraph) {
            for (ReebGraphVertex reebGraphVertex9 : reebGraphVertex8.neighbors) {
                if (reebGraphVertex8.getGlobalID() >= reebGraphVertex9.getGlobalID()) continue;
                printWriter.println("e " + reebGraphVertex8.getGlobalID() + " " + reebGraphVertex9.getGlobalID());
            }
        }
        printWriter.close();
    }

    private static ReebGraphVertex walk(Random random, ReebGraphVertex reebGraphVertex, int n) {
        if (n == 0) {
            return reebGraphVertex;
        }
        return RandomLoopTestCLI.walk(random, reebGraphVertex.neighbors.get(random.nextInt(reebGraphVertex.neighbors.size())), n - 1);
    }
}

